(ns enlive-utils.core
  (:use net.cgrand.enlive-html
        i18n.core))

(defn attr-some [attr f]
  (pred #(when-let [vs (attr-values % attr)] (some f vs))))

(defn localize-content [resname locale]
  (fn [nodes]
    (let [v (some #(resource resname locale %) (attr-values nodes :message))]
      (assoc nodes :content [v]))))

(defn localize-attribute [resname locale]
  (fn [nodes]
    (let [new-attrs
          (for [reskey (attr-values nodes :attr_message)
                :let [[_ attr-key attr-msgid] (re-matches #"([^=]+)=(.*)" reskey)
                      attr-val (resource resname locale attr-msgid)]]
            [(keyword attr-key) attr-val])]
      (update-in nodes [:attrs] #(into % new-attrs)))))

(defn localize-document [resname locale]
  (let [reskeys (set (map name (resource-keys resname locale)))]
    (transformation
      [(attr-some :message reskeys)]
      (do-> (localize-content resname locale)
            (remove-attr :message))
      [(attr-has :attr_message)]
      (do-> (localize-attribute resname locale)
            (remove-attr :attr_message)))))

(defn format-content [& args]
  #(let [[old-content] (:content %)]
     (if (string? old-content)
       (assoc % :content [(apply format old-content args)]))))

