(ns ttt-adapter.core
  (:import (server Server WrappedServerSocket Handler Request Response ApplicationBuilder)
           (java.net ServerSocket))
  (:require [clojure.string :as string]))

(defn get-bytes-from-string [body]
  (-> (java.lang.StringBuilder. body)
        (.toString)
        (.getBytes)))

(defn ringify [request]
  {:server-port 5000
   :server-name "jpetty"
   :remote-addr "localhost"
   :uri (.getPath request)
   :query-string (.getPath request)
   :scheme :http
   :request-method (.getAction request)
   :headers ""
   :body (.getBody request)})
; (java.io.ByteArrayInputStream. (get-bytes-from-string
;                                           (.getBody request)))})

(defn capitalize-header-key [header-key]
  (->> (string/split (name header-key) #"\b")
       (map string/capitalize)
       string/join))

(defn de-ringify [ring-response]
  (let [myResponse (Response. (:status ring-response))
        updatedResponse (reduce-kv (fn [jpetty-response header-key header-value]
                                     (.setHeader jpetty-response
                                                 (capitalize-header-key header-key)
                                                 (str header-value)))
                                   myResponse
                                   (:headers ring-response))]
        (.setBody updatedResponse
                  (get-bytes-from-string
                    (:body ring-response)))))

(defn wrap-ring [handler]
  (reify Handler
    (handle [this request]
      (let [ringified-response (handler (ringify request))]
        (de-ringify ringified-response)))))

(defn run-jpetty [application repository]
  (let [ring-application (.build
                           (ApplicationBuilder/setHandler
                             (wrap-ring application)))
        wrapped-server-socket (WrappedServerSocket. (ServerSocket. 5000)
                                                    ring-application)
        server (Server. wrapped-server-socket)]
    (.run server)))
