/*
 * Decompiled with CFR 0.152.
 */
package server.middlewares;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Base64;
import server.Handler;
import server.Middleware;
import server.Request;
import server.Response;

public class AuthorizationHandler
implements Middleware {
    private String userName;
    private String password;
    private String realm;
    private String[] protectedRoutes;

    public AuthorizationHandler() {
        this("", "", "", new String[0]);
    }

    private AuthorizationHandler(String string, String string2, String string3, String[] stringArray) {
        this.userName = string;
        this.password = string2;
        this.realm = string3;
        this.protectedRoutes = stringArray;
    }

    public AuthorizationHandler setUserName(String string) {
        return new AuthorizationHandler(string, this.password, this.realm, this.protectedRoutes);
    }

    public AuthorizationHandler setPassword(String string) {
        return new AuthorizationHandler(this.userName, string, this.realm, this.protectedRoutes);
    }

    public AuthorizationHandler setRealm(String string) {
        return new AuthorizationHandler(this.userName, this.password, string, this.protectedRoutes);
    }

    public AuthorizationHandler setProtectedRoutes(String[] stringArray) {
        return new AuthorizationHandler(this.userName, this.password, this.realm, stringArray);
    }

    @Override
    public Handler myApply(Handler handler) {
        return request -> {
            if (this.isAuthorized(request)) {
                return handler.handle(request);
            }
            return new Response(401).setHeader("WWW-Authenticate", "Basic realm=" + this.realm);
        };
    }

    private boolean isAuthorized(Request request) {
        return this.destinationIsNotProtected(request) || this.userAuthenticates(request);
    }

    private boolean destinationIsNotProtected(Request request) {
        return !Arrays.asList(this.protectedRoutes).contains(request.getPath());
    }

    private boolean userAuthenticates(Request request) {
        String string = request.getHeader("Authorization");
        if (string != null && string.contains(" ")) {
            String string2 = string.split(" ")[1];
            String string3 = null;
            try {
                string3 = new String(Base64.getDecoder().decode(string2), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            if (string3.contains(":")) {
                String[] stringArray = string3.split(":");
                return stringArray[0].contains(this.userName) && stringArray[1].contains(this.password);
            }
        }
        return false;
    }
}

