/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import server.Handler;
import server.Request;
import server.Response;
import server.Route;

public class Router
implements Handler {
    private Route[] routes;

    public Router() {
        this(new Route[0]);
    }

    private Router(Route[] routeArray) {
        this.routes = routeArray;
    }

    @Override
    public Response handle(Request request) throws IOException {
        if (request != null && this.getRoute(request) != null) {
            return this.getRoute(request).handle(request);
        }
        if (request != null && request.getAction().contains("OPTIONS")) {
            return this.handleOptionsRequest(request);
        }
        return new Response(404);
    }

    private Response handleOptionsRequest(Request request) {
        return new Response(200).setHeader("Allow", this.getValidActions(request.getPath()));
    }

    public Handler getRoute(Request request) {
        for (Route route : this.routes) {
            if (!route.isAMatch(request.getPath(), request.getAction())) continue;
            return route.get(request.getPath(), request.getAction());
        }
        return null;
    }

    private String getValidActions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Route route : this.routes) {
            if (!route.getPath().equals(string)) continue;
            arrayList.add(route.getAction());
        }
        arrayList.add("OPTIONS");
        return String.join((CharSequence)",", arrayList);
    }

    public Router setRoute(String string, String string2, Handler handler) {
        Route route = new Route().setPath(string).setAction(string2).setHandler(handler);
        List<Route> list = Arrays.asList(this.routes);
        ArrayList<Route> arrayList = new ArrayList<Route>(list);
        arrayList.add(route);
        Route[] routeArray = new Route[arrayList.size()];
        return new Router(arrayList.toArray(routeArray));
    }
}

