/*
 * Decompiled with CFR 0.152.
 */
package server.parsers;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import server.Request;
import server.parsers.RequestBodyParser;
import server.parsers.RequestHeaderParser;
import server.parsers.RequestLineParser;
import server.parsers.RequestParamsParser;

public class RequestParser {
    public Request parse(InputStream inputStream) throws IOException {
        byte[] byArray = this.readFromInputStream(inputStream);
        Map<String, String> map = new RequestHeaderParser().parse(byArray);
        Map<String, String> map2 = new RequestLineParser().parse(byArray);
        Map<String, String> map3 = new RequestParamsParser().parse(byArray);
        String string = new RequestBodyParser().parse(byArray);
        return new Request(map2.get("path"), map2.get("action")).setHeaders(map).setParams(map3).setBody(string);
    }

    private byte[] readFromInputStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((n = bufferedReader.read()) != -1) {
            byteArrayOutputStream.write(n);
            if (bufferedReader.ready()) continue;
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }
}

