/*
 * Decompiled with CFR 0.152.
 */
package server.middlewares;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import server.Handler;
import server.Middleware;
import server.Request;
import server.Response;
import server.staticFileHandlers.DirectoryHandler;
import server.staticFileHandlers.GetHandler;
import server.staticFileHandlers.PatchHandler;

public class WrapServeStaticFiles
implements Middleware {
    private File staticPath;
    private boolean autoIndex;

    public WrapServeStaticFiles() {
        this(new File("/public"), false);
    }

    private WrapServeStaticFiles(File file, boolean bl) {
        this.staticPath = file;
        this.autoIndex = bl;
    }

    public WrapServeStaticFiles setPublicDirectory(File file) {
        return new WrapServeStaticFiles(file, this.autoIndex);
    }

    public WrapServeStaticFiles setAutoIndex(boolean bl) {
        return new WrapServeStaticFiles(this.staticPath, bl);
    }

    @Override
    public Handler apply(Handler handler) {
        return request -> {
            File file = new File(this.staticPath, request.getPath());
            if (file.exists()) {
                return this.serveStaticFile(request);
            }
            return handler.handle(request);
        };
    }

    public Response serveStaticFile(Request request) throws IOException {
        File file = new File(this.staticPath, request.getPath());
        if (file.isDirectory()) {
            return this.handleDirectory(request);
        }
        if (this.supportedActions().get(request.getAction()) != null) {
            return this.supportedActions().get(request.getAction()).handle(request);
        }
        return new Response(405);
    }

    private Response handleDirectory(Request request) throws IOException {
        if (this.autoIndex && this.indexExists(request)) {
            return new GetHandler(this.staticPath).handle(new Request(request.getPath() + "/index.html", request.getAction()));
        }
        return new DirectoryHandler(this.staticPath).handle(request);
    }

    private boolean indexExists(Request request) {
        File file = new File(this.staticPath.getName() + request.getPath().concat("/index.html"));
        return file.exists();
    }

    private Map<String, Handler> supportedActions() {
        HashMap<String, Handler> hashMap = new HashMap<String, Handler>();
        hashMap.put("GET", new GetHandler(this.staticPath));
        hashMap.put("PATCH", new PatchHandler(this.staticPath));
        return hashMap;
    }
}

