/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;

public class FileHelper {
    public static File findFile(File file, String string) {
        return new File(file.getPath().concat(string));
    }

    public static byte[] readFile(File file) throws IOException {
        return FileHelper.isValidTarget(file) ? Files.readAllBytes(Paths.get(file.getPath(), new String[0])) : new byte[]{};
    }

    public static int findFileLength(File file) throws IOException {
        return FileHelper.isValidTarget(file) ? (int)Files.size(file.toPath()) : 0;
    }

    public static String findFileType(File file) {
        return FileHelper.isValidTarget(file) ? URLConnection.guessContentTypeFromName(file.getName()) : "";
    }

    private static boolean isValidTarget(File file) {
        return file != null && file.isFile();
    }

    public static String findFileDigest(File file) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray = FileHelper.readFile(file);
            if (byArray.length > 0) {
                return DatatypeConverter.printHexBinary((byte[])messageDigest.digest(Arrays.copyOf(byArray, byArray.length - 1)));
            }
            return DatatypeConverter.printHexBinary((byte[])messageDigest.digest(byArray));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return "";
        }
    }

    public static void changeFile(File file, String string) {
        try {
            FileWriter fileWriter = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string + "\r");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

