goog.provide('re_frame.fx');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed, other than that
 *   `:db` is guaranteed to be executed first.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__28169 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__28170 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__28170);

try{try{var effects = new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context);
var effects_without_db = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(effects,new cljs.core.Keyword(null,"db","db",993250759));
var temp__5735__auto___28405 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(effects);
if(cljs.core.truth_(temp__5735__auto___28405)){
var new_db_28406 = temp__5735__auto___28405;
var fexpr__28176_28407 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,new cljs.core.Keyword(null,"db","db",993250759),false);
(fexpr__28176_28407.cljs$core$IFn$_invoke$arity$1 ? fexpr__28176_28407.cljs$core$IFn$_invoke$arity$1(new_db_28406) : fexpr__28176_28407.call(null,new_db_28406));
} else {
}

var seq__28177 = cljs.core.seq(effects_without_db);
var chunk__28178 = null;
var count__28179 = (0);
var i__28180 = (0);
while(true){
if((i__28180 < count__28179)){
var vec__28189 = chunk__28178.cljs$core$IIndexed$_nth$arity$2(null,i__28180);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28189,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28189,(1),null);
var temp__5733__auto___28419 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28419)){
var effect_fn_28423 = temp__5733__auto___28419;
(effect_fn_28423.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28423.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28423.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28425 = seq__28177;
var G__28426 = chunk__28178;
var G__28427 = count__28179;
var G__28428 = (i__28180 + (1));
seq__28177 = G__28425;
chunk__28178 = G__28426;
count__28179 = G__28427;
i__28180 = G__28428;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28177);
if(temp__5735__auto__){
var seq__28177__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28177__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28177__$1);
var G__28432 = cljs.core.chunk_rest(seq__28177__$1);
var G__28433 = c__4556__auto__;
var G__28434 = cljs.core.count(c__4556__auto__);
var G__28435 = (0);
seq__28177 = G__28432;
chunk__28178 = G__28433;
count__28179 = G__28434;
i__28180 = G__28435;
continue;
} else {
var vec__28193 = cljs.core.first(seq__28177__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28193,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28193,(1),null);
var temp__5733__auto___28440 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28440)){
var effect_fn_28441 = temp__5733__auto___28440;
(effect_fn_28441.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28441.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28441.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28442 = cljs.core.next(seq__28177__$1);
var G__28443 = null;
var G__28444 = (0);
var G__28445 = (0);
seq__28177 = G__28442;
chunk__28178 = G__28443;
count__28179 = G__28444;
i__28180 = G__28445;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__27725__auto___28452 = re_frame.interop.now();
var duration__27726__auto___28453 = (end__27725__auto___28452 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__27726__auto___28453,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__27725__auto___28452);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__28169);
}} else {
var effects = new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context);
var effects_without_db = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(effects,new cljs.core.Keyword(null,"db","db",993250759));
var temp__5735__auto___28457 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(effects);
if(cljs.core.truth_(temp__5735__auto___28457)){
var new_db_28458 = temp__5735__auto___28457;
var fexpr__28198_28459 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,new cljs.core.Keyword(null,"db","db",993250759),false);
(fexpr__28198_28459.cljs$core$IFn$_invoke$arity$1 ? fexpr__28198_28459.cljs$core$IFn$_invoke$arity$1(new_db_28458) : fexpr__28198_28459.call(null,new_db_28458));
} else {
}

var seq__28199 = cljs.core.seq(effects_without_db);
var chunk__28200 = null;
var count__28201 = (0);
var i__28202 = (0);
while(true){
if((i__28202 < count__28201)){
var vec__28220 = chunk__28200.cljs$core$IIndexed$_nth$arity$2(null,i__28202);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28220,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28220,(1),null);
var temp__5733__auto___28464 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28464)){
var effect_fn_28467 = temp__5733__auto___28464;
(effect_fn_28467.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28467.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28467.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28470 = seq__28199;
var G__28471 = chunk__28200;
var G__28472 = count__28201;
var G__28473 = (i__28202 + (1));
seq__28199 = G__28470;
chunk__28200 = G__28471;
count__28201 = G__28472;
i__28202 = G__28473;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28199);
if(temp__5735__auto__){
var seq__28199__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28199__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28199__$1);
var G__28474 = cljs.core.chunk_rest(seq__28199__$1);
var G__28475 = c__4556__auto__;
var G__28476 = cljs.core.count(c__4556__auto__);
var G__28477 = (0);
seq__28199 = G__28474;
chunk__28200 = G__28475;
count__28201 = G__28476;
i__28202 = G__28477;
continue;
} else {
var vec__28227 = cljs.core.first(seq__28199__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28227,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28227,(1),null);
var temp__5733__auto___28481 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28481)){
var effect_fn_28482 = temp__5733__auto___28481;
(effect_fn_28482.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28482.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28482.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__28485 = cljs.core.next(seq__28199__$1);
var G__28486 = null;
var G__28487 = (0);
var G__28488 = (0);
seq__28199 = G__28485;
chunk__28200 = G__28486;
count__28201 = G__28487;
i__28202 = G__28488;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.dispatch_later = (function re_frame$fx$dispatch_later(p__28234){
var map__28235 = p__28234;
var map__28235__$1 = (((((!((map__28235 == null))))?(((((map__28235.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28235.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28235):map__28235);
var effect = map__28235__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28235__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28235__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
return re_frame.interop.set_timeout_BANG_((function (){
return re_frame.router.dispatch(dispatch);
}),ms);
}
});
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
if(cljs.core.map_QMARK_(value)){
return re_frame.fx.dispatch_later(value);
} else {
var seq__28244 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__28245 = null;
var count__28246 = (0);
var i__28247 = (0);
while(true){
if((i__28247 < count__28246)){
var effect = chunk__28245.cljs$core$IIndexed$_nth$arity$2(null,i__28247);
re_frame.fx.dispatch_later(effect);


var G__28492 = seq__28244;
var G__28493 = chunk__28245;
var G__28494 = count__28246;
var G__28495 = (i__28247 + (1));
seq__28244 = G__28492;
chunk__28245 = G__28493;
count__28246 = G__28494;
i__28247 = G__28495;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28244);
if(temp__5735__auto__){
var seq__28244__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28244__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28244__$1);
var G__28496 = cljs.core.chunk_rest(seq__28244__$1);
var G__28497 = c__4556__auto__;
var G__28498 = cljs.core.count(c__4556__auto__);
var G__28499 = (0);
seq__28244 = G__28496;
chunk__28245 = G__28497;
count__28246 = G__28498;
i__28247 = G__28499;
continue;
} else {
var effect = cljs.core.first(seq__28244__$1);
re_frame.fx.dispatch_later(effect);


var G__28503 = cljs.core.next(seq__28244__$1);
var G__28504 = null;
var G__28505 = (0);
var G__28506 = (0);
seq__28244 = G__28503;
chunk__28245 = G__28504;
count__28246 = G__28505;
i__28247 = G__28506;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"fx","fx",-1237829572),(function (seq_of_effects){
if((!(cljs.core.sequential_QMARK_(seq_of_effects)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect expects a seq, but was given ",cljs.core.type(seq_of_effects)], 0));
} else {
var seq__28266 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,seq_of_effects));
var chunk__28267 = null;
var count__28268 = (0);
var i__28269 = (0);
while(true){
if((i__28269 < count__28268)){
var vec__28299 = chunk__28267.cljs$core$IIndexed$_nth$arity$2(null,i__28269);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28299,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28299,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"db","db",993250759),effect_key)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect should not contain a :db effect"], 0));
} else {
}

var temp__5733__auto___28514 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28514)){
var effect_fn_28516 = temp__5733__auto___28514;
(effect_fn_28516.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28516.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28516.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in \":fx\" effect found ",effect_key," which has no associated handler. Ignoring."], 0));
}


var G__28518 = seq__28266;
var G__28519 = chunk__28267;
var G__28520 = count__28268;
var G__28521 = (i__28269 + (1));
seq__28266 = G__28518;
chunk__28267 = G__28519;
count__28268 = G__28520;
i__28269 = G__28521;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28266);
if(temp__5735__auto__){
var seq__28266__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28266__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28266__$1);
var G__28525 = cljs.core.chunk_rest(seq__28266__$1);
var G__28526 = c__4556__auto__;
var G__28527 = cljs.core.count(c__4556__auto__);
var G__28528 = (0);
seq__28266 = G__28525;
chunk__28267 = G__28526;
count__28268 = G__28527;
i__28269 = G__28528;
continue;
} else {
var vec__28305 = cljs.core.first(seq__28266__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28305,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28305,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"db","db",993250759),effect_key)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect should not contain a :db effect"], 0));
} else {
}

var temp__5733__auto___28532 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___28532)){
var effect_fn_28533 = temp__5733__auto___28532;
(effect_fn_28533.cljs$core$IFn$_invoke$arity$1 ? effect_fn_28533.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_28533.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in \":fx\" effect found ",effect_key," which has no associated handler. Ignoring."], 0));
}


var G__28536 = cljs.core.next(seq__28266__$1);
var G__28537 = null;
var G__28538 = (0);
var G__28539 = (0);
seq__28266 = G__28536;
chunk__28267 = G__28537;
count__28268 = G__28538;
i__28269 = G__28539;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__28330 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__28331 = null;
var count__28332 = (0);
var i__28333 = (0);
while(true){
if((i__28333 < count__28332)){
var event = chunk__28331.cljs$core$IIndexed$_nth$arity$2(null,i__28333);
re_frame.router.dispatch(event);


var G__28551 = seq__28330;
var G__28552 = chunk__28331;
var G__28553 = count__28332;
var G__28554 = (i__28333 + (1));
seq__28330 = G__28551;
chunk__28331 = G__28552;
count__28332 = G__28553;
i__28333 = G__28554;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28330);
if(temp__5735__auto__){
var seq__28330__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28330__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28330__$1);
var G__28557 = cljs.core.chunk_rest(seq__28330__$1);
var G__28558 = c__4556__auto__;
var G__28559 = cljs.core.count(c__4556__auto__);
var G__28560 = (0);
seq__28330 = G__28557;
chunk__28331 = G__28558;
count__28332 = G__28559;
i__28333 = G__28560;
continue;
} else {
var event = cljs.core.first(seq__28330__$1);
re_frame.router.dispatch(event);


var G__28561 = cljs.core.next(seq__28330__$1);
var G__28562 = null;
var G__28563 = (0);
var G__28564 = (0);
seq__28330 = G__28561;
chunk__28331 = G__28562;
count__28332 = G__28563;
i__28333 = G__28564;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__28372 = cljs.core.seq(value);
var chunk__28373 = null;
var count__28374 = (0);
var i__28375 = (0);
while(true){
if((i__28375 < count__28374)){
var event = chunk__28373.cljs$core$IIndexed$_nth$arity$2(null,i__28375);
clear_event(event);


var G__28569 = seq__28372;
var G__28570 = chunk__28373;
var G__28571 = count__28374;
var G__28572 = (i__28375 + (1));
seq__28372 = G__28569;
chunk__28373 = G__28570;
count__28374 = G__28571;
i__28375 = G__28572;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28372);
if(temp__5735__auto__){
var seq__28372__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28372__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28372__$1);
var G__28576 = cljs.core.chunk_rest(seq__28372__$1);
var G__28577 = c__4556__auto__;
var G__28578 = cljs.core.count(c__4556__auto__);
var G__28579 = (0);
seq__28372 = G__28576;
chunk__28373 = G__28577;
count__28374 = G__28578;
i__28375 = G__28579;
continue;
} else {
var event = cljs.core.first(seq__28372__$1);
clear_event(event);


var G__28582 = cljs.core.next(seq__28372__$1);
var G__28583 = null;
var G__28584 = (0);
var G__28585 = (0);
seq__28372 = G__28582;
chunk__28373 = G__28583;
count__28374 = G__28584;
i__28375 = G__28585;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
