goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_34107 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_34107(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_34108 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_34108(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__33180 = coll;
var G__33181 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__33180,G__33181) : shadow.dom.lazy_native_coll_seq.call(null,G__33180,G__33181));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__33209 = arguments.length;
switch (G__33209) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__33215 = arguments.length;
switch (G__33215) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__33222 = arguments.length;
switch (G__33222) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__33264 = arguments.length;
switch (G__33264) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__33280 = arguments.length;
switch (G__33280) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__33290 = arguments.length;
switch (G__33290) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e33297){if((e33297 instanceof Object)){
var e = e33297;
return console.log("didnt support attachEvent",el,e);
} else {
throw e33297;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__33306 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__33307 = null;
var count__33308 = (0);
var i__33309 = (0);
while(true){
if((i__33309 < count__33308)){
var el = chunk__33307.cljs$core$IIndexed$_nth$arity$2(null,i__33309);
var handler_34233__$1 = ((function (seq__33306,chunk__33307,count__33308,i__33309,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33306,chunk__33307,count__33308,i__33309,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_34233__$1);


var G__34234 = seq__33306;
var G__34235 = chunk__33307;
var G__34236 = count__33308;
var G__34237 = (i__33309 + (1));
seq__33306 = G__34234;
chunk__33307 = G__34235;
count__33308 = G__34236;
i__33309 = G__34237;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__33306);
if(temp__5735__auto__){
var seq__33306__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33306__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__33306__$1);
var G__34238 = cljs.core.chunk_rest(seq__33306__$1);
var G__34239 = c__4556__auto__;
var G__34240 = cljs.core.count(c__4556__auto__);
var G__34241 = (0);
seq__33306 = G__34238;
chunk__33307 = G__34239;
count__33308 = G__34240;
i__33309 = G__34241;
continue;
} else {
var el = cljs.core.first(seq__33306__$1);
var handler_34242__$1 = ((function (seq__33306,chunk__33307,count__33308,i__33309,el,seq__33306__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33306,chunk__33307,count__33308,i__33309,el,seq__33306__$1,temp__5735__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_34242__$1);


var G__34250 = cljs.core.next(seq__33306__$1);
var G__34251 = null;
var G__34252 = (0);
var G__34253 = (0);
seq__33306 = G__34250;
chunk__33307 = G__34251;
count__33308 = G__34252;
i__33309 = G__34253;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__33323 = arguments.length;
switch (G__33323) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__33333 = cljs.core.seq(events);
var chunk__33334 = null;
var count__33335 = (0);
var i__33336 = (0);
while(true){
if((i__33336 < count__33335)){
var vec__33350 = chunk__33334.cljs$core$IIndexed$_nth$arity$2(null,i__33336);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33350,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33350,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__34267 = seq__33333;
var G__34268 = chunk__33334;
var G__34269 = count__33335;
var G__34270 = (i__33336 + (1));
seq__33333 = G__34267;
chunk__33334 = G__34268;
count__33335 = G__34269;
i__33336 = G__34270;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__33333);
if(temp__5735__auto__){
var seq__33333__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33333__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__33333__$1);
var G__34271 = cljs.core.chunk_rest(seq__33333__$1);
var G__34272 = c__4556__auto__;
var G__34273 = cljs.core.count(c__4556__auto__);
var G__34274 = (0);
seq__33333 = G__34271;
chunk__33334 = G__34272;
count__33335 = G__34273;
i__33336 = G__34274;
continue;
} else {
var vec__33355 = cljs.core.first(seq__33333__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33355,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33355,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__34275 = cljs.core.next(seq__33333__$1);
var G__34276 = null;
var G__34277 = (0);
var G__34278 = (0);
seq__33333 = G__34275;
chunk__33334 = G__34276;
count__33335 = G__34277;
i__33336 = G__34278;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__33361 = cljs.core.seq(styles);
var chunk__33362 = null;
var count__33363 = (0);
var i__33364 = (0);
while(true){
if((i__33364 < count__33363)){
var vec__33377 = chunk__33362.cljs$core$IIndexed$_nth$arity$2(null,i__33364);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33377,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33377,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__34283 = seq__33361;
var G__34284 = chunk__33362;
var G__34285 = count__33363;
var G__34286 = (i__33364 + (1));
seq__33361 = G__34283;
chunk__33362 = G__34284;
count__33363 = G__34285;
i__33364 = G__34286;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__33361);
if(temp__5735__auto__){
var seq__33361__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33361__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__33361__$1);
var G__34287 = cljs.core.chunk_rest(seq__33361__$1);
var G__34288 = c__4556__auto__;
var G__34289 = cljs.core.count(c__4556__auto__);
var G__34290 = (0);
seq__33361 = G__34287;
chunk__33362 = G__34288;
count__33363 = G__34289;
i__33364 = G__34290;
continue;
} else {
var vec__33384 = cljs.core.first(seq__33361__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33384,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33384,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__34291 = cljs.core.next(seq__33361__$1);
var G__34292 = null;
var G__34293 = (0);
var G__34294 = (0);
seq__33361 = G__34291;
chunk__33362 = G__34292;
count__33363 = G__34293;
i__33364 = G__34294;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__33391_34295 = key;
var G__33391_34296__$1 = (((G__33391_34295 instanceof cljs.core.Keyword))?G__33391_34295.fqn:null);
switch (G__33391_34296__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_34305 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_34305,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_34305,"aria-");
}
})())){
el.setAttribute(ks_34305,value);
} else {
(el[ks_34305] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__33402){
var map__33403 = p__33402;
var map__33403__$1 = (((((!((map__33403 == null))))?(((((map__33403.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33403.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33403):map__33403);
var props = map__33403__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33403__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__33405 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33405,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33405,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33405,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__33408 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__33408,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__33408;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__33411 = arguments.length;
switch (G__33411) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__33415){
var vec__33416 = p__33415;
var seq__33417 = cljs.core.seq(vec__33416);
var first__33418 = cljs.core.first(seq__33417);
var seq__33417__$1 = cljs.core.next(seq__33417);
var nn = first__33418;
var first__33418__$1 = cljs.core.first(seq__33417__$1);
var seq__33417__$2 = cljs.core.next(seq__33417__$1);
var np = first__33418__$1;
var nc = seq__33417__$2;
var node = vec__33416;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33421 = nn;
var G__33422 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__33421,G__33422) : create_fn.call(null,G__33421,G__33422));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33423 = nn;
var G__33424 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__33423,G__33424) : create_fn.call(null,G__33423,G__33424));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__33427 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33427,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33427,(1),null);
var seq__33431_34344 = cljs.core.seq(node_children);
var chunk__33432_34345 = null;
var count__33433_34346 = (0);
var i__33434_34347 = (0);
while(true){
if((i__33434_34347 < count__33433_34346)){
var child_struct_34348 = chunk__33432_34345.cljs$core$IIndexed$_nth$arity$2(null,i__33434_34347);
var children_34350 = shadow.dom.dom_node(child_struct_34348);
if(cljs.core.seq_QMARK_(children_34350)){
var seq__33468_34351 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_34350));
var chunk__33470_34352 = null;
var count__33471_34353 = (0);
var i__33472_34354 = (0);
while(true){
if((i__33472_34354 < count__33471_34353)){
var child_34355 = chunk__33470_34352.cljs$core$IIndexed$_nth$arity$2(null,i__33472_34354);
if(cljs.core.truth_(child_34355)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34355);


var G__34356 = seq__33468_34351;
var G__34357 = chunk__33470_34352;
var G__34358 = count__33471_34353;
var G__34359 = (i__33472_34354 + (1));
seq__33468_34351 = G__34356;
chunk__33470_34352 = G__34357;
count__33471_34353 = G__34358;
i__33472_34354 = G__34359;
continue;
} else {
var G__34360 = seq__33468_34351;
var G__34361 = chunk__33470_34352;
var G__34362 = count__33471_34353;
var G__34363 = (i__33472_34354 + (1));
seq__33468_34351 = G__34360;
chunk__33470_34352 = G__34361;
count__33471_34353 = G__34362;
i__33472_34354 = G__34363;
continue;
}
} else {
var temp__5735__auto___34364 = cljs.core.seq(seq__33468_34351);
if(temp__5735__auto___34364){
var seq__33468_34365__$1 = temp__5735__auto___34364;
if(cljs.core.chunked_seq_QMARK_(seq__33468_34365__$1)){
var c__4556__auto___34366 = cljs.core.chunk_first(seq__33468_34365__$1);
var G__34367 = cljs.core.chunk_rest(seq__33468_34365__$1);
var G__34368 = c__4556__auto___34366;
var G__34369 = cljs.core.count(c__4556__auto___34366);
var G__34370 = (0);
seq__33468_34351 = G__34367;
chunk__33470_34352 = G__34368;
count__33471_34353 = G__34369;
i__33472_34354 = G__34370;
continue;
} else {
var child_34371 = cljs.core.first(seq__33468_34365__$1);
if(cljs.core.truth_(child_34371)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34371);


var G__34372 = cljs.core.next(seq__33468_34365__$1);
var G__34373 = null;
var G__34374 = (0);
var G__34375 = (0);
seq__33468_34351 = G__34372;
chunk__33470_34352 = G__34373;
count__33471_34353 = G__34374;
i__33472_34354 = G__34375;
continue;
} else {
var G__34376 = cljs.core.next(seq__33468_34365__$1);
var G__34377 = null;
var G__34378 = (0);
var G__34379 = (0);
seq__33468_34351 = G__34376;
chunk__33470_34352 = G__34377;
count__33471_34353 = G__34378;
i__33472_34354 = G__34379;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_34350);
}


var G__34380 = seq__33431_34344;
var G__34381 = chunk__33432_34345;
var G__34382 = count__33433_34346;
var G__34383 = (i__33434_34347 + (1));
seq__33431_34344 = G__34380;
chunk__33432_34345 = G__34381;
count__33433_34346 = G__34382;
i__33434_34347 = G__34383;
continue;
} else {
var temp__5735__auto___34384 = cljs.core.seq(seq__33431_34344);
if(temp__5735__auto___34384){
var seq__33431_34385__$1 = temp__5735__auto___34384;
if(cljs.core.chunked_seq_QMARK_(seq__33431_34385__$1)){
var c__4556__auto___34386 = cljs.core.chunk_first(seq__33431_34385__$1);
var G__34387 = cljs.core.chunk_rest(seq__33431_34385__$1);
var G__34388 = c__4556__auto___34386;
var G__34389 = cljs.core.count(c__4556__auto___34386);
var G__34390 = (0);
seq__33431_34344 = G__34387;
chunk__33432_34345 = G__34388;
count__33433_34346 = G__34389;
i__33434_34347 = G__34390;
continue;
} else {
var child_struct_34391 = cljs.core.first(seq__33431_34385__$1);
var children_34392 = shadow.dom.dom_node(child_struct_34391);
if(cljs.core.seq_QMARK_(children_34392)){
var seq__33477_34393 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_34392));
var chunk__33479_34394 = null;
var count__33480_34395 = (0);
var i__33481_34396 = (0);
while(true){
if((i__33481_34396 < count__33480_34395)){
var child_34397 = chunk__33479_34394.cljs$core$IIndexed$_nth$arity$2(null,i__33481_34396);
if(cljs.core.truth_(child_34397)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34397);


var G__34399 = seq__33477_34393;
var G__34400 = chunk__33479_34394;
var G__34401 = count__33480_34395;
var G__34402 = (i__33481_34396 + (1));
seq__33477_34393 = G__34399;
chunk__33479_34394 = G__34400;
count__33480_34395 = G__34401;
i__33481_34396 = G__34402;
continue;
} else {
var G__34403 = seq__33477_34393;
var G__34404 = chunk__33479_34394;
var G__34405 = count__33480_34395;
var G__34406 = (i__33481_34396 + (1));
seq__33477_34393 = G__34403;
chunk__33479_34394 = G__34404;
count__33480_34395 = G__34405;
i__33481_34396 = G__34406;
continue;
}
} else {
var temp__5735__auto___34407__$1 = cljs.core.seq(seq__33477_34393);
if(temp__5735__auto___34407__$1){
var seq__33477_34408__$1 = temp__5735__auto___34407__$1;
if(cljs.core.chunked_seq_QMARK_(seq__33477_34408__$1)){
var c__4556__auto___34409 = cljs.core.chunk_first(seq__33477_34408__$1);
var G__34411 = cljs.core.chunk_rest(seq__33477_34408__$1);
var G__34412 = c__4556__auto___34409;
var G__34413 = cljs.core.count(c__4556__auto___34409);
var G__34414 = (0);
seq__33477_34393 = G__34411;
chunk__33479_34394 = G__34412;
count__33480_34395 = G__34413;
i__33481_34396 = G__34414;
continue;
} else {
var child_34415 = cljs.core.first(seq__33477_34408__$1);
if(cljs.core.truth_(child_34415)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34415);


var G__34417 = cljs.core.next(seq__33477_34408__$1);
var G__34418 = null;
var G__34419 = (0);
var G__34420 = (0);
seq__33477_34393 = G__34417;
chunk__33479_34394 = G__34418;
count__33480_34395 = G__34419;
i__33481_34396 = G__34420;
continue;
} else {
var G__34421 = cljs.core.next(seq__33477_34408__$1);
var G__34422 = null;
var G__34423 = (0);
var G__34424 = (0);
seq__33477_34393 = G__34421;
chunk__33479_34394 = G__34422;
count__33480_34395 = G__34423;
i__33481_34396 = G__34424;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_34392);
}


var G__34425 = cljs.core.next(seq__33431_34385__$1);
var G__34426 = null;
var G__34427 = (0);
var G__34428 = (0);
seq__33431_34344 = G__34425;
chunk__33432_34345 = G__34426;
count__33433_34346 = G__34427;
i__33434_34347 = G__34428;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__33492 = cljs.core.seq(node);
var chunk__33493 = null;
var count__33494 = (0);
var i__33495 = (0);
while(true){
if((i__33495 < count__33494)){
var n = chunk__33493.cljs$core$IIndexed$_nth$arity$2(null,i__33495);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__34440 = seq__33492;
var G__34441 = chunk__33493;
var G__34442 = count__33494;
var G__34443 = (i__33495 + (1));
seq__33492 = G__34440;
chunk__33493 = G__34441;
count__33494 = G__34442;
i__33495 = G__34443;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__33492);
if(temp__5735__auto__){
var seq__33492__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33492__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__33492__$1);
var G__34464 = cljs.core.chunk_rest(seq__33492__$1);
var G__34465 = c__4556__auto__;
var G__34466 = cljs.core.count(c__4556__auto__);
var G__34467 = (0);
seq__33492 = G__34464;
chunk__33493 = G__34465;
count__33494 = G__34466;
i__33495 = G__34467;
continue;
} else {
var n = cljs.core.first(seq__33492__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__34468 = cljs.core.next(seq__33492__$1);
var G__34469 = null;
var G__34470 = (0);
var G__34471 = (0);
seq__33492 = G__34468;
chunk__33493 = G__34469;
count__33494 = G__34470;
i__33495 = G__34471;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__33510 = arguments.length;
switch (G__33510) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__33517 = arguments.length;
switch (G__33517) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__33532 = arguments.length;
switch (G__33532) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34486 = arguments.length;
var i__4737__auto___34487 = (0);
while(true){
if((i__4737__auto___34487 < len__4736__auto___34486)){
args__4742__auto__.push((arguments[i__4737__auto___34487]));

var G__34488 = (i__4737__auto___34487 + (1));
i__4737__auto___34487 = G__34488;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__33553_34492 = cljs.core.seq(nodes);
var chunk__33554_34493 = null;
var count__33555_34494 = (0);
var i__33556_34495 = (0);
while(true){
if((i__33556_34495 < count__33555_34494)){
var node_34497 = chunk__33554_34493.cljs$core$IIndexed$_nth$arity$2(null,i__33556_34495);
fragment.appendChild(shadow.dom._to_dom(node_34497));


var G__34498 = seq__33553_34492;
var G__34499 = chunk__33554_34493;
var G__34500 = count__33555_34494;
var G__34501 = (i__33556_34495 + (1));
seq__33553_34492 = G__34498;
chunk__33554_34493 = G__34499;
count__33555_34494 = G__34500;
i__33556_34495 = G__34501;
continue;
} else {
var temp__5735__auto___34502 = cljs.core.seq(seq__33553_34492);
if(temp__5735__auto___34502){
var seq__33553_34504__$1 = temp__5735__auto___34502;
if(cljs.core.chunked_seq_QMARK_(seq__33553_34504__$1)){
var c__4556__auto___34507 = cljs.core.chunk_first(seq__33553_34504__$1);
var G__34509 = cljs.core.chunk_rest(seq__33553_34504__$1);
var G__34510 = c__4556__auto___34507;
var G__34511 = cljs.core.count(c__4556__auto___34507);
var G__34512 = (0);
seq__33553_34492 = G__34509;
chunk__33554_34493 = G__34510;
count__33555_34494 = G__34511;
i__33556_34495 = G__34512;
continue;
} else {
var node_34513 = cljs.core.first(seq__33553_34504__$1);
fragment.appendChild(shadow.dom._to_dom(node_34513));


var G__34535 = cljs.core.next(seq__33553_34504__$1);
var G__34536 = null;
var G__34537 = (0);
var G__34538 = (0);
seq__33553_34492 = G__34535;
chunk__33554_34493 = G__34536;
count__33555_34494 = G__34537;
i__33556_34495 = G__34538;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq33550){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33550));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__33575_34541 = cljs.core.seq(scripts);
var chunk__33580_34542 = null;
var count__33581_34543 = (0);
var i__33582_34544 = (0);
while(true){
if((i__33582_34544 < count__33581_34543)){
var vec__33598_34545 = chunk__33580_34542.cljs$core$IIndexed$_nth$arity$2(null,i__33582_34544);
var script_tag_34546 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33598_34545,(0),null);
var script_body_34547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33598_34545,(1),null);
eval(script_body_34547);


var G__34548 = seq__33575_34541;
var G__34549 = chunk__33580_34542;
var G__34550 = count__33581_34543;
var G__34551 = (i__33582_34544 + (1));
seq__33575_34541 = G__34548;
chunk__33580_34542 = G__34549;
count__33581_34543 = G__34550;
i__33582_34544 = G__34551;
continue;
} else {
var temp__5735__auto___34552 = cljs.core.seq(seq__33575_34541);
if(temp__5735__auto___34552){
var seq__33575_34553__$1 = temp__5735__auto___34552;
if(cljs.core.chunked_seq_QMARK_(seq__33575_34553__$1)){
var c__4556__auto___34554 = cljs.core.chunk_first(seq__33575_34553__$1);
var G__34555 = cljs.core.chunk_rest(seq__33575_34553__$1);
var G__34556 = c__4556__auto___34554;
var G__34557 = cljs.core.count(c__4556__auto___34554);
var G__34558 = (0);
seq__33575_34541 = G__34555;
chunk__33580_34542 = G__34556;
count__33581_34543 = G__34557;
i__33582_34544 = G__34558;
continue;
} else {
var vec__33601_34559 = cljs.core.first(seq__33575_34553__$1);
var script_tag_34560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33601_34559,(0),null);
var script_body_34561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33601_34559,(1),null);
eval(script_body_34561);


var G__34562 = cljs.core.next(seq__33575_34553__$1);
var G__34563 = null;
var G__34564 = (0);
var G__34565 = (0);
seq__33575_34541 = G__34562;
chunk__33580_34542 = G__34563;
count__33581_34543 = G__34564;
i__33582_34544 = G__34565;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__33605){
var vec__33606 = p__33605;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33606,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33606,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__33615 = arguments.length;
switch (G__33615) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__33627 = cljs.core.seq(style_keys);
var chunk__33628 = null;
var count__33629 = (0);
var i__33630 = (0);
while(true){
if((i__33630 < count__33629)){
var it = chunk__33628.cljs$core$IIndexed$_nth$arity$2(null,i__33630);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__34571 = seq__33627;
var G__34572 = chunk__33628;
var G__34573 = count__33629;
var G__34574 = (i__33630 + (1));
seq__33627 = G__34571;
chunk__33628 = G__34572;
count__33629 = G__34573;
i__33630 = G__34574;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__33627);
if(temp__5735__auto__){
var seq__33627__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33627__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__33627__$1);
var G__34575 = cljs.core.chunk_rest(seq__33627__$1);
var G__34576 = c__4556__auto__;
var G__34577 = cljs.core.count(c__4556__auto__);
var G__34578 = (0);
seq__33627 = G__34575;
chunk__33628 = G__34576;
count__33629 = G__34577;
i__33630 = G__34578;
continue;
} else {
var it = cljs.core.first(seq__33627__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__34583 = cljs.core.next(seq__33627__$1);
var G__34584 = null;
var G__34585 = (0);
var G__34586 = (0);
seq__33627 = G__34583;
chunk__33628 = G__34584;
count__33629 = G__34585;
i__33630 = G__34586;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k33640,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__33652 = k33640;
var G__33652__$1 = (((G__33652 instanceof cljs.core.Keyword))?G__33652.fqn:null);
switch (G__33652__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k33640,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__33656){
var vec__33659 = p__33656;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33659,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33659,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__33639){
var self__ = this;
var G__33639__$1 = this;
return (new cljs.core.RecordIter((0),G__33639__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this33641,other33643){
var self__ = this;
var this33641__$1 = this;
return (((!((other33643 == null)))) && ((this33641__$1.constructor === other33643.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33641__$1.x,other33643.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33641__$1.y,other33643.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33641__$1.__extmap,other33643.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__33639){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__33685 = cljs.core.keyword_identical_QMARK_;
var expr__33686 = k__4388__auto__;
if(cljs.core.truth_((pred__33685.cljs$core$IFn$_invoke$arity$2 ? pred__33685.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__33686) : pred__33685.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__33686)))){
return (new shadow.dom.Coordinate(G__33639,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__33685.cljs$core$IFn$_invoke$arity$2 ? pred__33685.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__33686) : pred__33685.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__33686)))){
return (new shadow.dom.Coordinate(self__.x,G__33639,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__33639),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__33639){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__33639,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__33644){
var extmap__4419__auto__ = (function (){var G__33696 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__33644,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__33644)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__33696);
} else {
return G__33696;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__33644),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__33644),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k33729,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__33739 = k33729;
var G__33739__$1 = (((G__33739 instanceof cljs.core.Keyword))?G__33739.fqn:null);
switch (G__33739__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k33729,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__33742){
var vec__33743 = p__33742;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33743,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33743,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__33728){
var self__ = this;
var G__33728__$1 = this;
return (new cljs.core.RecordIter((0),G__33728__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this33730,other33731){
var self__ = this;
var this33730__$1 = this;
return (((!((other33731 == null)))) && ((this33730__$1.constructor === other33731.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33730__$1.w,other33731.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33730__$1.h,other33731.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33730__$1.__extmap,other33731.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__33728){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__33762 = cljs.core.keyword_identical_QMARK_;
var expr__33763 = k__4388__auto__;
if(cljs.core.truth_((pred__33762.cljs$core$IFn$_invoke$arity$2 ? pred__33762.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__33763) : pred__33762.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__33763)))){
return (new shadow.dom.Size(G__33728,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__33762.cljs$core$IFn$_invoke$arity$2 ? pred__33762.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__33763) : pred__33762.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__33763)))){
return (new shadow.dom.Size(self__.w,G__33728,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__33728),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__33728){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__33728,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__33733){
var extmap__4419__auto__ = (function (){var G__33768 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__33733,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__33733)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__33768);
} else {
return G__33768;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__33733),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__33733),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__34603 = (i + (1));
var G__34604 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__34603;
ret = G__34604;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__33796){
var vec__33797 = p__33796;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33797,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33797,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__33865 = arguments.length;
switch (G__33865) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__34606 = ps;
var G__34607 = (i + (1));
el__$1 = G__34606;
i = G__34607;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__33894 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33894,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33894,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33894,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__33897_34608 = cljs.core.seq(props);
var chunk__33898_34609 = null;
var count__33899_34610 = (0);
var i__33900_34611 = (0);
while(true){
if((i__33900_34611 < count__33899_34610)){
var vec__33923_34612 = chunk__33898_34609.cljs$core$IIndexed$_nth$arity$2(null,i__33900_34611);
var k_34613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33923_34612,(0),null);
var v_34614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33923_34612,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_34613);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_34613),v_34614);


var G__34615 = seq__33897_34608;
var G__34616 = chunk__33898_34609;
var G__34617 = count__33899_34610;
var G__34618 = (i__33900_34611 + (1));
seq__33897_34608 = G__34615;
chunk__33898_34609 = G__34616;
count__33899_34610 = G__34617;
i__33900_34611 = G__34618;
continue;
} else {
var temp__5735__auto___34619 = cljs.core.seq(seq__33897_34608);
if(temp__5735__auto___34619){
var seq__33897_34620__$1 = temp__5735__auto___34619;
if(cljs.core.chunked_seq_QMARK_(seq__33897_34620__$1)){
var c__4556__auto___34621 = cljs.core.chunk_first(seq__33897_34620__$1);
var G__34622 = cljs.core.chunk_rest(seq__33897_34620__$1);
var G__34623 = c__4556__auto___34621;
var G__34624 = cljs.core.count(c__4556__auto___34621);
var G__34625 = (0);
seq__33897_34608 = G__34622;
chunk__33898_34609 = G__34623;
count__33899_34610 = G__34624;
i__33900_34611 = G__34625;
continue;
} else {
var vec__33928_34626 = cljs.core.first(seq__33897_34620__$1);
var k_34627 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33928_34626,(0),null);
var v_34628 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33928_34626,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_34627);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_34627),v_34628);


var G__34629 = cljs.core.next(seq__33897_34620__$1);
var G__34630 = null;
var G__34631 = (0);
var G__34632 = (0);
seq__33897_34608 = G__34629;
chunk__33898_34609 = G__34630;
count__33899_34610 = G__34631;
i__33900_34611 = G__34632;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__33940 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33940,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33940,(1),null);
var seq__33943_34639 = cljs.core.seq(node_children);
var chunk__33945_34640 = null;
var count__33946_34641 = (0);
var i__33947_34642 = (0);
while(true){
if((i__33947_34642 < count__33946_34641)){
var child_struct_34643 = chunk__33945_34640.cljs$core$IIndexed$_nth$arity$2(null,i__33947_34642);
if((!((child_struct_34643 == null)))){
if(typeof child_struct_34643 === 'string'){
var text_34644 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_34644),child_struct_34643].join(''));
} else {
var children_34645 = shadow.dom.svg_node(child_struct_34643);
if(cljs.core.seq_QMARK_(children_34645)){
var seq__33997_34646 = cljs.core.seq(children_34645);
var chunk__33999_34647 = null;
var count__34000_34648 = (0);
var i__34001_34649 = (0);
while(true){
if((i__34001_34649 < count__34000_34648)){
var child_34650 = chunk__33999_34647.cljs$core$IIndexed$_nth$arity$2(null,i__34001_34649);
if(cljs.core.truth_(child_34650)){
node.appendChild(child_34650);


var G__34651 = seq__33997_34646;
var G__34652 = chunk__33999_34647;
var G__34653 = count__34000_34648;
var G__34654 = (i__34001_34649 + (1));
seq__33997_34646 = G__34651;
chunk__33999_34647 = G__34652;
count__34000_34648 = G__34653;
i__34001_34649 = G__34654;
continue;
} else {
var G__34655 = seq__33997_34646;
var G__34656 = chunk__33999_34647;
var G__34657 = count__34000_34648;
var G__34658 = (i__34001_34649 + (1));
seq__33997_34646 = G__34655;
chunk__33999_34647 = G__34656;
count__34000_34648 = G__34657;
i__34001_34649 = G__34658;
continue;
}
} else {
var temp__5735__auto___34659 = cljs.core.seq(seq__33997_34646);
if(temp__5735__auto___34659){
var seq__33997_34660__$1 = temp__5735__auto___34659;
if(cljs.core.chunked_seq_QMARK_(seq__33997_34660__$1)){
var c__4556__auto___34661 = cljs.core.chunk_first(seq__33997_34660__$1);
var G__34662 = cljs.core.chunk_rest(seq__33997_34660__$1);
var G__34663 = c__4556__auto___34661;
var G__34664 = cljs.core.count(c__4556__auto___34661);
var G__34665 = (0);
seq__33997_34646 = G__34662;
chunk__33999_34647 = G__34663;
count__34000_34648 = G__34664;
i__34001_34649 = G__34665;
continue;
} else {
var child_34666 = cljs.core.first(seq__33997_34660__$1);
if(cljs.core.truth_(child_34666)){
node.appendChild(child_34666);


var G__34667 = cljs.core.next(seq__33997_34660__$1);
var G__34668 = null;
var G__34669 = (0);
var G__34670 = (0);
seq__33997_34646 = G__34667;
chunk__33999_34647 = G__34668;
count__34000_34648 = G__34669;
i__34001_34649 = G__34670;
continue;
} else {
var G__34671 = cljs.core.next(seq__33997_34660__$1);
var G__34672 = null;
var G__34673 = (0);
var G__34674 = (0);
seq__33997_34646 = G__34671;
chunk__33999_34647 = G__34672;
count__34000_34648 = G__34673;
i__34001_34649 = G__34674;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_34645);
}
}


var G__34675 = seq__33943_34639;
var G__34676 = chunk__33945_34640;
var G__34677 = count__33946_34641;
var G__34678 = (i__33947_34642 + (1));
seq__33943_34639 = G__34675;
chunk__33945_34640 = G__34676;
count__33946_34641 = G__34677;
i__33947_34642 = G__34678;
continue;
} else {
var G__34679 = seq__33943_34639;
var G__34680 = chunk__33945_34640;
var G__34681 = count__33946_34641;
var G__34682 = (i__33947_34642 + (1));
seq__33943_34639 = G__34679;
chunk__33945_34640 = G__34680;
count__33946_34641 = G__34681;
i__33947_34642 = G__34682;
continue;
}
} else {
var temp__5735__auto___34683 = cljs.core.seq(seq__33943_34639);
if(temp__5735__auto___34683){
var seq__33943_34684__$1 = temp__5735__auto___34683;
if(cljs.core.chunked_seq_QMARK_(seq__33943_34684__$1)){
var c__4556__auto___34685 = cljs.core.chunk_first(seq__33943_34684__$1);
var G__34686 = cljs.core.chunk_rest(seq__33943_34684__$1);
var G__34687 = c__4556__auto___34685;
var G__34688 = cljs.core.count(c__4556__auto___34685);
var G__34689 = (0);
seq__33943_34639 = G__34686;
chunk__33945_34640 = G__34687;
count__33946_34641 = G__34688;
i__33947_34642 = G__34689;
continue;
} else {
var child_struct_34690 = cljs.core.first(seq__33943_34684__$1);
if((!((child_struct_34690 == null)))){
if(typeof child_struct_34690 === 'string'){
var text_34691 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_34691),child_struct_34690].join(''));
} else {
var children_34692 = shadow.dom.svg_node(child_struct_34690);
if(cljs.core.seq_QMARK_(children_34692)){
var seq__34026_34693 = cljs.core.seq(children_34692);
var chunk__34028_34694 = null;
var count__34029_34695 = (0);
var i__34030_34696 = (0);
while(true){
if((i__34030_34696 < count__34029_34695)){
var child_34697 = chunk__34028_34694.cljs$core$IIndexed$_nth$arity$2(null,i__34030_34696);
if(cljs.core.truth_(child_34697)){
node.appendChild(child_34697);


var G__34698 = seq__34026_34693;
var G__34699 = chunk__34028_34694;
var G__34700 = count__34029_34695;
var G__34701 = (i__34030_34696 + (1));
seq__34026_34693 = G__34698;
chunk__34028_34694 = G__34699;
count__34029_34695 = G__34700;
i__34030_34696 = G__34701;
continue;
} else {
var G__34702 = seq__34026_34693;
var G__34703 = chunk__34028_34694;
var G__34704 = count__34029_34695;
var G__34705 = (i__34030_34696 + (1));
seq__34026_34693 = G__34702;
chunk__34028_34694 = G__34703;
count__34029_34695 = G__34704;
i__34030_34696 = G__34705;
continue;
}
} else {
var temp__5735__auto___34706__$1 = cljs.core.seq(seq__34026_34693);
if(temp__5735__auto___34706__$1){
var seq__34026_34707__$1 = temp__5735__auto___34706__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34026_34707__$1)){
var c__4556__auto___34708 = cljs.core.chunk_first(seq__34026_34707__$1);
var G__34709 = cljs.core.chunk_rest(seq__34026_34707__$1);
var G__34710 = c__4556__auto___34708;
var G__34711 = cljs.core.count(c__4556__auto___34708);
var G__34712 = (0);
seq__34026_34693 = G__34709;
chunk__34028_34694 = G__34710;
count__34029_34695 = G__34711;
i__34030_34696 = G__34712;
continue;
} else {
var child_34713 = cljs.core.first(seq__34026_34707__$1);
if(cljs.core.truth_(child_34713)){
node.appendChild(child_34713);


var G__34714 = cljs.core.next(seq__34026_34707__$1);
var G__34715 = null;
var G__34716 = (0);
var G__34717 = (0);
seq__34026_34693 = G__34714;
chunk__34028_34694 = G__34715;
count__34029_34695 = G__34716;
i__34030_34696 = G__34717;
continue;
} else {
var G__34718 = cljs.core.next(seq__34026_34707__$1);
var G__34719 = null;
var G__34720 = (0);
var G__34721 = (0);
seq__34026_34693 = G__34718;
chunk__34028_34694 = G__34719;
count__34029_34695 = G__34720;
i__34030_34696 = G__34721;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_34692);
}
}


var G__34722 = cljs.core.next(seq__33943_34684__$1);
var G__34723 = null;
var G__34724 = (0);
var G__34725 = (0);
seq__33943_34639 = G__34722;
chunk__33945_34640 = G__34723;
count__33946_34641 = G__34724;
i__33947_34642 = G__34725;
continue;
} else {
var G__34726 = cljs.core.next(seq__33943_34684__$1);
var G__34727 = null;
var G__34728 = (0);
var G__34729 = (0);
seq__33943_34639 = G__34726;
chunk__33945_34640 = G__34727;
count__33946_34641 = G__34728;
i__33947_34642 = G__34729;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34730 = arguments.length;
var i__4737__auto___34731 = (0);
while(true){
if((i__4737__auto___34731 < len__4736__auto___34730)){
args__4742__auto__.push((arguments[i__4737__auto___34731]));

var G__34732 = (i__4737__auto___34731 + (1));
i__4737__auto___34731 = G__34732;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq34047){
var G__34048 = cljs.core.first(seq34047);
var seq34047__$1 = cljs.core.next(seq34047);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34048,seq34047__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__34055 = arguments.length;
switch (G__34055) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__30152__auto___34734 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_34060){
var state_val_34061 = (state_34060[(1)]);
if((state_val_34061 === (1))){
var state_34060__$1 = state_34060;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34060__$1,(2),once_or_cleanup);
} else {
if((state_val_34061 === (2))){
var inst_34057 = (state_34060[(2)]);
var inst_34058 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_34060__$1 = (function (){var statearr_34063 = state_34060;
(statearr_34063[(7)] = inst_34057);

return statearr_34063;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34060__$1,inst_34058);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__29915__auto__ = null;
var shadow$dom$state_machine__29915__auto____0 = (function (){
var statearr_34065 = [null,null,null,null,null,null,null,null];
(statearr_34065[(0)] = shadow$dom$state_machine__29915__auto__);

(statearr_34065[(1)] = (1));

return statearr_34065;
});
var shadow$dom$state_machine__29915__auto____1 = (function (state_34060){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_34060);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e34066){var ex__29918__auto__ = e34066;
var statearr_34067_34735 = state_34060;
(statearr_34067_34735[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_34060[(4)]))){
var statearr_34068_34736 = state_34060;
(statearr_34068_34736[(1)] = cljs.core.first((state_34060[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34739 = state_34060;
state_34060 = G__34739;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
shadow$dom$state_machine__29915__auto__ = function(state_34060){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__29915__auto____0.call(this);
case 1:
return shadow$dom$state_machine__29915__auto____1.call(this,state_34060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__29915__auto____0;
shadow$dom$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__29915__auto____1;
return shadow$dom$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_34069 = f__30153__auto__();
(statearr_34069[(6)] = c__30152__auto___34734);

return statearr_34069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
