goog.provide('zprint.sutil');
/**
 * The string value of this sexpr.
 */
zprint.sutil.sstring = (function zprint$sutil$sstring(sexpr){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([sexpr], 0));
});
/**
 * Does pr-str.
 */
zprint.sutil.snumstr = (function zprint$sutil$snumstr(zloc,hex_QMARK_,shift_seq){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([zloc], 0));
});
/**
 * Return a seq of everything after this. Maps get
 *   special handling here, as a seq of a map is a bunch
 *   of map elements, which are pretty much vectors of
 *   [k v] pairs.
 */
zprint.sutil.sseqnws = (function zprint$sutil$sseqnws(sexpr){
if(cljs.core.map_QMARK_(sexpr)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.seq(sexpr));
} else {
return cljs.core.seq(sexpr);
}
});
/**
 * Considering the current sexpr a collection, move down into it and
 *   take n non-whitespace elements, dropping the rest.  Then append the
 *   given element to the end.
 */
zprint.sutil.stake_append = (function zprint$sutil$stake_append(n,sexpr,end_sexpr){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,sexpr),(new cljs.core.List(null,end_sexpr,null,(1),null)));
});
/**
 * Take the various inputs and come up with a style.  But we
 *   don't do focus, so that's easy.
 */
zprint.sutil.sfocus_style = (function zprint$sutil$sfocus_style(style,_,sexpr){
return style;
});
/**
 * Find the nthnext of this sexpr.
 */
zprint.sutil.snthnext = (function zprint$sutil$snthnext(sexpr,n){
if(cljs.core.coll_QMARK_(sexpr)){
return cljs.core.nthnext(sexpr,n);
} else {
return null;
}
});
/**
 * Find the locations (counting from zero, and only counting non-whitespace
 *   elements) of the first zthing?.  Return its index if it is found, nil if not.
 */
zprint.sutil.sfind = (function zprint$sutil$sfind(zthing_QMARK_,sexpr){
if(cljs.core.coll_QMARK_(sexpr)){
var sloc = sexpr;
var i = (0);
while(true){
if(cljs.core.truth_(sloc)){
if(cljs.core.truth_((function (){var G__34528 = cljs.core.first(sloc);
return (zthing_QMARK_.cljs$core$IFn$_invoke$arity$1 ? zthing_QMARK_.cljs$core$IFn$_invoke$arity$1(G__34528) : zthing_QMARK_.call(null,G__34528));
})())){
return i;
} else {
var G__34689 = cljs.core.next(sloc);
var G__34690 = (i + (1));
sloc = G__34689;
i = G__34690;
continue;
}
} else {
return null;
}
break;
}
} else {
return null;
}
});
/**
 * How many children does sexpr have?
 */
zprint.sutil.scount = (function zprint$sutil$scount(sexpr){
if(cljs.core.coll_QMARK_(sexpr)){
return cljs.core.count(sexpr);
} else {
return (0);
}
});
/**
 * Return a vector containing the return of applying a function to
 *   every element inside of sexpr.
 */
zprint.sutil.smap = (function zprint$sutil$smap(zfn,sexpr){
var v = ((cljs.core.coll_QMARK_(sexpr))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(zfn,sexpr):cljs.core.PersistentVector.EMPTY);
return v;
});
/**
 * Is this an anonymous fn?
 */
zprint.sutil.sfn_QMARK_ = (function zprint$sutil$sfn_QMARK_(sexpr){
return cljs.core.fn_QMARK_(sexpr);
});
/**
 * Is this the focus.  It is possible that this could
 *   be implemented with path's and such, but that is not a goal
 *   at this point.
 */
zprint.sutil.sfocus = (function zprint$sutil$sfocus(sexpr,fsexpr){
return null;
});
/**
 * This is inherently impossible, as we don't have
 *   an up capability.  But we could build one as we
 *   go down which would give us an up capability (or
 *   at least we would always know where we were).  An
 *   interesting idea, but for now, return essentially
 *   nothing.
 */
zprint.sutil.sfind_root_and_path = (function zprint$sutil$sfind_root_and_path(sexpr){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["root",cljs.core.PersistentVector.EMPTY], null);
});
/**
 * Return true if this is whitespace.  But as we
 *   don't have any whitespace in regular s-expressions,
 *   we will always return false.
 */
zprint.sutil.swhitespace_QMARK_ = (function zprint$sutil$swhitespace_QMARK_(sexpr){
return null;
});
/**
 * Do the first thing, with the right amount of arguments.
 */
zprint.sutil.sfirst = (function zprint$sutil$sfirst(sexpr){
return cljs.core.first(sexpr);
});
/**
 * Do the second thing, with the right amount of arguments.
 */
zprint.sutil.ssecond = (function zprint$sutil$ssecond(sexpr){
return cljs.core.second(sexpr);
});
/**
 * Define a third since we need one, and znth isn't really nth.
 */
zprint.sutil.sthird = (function zprint$sutil$sthird(sexpr){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sexpr,(2));
});
/**
 * Define a fourth since we need one, and znth isn't really nth.
 */
zprint.sutil.sfourth = (function zprint$sutil$sfourth(sexpr){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sexpr,(3));
});
/**
 * A list? that includes cons.
 */
zprint.sutil.slist_QMARK_ = (function zprint$sutil$slist_QMARK_(sexpr){
return ((cljs.core.list_QMARK_(sexpr)) || (cljs.core.seq_QMARK_(sexpr)));
});
/**
 * last which can take two arguments.
 */
zprint.sutil.slast = (function zprint$sutil$slast(sexpr){
if(cljs.core.coll_QMARK_(sexpr)){
return cljs.core.last(sexpr);
} else {
return sexpr;
}
});
/**
 * Is this an array?
 */
zprint.sutil.sarray_QMARK_ = (function zprint$sutil$sarray_QMARK_(x){
if(cljs.core.truth_(x)){
return cljs.core.array_QMARK_(x);
} else {
return null;
}
});
/**
 * Is this an atom?
 */
zprint.sutil.satom_QMARK_ = (function zprint$sutil$satom_QMARK_(x){
if(cljs.core.truth_(x)){
return null;
} else {
return null;
}
});
/**
 * Deref this thing.
 */
zprint.sutil.sderef = (function zprint$sutil$sderef(x){
return cljs.core.deref(x);
});
/**
 * Blow an array out into a vector.
 */
zprint.sutil.sexpandarray = (function zprint$sutil$sexpandarray(a){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,a);
});
/**
 * Is this a namespace?
 */
zprint.sutil.sns_QMARK_ = (function zprint$sutil$sns_QMARK_(x){
if((x instanceof cljs.core.Symbol)){
return cljs.core.find_ns(x);
} else {
return null;
}
});
/**
 * Turn something whose pr-str starts with #object into a vector.
 *   obj is the thing that prints as #object, and val is its value.
 *   Two forms, one with and one w/out val.  val could be nil, or
 *   anything, so there isn't a particularly good sentinal here.
 */
zprint.sutil.sobj_to_vec = (function zprint$sutil$sobj_to_vec(var_args){
var G__34543 = arguments.length;
switch (G__34543) {
case 2:
return zprint.sutil.sobj_to_vec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return zprint.sutil.sobj_to_vec.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(zprint.sutil.sobj_to_vec.cljs$core$IFn$_invoke$arity$2 = (function (obj,val){
var obj_term = clojure.string.split.cljs$core$IFn$_invoke$arity$3(clojure.string.replace(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([obj], 0)),/^\#object\[/,""),/ /,(3));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.first(obj_term)),cljs.core.second(obj_term),val], null);
}));

(zprint.sutil.sobj_to_vec.cljs$core$IFn$_invoke$arity$1 = (function (obj){
var obj_term = clojure.string.split.cljs$core$IFn$_invoke$arity$3(clojure.string.replace(clojure.string.replace(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([obj], 0)),/^\#object\[/,""),/\]$/,""),/ /,(3));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.first(obj_term)),cljs.core.second(obj_term),cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(obj_term,(2)))], null);
}));

(zprint.sutil.sobj_to_vec.cljs$lang$maxFixedArity = 2);

/**
 * Is this a promise?
 */
zprint.sutil.spromise_QMARK_ = (function zprint$sutil$spromise_QMARK_(x){
return null;
});
/**
 * Is this an agent?
 */
zprint.sutil.sagent_QMARK_ = (function zprint$sutil$sagent_QMARK_(x){
return null;
});
/**
 * Is this a constant?
 */
zprint.sutil.sconstant_QMARK_ = (function zprint$sutil$sconstant_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || (typeof x === 'string') || (typeof x === 'number') || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("true",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("false",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))));
});
/**
 * Perform a lift-ns on a pair-seq that is returned from
 *   partition-2-all-nc, which is a seq of pairs of zlocs that may or
 *   may not have been sorted and which may or may not have had things
 *   removed from it and may or may not actually be pairs.  Could be
 *   single things, could be multiple things.  If contains multiple
 *   things, the first thing is the key, but if it is just a single
 *   thing, the first thing is *not* a key. So we only need to work
 *   on the first of each seq which has more than one element in it,
 *   and possibly replace it. This will only lift out a ns if all keys
 *   in seqs with more than one element have the same namespace. Returns
 *   the [namespace pair-seq] or nil.
 */
zprint.sutil.slift_ns = (function zprint$sutil$slift_ns(p__34545,pair_seq,ns){
var map__34546 = p__34545;
var map__34546__$1 = (((((!((map__34546 == null))))?(((((map__34546.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34546.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34546):map__34546);
var map_options = map__34546__$1;
var in_code_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34546__$1,new cljs.core.Keyword(null,"in-code?","in-code?",194866464));
var lift_ns_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34546__$1,new cljs.core.Keyword(null,"lift-ns?","lift-ns?",2021372853));
var lift_ns_in_code_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34546__$1,new cljs.core.Keyword(null,"lift-ns-in-code?","lift-ns-in-code?",1444279377));
var unlift_ns_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34546__$1,new cljs.core.Keyword(null,"unlift-ns?","unlift-ns?",1065087867));
if(cljs.core.truth_((function (){var and__4115__auto__ = lift_ns_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
if(cljs.core.truth_(in_code_QMARK_)){
return lift_ns_in_code_QMARK_;
} else {
return true;
}
} else {
return and__4115__auto__;
}
})())){
var strip_ns = (function (named){
if((named instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,cljs.core.name(named));
} else {
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(null,cljs.core.name(named));
}
});
var ns__$1 = null;
var pair_seq__$1 = pair_seq;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
var vec__34551 = cljs.core.first(pair_seq__$1);
var seq__34552 = cljs.core.seq(vec__34551);
var first__34553 = cljs.core.first(seq__34552);
var seq__34552__$1 = cljs.core.next(seq__34552);
var k = first__34553;
var rest_of_pair = seq__34552__$1;
var pair = vec__34551;
var current_ns = ((((rest_of_pair) && ((((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))))))?cljs.core.namespace(k):null);
if(cljs.core.not(k)){
if(cljs.core.truth_(ns__$1)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1)].join(''),out], null);
} else {
return null;
}
} else {
if(cljs.core.truth_(current_ns)){
if(cljs.core.truth_(ns__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns__$1,current_ns)){
var G__34700 = ns__$1;
var G__34701 = cljs.core.next(pair_seq__$1);
var G__34702 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,cljs.core.cons(strip_ns(k),rest_of_pair));
ns__$1 = G__34700;
pair_seq__$1 = G__34701;
out = G__34702;
continue;
} else {
return null;
}
} else {
var G__34704 = current_ns;
var G__34705 = cljs.core.next(pair_seq__$1);
var G__34706 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,cljs.core.cons(strip_ns(k),rest_of_pair));
ns__$1 = G__34704;
pair_seq__$1 = G__34705;
out = G__34706;
continue;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(pair),(1))){
var G__34708 = ns__$1;
var G__34709 = cljs.core.next(pair_seq__$1);
var G__34710 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,pair);
ns__$1 = G__34708;
pair_seq__$1 = G__34709;
out = G__34710;
continue;
} else {
return null;
}
}
}
break;
}
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,pair_seq], null);
}
});
/**
 * Redefine all of the traversal functions for s-expressions, then
 *   call the function of no arguments passed in.
 */
zprint.sutil.sredef_call = (function zprint$sutil$sredef_call(body_fn){
var zstring_orig_val__34556 = zprint.zfns.zstring;
var znumstr_orig_val__34557 = zprint.zfns.znumstr;
var zcomment_QMARK__orig_val__34558 = zprint.zfns.zcomment_QMARK_;
var zsexpr_orig_val__34559 = zprint.zfns.zsexpr;
var zseqnws_orig_val__34560 = zprint.zfns.zseqnws;
var zseqnws_w_nl_orig_val__34561 = zprint.zfns.zseqnws_w_nl;
var zseqnws_w_bl_orig_val__34562 = zprint.zfns.zseqnws_w_bl;
var zfocus_style_orig_val__34563 = zprint.zfns.zfocus_style;
var zstart_orig_val__34564 = zprint.zfns.zstart;
var zfirst_orig_val__34565 = zprint.zfns.zfirst;
var zfirst_no_comment_orig_val__34566 = zprint.zfns.zfirst_no_comment;
var zsecond_orig_val__34567 = zprint.zfns.zsecond;
var zsecond_no_comment_orig_val__34568 = zprint.zfns.zsecond_no_comment;
var zthird_orig_val__34569 = zprint.zfns.zthird;
var zthird_no_comment_orig_val__34570 = zprint.zfns.zthird_no_comment;
var zfourth_orig_val__34571 = zprint.zfns.zfourth;
var znextnws_orig_val__34572 = zprint.zfns.znextnws;
var znextnws_w_nl_orig_val__34573 = zprint.zfns.znextnws_w_nl;
var znthnext_orig_val__34574 = zprint.zfns.znthnext;
var zcount_orig_val__34575 = zprint.zfns.zcount;
var zcount_zloc_seq_nc_nws_orig_val__34576 = zprint.zfns.zcount_zloc_seq_nc_nws;
var zmap_orig_val__34577 = zprint.zfns.zmap;
var zmap_w_nl_orig_val__34578 = zprint.zfns.zmap_w_nl;
var zmap_w_bl_orig_val__34579 = zprint.zfns.zmap_w_bl;
var zmap_w_nl_comma_orig_val__34580 = zprint.zfns.zmap_w_nl_comma;
var zanonfn_QMARK__orig_val__34581 = zprint.zfns.zanonfn_QMARK_;
var zfn_obj_QMARK__orig_val__34582 = zprint.zfns.zfn_obj_QMARK_;
var zfocus_orig_val__34583 = zprint.zfns.zfocus;
var zfind_path_orig_val__34584 = zprint.zfns.zfind_path;
var zwhitespace_QMARK__orig_val__34585 = zprint.zfns.zwhitespace_QMARK_;
var zlist_QMARK__orig_val__34586 = zprint.zfns.zlist_QMARK_;
var zvector_QMARK__orig_val__34587 = zprint.zfns.zvector_QMARK_;
var zmap_QMARK__orig_val__34588 = zprint.zfns.zmap_QMARK_;
var znamespacedmap_QMARK__orig_val__34589 = zprint.zfns.znamespacedmap_QMARK_;
var zset_QMARK__orig_val__34590 = zprint.zfns.zset_QMARK_;
var zcoll_QMARK__orig_val__34591 = zprint.zfns.zcoll_QMARK_;
var zmeta_QMARK__orig_val__34592 = zprint.zfns.zmeta_QMARK_;
var zuneval_QMARK__orig_val__34593 = zprint.zfns.zuneval_QMARK_;
var ztag_orig_val__34594 = zprint.zfns.ztag;
var zlast_orig_val__34595 = zprint.zfns.zlast;
var zarray_QMARK__orig_val__34596 = zprint.zfns.zarray_QMARK_;
var zatom_QMARK__orig_val__34597 = zprint.zfns.zatom_QMARK_;
var zderef_orig_val__34598 = zprint.zfns.zderef;
var zrecord_QMARK__orig_val__34599 = zprint.zfns.zrecord_QMARK_;
var zns_QMARK__orig_val__34600 = zprint.zfns.zns_QMARK_;
var zobj_to_vec_orig_val__34601 = zprint.zfns.zobj_to_vec;
var zexpandarray_orig_val__34602 = zprint.zfns.zexpandarray;
var znewline_QMARK__orig_val__34603 = zprint.zfns.znewline_QMARK_;
var zwhitespaceorcomment_QMARK__orig_val__34604 = zprint.zfns.zwhitespaceorcomment_QMARK_;
var zmap_all_orig_val__34605 = zprint.zfns.zmap_all;
var zfuture_QMARK__orig_val__34606 = zprint.zfns.zfuture_QMARK_;
var zpromise_QMARK__orig_val__34607 = zprint.zfns.zpromise_QMARK_;
var zkeyword_QMARK__orig_val__34608 = zprint.zfns.zkeyword_QMARK_;
var zdelay_QMARK__orig_val__34609 = zprint.zfns.zdelay_QMARK_;
var zconstant_QMARK__orig_val__34610 = zprint.zfns.zconstant_QMARK_;
var zagent_QMARK__orig_val__34611 = zprint.zfns.zagent_QMARK_;
var zreader_macro_QMARK__orig_val__34612 = zprint.zfns.zreader_macro_QMARK_;
var zarray_to_shift_seq_orig_val__34613 = zprint.zfns.zarray_to_shift_seq;
var zdotdotdot_orig_val__34614 = zprint.zfns.zdotdotdot;
var zsymbol_QMARK__orig_val__34615 = zprint.zfns.zsymbol_QMARK_;
var znil_QMARK__orig_val__34616 = zprint.zfns.znil_QMARK_;
var zreader_cond_w_symbol_QMARK__orig_val__34617 = zprint.zfns.zreader_cond_w_symbol_QMARK_;
var zreader_cond_w_coll_QMARK__orig_val__34618 = zprint.zfns.zreader_cond_w_coll_QMARK_;
var zlift_ns_orig_val__34619 = zprint.zfns.zlift_ns;
var zfind_orig_val__34620 = zprint.zfns.zfind;
var ztake_append_orig_val__34621 = zprint.zfns.ztake_append;
var zstring_temp_val__34622 = zprint.sutil.sstring;
var znumstr_temp_val__34623 = zprint.sutil.snumstr;
var zcomment_QMARK__temp_val__34624 = cljs.core.constantly(false);
var zsexpr_temp_val__34625 = cljs.core.identity;
var zseqnws_temp_val__34626 = zprint.sutil.sseqnws;
var zseqnws_w_nl_temp_val__34627 = zprint.sutil.sseqnws;
var zseqnws_w_bl_temp_val__34628 = zprint.sutil.sseqnws;
var zfocus_style_temp_val__34629 = zprint.sutil.sfocus_style;
var zstart_temp_val__34630 = zprint.sutil.sfirst;
var zfirst_temp_val__34631 = zprint.sutil.sfirst;
var zfirst_no_comment_temp_val__34632 = zprint.sutil.sfirst;
var zsecond_temp_val__34633 = zprint.sutil.ssecond;
var zsecond_no_comment_temp_val__34634 = zprint.sutil.ssecond;
var zthird_temp_val__34635 = zprint.sutil.sthird;
var zthird_no_comment_temp_val__34636 = zprint.sutil.sthird;
var zfourth_temp_val__34637 = zprint.sutil.sfourth;
var znextnws_temp_val__34638 = cljs.core.next;
var znextnws_w_nl_temp_val__34639 = cljs.core.next;
var znthnext_temp_val__34640 = zprint.sutil.snthnext;
var zcount_temp_val__34641 = zprint.sutil.scount;
var zcount_zloc_seq_nc_nws_temp_val__34642 = zprint.sutil.scount;
var zmap_temp_val__34643 = zprint.sutil.smap;
var zmap_w_nl_temp_val__34644 = zprint.sutil.smap;
var zmap_w_bl_temp_val__34645 = zprint.sutil.smap;
var zmap_w_nl_comma_temp_val__34646 = zprint.sutil.smap;
var zanonfn_QMARK__temp_val__34647 = cljs.core.constantly(false);
var zfn_obj_QMARK__temp_val__34648 = cljs.core.fn_QMARK_;
var zfocus_temp_val__34649 = zprint.sutil.sfocus;
var zfind_path_temp_val__34650 = zprint.sutil.sfind_root_and_path;
var zwhitespace_QMARK__temp_val__34651 = zprint.sutil.swhitespace_QMARK_;
var zlist_QMARK__temp_val__34652 = zprint.sutil.slist_QMARK_;
var zvector_QMARK__temp_val__34653 = cljs.core.vector_QMARK_;
var zmap_QMARK__temp_val__34654 = cljs.core.map_QMARK_;
var znamespacedmap_QMARK__temp_val__34655 = cljs.core.constantly(false);
var zset_QMARK__temp_val__34656 = cljs.core.set_QMARK_;
var zcoll_QMARK__temp_val__34657 = cljs.core.coll_QMARK_;
var zmeta_QMARK__temp_val__34658 = cljs.core.constantly(false);
var zuneval_QMARK__temp_val__34659 = cljs.core.constantly(false);
var ztag_temp_val__34660 = cljs.core.constantly(null);
var zlast_temp_val__34661 = zprint.sutil.slast;
var zarray_QMARK__temp_val__34662 = zprint.sutil.sarray_QMARK_;
var zatom_QMARK__temp_val__34663 = zprint.sutil.satom_QMARK_;
var zderef_temp_val__34664 = zprint.sutil.sderef;
var zrecord_QMARK__temp_val__34665 = cljs.core.record_QMARK_;
var zns_QMARK__temp_val__34666 = cljs.core.constantly(false);
var zobj_to_vec_temp_val__34667 = zprint.sutil.sobj_to_vec;
var zexpandarray_temp_val__34668 = zprint.sutil.sexpandarray;
var znewline_QMARK__temp_val__34669 = cljs.core.constantly(false);
var zwhitespaceorcomment_QMARK__temp_val__34670 = cljs.core.constantly(false);
var zmap_all_temp_val__34671 = cljs.core.map;
var zfuture_QMARK__temp_val__34672 = cljs.core.constantly(false);
var zpromise_QMARK__temp_val__34673 = zprint.sutil.spromise_QMARK_;
var zkeyword_QMARK__temp_val__34674 = cljs.core.keyword_QMARK_;
var zdelay_QMARK__temp_val__34675 = cljs.core.delay_QMARK_;
var zconstant_QMARK__temp_val__34676 = zprint.sutil.sconstant_QMARK_;
var zagent_QMARK__temp_val__34677 = zprint.sutil.sagent_QMARK_;
var zreader_macro_QMARK__temp_val__34678 = cljs.core.constantly(false);
var zarray_to_shift_seq_temp_val__34679 = null;
var zdotdotdot_temp_val__34680 = cljs.core.constantly(new cljs.core.Symbol(null,"...","...",-1926939749,null));
var zsymbol_QMARK__temp_val__34681 = cljs.core.symbol_QMARK_;
var znil_QMARK__temp_val__34682 = cljs.core.nil_QMARK_;
var zreader_cond_w_symbol_QMARK__temp_val__34683 = cljs.core.constantly(false);
var zreader_cond_w_coll_QMARK__temp_val__34684 = cljs.core.constantly(false);
var zlift_ns_temp_val__34685 = zprint.sutil.slift_ns;
var zfind_temp_val__34686 = zprint.sutil.sfind;
var ztake_append_temp_val__34687 = zprint.sutil.stake_append;
(zprint.zfns.zstring = zstring_temp_val__34622);

(zprint.zfns.znumstr = znumstr_temp_val__34623);

(zprint.zfns.zcomment_QMARK_ = zcomment_QMARK__temp_val__34624);

(zprint.zfns.zsexpr = zsexpr_temp_val__34625);

(zprint.zfns.zseqnws = zseqnws_temp_val__34626);

(zprint.zfns.zseqnws_w_nl = zseqnws_w_nl_temp_val__34627);

(zprint.zfns.zseqnws_w_bl = zseqnws_w_bl_temp_val__34628);

(zprint.zfns.zfocus_style = zfocus_style_temp_val__34629);

(zprint.zfns.zstart = zstart_temp_val__34630);

(zprint.zfns.zfirst = zfirst_temp_val__34631);

(zprint.zfns.zfirst_no_comment = zfirst_no_comment_temp_val__34632);

(zprint.zfns.zsecond = zsecond_temp_val__34633);

(zprint.zfns.zsecond_no_comment = zsecond_no_comment_temp_val__34634);

(zprint.zfns.zthird = zthird_temp_val__34635);

(zprint.zfns.zthird_no_comment = zthird_no_comment_temp_val__34636);

(zprint.zfns.zfourth = zfourth_temp_val__34637);

(zprint.zfns.znextnws = znextnws_temp_val__34638);

(zprint.zfns.znextnws_w_nl = znextnws_w_nl_temp_val__34639);

(zprint.zfns.znthnext = znthnext_temp_val__34640);

(zprint.zfns.zcount = zcount_temp_val__34641);

(zprint.zfns.zcount_zloc_seq_nc_nws = zcount_zloc_seq_nc_nws_temp_val__34642);

(zprint.zfns.zmap = zmap_temp_val__34643);

(zprint.zfns.zmap_w_nl = zmap_w_nl_temp_val__34644);

(zprint.zfns.zmap_w_bl = zmap_w_bl_temp_val__34645);

(zprint.zfns.zmap_w_nl_comma = zmap_w_nl_comma_temp_val__34646);

(zprint.zfns.zanonfn_QMARK_ = zanonfn_QMARK__temp_val__34647);

(zprint.zfns.zfn_obj_QMARK_ = zfn_obj_QMARK__temp_val__34648);

(zprint.zfns.zfocus = zfocus_temp_val__34649);

(zprint.zfns.zfind_path = zfind_path_temp_val__34650);

(zprint.zfns.zwhitespace_QMARK_ = zwhitespace_QMARK__temp_val__34651);

(zprint.zfns.zlist_QMARK_ = zlist_QMARK__temp_val__34652);

(zprint.zfns.zvector_QMARK_ = zvector_QMARK__temp_val__34653);

(zprint.zfns.zmap_QMARK_ = zmap_QMARK__temp_val__34654);

(zprint.zfns.znamespacedmap_QMARK_ = znamespacedmap_QMARK__temp_val__34655);

(zprint.zfns.zset_QMARK_ = zset_QMARK__temp_val__34656);

(zprint.zfns.zcoll_QMARK_ = zcoll_QMARK__temp_val__34657);

(zprint.zfns.zmeta_QMARK_ = zmeta_QMARK__temp_val__34658);

(zprint.zfns.zuneval_QMARK_ = zuneval_QMARK__temp_val__34659);

(zprint.zfns.ztag = ztag_temp_val__34660);

(zprint.zfns.zlast = zlast_temp_val__34661);

(zprint.zfns.zarray_QMARK_ = zarray_QMARK__temp_val__34662);

(zprint.zfns.zatom_QMARK_ = zatom_QMARK__temp_val__34663);

(zprint.zfns.zderef = zderef_temp_val__34664);

(zprint.zfns.zrecord_QMARK_ = zrecord_QMARK__temp_val__34665);

(zprint.zfns.zns_QMARK_ = zns_QMARK__temp_val__34666);

(zprint.zfns.zobj_to_vec = zobj_to_vec_temp_val__34667);

(zprint.zfns.zexpandarray = zexpandarray_temp_val__34668);

(zprint.zfns.znewline_QMARK_ = znewline_QMARK__temp_val__34669);

(zprint.zfns.zwhitespaceorcomment_QMARK_ = zwhitespaceorcomment_QMARK__temp_val__34670);

(zprint.zfns.zmap_all = zmap_all_temp_val__34671);

(zprint.zfns.zfuture_QMARK_ = zfuture_QMARK__temp_val__34672);

(zprint.zfns.zpromise_QMARK_ = zpromise_QMARK__temp_val__34673);

(zprint.zfns.zkeyword_QMARK_ = zkeyword_QMARK__temp_val__34674);

(zprint.zfns.zdelay_QMARK_ = zdelay_QMARK__temp_val__34675);

(zprint.zfns.zconstant_QMARK_ = zconstant_QMARK__temp_val__34676);

(zprint.zfns.zagent_QMARK_ = zagent_QMARK__temp_val__34677);

(zprint.zfns.zreader_macro_QMARK_ = zreader_macro_QMARK__temp_val__34678);

(zprint.zfns.zarray_to_shift_seq = zarray_to_shift_seq_temp_val__34679);

(zprint.zfns.zdotdotdot = zdotdotdot_temp_val__34680);

(zprint.zfns.zsymbol_QMARK_ = zsymbol_QMARK__temp_val__34681);

(zprint.zfns.znil_QMARK_ = znil_QMARK__temp_val__34682);

(zprint.zfns.zreader_cond_w_symbol_QMARK_ = zreader_cond_w_symbol_QMARK__temp_val__34683);

(zprint.zfns.zreader_cond_w_coll_QMARK_ = zreader_cond_w_coll_QMARK__temp_val__34684);

(zprint.zfns.zlift_ns = zlift_ns_temp_val__34685);

(zprint.zfns.zfind = zfind_temp_val__34686);

(zprint.zfns.ztake_append = ztake_append_temp_val__34687);

try{return (body_fn.cljs$core$IFn$_invoke$arity$0 ? body_fn.cljs$core$IFn$_invoke$arity$0() : body_fn.call(null));
}finally {(zprint.zfns.ztake_append = ztake_append_orig_val__34621);

(zprint.zfns.zfind = zfind_orig_val__34620);

(zprint.zfns.zlift_ns = zlift_ns_orig_val__34619);

(zprint.zfns.zreader_cond_w_coll_QMARK_ = zreader_cond_w_coll_QMARK__orig_val__34618);

(zprint.zfns.zreader_cond_w_symbol_QMARK_ = zreader_cond_w_symbol_QMARK__orig_val__34617);

(zprint.zfns.znil_QMARK_ = znil_QMARK__orig_val__34616);

(zprint.zfns.zsymbol_QMARK_ = zsymbol_QMARK__orig_val__34615);

(zprint.zfns.zdotdotdot = zdotdotdot_orig_val__34614);

(zprint.zfns.zarray_to_shift_seq = zarray_to_shift_seq_orig_val__34613);

(zprint.zfns.zreader_macro_QMARK_ = zreader_macro_QMARK__orig_val__34612);

(zprint.zfns.zagent_QMARK_ = zagent_QMARK__orig_val__34611);

(zprint.zfns.zconstant_QMARK_ = zconstant_QMARK__orig_val__34610);

(zprint.zfns.zdelay_QMARK_ = zdelay_QMARK__orig_val__34609);

(zprint.zfns.zkeyword_QMARK_ = zkeyword_QMARK__orig_val__34608);

(zprint.zfns.zpromise_QMARK_ = zpromise_QMARK__orig_val__34607);

(zprint.zfns.zfuture_QMARK_ = zfuture_QMARK__orig_val__34606);

(zprint.zfns.zmap_all = zmap_all_orig_val__34605);

(zprint.zfns.zwhitespaceorcomment_QMARK_ = zwhitespaceorcomment_QMARK__orig_val__34604);

(zprint.zfns.znewline_QMARK_ = znewline_QMARK__orig_val__34603);

(zprint.zfns.zexpandarray = zexpandarray_orig_val__34602);

(zprint.zfns.zobj_to_vec = zobj_to_vec_orig_val__34601);

(zprint.zfns.zns_QMARK_ = zns_QMARK__orig_val__34600);

(zprint.zfns.zrecord_QMARK_ = zrecord_QMARK__orig_val__34599);

(zprint.zfns.zderef = zderef_orig_val__34598);

(zprint.zfns.zatom_QMARK_ = zatom_QMARK__orig_val__34597);

(zprint.zfns.zarray_QMARK_ = zarray_QMARK__orig_val__34596);

(zprint.zfns.zlast = zlast_orig_val__34595);

(zprint.zfns.ztag = ztag_orig_val__34594);

(zprint.zfns.zuneval_QMARK_ = zuneval_QMARK__orig_val__34593);

(zprint.zfns.zmeta_QMARK_ = zmeta_QMARK__orig_val__34592);

(zprint.zfns.zcoll_QMARK_ = zcoll_QMARK__orig_val__34591);

(zprint.zfns.zset_QMARK_ = zset_QMARK__orig_val__34590);

(zprint.zfns.znamespacedmap_QMARK_ = znamespacedmap_QMARK__orig_val__34589);

(zprint.zfns.zmap_QMARK_ = zmap_QMARK__orig_val__34588);

(zprint.zfns.zvector_QMARK_ = zvector_QMARK__orig_val__34587);

(zprint.zfns.zlist_QMARK_ = zlist_QMARK__orig_val__34586);

(zprint.zfns.zwhitespace_QMARK_ = zwhitespace_QMARK__orig_val__34585);

(zprint.zfns.zfind_path = zfind_path_orig_val__34584);

(zprint.zfns.zfocus = zfocus_orig_val__34583);

(zprint.zfns.zfn_obj_QMARK_ = zfn_obj_QMARK__orig_val__34582);

(zprint.zfns.zanonfn_QMARK_ = zanonfn_QMARK__orig_val__34581);

(zprint.zfns.zmap_w_nl_comma = zmap_w_nl_comma_orig_val__34580);

(zprint.zfns.zmap_w_bl = zmap_w_bl_orig_val__34579);

(zprint.zfns.zmap_w_nl = zmap_w_nl_orig_val__34578);

(zprint.zfns.zmap = zmap_orig_val__34577);

(zprint.zfns.zcount_zloc_seq_nc_nws = zcount_zloc_seq_nc_nws_orig_val__34576);

(zprint.zfns.zcount = zcount_orig_val__34575);

(zprint.zfns.znthnext = znthnext_orig_val__34574);

(zprint.zfns.znextnws_w_nl = znextnws_w_nl_orig_val__34573);

(zprint.zfns.znextnws = znextnws_orig_val__34572);

(zprint.zfns.zfourth = zfourth_orig_val__34571);

(zprint.zfns.zthird_no_comment = zthird_no_comment_orig_val__34570);

(zprint.zfns.zthird = zthird_orig_val__34569);

(zprint.zfns.zsecond_no_comment = zsecond_no_comment_orig_val__34568);

(zprint.zfns.zsecond = zsecond_orig_val__34567);

(zprint.zfns.zfirst_no_comment = zfirst_no_comment_orig_val__34566);

(zprint.zfns.zfirst = zfirst_orig_val__34565);

(zprint.zfns.zstart = zstart_orig_val__34564);

(zprint.zfns.zfocus_style = zfocus_style_orig_val__34563);

(zprint.zfns.zseqnws_w_bl = zseqnws_w_bl_orig_val__34562);

(zprint.zfns.zseqnws_w_nl = zseqnws_w_nl_orig_val__34561);

(zprint.zfns.zseqnws = zseqnws_orig_val__34560);

(zprint.zfns.zsexpr = zsexpr_orig_val__34559);

(zprint.zfns.zcomment_QMARK_ = zcomment_QMARK__orig_val__34558);

(zprint.zfns.znumstr = znumstr_orig_val__34557);

(zprint.zfns.zstring = zstring_orig_val__34556);
}});

//# sourceMappingURL=zprint.sutil.js.map
