goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30292 = arguments.length;
switch (G__30292) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30299 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30299 = (function (f,blockable,meta30300){
this.f = f;
this.blockable = blockable;
this.meta30300 = meta30300;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30299.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30301,meta30300__$1){
var self__ = this;
var _30301__$1 = this;
return (new cljs.core.async.t_cljs$core$async30299(self__.f,self__.blockable,meta30300__$1));
}));

(cljs.core.async.t_cljs$core$async30299.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30301){
var self__ = this;
var _30301__$1 = this;
return self__.meta30300;
}));

(cljs.core.async.t_cljs$core$async30299.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30299.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30299.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async30299.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async30299.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30300","meta30300",1990555963,null)], null);
}));

(cljs.core.async.t_cljs$core$async30299.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30299.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30299");

(cljs.core.async.t_cljs$core$async30299.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30299");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30299.
 */
cljs.core.async.__GT_t_cljs$core$async30299 = (function cljs$core$async$__GT_t_cljs$core$async30299(f__$1,blockable__$1,meta30300){
return (new cljs.core.async.t_cljs$core$async30299(f__$1,blockable__$1,meta30300));
});

}

return (new cljs.core.async.t_cljs$core$async30299(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__30381 = arguments.length;
switch (G__30381) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__30385 = arguments.length;
switch (G__30385) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__30400 = arguments.length;
switch (G__30400) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_33125 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_33125) : fn1.call(null,val_33125));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_33125) : fn1.call(null,val_33125));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__30439 = arguments.length;
switch (G__30439) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___33129 = n;
var x_33131 = (0);
while(true){
if((x_33131 < n__4613__auto___33129)){
(a[x_33131] = x_33131);

var G__33132 = (x_33131 + (1));
x_33131 = G__33132;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30462 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30462 = (function (flag,meta30463){
this.flag = flag;
this.meta30463 = meta30463;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30462.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30464,meta30463__$1){
var self__ = this;
var _30464__$1 = this;
return (new cljs.core.async.t_cljs$core$async30462(self__.flag,meta30463__$1));
}));

(cljs.core.async.t_cljs$core$async30462.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30464){
var self__ = this;
var _30464__$1 = this;
return self__.meta30463;
}));

(cljs.core.async.t_cljs$core$async30462.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30462.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30462.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30462.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async30462.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30463","meta30463",-1968638225,null)], null);
}));

(cljs.core.async.t_cljs$core$async30462.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30462.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30462");

(cljs.core.async.t_cljs$core$async30462.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30462");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30462.
 */
cljs.core.async.__GT_t_cljs$core$async30462 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async30462(flag__$1,meta30463){
return (new cljs.core.async.t_cljs$core$async30462(flag__$1,meta30463));
});

}

return (new cljs.core.async.t_cljs$core$async30462(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30491 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30491 = (function (flag,cb,meta30492){
this.flag = flag;
this.cb = cb;
this.meta30492 = meta30492;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30493,meta30492__$1){
var self__ = this;
var _30493__$1 = this;
return (new cljs.core.async.t_cljs$core$async30491(self__.flag,self__.cb,meta30492__$1));
}));

(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30493){
var self__ = this;
var _30493__$1 = this;
return self__.meta30492;
}));

(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async30491.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30492","meta30492",-750744378,null)], null);
}));

(cljs.core.async.t_cljs$core$async30491.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30491.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30491");

(cljs.core.async.t_cljs$core$async30491.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30491");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30491.
 */
cljs.core.async.__GT_t_cljs$core$async30491 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async30491(flag__$1,cb__$1,meta30492){
return (new cljs.core.async.t_cljs$core$async30491(flag__$1,cb__$1,meta30492));
});

}

return (new cljs.core.async.t_cljs$core$async30491(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30513_SHARP_){
var G__30515 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30513_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30515) : fret.call(null,G__30515));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30514_SHARP_){
var G__30545 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30514_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30545) : fret.call(null,G__30545));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__33154 = (i + (1));
i = G__33154;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33155 = arguments.length;
var i__4737__auto___33156 = (0);
while(true){
if((i__4737__auto___33156 < len__4736__auto___33155)){
args__4742__auto__.push((arguments[i__4737__auto___33156]));

var G__33157 = (i__4737__auto___33156 + (1));
i__4737__auto___33156 = G__33157;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30552){
var map__30553 = p__30552;
var map__30553__$1 = (((((!((map__30553 == null))))?(((((map__30553.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30553.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30553):map__30553);
var opts = map__30553__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30550){
var G__30551 = cljs.core.first(seq30550);
var seq30550__$1 = cljs.core.next(seq30550);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30551,seq30550__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__30579 = arguments.length;
switch (G__30579) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30152__auto___33160 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_30750){
var state_val_30751 = (state_30750[(1)]);
if((state_val_30751 === (7))){
var inst_30728 = (state_30750[(2)]);
var state_30750__$1 = state_30750;
var statearr_30755_33161 = state_30750__$1;
(statearr_30755_33161[(2)] = inst_30728);

(statearr_30755_33161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30751 === (1))){
var state_30750__$1 = state_30750;
var statearr_30758_33162 = state_30750__$1;
(statearr_30758_33162[(2)] = null);

(statearr_30758_33162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30751 === (4))){
var inst_30707 = (state_30750[(7)]);
var inst_30707__$1 = (state_30750[(2)]);
var inst_30710 = (inst_30707__$1 == null);
var state_30750__$1 = (function (){var statearr_30763 = state_30750;
(statearr_30763[(7)] = inst_30707__$1);

return statearr_30763;
})();
if(cljs.core.truth_(inst_30710)){
var statearr_30765_33164 = state_30750__$1;
(statearr_30765_33164[(1)] = (5));

} else {
var statearr_30766_33165 = state_30750__$1;
(statearr_30766_33165[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30751 === (13))){
var state_30750__$1 = state_30750;
var statearr_30770_33166 = state_30750__$1;
(statearr_30770_33166[(2)] = null);

(statearr_30770_33166[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30751 === (6))){
var inst_30707 = (state_30750[(7)]);
var state_30750__$1 = state_30750;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30750__$1,(11),to,inst_30707);
} else {
if((state_val_30751 === (3))){
var inst_30731 = (state_30750[(2)]);
var state_30750__$1 = state_30750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30750__$1,inst_30731);
} else {
if((state_val_30751 === (12))){
var state_30750__$1 = state_30750;
var statearr_30778_33167 = state_30750__$1;
(statearr_30778_33167[(2)] = null);

(statearr_30778_33167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30751 === (2))){
var state_30750__$1 = state_30750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30750__$1,(4),from);
} else {
if((state_val_30751 === (11))){
var inst_30721 = (state_30750[(2)]);
var state_30750__$1 = state_30750;
if(cljs.core.truth_(inst_30721)){
var statearr_30779_33168 = state_30750__$1;
(statearr_30779_33168[(1)] = (12));

} else {
var statearr_30780_33169 = state_30750__$1;
(statearr_30780_33169[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30751 === (9))){
var state_30750__$1 = state_30750;
var statearr_30781_33170 = state_30750__$1;
(statearr_30781_33170[(2)] = null);

(statearr_30781_33170[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30751 === (5))){
var state_30750__$1 = state_30750;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30782_33171 = state_30750__$1;
(statearr_30782_33171[(1)] = (8));

} else {
var statearr_30783_33172 = state_30750__$1;
(statearr_30783_33172[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30751 === (14))){
var inst_30726 = (state_30750[(2)]);
var state_30750__$1 = state_30750;
var statearr_30792_33173 = state_30750__$1;
(statearr_30792_33173[(2)] = inst_30726);

(statearr_30792_33173[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30751 === (10))){
var inst_30718 = (state_30750[(2)]);
var state_30750__$1 = state_30750;
var statearr_30793_33176 = state_30750__$1;
(statearr_30793_33176[(2)] = inst_30718);

(statearr_30793_33176[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30751 === (8))){
var inst_30715 = cljs.core.async.close_BANG_(to);
var state_30750__$1 = state_30750;
var statearr_30796_33177 = state_30750__$1;
(statearr_30796_33177[(2)] = inst_30715);

(statearr_30796_33177[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_30798 = [null,null,null,null,null,null,null,null];
(statearr_30798[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_30798[(1)] = (1));

return statearr_30798;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_30750){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_30750);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e30802){var ex__29918__auto__ = e30802;
var statearr_30803_33183 = state_30750;
(statearr_30803_33183[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_30750[(4)]))){
var statearr_30814_33186 = state_30750;
(statearr_30814_33186[(1)] = cljs.core.first((state_30750[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33188 = state_30750;
state_30750 = G__33188;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_30750){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_30750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_30817 = f__30153__auto__();
(statearr_30817[(6)] = c__30152__auto___33160);

return statearr_30817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__30838){
var vec__30839 = p__30838;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30839,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30839,(1),null);
var job = vec__30839;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__30152__auto___33191 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_30846){
var state_val_30847 = (state_30846[(1)]);
if((state_val_30847 === (1))){
var state_30846__$1 = state_30846;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30846__$1,(2),res,v);
} else {
if((state_val_30847 === (2))){
var inst_30843 = (state_30846[(2)]);
var inst_30844 = cljs.core.async.close_BANG_(res);
var state_30846__$1 = (function (){var statearr_30857 = state_30846;
(statearr_30857[(7)] = inst_30843);

return statearr_30857;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30846__$1,inst_30844);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0 = (function (){
var statearr_30859 = [null,null,null,null,null,null,null,null];
(statearr_30859[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__);

(statearr_30859[(1)] = (1));

return statearr_30859;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1 = (function (state_30846){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_30846);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e30861){var ex__29918__auto__ = e30861;
var statearr_30862_33192 = state_30846;
(statearr_30862_33192[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_30846[(4)]))){
var statearr_30863_33193 = state_30846;
(statearr_30863_33193[(1)] = cljs.core.first((state_30846[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33194 = state_30846;
state_30846 = G__33194;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__ = function(state_30846){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1.call(this,state_30846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_30865 = f__30153__auto__();
(statearr_30865[(6)] = c__30152__auto___33191);

return statearr_30865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__30875){
var vec__30876 = p__30875;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30876,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30876,(1),null);
var job = vec__30876;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___33195 = n;
var __33196 = (0);
while(true){
if((__33196 < n__4613__auto___33195)){
var G__30882_33197 = type;
var G__30882_33198__$1 = (((G__30882_33197 instanceof cljs.core.Keyword))?G__30882_33197.fqn:null);
switch (G__30882_33198__$1) {
case "compute":
var c__30152__auto___33200 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33196,c__30152__auto___33200,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async){
return (function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = ((function (__33196,c__30152__auto___33200,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async){
return (function (state_30913){
var state_val_30914 = (state_30913[(1)]);
if((state_val_30914 === (1))){
var state_30913__$1 = state_30913;
var statearr_30920_33201 = state_30913__$1;
(statearr_30920_33201[(2)] = null);

(statearr_30920_33201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30914 === (2))){
var state_30913__$1 = state_30913;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30913__$1,(4),jobs);
} else {
if((state_val_30914 === (3))){
var inst_30910 = (state_30913[(2)]);
var state_30913__$1 = state_30913;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30913__$1,inst_30910);
} else {
if((state_val_30914 === (4))){
var inst_30889 = (state_30913[(2)]);
var inst_30890 = process(inst_30889);
var state_30913__$1 = state_30913;
if(cljs.core.truth_(inst_30890)){
var statearr_30924_33203 = state_30913__$1;
(statearr_30924_33203[(1)] = (5));

} else {
var statearr_30925_33204 = state_30913__$1;
(statearr_30925_33204[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30914 === (5))){
var state_30913__$1 = state_30913;
var statearr_30950_33205 = state_30913__$1;
(statearr_30950_33205[(2)] = null);

(statearr_30950_33205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30914 === (6))){
var state_30913__$1 = state_30913;
var statearr_30951_33206 = state_30913__$1;
(statearr_30951_33206[(2)] = null);

(statearr_30951_33206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30914 === (7))){
var inst_30908 = (state_30913[(2)]);
var state_30913__$1 = state_30913;
var statearr_30952_33208 = state_30913__$1;
(statearr_30952_33208[(2)] = inst_30908);

(statearr_30952_33208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33196,c__30152__auto___33200,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async))
;
return ((function (__33196,switch__29914__auto__,c__30152__auto___33200,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0 = (function (){
var statearr_30953 = [null,null,null,null,null,null,null];
(statearr_30953[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__);

(statearr_30953[(1)] = (1));

return statearr_30953;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1 = (function (state_30913){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_30913);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e30954){var ex__29918__auto__ = e30954;
var statearr_30955_33210 = state_30913;
(statearr_30955_33210[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_30913[(4)]))){
var statearr_30956_33211 = state_30913;
(statearr_30956_33211[(1)] = cljs.core.first((state_30913[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33212 = state_30913;
state_30913 = G__33212;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__ = function(state_30913){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1.call(this,state_30913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__;
})()
;})(__33196,switch__29914__auto__,c__30152__auto___33200,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async))
})();
var state__30154__auto__ = (function (){var statearr_30957 = f__30153__auto__();
(statearr_30957[(6)] = c__30152__auto___33200);

return statearr_30957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
});})(__33196,c__30152__auto___33200,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async))
);


break;
case "async":
var c__30152__auto___33214 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33196,c__30152__auto___33214,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async){
return (function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = ((function (__33196,c__30152__auto___33214,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async){
return (function (state_30971){
var state_val_30972 = (state_30971[(1)]);
if((state_val_30972 === (1))){
var state_30971__$1 = state_30971;
var statearr_30975_33216 = state_30971__$1;
(statearr_30975_33216[(2)] = null);

(statearr_30975_33216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30972 === (2))){
var state_30971__$1 = state_30971;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30971__$1,(4),jobs);
} else {
if((state_val_30972 === (3))){
var inst_30969 = (state_30971[(2)]);
var state_30971__$1 = state_30971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30971__$1,inst_30969);
} else {
if((state_val_30972 === (4))){
var inst_30961 = (state_30971[(2)]);
var inst_30962 = async(inst_30961);
var state_30971__$1 = state_30971;
if(cljs.core.truth_(inst_30962)){
var statearr_30976_33217 = state_30971__$1;
(statearr_30976_33217[(1)] = (5));

} else {
var statearr_30977_33218 = state_30971__$1;
(statearr_30977_33218[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30972 === (5))){
var state_30971__$1 = state_30971;
var statearr_30981_33219 = state_30971__$1;
(statearr_30981_33219[(2)] = null);

(statearr_30981_33219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30972 === (6))){
var state_30971__$1 = state_30971;
var statearr_30982_33221 = state_30971__$1;
(statearr_30982_33221[(2)] = null);

(statearr_30982_33221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30972 === (7))){
var inst_30967 = (state_30971[(2)]);
var state_30971__$1 = state_30971;
var statearr_30983_33224 = state_30971__$1;
(statearr_30983_33224[(2)] = inst_30967);

(statearr_30983_33224[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33196,c__30152__auto___33214,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async))
;
return ((function (__33196,switch__29914__auto__,c__30152__auto___33214,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0 = (function (){
var statearr_30985 = [null,null,null,null,null,null,null];
(statearr_30985[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__);

(statearr_30985[(1)] = (1));

return statearr_30985;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1 = (function (state_30971){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_30971);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e30988){var ex__29918__auto__ = e30988;
var statearr_30990_33226 = state_30971;
(statearr_30990_33226[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_30971[(4)]))){
var statearr_30991_33228 = state_30971;
(statearr_30991_33228[(1)] = cljs.core.first((state_30971[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33230 = state_30971;
state_30971 = G__33230;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__ = function(state_30971){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1.call(this,state_30971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__;
})()
;})(__33196,switch__29914__auto__,c__30152__auto___33214,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async))
})();
var state__30154__auto__ = (function (){var statearr_30992 = f__30153__auto__();
(statearr_30992[(6)] = c__30152__auto___33214);

return statearr_30992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
});})(__33196,c__30152__auto___33214,G__30882_33197,G__30882_33198__$1,n__4613__auto___33195,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30882_33198__$1)].join('')));

}

var G__33231 = (__33196 + (1));
__33196 = G__33231;
continue;
} else {
}
break;
}

var c__30152__auto___33232 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_31023){
var state_val_31024 = (state_31023[(1)]);
if((state_val_31024 === (7))){
var inst_31019 = (state_31023[(2)]);
var state_31023__$1 = state_31023;
var statearr_31025_33233 = state_31023__$1;
(statearr_31025_33233[(2)] = inst_31019);

(statearr_31025_33233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31024 === (1))){
var state_31023__$1 = state_31023;
var statearr_31026_33234 = state_31023__$1;
(statearr_31026_33234[(2)] = null);

(statearr_31026_33234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31024 === (4))){
var inst_31002 = (state_31023[(7)]);
var inst_31002__$1 = (state_31023[(2)]);
var inst_31003 = (inst_31002__$1 == null);
var state_31023__$1 = (function (){var statearr_31027 = state_31023;
(statearr_31027[(7)] = inst_31002__$1);

return statearr_31027;
})();
if(cljs.core.truth_(inst_31003)){
var statearr_31028_33235 = state_31023__$1;
(statearr_31028_33235[(1)] = (5));

} else {
var statearr_31029_33236 = state_31023__$1;
(statearr_31029_33236[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31024 === (6))){
var inst_31007 = (state_31023[(8)]);
var inst_31002 = (state_31023[(7)]);
var inst_31007__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31010 = [inst_31002,inst_31007__$1];
var inst_31011 = (new cljs.core.PersistentVector(null,2,(5),inst_31008,inst_31010,null));
var state_31023__$1 = (function (){var statearr_31032 = state_31023;
(statearr_31032[(8)] = inst_31007__$1);

return statearr_31032;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31023__$1,(8),jobs,inst_31011);
} else {
if((state_val_31024 === (3))){
var inst_31021 = (state_31023[(2)]);
var state_31023__$1 = state_31023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31023__$1,inst_31021);
} else {
if((state_val_31024 === (2))){
var state_31023__$1 = state_31023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31023__$1,(4),from);
} else {
if((state_val_31024 === (9))){
var inst_31016 = (state_31023[(2)]);
var state_31023__$1 = (function (){var statearr_31033 = state_31023;
(statearr_31033[(9)] = inst_31016);

return statearr_31033;
})();
var statearr_31034_33239 = state_31023__$1;
(statearr_31034_33239[(2)] = null);

(statearr_31034_33239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31024 === (5))){
var inst_31005 = cljs.core.async.close_BANG_(jobs);
var state_31023__$1 = state_31023;
var statearr_31035_33240 = state_31023__$1;
(statearr_31035_33240[(2)] = inst_31005);

(statearr_31035_33240[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31024 === (8))){
var inst_31007 = (state_31023[(8)]);
var inst_31014 = (state_31023[(2)]);
var state_31023__$1 = (function (){var statearr_31036 = state_31023;
(statearr_31036[(10)] = inst_31014);

return statearr_31036;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31023__$1,(9),results,inst_31007);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0 = (function (){
var statearr_31037 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31037[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__);

(statearr_31037[(1)] = (1));

return statearr_31037;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1 = (function (state_31023){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_31023);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e31041){var ex__29918__auto__ = e31041;
var statearr_31043_33241 = state_31023;
(statearr_31043_33241[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_31023[(4)]))){
var statearr_31044_33242 = state_31023;
(statearr_31044_33242[(1)] = cljs.core.first((state_31023[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33243 = state_31023;
state_31023 = G__33243;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__ = function(state_31023){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1.call(this,state_31023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_31045 = f__30153__auto__();
(statearr_31045[(6)] = c__30152__auto___33232);

return statearr_31045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


var c__30152__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_31102){
var state_val_31103 = (state_31102[(1)]);
if((state_val_31103 === (7))){
var inst_31098 = (state_31102[(2)]);
var state_31102__$1 = state_31102;
var statearr_31104_33244 = state_31102__$1;
(statearr_31104_33244[(2)] = inst_31098);

(statearr_31104_33244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (20))){
var state_31102__$1 = state_31102;
var statearr_31105_33246 = state_31102__$1;
(statearr_31105_33246[(2)] = null);

(statearr_31105_33246[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (1))){
var state_31102__$1 = state_31102;
var statearr_31106_33248 = state_31102__$1;
(statearr_31106_33248[(2)] = null);

(statearr_31106_33248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (4))){
var inst_31063 = (state_31102[(7)]);
var inst_31063__$1 = (state_31102[(2)]);
var inst_31064 = (inst_31063__$1 == null);
var state_31102__$1 = (function (){var statearr_31107 = state_31102;
(statearr_31107[(7)] = inst_31063__$1);

return statearr_31107;
})();
if(cljs.core.truth_(inst_31064)){
var statearr_31108_33249 = state_31102__$1;
(statearr_31108_33249[(1)] = (5));

} else {
var statearr_31109_33250 = state_31102__$1;
(statearr_31109_33250[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (15))){
var inst_31077 = (state_31102[(8)]);
var state_31102__$1 = state_31102;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31102__$1,(18),to,inst_31077);
} else {
if((state_val_31103 === (21))){
var inst_31093 = (state_31102[(2)]);
var state_31102__$1 = state_31102;
var statearr_31111_33251 = state_31102__$1;
(statearr_31111_33251[(2)] = inst_31093);

(statearr_31111_33251[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (13))){
var inst_31095 = (state_31102[(2)]);
var state_31102__$1 = (function (){var statearr_31140 = state_31102;
(statearr_31140[(9)] = inst_31095);

return statearr_31140;
})();
var statearr_31141_33254 = state_31102__$1;
(statearr_31141_33254[(2)] = null);

(statearr_31141_33254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (6))){
var inst_31063 = (state_31102[(7)]);
var state_31102__$1 = state_31102;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31102__$1,(11),inst_31063);
} else {
if((state_val_31103 === (17))){
var inst_31087 = (state_31102[(2)]);
var state_31102__$1 = state_31102;
if(cljs.core.truth_(inst_31087)){
var statearr_31142_33255 = state_31102__$1;
(statearr_31142_33255[(1)] = (19));

} else {
var statearr_31143_33256 = state_31102__$1;
(statearr_31143_33256[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (3))){
var inst_31100 = (state_31102[(2)]);
var state_31102__$1 = state_31102;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31102__$1,inst_31100);
} else {
if((state_val_31103 === (12))){
var inst_31074 = (state_31102[(10)]);
var state_31102__$1 = state_31102;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31102__$1,(14),inst_31074);
} else {
if((state_val_31103 === (2))){
var state_31102__$1 = state_31102;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31102__$1,(4),results);
} else {
if((state_val_31103 === (19))){
var state_31102__$1 = state_31102;
var statearr_31144_33259 = state_31102__$1;
(statearr_31144_33259[(2)] = null);

(statearr_31144_33259[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (11))){
var inst_31074 = (state_31102[(2)]);
var state_31102__$1 = (function (){var statearr_31145 = state_31102;
(statearr_31145[(10)] = inst_31074);

return statearr_31145;
})();
var statearr_31146_33260 = state_31102__$1;
(statearr_31146_33260[(2)] = null);

(statearr_31146_33260[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (9))){
var state_31102__$1 = state_31102;
var statearr_31147_33265 = state_31102__$1;
(statearr_31147_33265[(2)] = null);

(statearr_31147_33265[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (5))){
var state_31102__$1 = state_31102;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31149_33267 = state_31102__$1;
(statearr_31149_33267[(1)] = (8));

} else {
var statearr_31150_33268 = state_31102__$1;
(statearr_31150_33268[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (14))){
var inst_31077 = (state_31102[(8)]);
var inst_31077__$1 = (state_31102[(2)]);
var inst_31080 = (inst_31077__$1 == null);
var inst_31081 = cljs.core.not(inst_31080);
var state_31102__$1 = (function (){var statearr_31151 = state_31102;
(statearr_31151[(8)] = inst_31077__$1);

return statearr_31151;
})();
if(inst_31081){
var statearr_31153_33272 = state_31102__$1;
(statearr_31153_33272[(1)] = (15));

} else {
var statearr_31156_33273 = state_31102__$1;
(statearr_31156_33273[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (16))){
var state_31102__$1 = state_31102;
var statearr_31160_33274 = state_31102__$1;
(statearr_31160_33274[(2)] = false);

(statearr_31160_33274[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (10))){
var inst_31070 = (state_31102[(2)]);
var state_31102__$1 = state_31102;
var statearr_31161_33275 = state_31102__$1;
(statearr_31161_33275[(2)] = inst_31070);

(statearr_31161_33275[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (18))){
var inst_31084 = (state_31102[(2)]);
var state_31102__$1 = state_31102;
var statearr_31162_33276 = state_31102__$1;
(statearr_31162_33276[(2)] = inst_31084);

(statearr_31162_33276[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31103 === (8))){
var inst_31067 = cljs.core.async.close_BANG_(to);
var state_31102__$1 = state_31102;
var statearr_31163_33277 = state_31102__$1;
(statearr_31163_33277[(2)] = inst_31067);

(statearr_31163_33277[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0 = (function (){
var statearr_31164 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31164[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__);

(statearr_31164[(1)] = (1));

return statearr_31164;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1 = (function (state_31102){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_31102);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e31165){var ex__29918__auto__ = e31165;
var statearr_31166_33281 = state_31102;
(statearr_31166_33281[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_31102[(4)]))){
var statearr_31167_33283 = state_31102;
(statearr_31167_33283[(1)] = cljs.core.first((state_31102[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33286 = state_31102;
state_31102 = G__33286;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__ = function(state_31102){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1.call(this,state_31102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29915__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_31184 = f__30153__auto__();
(statearr_31184[(6)] = c__30152__auto__);

return statearr_31184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));

return c__30152__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31188 = arguments.length;
switch (G__31188) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31192 = arguments.length;
switch (G__31192) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31218 = arguments.length;
switch (G__31218) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__30152__auto___33294 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_31246){
var state_val_31247 = (state_31246[(1)]);
if((state_val_31247 === (7))){
var inst_31242 = (state_31246[(2)]);
var state_31246__$1 = state_31246;
var statearr_31248_33295 = state_31246__$1;
(statearr_31248_33295[(2)] = inst_31242);

(statearr_31248_33295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31247 === (1))){
var state_31246__$1 = state_31246;
var statearr_31249_33296 = state_31246__$1;
(statearr_31249_33296[(2)] = null);

(statearr_31249_33296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31247 === (4))){
var inst_31223 = (state_31246[(7)]);
var inst_31223__$1 = (state_31246[(2)]);
var inst_31224 = (inst_31223__$1 == null);
var state_31246__$1 = (function (){var statearr_31250 = state_31246;
(statearr_31250[(7)] = inst_31223__$1);

return statearr_31250;
})();
if(cljs.core.truth_(inst_31224)){
var statearr_31251_33298 = state_31246__$1;
(statearr_31251_33298[(1)] = (5));

} else {
var statearr_31252_33299 = state_31246__$1;
(statearr_31252_33299[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31247 === (13))){
var state_31246__$1 = state_31246;
var statearr_31253_33300 = state_31246__$1;
(statearr_31253_33300[(2)] = null);

(statearr_31253_33300[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31247 === (6))){
var inst_31223 = (state_31246[(7)]);
var inst_31229 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31223) : p.call(null,inst_31223));
var state_31246__$1 = state_31246;
if(cljs.core.truth_(inst_31229)){
var statearr_31254_33301 = state_31246__$1;
(statearr_31254_33301[(1)] = (9));

} else {
var statearr_31255_33302 = state_31246__$1;
(statearr_31255_33302[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31247 === (3))){
var inst_31244 = (state_31246[(2)]);
var state_31246__$1 = state_31246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31246__$1,inst_31244);
} else {
if((state_val_31247 === (12))){
var state_31246__$1 = state_31246;
var statearr_31257_33304 = state_31246__$1;
(statearr_31257_33304[(2)] = null);

(statearr_31257_33304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31247 === (2))){
var state_31246__$1 = state_31246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31246__$1,(4),ch);
} else {
if((state_val_31247 === (11))){
var inst_31223 = (state_31246[(7)]);
var inst_31233 = (state_31246[(2)]);
var state_31246__$1 = state_31246;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31246__$1,(8),inst_31233,inst_31223);
} else {
if((state_val_31247 === (9))){
var state_31246__$1 = state_31246;
var statearr_31262_33310 = state_31246__$1;
(statearr_31262_33310[(2)] = tc);

(statearr_31262_33310[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31247 === (5))){
var inst_31226 = cljs.core.async.close_BANG_(tc);
var inst_31227 = cljs.core.async.close_BANG_(fc);
var state_31246__$1 = (function (){var statearr_31263 = state_31246;
(statearr_31263[(8)] = inst_31226);

return statearr_31263;
})();
var statearr_31264_33311 = state_31246__$1;
(statearr_31264_33311[(2)] = inst_31227);

(statearr_31264_33311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31247 === (14))){
var inst_31240 = (state_31246[(2)]);
var state_31246__$1 = state_31246;
var statearr_31265_33312 = state_31246__$1;
(statearr_31265_33312[(2)] = inst_31240);

(statearr_31265_33312[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31247 === (10))){
var state_31246__$1 = state_31246;
var statearr_31266_33313 = state_31246__$1;
(statearr_31266_33313[(2)] = fc);

(statearr_31266_33313[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31247 === (8))){
var inst_31235 = (state_31246[(2)]);
var state_31246__$1 = state_31246;
if(cljs.core.truth_(inst_31235)){
var statearr_31267_33314 = state_31246__$1;
(statearr_31267_33314[(1)] = (12));

} else {
var statearr_31268_33315 = state_31246__$1;
(statearr_31268_33315[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_31272 = [null,null,null,null,null,null,null,null,null];
(statearr_31272[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_31272[(1)] = (1));

return statearr_31272;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_31246){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_31246);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e31273){var ex__29918__auto__ = e31273;
var statearr_31274_33317 = state_31246;
(statearr_31274_33317[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_31246[(4)]))){
var statearr_31295_33318 = state_31246;
(statearr_31295_33318[(1)] = cljs.core.first((state_31246[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33319 = state_31246;
state_31246 = G__33319;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_31246){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_31246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_31296 = f__30153__auto__();
(statearr_31296[(6)] = c__30152__auto___33294);

return statearr_31296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30152__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_31318){
var state_val_31319 = (state_31318[(1)]);
if((state_val_31319 === (7))){
var inst_31314 = (state_31318[(2)]);
var state_31318__$1 = state_31318;
var statearr_31321_33320 = state_31318__$1;
(statearr_31321_33320[(2)] = inst_31314);

(statearr_31321_33320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (1))){
var inst_31297 = init;
var inst_31298 = inst_31297;
var state_31318__$1 = (function (){var statearr_31322 = state_31318;
(statearr_31322[(7)] = inst_31298);

return statearr_31322;
})();
var statearr_31323_33322 = state_31318__$1;
(statearr_31323_33322[(2)] = null);

(statearr_31323_33322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (4))){
var inst_31301 = (state_31318[(8)]);
var inst_31301__$1 = (state_31318[(2)]);
var inst_31302 = (inst_31301__$1 == null);
var state_31318__$1 = (function (){var statearr_31324 = state_31318;
(statearr_31324[(8)] = inst_31301__$1);

return statearr_31324;
})();
if(cljs.core.truth_(inst_31302)){
var statearr_31325_33325 = state_31318__$1;
(statearr_31325_33325[(1)] = (5));

} else {
var statearr_31326_33326 = state_31318__$1;
(statearr_31326_33326[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (6))){
var inst_31301 = (state_31318[(8)]);
var inst_31305 = (state_31318[(9)]);
var inst_31298 = (state_31318[(7)]);
var inst_31305__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31298,inst_31301) : f.call(null,inst_31298,inst_31301));
var inst_31306 = cljs.core.reduced_QMARK_(inst_31305__$1);
var state_31318__$1 = (function (){var statearr_31327 = state_31318;
(statearr_31327[(9)] = inst_31305__$1);

return statearr_31327;
})();
if(inst_31306){
var statearr_31328_33327 = state_31318__$1;
(statearr_31328_33327[(1)] = (8));

} else {
var statearr_31329_33328 = state_31318__$1;
(statearr_31329_33328[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (3))){
var inst_31316 = (state_31318[(2)]);
var state_31318__$1 = state_31318;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31318__$1,inst_31316);
} else {
if((state_val_31319 === (2))){
var state_31318__$1 = state_31318;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31318__$1,(4),ch);
} else {
if((state_val_31319 === (9))){
var inst_31305 = (state_31318[(9)]);
var inst_31298 = inst_31305;
var state_31318__$1 = (function (){var statearr_31330 = state_31318;
(statearr_31330[(7)] = inst_31298);

return statearr_31330;
})();
var statearr_31331_33329 = state_31318__$1;
(statearr_31331_33329[(2)] = null);

(statearr_31331_33329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (5))){
var inst_31298 = (state_31318[(7)]);
var state_31318__$1 = state_31318;
var statearr_31332_33330 = state_31318__$1;
(statearr_31332_33330[(2)] = inst_31298);

(statearr_31332_33330[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (10))){
var inst_31312 = (state_31318[(2)]);
var state_31318__$1 = state_31318;
var statearr_31333_33331 = state_31318__$1;
(statearr_31333_33331[(2)] = inst_31312);

(statearr_31333_33331[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31319 === (8))){
var inst_31305 = (state_31318[(9)]);
var inst_31308 = cljs.core.deref(inst_31305);
var state_31318__$1 = state_31318;
var statearr_31334_33332 = state_31318__$1;
(statearr_31334_33332[(2)] = inst_31308);

(statearr_31334_33332[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__29915__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29915__auto____0 = (function (){
var statearr_31335 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31335[(0)] = cljs$core$async$reduce_$_state_machine__29915__auto__);

(statearr_31335[(1)] = (1));

return statearr_31335;
});
var cljs$core$async$reduce_$_state_machine__29915__auto____1 = (function (state_31318){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_31318);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e31336){var ex__29918__auto__ = e31336;
var statearr_31337_33340 = state_31318;
(statearr_31337_33340[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_31318[(4)]))){
var statearr_31338_33341 = state_31318;
(statearr_31338_33341[(1)] = cljs.core.first((state_31318[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33342 = state_31318;
state_31318 = G__33342;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29915__auto__ = function(state_31318){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29915__auto____1.call(this,state_31318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29915__auto____0;
cljs$core$async$reduce_$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29915__auto____1;
return cljs$core$async$reduce_$_state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_31339 = f__30153__auto__();
(statearr_31339[(6)] = c__30152__auto__);

return statearr_31339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));

return c__30152__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__30152__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_31350){
var state_val_31351 = (state_31350[(1)]);
if((state_val_31351 === (1))){
var inst_31345 = cljs.core.async.reduce(f__$1,init,ch);
var state_31350__$1 = state_31350;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31350__$1,(2),inst_31345);
} else {
if((state_val_31351 === (2))){
var inst_31347 = (state_31350[(2)]);
var inst_31348 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31347) : f__$1.call(null,inst_31347));
var state_31350__$1 = state_31350;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31350__$1,inst_31348);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__29915__auto__ = null;
var cljs$core$async$transduce_$_state_machine__29915__auto____0 = (function (){
var statearr_31353 = [null,null,null,null,null,null,null];
(statearr_31353[(0)] = cljs$core$async$transduce_$_state_machine__29915__auto__);

(statearr_31353[(1)] = (1));

return statearr_31353;
});
var cljs$core$async$transduce_$_state_machine__29915__auto____1 = (function (state_31350){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_31350);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e31354){var ex__29918__auto__ = e31354;
var statearr_31355_33346 = state_31350;
(statearr_31355_33346[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_31350[(4)]))){
var statearr_31356_33347 = state_31350;
(statearr_31356_33347[(1)] = cljs.core.first((state_31350[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33349 = state_31350;
state_31350 = G__33349;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__29915__auto__ = function(state_31350){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__29915__auto____1.call(this,state_31350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__29915__auto____0;
cljs$core$async$transduce_$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__29915__auto____1;
return cljs$core$async$transduce_$_state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_31357 = f__30153__auto__();
(statearr_31357[(6)] = c__30152__auto__);

return statearr_31357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));

return c__30152__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__31360 = arguments.length;
switch (G__31360) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30152__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_31385){
var state_val_31386 = (state_31385[(1)]);
if((state_val_31386 === (7))){
var inst_31367 = (state_31385[(2)]);
var state_31385__$1 = state_31385;
var statearr_31387_33358 = state_31385__$1;
(statearr_31387_33358[(2)] = inst_31367);

(statearr_31387_33358[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31386 === (1))){
var inst_31361 = cljs.core.seq(coll);
var inst_31362 = inst_31361;
var state_31385__$1 = (function (){var statearr_31388 = state_31385;
(statearr_31388[(7)] = inst_31362);

return statearr_31388;
})();
var statearr_31389_33359 = state_31385__$1;
(statearr_31389_33359[(2)] = null);

(statearr_31389_33359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31386 === (4))){
var inst_31362 = (state_31385[(7)]);
var inst_31365 = cljs.core.first(inst_31362);
var state_31385__$1 = state_31385;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31385__$1,(7),ch,inst_31365);
} else {
if((state_val_31386 === (13))){
var inst_31379 = (state_31385[(2)]);
var state_31385__$1 = state_31385;
var statearr_31390_33360 = state_31385__$1;
(statearr_31390_33360[(2)] = inst_31379);

(statearr_31390_33360[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31386 === (6))){
var inst_31370 = (state_31385[(2)]);
var state_31385__$1 = state_31385;
if(cljs.core.truth_(inst_31370)){
var statearr_31391_33368 = state_31385__$1;
(statearr_31391_33368[(1)] = (8));

} else {
var statearr_31392_33369 = state_31385__$1;
(statearr_31392_33369[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31386 === (3))){
var inst_31383 = (state_31385[(2)]);
var state_31385__$1 = state_31385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31385__$1,inst_31383);
} else {
if((state_val_31386 === (12))){
var state_31385__$1 = state_31385;
var statearr_31393_33370 = state_31385__$1;
(statearr_31393_33370[(2)] = null);

(statearr_31393_33370[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31386 === (2))){
var inst_31362 = (state_31385[(7)]);
var state_31385__$1 = state_31385;
if(cljs.core.truth_(inst_31362)){
var statearr_31394_33374 = state_31385__$1;
(statearr_31394_33374[(1)] = (4));

} else {
var statearr_31395_33375 = state_31385__$1;
(statearr_31395_33375[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31386 === (11))){
var inst_31376 = cljs.core.async.close_BANG_(ch);
var state_31385__$1 = state_31385;
var statearr_31397_33376 = state_31385__$1;
(statearr_31397_33376[(2)] = inst_31376);

(statearr_31397_33376[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31386 === (9))){
var state_31385__$1 = state_31385;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31398_33380 = state_31385__$1;
(statearr_31398_33380[(1)] = (11));

} else {
var statearr_31399_33381 = state_31385__$1;
(statearr_31399_33381[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31386 === (5))){
var inst_31362 = (state_31385[(7)]);
var state_31385__$1 = state_31385;
var statearr_31401_33382 = state_31385__$1;
(statearr_31401_33382[(2)] = inst_31362);

(statearr_31401_33382[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31386 === (10))){
var inst_31381 = (state_31385[(2)]);
var state_31385__$1 = state_31385;
var statearr_31403_33383 = state_31385__$1;
(statearr_31403_33383[(2)] = inst_31381);

(statearr_31403_33383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31386 === (8))){
var inst_31362 = (state_31385[(7)]);
var inst_31372 = cljs.core.next(inst_31362);
var inst_31362__$1 = inst_31372;
var state_31385__$1 = (function (){var statearr_31404 = state_31385;
(statearr_31404[(7)] = inst_31362__$1);

return statearr_31404;
})();
var statearr_31405_33387 = state_31385__$1;
(statearr_31405_33387[(2)] = null);

(statearr_31405_33387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_31408 = [null,null,null,null,null,null,null,null];
(statearr_31408[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_31408[(1)] = (1));

return statearr_31408;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_31385){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_31385);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e31409){var ex__29918__auto__ = e31409;
var statearr_31410_33390 = state_31385;
(statearr_31410_33390[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_31385[(4)]))){
var statearr_31411_33392 = state_31385;
(statearr_31411_33392[(1)] = cljs.core.first((state_31385[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33393 = state_31385;
state_31385 = G__33393;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_31385){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_31385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_31412 = f__30153__auto__();
(statearr_31412[(6)] = c__30152__auto__);

return statearr_31412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));

return c__30152__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31414 = arguments.length;
switch (G__31414) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_33395 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_33395(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_33397 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_33397(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_33398 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_33398(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_33400 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_33400(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31422 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31422 = (function (ch,cs,meta31423){
this.ch = ch;
this.cs = cs;
this.meta31423 = meta31423;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31422.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31424,meta31423__$1){
var self__ = this;
var _31424__$1 = this;
return (new cljs.core.async.t_cljs$core$async31422(self__.ch,self__.cs,meta31423__$1));
}));

(cljs.core.async.t_cljs$core$async31422.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31424){
var self__ = this;
var _31424__$1 = this;
return self__.meta31423;
}));

(cljs.core.async.t_cljs$core$async31422.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31422.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31422.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31422.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async31422.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async31422.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async31422.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31423","meta31423",-817217982,null)], null);
}));

(cljs.core.async.t_cljs$core$async31422.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31422.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31422");

(cljs.core.async.t_cljs$core$async31422.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async31422");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31422.
 */
cljs.core.async.__GT_t_cljs$core$async31422 = (function cljs$core$async$mult_$___GT_t_cljs$core$async31422(ch__$1,cs__$1,meta31423){
return (new cljs.core.async.t_cljs$core$async31422(ch__$1,cs__$1,meta31423));
});

}

return (new cljs.core.async.t_cljs$core$async31422(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__30152__auto___33413 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_31589){
var state_val_31590 = (state_31589[(1)]);
if((state_val_31590 === (7))){
var inst_31585 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31597_33414 = state_31589__$1;
(statearr_31597_33414[(2)] = inst_31585);

(statearr_31597_33414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (20))){
var inst_31479 = (state_31589[(7)]);
var inst_31496 = cljs.core.first(inst_31479);
var inst_31497 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31496,(0),null);
var inst_31498 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31496,(1),null);
var state_31589__$1 = (function (){var statearr_31598 = state_31589;
(statearr_31598[(8)] = inst_31497);

return statearr_31598;
})();
if(cljs.core.truth_(inst_31498)){
var statearr_31599_33419 = state_31589__$1;
(statearr_31599_33419[(1)] = (22));

} else {
var statearr_31600_33420 = state_31589__$1;
(statearr_31600_33420[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (27))){
var inst_31528 = (state_31589[(9)]);
var inst_31530 = (state_31589[(10)]);
var inst_31441 = (state_31589[(11)]);
var inst_31539 = (state_31589[(12)]);
var inst_31539__$1 = cljs.core._nth(inst_31528,inst_31530);
var inst_31540 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31539__$1,inst_31441,done);
var state_31589__$1 = (function (){var statearr_31601 = state_31589;
(statearr_31601[(12)] = inst_31539__$1);

return statearr_31601;
})();
if(cljs.core.truth_(inst_31540)){
var statearr_31602_33425 = state_31589__$1;
(statearr_31602_33425[(1)] = (30));

} else {
var statearr_31603_33426 = state_31589__$1;
(statearr_31603_33426[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (1))){
var state_31589__$1 = state_31589;
var statearr_31607_33430 = state_31589__$1;
(statearr_31607_33430[(2)] = null);

(statearr_31607_33430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (24))){
var inst_31479 = (state_31589[(7)]);
var inst_31504 = (state_31589[(2)]);
var inst_31505 = cljs.core.next(inst_31479);
var inst_31450 = inst_31505;
var inst_31451 = null;
var inst_31452 = (0);
var inst_31453 = (0);
var state_31589__$1 = (function (){var statearr_31609 = state_31589;
(statearr_31609[(13)] = inst_31450);

(statearr_31609[(14)] = inst_31453);

(statearr_31609[(15)] = inst_31504);

(statearr_31609[(16)] = inst_31451);

(statearr_31609[(17)] = inst_31452);

return statearr_31609;
})();
var statearr_31610_33442 = state_31589__$1;
(statearr_31610_33442[(2)] = null);

(statearr_31610_33442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (39))){
var state_31589__$1 = state_31589;
var statearr_31614_33443 = state_31589__$1;
(statearr_31614_33443[(2)] = null);

(statearr_31614_33443[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (4))){
var inst_31441 = (state_31589[(11)]);
var inst_31441__$1 = (state_31589[(2)]);
var inst_31442 = (inst_31441__$1 == null);
var state_31589__$1 = (function (){var statearr_31615 = state_31589;
(statearr_31615[(11)] = inst_31441__$1);

return statearr_31615;
})();
if(cljs.core.truth_(inst_31442)){
var statearr_31616_33444 = state_31589__$1;
(statearr_31616_33444[(1)] = (5));

} else {
var statearr_31617_33445 = state_31589__$1;
(statearr_31617_33445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (15))){
var inst_31450 = (state_31589[(13)]);
var inst_31453 = (state_31589[(14)]);
var inst_31451 = (state_31589[(16)]);
var inst_31452 = (state_31589[(17)]);
var inst_31471 = (state_31589[(2)]);
var inst_31476 = (inst_31453 + (1));
var tmp31611 = inst_31450;
var tmp31612 = inst_31451;
var tmp31613 = inst_31452;
var inst_31450__$1 = tmp31611;
var inst_31451__$1 = tmp31612;
var inst_31452__$1 = tmp31613;
var inst_31453__$1 = inst_31476;
var state_31589__$1 = (function (){var statearr_31620 = state_31589;
(statearr_31620[(13)] = inst_31450__$1);

(statearr_31620[(14)] = inst_31453__$1);

(statearr_31620[(18)] = inst_31471);

(statearr_31620[(16)] = inst_31451__$1);

(statearr_31620[(17)] = inst_31452__$1);

return statearr_31620;
})();
var statearr_31621_33447 = state_31589__$1;
(statearr_31621_33447[(2)] = null);

(statearr_31621_33447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (21))){
var inst_31508 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31629_33454 = state_31589__$1;
(statearr_31629_33454[(2)] = inst_31508);

(statearr_31629_33454[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (31))){
var inst_31539 = (state_31589[(12)]);
var inst_31543 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31539);
var state_31589__$1 = state_31589;
var statearr_31631_33458 = state_31589__$1;
(statearr_31631_33458[(2)] = inst_31543);

(statearr_31631_33458[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (32))){
var inst_31528 = (state_31589[(9)]);
var inst_31530 = (state_31589[(10)]);
var inst_31527 = (state_31589[(19)]);
var inst_31529 = (state_31589[(20)]);
var inst_31545 = (state_31589[(2)]);
var inst_31546 = (inst_31530 + (1));
var tmp31626 = inst_31528;
var tmp31627 = inst_31527;
var tmp31628 = inst_31529;
var inst_31527__$1 = tmp31627;
var inst_31528__$1 = tmp31626;
var inst_31529__$1 = tmp31628;
var inst_31530__$1 = inst_31546;
var state_31589__$1 = (function (){var statearr_31643 = state_31589;
(statearr_31643[(9)] = inst_31528__$1);

(statearr_31643[(21)] = inst_31545);

(statearr_31643[(10)] = inst_31530__$1);

(statearr_31643[(19)] = inst_31527__$1);

(statearr_31643[(20)] = inst_31529__$1);

return statearr_31643;
})();
var statearr_31645_33460 = state_31589__$1;
(statearr_31645_33460[(2)] = null);

(statearr_31645_33460[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (40))){
var inst_31558 = (state_31589[(22)]);
var inst_31562 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31558);
var state_31589__$1 = state_31589;
var statearr_31647_33461 = state_31589__$1;
(statearr_31647_33461[(2)] = inst_31562);

(statearr_31647_33461[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (33))){
var inst_31549 = (state_31589[(23)]);
var inst_31551 = cljs.core.chunked_seq_QMARK_(inst_31549);
var state_31589__$1 = state_31589;
if(inst_31551){
var statearr_31648_33463 = state_31589__$1;
(statearr_31648_33463[(1)] = (36));

} else {
var statearr_31649_33464 = state_31589__$1;
(statearr_31649_33464[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (13))){
var inst_31465 = (state_31589[(24)]);
var inst_31468 = cljs.core.async.close_BANG_(inst_31465);
var state_31589__$1 = state_31589;
var statearr_31651_33466 = state_31589__$1;
(statearr_31651_33466[(2)] = inst_31468);

(statearr_31651_33466[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (22))){
var inst_31497 = (state_31589[(8)]);
var inst_31501 = cljs.core.async.close_BANG_(inst_31497);
var state_31589__$1 = state_31589;
var statearr_31656_33474 = state_31589__$1;
(statearr_31656_33474[(2)] = inst_31501);

(statearr_31656_33474[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (36))){
var inst_31549 = (state_31589[(23)]);
var inst_31553 = cljs.core.chunk_first(inst_31549);
var inst_31554 = cljs.core.chunk_rest(inst_31549);
var inst_31555 = cljs.core.count(inst_31553);
var inst_31527 = inst_31554;
var inst_31528 = inst_31553;
var inst_31529 = inst_31555;
var inst_31530 = (0);
var state_31589__$1 = (function (){var statearr_31657 = state_31589;
(statearr_31657[(9)] = inst_31528);

(statearr_31657[(10)] = inst_31530);

(statearr_31657[(19)] = inst_31527);

(statearr_31657[(20)] = inst_31529);

return statearr_31657;
})();
var statearr_31658_33490 = state_31589__$1;
(statearr_31658_33490[(2)] = null);

(statearr_31658_33490[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (41))){
var inst_31549 = (state_31589[(23)]);
var inst_31564 = (state_31589[(2)]);
var inst_31565 = cljs.core.next(inst_31549);
var inst_31527 = inst_31565;
var inst_31528 = null;
var inst_31529 = (0);
var inst_31530 = (0);
var state_31589__$1 = (function (){var statearr_31659 = state_31589;
(statearr_31659[(9)] = inst_31528);

(statearr_31659[(10)] = inst_31530);

(statearr_31659[(19)] = inst_31527);

(statearr_31659[(20)] = inst_31529);

(statearr_31659[(25)] = inst_31564);

return statearr_31659;
})();
var statearr_31660_33496 = state_31589__$1;
(statearr_31660_33496[(2)] = null);

(statearr_31660_33496[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (43))){
var state_31589__$1 = state_31589;
var statearr_31661_33497 = state_31589__$1;
(statearr_31661_33497[(2)] = null);

(statearr_31661_33497[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (29))){
var inst_31573 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31662_33498 = state_31589__$1;
(statearr_31662_33498[(2)] = inst_31573);

(statearr_31662_33498[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (44))){
var inst_31582 = (state_31589[(2)]);
var state_31589__$1 = (function (){var statearr_31663 = state_31589;
(statearr_31663[(26)] = inst_31582);

return statearr_31663;
})();
var statearr_31664_33500 = state_31589__$1;
(statearr_31664_33500[(2)] = null);

(statearr_31664_33500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (6))){
var inst_31519 = (state_31589[(27)]);
var inst_31518 = cljs.core.deref(cs);
var inst_31519__$1 = cljs.core.keys(inst_31518);
var inst_31520 = cljs.core.count(inst_31519__$1);
var inst_31521 = cljs.core.reset_BANG_(dctr,inst_31520);
var inst_31526 = cljs.core.seq(inst_31519__$1);
var inst_31527 = inst_31526;
var inst_31528 = null;
var inst_31529 = (0);
var inst_31530 = (0);
var state_31589__$1 = (function (){var statearr_31665 = state_31589;
(statearr_31665[(9)] = inst_31528);

(statearr_31665[(10)] = inst_31530);

(statearr_31665[(28)] = inst_31521);

(statearr_31665[(19)] = inst_31527);

(statearr_31665[(20)] = inst_31529);

(statearr_31665[(27)] = inst_31519__$1);

return statearr_31665;
})();
var statearr_31666_33504 = state_31589__$1;
(statearr_31666_33504[(2)] = null);

(statearr_31666_33504[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (28))){
var inst_31549 = (state_31589[(23)]);
var inst_31527 = (state_31589[(19)]);
var inst_31549__$1 = cljs.core.seq(inst_31527);
var state_31589__$1 = (function (){var statearr_31667 = state_31589;
(statearr_31667[(23)] = inst_31549__$1);

return statearr_31667;
})();
if(inst_31549__$1){
var statearr_31668_33506 = state_31589__$1;
(statearr_31668_33506[(1)] = (33));

} else {
var statearr_31669_33508 = state_31589__$1;
(statearr_31669_33508[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (25))){
var inst_31530 = (state_31589[(10)]);
var inst_31529 = (state_31589[(20)]);
var inst_31532 = (inst_31530 < inst_31529);
var inst_31533 = inst_31532;
var state_31589__$1 = state_31589;
if(cljs.core.truth_(inst_31533)){
var statearr_31670_33511 = state_31589__$1;
(statearr_31670_33511[(1)] = (27));

} else {
var statearr_31671_33512 = state_31589__$1;
(statearr_31671_33512[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (34))){
var state_31589__$1 = state_31589;
var statearr_31676_33513 = state_31589__$1;
(statearr_31676_33513[(2)] = null);

(statearr_31676_33513[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (17))){
var state_31589__$1 = state_31589;
var statearr_31677_33514 = state_31589__$1;
(statearr_31677_33514[(2)] = null);

(statearr_31677_33514[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (3))){
var inst_31587 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31589__$1,inst_31587);
} else {
if((state_val_31590 === (12))){
var inst_31513 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31678_33516 = state_31589__$1;
(statearr_31678_33516[(2)] = inst_31513);

(statearr_31678_33516[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (2))){
var state_31589__$1 = state_31589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31589__$1,(4),ch);
} else {
if((state_val_31590 === (23))){
var state_31589__$1 = state_31589;
var statearr_31683_33518 = state_31589__$1;
(statearr_31683_33518[(2)] = null);

(statearr_31683_33518[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (35))){
var inst_31571 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31684_33519 = state_31589__$1;
(statearr_31684_33519[(2)] = inst_31571);

(statearr_31684_33519[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (19))){
var inst_31479 = (state_31589[(7)]);
var inst_31487 = cljs.core.chunk_first(inst_31479);
var inst_31488 = cljs.core.chunk_rest(inst_31479);
var inst_31489 = cljs.core.count(inst_31487);
var inst_31450 = inst_31488;
var inst_31451 = inst_31487;
var inst_31452 = inst_31489;
var inst_31453 = (0);
var state_31589__$1 = (function (){var statearr_31685 = state_31589;
(statearr_31685[(13)] = inst_31450);

(statearr_31685[(14)] = inst_31453);

(statearr_31685[(16)] = inst_31451);

(statearr_31685[(17)] = inst_31452);

return statearr_31685;
})();
var statearr_31686_33522 = state_31589__$1;
(statearr_31686_33522[(2)] = null);

(statearr_31686_33522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (11))){
var inst_31450 = (state_31589[(13)]);
var inst_31479 = (state_31589[(7)]);
var inst_31479__$1 = cljs.core.seq(inst_31450);
var state_31589__$1 = (function (){var statearr_31687 = state_31589;
(statearr_31687[(7)] = inst_31479__$1);

return statearr_31687;
})();
if(inst_31479__$1){
var statearr_31688_33526 = state_31589__$1;
(statearr_31688_33526[(1)] = (16));

} else {
var statearr_31689_33527 = state_31589__$1;
(statearr_31689_33527[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (9))){
var inst_31515 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31690_33528 = state_31589__$1;
(statearr_31690_33528[(2)] = inst_31515);

(statearr_31690_33528[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (5))){
var inst_31448 = cljs.core.deref(cs);
var inst_31449 = cljs.core.seq(inst_31448);
var inst_31450 = inst_31449;
var inst_31451 = null;
var inst_31452 = (0);
var inst_31453 = (0);
var state_31589__$1 = (function (){var statearr_31691 = state_31589;
(statearr_31691[(13)] = inst_31450);

(statearr_31691[(14)] = inst_31453);

(statearr_31691[(16)] = inst_31451);

(statearr_31691[(17)] = inst_31452);

return statearr_31691;
})();
var statearr_31692_33531 = state_31589__$1;
(statearr_31692_33531[(2)] = null);

(statearr_31692_33531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (14))){
var state_31589__$1 = state_31589;
var statearr_31693_33533 = state_31589__$1;
(statearr_31693_33533[(2)] = null);

(statearr_31693_33533[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (45))){
var inst_31579 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31697_33535 = state_31589__$1;
(statearr_31697_33535[(2)] = inst_31579);

(statearr_31697_33535[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (26))){
var inst_31519 = (state_31589[(27)]);
var inst_31575 = (state_31589[(2)]);
var inst_31576 = cljs.core.seq(inst_31519);
var state_31589__$1 = (function (){var statearr_31698 = state_31589;
(statearr_31698[(29)] = inst_31575);

return statearr_31698;
})();
if(inst_31576){
var statearr_31699_33538 = state_31589__$1;
(statearr_31699_33538[(1)] = (42));

} else {
var statearr_31700_33540 = state_31589__$1;
(statearr_31700_33540[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (16))){
var inst_31479 = (state_31589[(7)]);
var inst_31481 = cljs.core.chunked_seq_QMARK_(inst_31479);
var state_31589__$1 = state_31589;
if(inst_31481){
var statearr_31701_33541 = state_31589__$1;
(statearr_31701_33541[(1)] = (19));

} else {
var statearr_31702_33542 = state_31589__$1;
(statearr_31702_33542[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (38))){
var inst_31568 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31703_33543 = state_31589__$1;
(statearr_31703_33543[(2)] = inst_31568);

(statearr_31703_33543[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (30))){
var state_31589__$1 = state_31589;
var statearr_31704_33544 = state_31589__$1;
(statearr_31704_33544[(2)] = null);

(statearr_31704_33544[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (10))){
var inst_31453 = (state_31589[(14)]);
var inst_31451 = (state_31589[(16)]);
var inst_31461 = cljs.core._nth(inst_31451,inst_31453);
var inst_31465 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31461,(0),null);
var inst_31466 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31461,(1),null);
var state_31589__$1 = (function (){var statearr_31706 = state_31589;
(statearr_31706[(24)] = inst_31465);

return statearr_31706;
})();
if(cljs.core.truth_(inst_31466)){
var statearr_31707_33545 = state_31589__$1;
(statearr_31707_33545[(1)] = (13));

} else {
var statearr_31708_33546 = state_31589__$1;
(statearr_31708_33546[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (18))){
var inst_31511 = (state_31589[(2)]);
var state_31589__$1 = state_31589;
var statearr_31711_33547 = state_31589__$1;
(statearr_31711_33547[(2)] = inst_31511);

(statearr_31711_33547[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (42))){
var state_31589__$1 = state_31589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31589__$1,(45),dchan);
} else {
if((state_val_31590 === (37))){
var inst_31549 = (state_31589[(23)]);
var inst_31558 = (state_31589[(22)]);
var inst_31441 = (state_31589[(11)]);
var inst_31558__$1 = cljs.core.first(inst_31549);
var inst_31559 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31558__$1,inst_31441,done);
var state_31589__$1 = (function (){var statearr_31715 = state_31589;
(statearr_31715[(22)] = inst_31558__$1);

return statearr_31715;
})();
if(cljs.core.truth_(inst_31559)){
var statearr_31716_33548 = state_31589__$1;
(statearr_31716_33548[(1)] = (39));

} else {
var statearr_31717_33549 = state_31589__$1;
(statearr_31717_33549[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31590 === (8))){
var inst_31453 = (state_31589[(14)]);
var inst_31452 = (state_31589[(17)]);
var inst_31455 = (inst_31453 < inst_31452);
var inst_31456 = inst_31455;
var state_31589__$1 = state_31589;
if(cljs.core.truth_(inst_31456)){
var statearr_31718_33551 = state_31589__$1;
(statearr_31718_33551[(1)] = (10));

} else {
var statearr_31719_33552 = state_31589__$1;
(statearr_31719_33552[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__29915__auto__ = null;
var cljs$core$async$mult_$_state_machine__29915__auto____0 = (function (){
var statearr_31726 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31726[(0)] = cljs$core$async$mult_$_state_machine__29915__auto__);

(statearr_31726[(1)] = (1));

return statearr_31726;
});
var cljs$core$async$mult_$_state_machine__29915__auto____1 = (function (state_31589){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_31589);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e31727){var ex__29918__auto__ = e31727;
var statearr_31728_33560 = state_31589;
(statearr_31728_33560[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_31589[(4)]))){
var statearr_31729_33563 = state_31589;
(statearr_31729_33563[(1)] = cljs.core.first((state_31589[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33564 = state_31589;
state_31589 = G__33564;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29915__auto__ = function(state_31589){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29915__auto____1.call(this,state_31589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29915__auto____0;
cljs$core$async$mult_$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29915__auto____1;
return cljs$core$async$mult_$_state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_31733 = f__30153__auto__();
(statearr_31733[(6)] = c__30152__auto___33413);

return statearr_31733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__31735 = arguments.length;
switch (G__31735) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_33574 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_33574(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_33597 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_33597(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_33604 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_33604(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_33612 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_33612(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_33613 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_33613(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33616 = arguments.length;
var i__4737__auto___33617 = (0);
while(true){
if((i__4737__auto___33617 < len__4736__auto___33616)){
args__4742__auto__.push((arguments[i__4737__auto___33617]));

var G__33618 = (i__4737__auto___33617 + (1));
i__4737__auto___33617 = G__33618;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31748){
var map__31749 = p__31748;
var map__31749__$1 = (((((!((map__31749 == null))))?(((((map__31749.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31749.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31749):map__31749);
var opts = map__31749__$1;
var statearr_31751_33620 = state;
(statearr_31751_33620[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_31752_33621 = state;
(statearr_31752_33621[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_31753_33622 = state;
(statearr_31753_33622[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31742){
var G__31743 = cljs.core.first(seq31742);
var seq31742__$1 = cljs.core.next(seq31742);
var G__31744 = cljs.core.first(seq31742__$1);
var seq31742__$2 = cljs.core.next(seq31742__$1);
var G__31745 = cljs.core.first(seq31742__$2);
var seq31742__$3 = cljs.core.next(seq31742__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31743,G__31744,G__31745,seq31742__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31754 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31754 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31755){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta31755 = meta31755;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31754.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31756,meta31755__$1){
var self__ = this;
var _31756__$1 = this;
return (new cljs.core.async.t_cljs$core$async31754(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta31755__$1));
}));

(cljs.core.async.t_cljs$core$async31754.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31756){
var self__ = this;
var _31756__$1 = this;
return self__.meta31755;
}));

(cljs.core.async.t_cljs$core$async31754.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31754.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async31754.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31754.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31754.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31754.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31754.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31754.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31754.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta31755","meta31755",1574482905,null)], null);
}));

(cljs.core.async.t_cljs$core$async31754.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31754.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31754");

(cljs.core.async.t_cljs$core$async31754.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async31754");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31754.
 */
cljs.core.async.__GT_t_cljs$core$async31754 = (function cljs$core$async$mix_$___GT_t_cljs$core$async31754(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31755){
return (new cljs.core.async.t_cljs$core$async31754(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31755));
});

}

return (new cljs.core.async.t_cljs$core$async31754(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30152__auto___33648 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_31869){
var state_val_31875 = (state_31869[(1)]);
if((state_val_31875 === (7))){
var inst_31773 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
var statearr_31880_33649 = state_31869__$1;
(statearr_31880_33649[(2)] = inst_31773);

(statearr_31880_33649[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (20))){
var inst_31785 = (state_31869[(7)]);
var state_31869__$1 = state_31869;
var statearr_31881_33654 = state_31869__$1;
(statearr_31881_33654[(2)] = inst_31785);

(statearr_31881_33654[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (27))){
var state_31869__$1 = state_31869;
var statearr_31886_33655 = state_31869__$1;
(statearr_31886_33655[(2)] = null);

(statearr_31886_33655[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (1))){
var inst_31760 = (state_31869[(8)]);
var inst_31760__$1 = calc_state();
var inst_31762 = (inst_31760__$1 == null);
var inst_31763 = cljs.core.not(inst_31762);
var state_31869__$1 = (function (){var statearr_31887 = state_31869;
(statearr_31887[(8)] = inst_31760__$1);

return statearr_31887;
})();
if(inst_31763){
var statearr_31888_33657 = state_31869__$1;
(statearr_31888_33657[(1)] = (2));

} else {
var statearr_31889_33662 = state_31869__$1;
(statearr_31889_33662[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (24))){
var inst_31810 = (state_31869[(9)]);
var inst_31820 = (state_31869[(10)]);
var inst_31836 = (state_31869[(11)]);
var inst_31836__$1 = (inst_31810.cljs$core$IFn$_invoke$arity$1 ? inst_31810.cljs$core$IFn$_invoke$arity$1(inst_31820) : inst_31810.call(null,inst_31820));
var state_31869__$1 = (function (){var statearr_31890 = state_31869;
(statearr_31890[(11)] = inst_31836__$1);

return statearr_31890;
})();
if(cljs.core.truth_(inst_31836__$1)){
var statearr_31891_33665 = state_31869__$1;
(statearr_31891_33665[(1)] = (29));

} else {
var statearr_31892_33666 = state_31869__$1;
(statearr_31892_33666[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (4))){
var inst_31776 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
if(cljs.core.truth_(inst_31776)){
var statearr_31893_33667 = state_31869__$1;
(statearr_31893_33667[(1)] = (8));

} else {
var statearr_31894_33668 = state_31869__$1;
(statearr_31894_33668[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (15))){
var inst_31804 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
if(cljs.core.truth_(inst_31804)){
var statearr_31896_33674 = state_31869__$1;
(statearr_31896_33674[(1)] = (19));

} else {
var statearr_31897_33675 = state_31869__$1;
(statearr_31897_33675[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (21))){
var inst_31809 = (state_31869[(12)]);
var inst_31809__$1 = (state_31869[(2)]);
var inst_31810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31809__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31811 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31809__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31812 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31809__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31869__$1 = (function (){var statearr_31900 = state_31869;
(statearr_31900[(9)] = inst_31810);

(statearr_31900[(13)] = inst_31811);

(statearr_31900[(12)] = inst_31809__$1);

return statearr_31900;
})();
return cljs.core.async.ioc_alts_BANG_(state_31869__$1,(22),inst_31812);
} else {
if((state_val_31875 === (31))){
var inst_31845 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
if(cljs.core.truth_(inst_31845)){
var statearr_31904_33678 = state_31869__$1;
(statearr_31904_33678[(1)] = (32));

} else {
var statearr_31905_33689 = state_31869__$1;
(statearr_31905_33689[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (32))){
var inst_31819 = (state_31869[(14)]);
var state_31869__$1 = state_31869;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31869__$1,(35),out,inst_31819);
} else {
if((state_val_31875 === (33))){
var inst_31809 = (state_31869[(12)]);
var inst_31785 = inst_31809;
var state_31869__$1 = (function (){var statearr_31909 = state_31869;
(statearr_31909[(7)] = inst_31785);

return statearr_31909;
})();
var statearr_31910_33690 = state_31869__$1;
(statearr_31910_33690[(2)] = null);

(statearr_31910_33690[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (13))){
var inst_31785 = (state_31869[(7)]);
var inst_31793 = inst_31785.cljs$lang$protocol_mask$partition0$;
var inst_31794 = (inst_31793 & (64));
var inst_31795 = inst_31785.cljs$core$ISeq$;
var inst_31796 = (cljs.core.PROTOCOL_SENTINEL === inst_31795);
var inst_31797 = ((inst_31794) || (inst_31796));
var state_31869__$1 = state_31869;
if(cljs.core.truth_(inst_31797)){
var statearr_31911_33691 = state_31869__$1;
(statearr_31911_33691[(1)] = (16));

} else {
var statearr_31913_33692 = state_31869__$1;
(statearr_31913_33692[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (22))){
var inst_31820 = (state_31869[(10)]);
var inst_31819 = (state_31869[(14)]);
var inst_31818 = (state_31869[(2)]);
var inst_31819__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31818,(0),null);
var inst_31820__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31818,(1),null);
var inst_31821 = (inst_31819__$1 == null);
var inst_31822 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31820__$1,change);
var inst_31824 = ((inst_31821) || (inst_31822));
var state_31869__$1 = (function (){var statearr_31915 = state_31869;
(statearr_31915[(10)] = inst_31820__$1);

(statearr_31915[(14)] = inst_31819__$1);

return statearr_31915;
})();
if(cljs.core.truth_(inst_31824)){
var statearr_31920_33700 = state_31869__$1;
(statearr_31920_33700[(1)] = (23));

} else {
var statearr_31921_33704 = state_31869__$1;
(statearr_31921_33704[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (36))){
var inst_31809 = (state_31869[(12)]);
var inst_31785 = inst_31809;
var state_31869__$1 = (function (){var statearr_31926 = state_31869;
(statearr_31926[(7)] = inst_31785);

return statearr_31926;
})();
var statearr_31927_33705 = state_31869__$1;
(statearr_31927_33705[(2)] = null);

(statearr_31927_33705[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (29))){
var inst_31836 = (state_31869[(11)]);
var state_31869__$1 = state_31869;
var statearr_31928_33706 = state_31869__$1;
(statearr_31928_33706[(2)] = inst_31836);

(statearr_31928_33706[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (6))){
var state_31869__$1 = state_31869;
var statearr_31929_33707 = state_31869__$1;
(statearr_31929_33707[(2)] = false);

(statearr_31929_33707[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (28))){
var inst_31831 = (state_31869[(2)]);
var inst_31832 = calc_state();
var inst_31785 = inst_31832;
var state_31869__$1 = (function (){var statearr_31930 = state_31869;
(statearr_31930[(15)] = inst_31831);

(statearr_31930[(7)] = inst_31785);

return statearr_31930;
})();
var statearr_31931_33708 = state_31869__$1;
(statearr_31931_33708[(2)] = null);

(statearr_31931_33708[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (25))){
var inst_31865 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
var statearr_31932_33709 = state_31869__$1;
(statearr_31932_33709[(2)] = inst_31865);

(statearr_31932_33709[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (34))){
var inst_31863 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
var statearr_31933_33710 = state_31869__$1;
(statearr_31933_33710[(2)] = inst_31863);

(statearr_31933_33710[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (17))){
var state_31869__$1 = state_31869;
var statearr_31934_33711 = state_31869__$1;
(statearr_31934_33711[(2)] = false);

(statearr_31934_33711[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (3))){
var state_31869__$1 = state_31869;
var statearr_31935_33712 = state_31869__$1;
(statearr_31935_33712[(2)] = false);

(statearr_31935_33712[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (12))){
var inst_31867 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31869__$1,inst_31867);
} else {
if((state_val_31875 === (2))){
var inst_31760 = (state_31869[(8)]);
var inst_31765 = inst_31760.cljs$lang$protocol_mask$partition0$;
var inst_31766 = (inst_31765 & (64));
var inst_31767 = inst_31760.cljs$core$ISeq$;
var inst_31768 = (cljs.core.PROTOCOL_SENTINEL === inst_31767);
var inst_31769 = ((inst_31766) || (inst_31768));
var state_31869__$1 = state_31869;
if(cljs.core.truth_(inst_31769)){
var statearr_31936_33713 = state_31869__$1;
(statearr_31936_33713[(1)] = (5));

} else {
var statearr_31937_33714 = state_31869__$1;
(statearr_31937_33714[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (23))){
var inst_31819 = (state_31869[(14)]);
var inst_31826 = (inst_31819 == null);
var state_31869__$1 = state_31869;
if(cljs.core.truth_(inst_31826)){
var statearr_31938_33715 = state_31869__$1;
(statearr_31938_33715[(1)] = (26));

} else {
var statearr_31941_33716 = state_31869__$1;
(statearr_31941_33716[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (35))){
var inst_31854 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
if(cljs.core.truth_(inst_31854)){
var statearr_31942_33717 = state_31869__$1;
(statearr_31942_33717[(1)] = (36));

} else {
var statearr_31943_33718 = state_31869__$1;
(statearr_31943_33718[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (19))){
var inst_31785 = (state_31869[(7)]);
var inst_31806 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31785);
var state_31869__$1 = state_31869;
var statearr_31944_33719 = state_31869__$1;
(statearr_31944_33719[(2)] = inst_31806);

(statearr_31944_33719[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (11))){
var inst_31785 = (state_31869[(7)]);
var inst_31789 = (inst_31785 == null);
var inst_31790 = cljs.core.not(inst_31789);
var state_31869__$1 = state_31869;
if(inst_31790){
var statearr_31945_33720 = state_31869__$1;
(statearr_31945_33720[(1)] = (13));

} else {
var statearr_31946_33721 = state_31869__$1;
(statearr_31946_33721[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (9))){
var inst_31760 = (state_31869[(8)]);
var state_31869__$1 = state_31869;
var statearr_31947_33722 = state_31869__$1;
(statearr_31947_33722[(2)] = inst_31760);

(statearr_31947_33722[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (5))){
var state_31869__$1 = state_31869;
var statearr_31948_33723 = state_31869__$1;
(statearr_31948_33723[(2)] = true);

(statearr_31948_33723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (14))){
var state_31869__$1 = state_31869;
var statearr_31949_33724 = state_31869__$1;
(statearr_31949_33724[(2)] = false);

(statearr_31949_33724[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (26))){
var inst_31820 = (state_31869[(10)]);
var inst_31828 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_31820);
var state_31869__$1 = state_31869;
var statearr_31950_33725 = state_31869__$1;
(statearr_31950_33725[(2)] = inst_31828);

(statearr_31950_33725[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (16))){
var state_31869__$1 = state_31869;
var statearr_31951_33726 = state_31869__$1;
(statearr_31951_33726[(2)] = true);

(statearr_31951_33726[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (38))){
var inst_31859 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
var statearr_31952_33727 = state_31869__$1;
(statearr_31952_33727[(2)] = inst_31859);

(statearr_31952_33727[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (30))){
var inst_31810 = (state_31869[(9)]);
var inst_31811 = (state_31869[(13)]);
var inst_31820 = (state_31869[(10)]);
var inst_31839 = cljs.core.empty_QMARK_(inst_31810);
var inst_31841 = (inst_31811.cljs$core$IFn$_invoke$arity$1 ? inst_31811.cljs$core$IFn$_invoke$arity$1(inst_31820) : inst_31811.call(null,inst_31820));
var inst_31842 = cljs.core.not(inst_31841);
var inst_31843 = ((inst_31839) && (inst_31842));
var state_31869__$1 = state_31869;
var statearr_31953_33732 = state_31869__$1;
(statearr_31953_33732[(2)] = inst_31843);

(statearr_31953_33732[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (10))){
var inst_31760 = (state_31869[(8)]);
var inst_31781 = (state_31869[(2)]);
var inst_31782 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31781,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31783 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31781,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31784 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31781,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31785 = inst_31760;
var state_31869__$1 = (function (){var statearr_31958 = state_31869;
(statearr_31958[(16)] = inst_31782);

(statearr_31958[(7)] = inst_31785);

(statearr_31958[(17)] = inst_31784);

(statearr_31958[(18)] = inst_31783);

return statearr_31958;
})();
var statearr_31959_33734 = state_31869__$1;
(statearr_31959_33734[(2)] = null);

(statearr_31959_33734[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (18))){
var inst_31801 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
var statearr_31965_33735 = state_31869__$1;
(statearr_31965_33735[(2)] = inst_31801);

(statearr_31965_33735[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (37))){
var state_31869__$1 = state_31869;
var statearr_31966_33736 = state_31869__$1;
(statearr_31966_33736[(2)] = null);

(statearr_31966_33736[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (8))){
var inst_31760 = (state_31869[(8)]);
var inst_31778 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31760);
var state_31869__$1 = state_31869;
var statearr_31971_33737 = state_31869__$1;
(statearr_31971_33737[(2)] = inst_31778);

(statearr_31971_33737[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__29915__auto__ = null;
var cljs$core$async$mix_$_state_machine__29915__auto____0 = (function (){
var statearr_31972 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31972[(0)] = cljs$core$async$mix_$_state_machine__29915__auto__);

(statearr_31972[(1)] = (1));

return statearr_31972;
});
var cljs$core$async$mix_$_state_machine__29915__auto____1 = (function (state_31869){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_31869);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e31973){var ex__29918__auto__ = e31973;
var statearr_31974_33738 = state_31869;
(statearr_31974_33738[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_31869[(4)]))){
var statearr_31977_33740 = state_31869;
(statearr_31977_33740[(1)] = cljs.core.first((state_31869[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33741 = state_31869;
state_31869 = G__33741;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29915__auto__ = function(state_31869){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29915__auto____1.call(this,state_31869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29915__auto____0;
cljs$core$async$mix_$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29915__auto____1;
return cljs$core$async$mix_$_state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_31978 = f__30153__auto__();
(statearr_31978[(6)] = c__30152__auto___33648);

return statearr_31978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_33750 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_33750(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_33754 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_33754(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_33755 = (function() {
var G__33756 = null;
var G__33756__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__33756__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__33756 = function(p,v){
switch(arguments.length){
case 1:
return G__33756__1.call(this,p);
case 2:
return G__33756__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33756.cljs$core$IFn$_invoke$arity$1 = G__33756__1;
G__33756.cljs$core$IFn$_invoke$arity$2 = G__33756__2;
return G__33756;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32021 = arguments.length;
switch (G__32021) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_33755(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_33755(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32039 = arguments.length;
switch (G__32039) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__32031_SHARP_){
if(cljs.core.truth_((p1__32031_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32031_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32031_SHARP_.call(null,topic)))){
return p1__32031_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32031_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32048 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32048 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32049){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32049 = meta32049;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32048.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32050,meta32049__$1){
var self__ = this;
var _32050__$1 = this;
return (new cljs.core.async.t_cljs$core$async32048(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32049__$1));
}));

(cljs.core.async.t_cljs$core$async32048.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32050){
var self__ = this;
var _32050__$1 = this;
return self__.meta32049;
}));

(cljs.core.async.t_cljs$core$async32048.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32048.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32048.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32048.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async32048.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async32048.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async32048.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async32048.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32049","meta32049",1156297648,null)], null);
}));

(cljs.core.async.t_cljs$core$async32048.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32048.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32048");

(cljs.core.async.t_cljs$core$async32048.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async32048");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32048.
 */
cljs.core.async.__GT_t_cljs$core$async32048 = (function cljs$core$async$__GT_t_cljs$core$async32048(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32049){
return (new cljs.core.async.t_cljs$core$async32048(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32049));
});

}

return (new cljs.core.async.t_cljs$core$async32048(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30152__auto___33774 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_32134){
var state_val_32135 = (state_32134[(1)]);
if((state_val_32135 === (7))){
var inst_32130 = (state_32134[(2)]);
var state_32134__$1 = state_32134;
var statearr_32136_33775 = state_32134__$1;
(statearr_32136_33775[(2)] = inst_32130);

(statearr_32136_33775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (20))){
var state_32134__$1 = state_32134;
var statearr_32137_33776 = state_32134__$1;
(statearr_32137_33776[(2)] = null);

(statearr_32137_33776[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (1))){
var state_32134__$1 = state_32134;
var statearr_32138_33777 = state_32134__$1;
(statearr_32138_33777[(2)] = null);

(statearr_32138_33777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (24))){
var inst_32113 = (state_32134[(7)]);
var inst_32122 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32113);
var state_32134__$1 = state_32134;
var statearr_32139_33781 = state_32134__$1;
(statearr_32139_33781[(2)] = inst_32122);

(statearr_32139_33781[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (4))){
var inst_32065 = (state_32134[(8)]);
var inst_32065__$1 = (state_32134[(2)]);
var inst_32066 = (inst_32065__$1 == null);
var state_32134__$1 = (function (){var statearr_32140 = state_32134;
(statearr_32140[(8)] = inst_32065__$1);

return statearr_32140;
})();
if(cljs.core.truth_(inst_32066)){
var statearr_32141_33782 = state_32134__$1;
(statearr_32141_33782[(1)] = (5));

} else {
var statearr_32144_33783 = state_32134__$1;
(statearr_32144_33783[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (15))){
var inst_32107 = (state_32134[(2)]);
var state_32134__$1 = state_32134;
var statearr_32147_33784 = state_32134__$1;
(statearr_32147_33784[(2)] = inst_32107);

(statearr_32147_33784[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (21))){
var inst_32127 = (state_32134[(2)]);
var state_32134__$1 = (function (){var statearr_32148 = state_32134;
(statearr_32148[(9)] = inst_32127);

return statearr_32148;
})();
var statearr_32149_33803 = state_32134__$1;
(statearr_32149_33803[(2)] = null);

(statearr_32149_33803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (13))){
var inst_32089 = (state_32134[(10)]);
var inst_32091 = cljs.core.chunked_seq_QMARK_(inst_32089);
var state_32134__$1 = state_32134;
if(inst_32091){
var statearr_32150_33804 = state_32134__$1;
(statearr_32150_33804[(1)] = (16));

} else {
var statearr_32151_33805 = state_32134__$1;
(statearr_32151_33805[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (22))){
var inst_32119 = (state_32134[(2)]);
var state_32134__$1 = state_32134;
if(cljs.core.truth_(inst_32119)){
var statearr_32155_33806 = state_32134__$1;
(statearr_32155_33806[(1)] = (23));

} else {
var statearr_32156_33811 = state_32134__$1;
(statearr_32156_33811[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (6))){
var inst_32065 = (state_32134[(8)]);
var inst_32113 = (state_32134[(7)]);
var inst_32115 = (state_32134[(11)]);
var inst_32113__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32065) : topic_fn.call(null,inst_32065));
var inst_32114 = cljs.core.deref(mults);
var inst_32115__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32114,inst_32113__$1);
var state_32134__$1 = (function (){var statearr_32157 = state_32134;
(statearr_32157[(7)] = inst_32113__$1);

(statearr_32157[(11)] = inst_32115__$1);

return statearr_32157;
})();
if(cljs.core.truth_(inst_32115__$1)){
var statearr_32159_33820 = state_32134__$1;
(statearr_32159_33820[(1)] = (19));

} else {
var statearr_32160_33822 = state_32134__$1;
(statearr_32160_33822[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (25))){
var inst_32124 = (state_32134[(2)]);
var state_32134__$1 = state_32134;
var statearr_32161_33828 = state_32134__$1;
(statearr_32161_33828[(2)] = inst_32124);

(statearr_32161_33828[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (17))){
var inst_32089 = (state_32134[(10)]);
var inst_32098 = cljs.core.first(inst_32089);
var inst_32099 = cljs.core.async.muxch_STAR_(inst_32098);
var inst_32100 = cljs.core.async.close_BANG_(inst_32099);
var inst_32101 = cljs.core.next(inst_32089);
var inst_32075 = inst_32101;
var inst_32076 = null;
var inst_32077 = (0);
var inst_32078 = (0);
var state_32134__$1 = (function (){var statearr_32163 = state_32134;
(statearr_32163[(12)] = inst_32078);

(statearr_32163[(13)] = inst_32075);

(statearr_32163[(14)] = inst_32076);

(statearr_32163[(15)] = inst_32100);

(statearr_32163[(16)] = inst_32077);

return statearr_32163;
})();
var statearr_32164_33840 = state_32134__$1;
(statearr_32164_33840[(2)] = null);

(statearr_32164_33840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (3))){
var inst_32132 = (state_32134[(2)]);
var state_32134__$1 = state_32134;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32134__$1,inst_32132);
} else {
if((state_val_32135 === (12))){
var inst_32109 = (state_32134[(2)]);
var state_32134__$1 = state_32134;
var statearr_32165_33847 = state_32134__$1;
(statearr_32165_33847[(2)] = inst_32109);

(statearr_32165_33847[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (2))){
var state_32134__$1 = state_32134;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32134__$1,(4),ch);
} else {
if((state_val_32135 === (23))){
var state_32134__$1 = state_32134;
var statearr_32172_33856 = state_32134__$1;
(statearr_32172_33856[(2)] = null);

(statearr_32172_33856[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (19))){
var inst_32065 = (state_32134[(8)]);
var inst_32115 = (state_32134[(11)]);
var inst_32117 = cljs.core.async.muxch_STAR_(inst_32115);
var state_32134__$1 = state_32134;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32134__$1,(22),inst_32117,inst_32065);
} else {
if((state_val_32135 === (11))){
var inst_32075 = (state_32134[(13)]);
var inst_32089 = (state_32134[(10)]);
var inst_32089__$1 = cljs.core.seq(inst_32075);
var state_32134__$1 = (function (){var statearr_32173 = state_32134;
(statearr_32173[(10)] = inst_32089__$1);

return statearr_32173;
})();
if(inst_32089__$1){
var statearr_32174_33862 = state_32134__$1;
(statearr_32174_33862[(1)] = (13));

} else {
var statearr_32175_33863 = state_32134__$1;
(statearr_32175_33863[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (9))){
var inst_32111 = (state_32134[(2)]);
var state_32134__$1 = state_32134;
var statearr_32176_33864 = state_32134__$1;
(statearr_32176_33864[(2)] = inst_32111);

(statearr_32176_33864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (5))){
var inst_32072 = cljs.core.deref(mults);
var inst_32073 = cljs.core.vals(inst_32072);
var inst_32074 = cljs.core.seq(inst_32073);
var inst_32075 = inst_32074;
var inst_32076 = null;
var inst_32077 = (0);
var inst_32078 = (0);
var state_32134__$1 = (function (){var statearr_32177 = state_32134;
(statearr_32177[(12)] = inst_32078);

(statearr_32177[(13)] = inst_32075);

(statearr_32177[(14)] = inst_32076);

(statearr_32177[(16)] = inst_32077);

return statearr_32177;
})();
var statearr_32182_33866 = state_32134__$1;
(statearr_32182_33866[(2)] = null);

(statearr_32182_33866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (14))){
var state_32134__$1 = state_32134;
var statearr_32186_33868 = state_32134__$1;
(statearr_32186_33868[(2)] = null);

(statearr_32186_33868[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (16))){
var inst_32089 = (state_32134[(10)]);
var inst_32093 = cljs.core.chunk_first(inst_32089);
var inst_32094 = cljs.core.chunk_rest(inst_32089);
var inst_32095 = cljs.core.count(inst_32093);
var inst_32075 = inst_32094;
var inst_32076 = inst_32093;
var inst_32077 = inst_32095;
var inst_32078 = (0);
var state_32134__$1 = (function (){var statearr_32187 = state_32134;
(statearr_32187[(12)] = inst_32078);

(statearr_32187[(13)] = inst_32075);

(statearr_32187[(14)] = inst_32076);

(statearr_32187[(16)] = inst_32077);

return statearr_32187;
})();
var statearr_32188_33872 = state_32134__$1;
(statearr_32188_33872[(2)] = null);

(statearr_32188_33872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (10))){
var inst_32078 = (state_32134[(12)]);
var inst_32075 = (state_32134[(13)]);
var inst_32076 = (state_32134[(14)]);
var inst_32077 = (state_32134[(16)]);
var inst_32083 = cljs.core._nth(inst_32076,inst_32078);
var inst_32084 = cljs.core.async.muxch_STAR_(inst_32083);
var inst_32085 = cljs.core.async.close_BANG_(inst_32084);
var inst_32086 = (inst_32078 + (1));
var tmp32183 = inst_32075;
var tmp32184 = inst_32076;
var tmp32185 = inst_32077;
var inst_32075__$1 = tmp32183;
var inst_32076__$1 = tmp32184;
var inst_32077__$1 = tmp32185;
var inst_32078__$1 = inst_32086;
var state_32134__$1 = (function (){var statearr_32189 = state_32134;
(statearr_32189[(12)] = inst_32078__$1);

(statearr_32189[(13)] = inst_32075__$1);

(statearr_32189[(14)] = inst_32076__$1);

(statearr_32189[(17)] = inst_32085);

(statearr_32189[(16)] = inst_32077__$1);

return statearr_32189;
})();
var statearr_32190_33873 = state_32134__$1;
(statearr_32190_33873[(2)] = null);

(statearr_32190_33873[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (18))){
var inst_32104 = (state_32134[(2)]);
var state_32134__$1 = state_32134;
var statearr_32191_33874 = state_32134__$1;
(statearr_32191_33874[(2)] = inst_32104);

(statearr_32191_33874[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32135 === (8))){
var inst_32078 = (state_32134[(12)]);
var inst_32077 = (state_32134[(16)]);
var inst_32080 = (inst_32078 < inst_32077);
var inst_32081 = inst_32080;
var state_32134__$1 = state_32134;
if(cljs.core.truth_(inst_32081)){
var statearr_32192_33875 = state_32134__$1;
(statearr_32192_33875[(1)] = (10));

} else {
var statearr_32193_33876 = state_32134__$1;
(statearr_32193_33876[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_32194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32194[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_32194[(1)] = (1));

return statearr_32194;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_32134){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_32134);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e32195){var ex__29918__auto__ = e32195;
var statearr_32196_33878 = state_32134;
(statearr_32196_33878[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_32134[(4)]))){
var statearr_32197_33879 = state_32134;
(statearr_32197_33879[(1)] = cljs.core.first((state_32134[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33886 = state_32134;
state_32134 = G__33886;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_32134){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_32134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_32198 = f__30153__auto__();
(statearr_32198[(6)] = c__30152__auto___33774);

return statearr_32198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32200 = arguments.length;
switch (G__32200) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32208 = arguments.length;
switch (G__32208) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32210 = arguments.length;
switch (G__32210) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__30152__auto___33926 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_32259){
var state_val_32260 = (state_32259[(1)]);
if((state_val_32260 === (7))){
var state_32259__$1 = state_32259;
var statearr_32261_33927 = state_32259__$1;
(statearr_32261_33927[(2)] = null);

(statearr_32261_33927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (1))){
var state_32259__$1 = state_32259;
var statearr_32262_33931 = state_32259__$1;
(statearr_32262_33931[(2)] = null);

(statearr_32262_33931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (4))){
var inst_32214 = (state_32259[(7)]);
var inst_32213 = (state_32259[(8)]);
var inst_32218 = (inst_32214 < inst_32213);
var state_32259__$1 = state_32259;
if(cljs.core.truth_(inst_32218)){
var statearr_32263_33932 = state_32259__$1;
(statearr_32263_33932[(1)] = (6));

} else {
var statearr_32266_33933 = state_32259__$1;
(statearr_32266_33933[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (15))){
var inst_32245 = (state_32259[(9)]);
var inst_32250 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32245);
var state_32259__$1 = state_32259;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32259__$1,(17),out,inst_32250);
} else {
if((state_val_32260 === (13))){
var inst_32245 = (state_32259[(9)]);
var inst_32245__$1 = (state_32259[(2)]);
var inst_32246 = cljs.core.some(cljs.core.nil_QMARK_,inst_32245__$1);
var state_32259__$1 = (function (){var statearr_32269 = state_32259;
(statearr_32269[(9)] = inst_32245__$1);

return statearr_32269;
})();
if(cljs.core.truth_(inst_32246)){
var statearr_32275_33935 = state_32259__$1;
(statearr_32275_33935[(1)] = (14));

} else {
var statearr_32276_33936 = state_32259__$1;
(statearr_32276_33936[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (6))){
var state_32259__$1 = state_32259;
var statearr_32277_33937 = state_32259__$1;
(statearr_32277_33937[(2)] = null);

(statearr_32277_33937[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (17))){
var inst_32252 = (state_32259[(2)]);
var state_32259__$1 = (function (){var statearr_32289 = state_32259;
(statearr_32289[(10)] = inst_32252);

return statearr_32289;
})();
var statearr_32290_33938 = state_32259__$1;
(statearr_32290_33938[(2)] = null);

(statearr_32290_33938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (3))){
var inst_32257 = (state_32259[(2)]);
var state_32259__$1 = state_32259;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32259__$1,inst_32257);
} else {
if((state_val_32260 === (12))){
var _ = (function (){var statearr_32291 = state_32259;
(statearr_32291[(4)] = cljs.core.rest((state_32259[(4)])));

return statearr_32291;
})();
var state_32259__$1 = state_32259;
var ex32288 = (state_32259__$1[(2)]);
var statearr_32292_33949 = state_32259__$1;
(statearr_32292_33949[(5)] = ex32288);


if((ex32288 instanceof Object)){
var statearr_32293_33950 = state_32259__$1;
(statearr_32293_33950[(1)] = (11));

(statearr_32293_33950[(5)] = null);

} else {
throw ex32288;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (2))){
var inst_32212 = cljs.core.reset_BANG_(dctr,cnt);
var inst_32213 = cnt;
var inst_32214 = (0);
var state_32259__$1 = (function (){var statearr_32294 = state_32259;
(statearr_32294[(7)] = inst_32214);

(statearr_32294[(11)] = inst_32212);

(statearr_32294[(8)] = inst_32213);

return statearr_32294;
})();
var statearr_32295_33957 = state_32259__$1;
(statearr_32295_33957[(2)] = null);

(statearr_32295_33957[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (11))){
var inst_32224 = (state_32259[(2)]);
var inst_32225 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32259__$1 = (function (){var statearr_32300 = state_32259;
(statearr_32300[(12)] = inst_32224);

return statearr_32300;
})();
var statearr_32301_33958 = state_32259__$1;
(statearr_32301_33958[(2)] = inst_32225);

(statearr_32301_33958[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (9))){
var inst_32214 = (state_32259[(7)]);
var _ = (function (){var statearr_32302 = state_32259;
(statearr_32302[(4)] = cljs.core.cons((12),(state_32259[(4)])));

return statearr_32302;
})();
var inst_32231 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_32214) : chs__$1.call(null,inst_32214));
var inst_32232 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_32214) : done.call(null,inst_32214));
var inst_32233 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32231,inst_32232);
var ___$1 = (function (){var statearr_32303 = state_32259;
(statearr_32303[(4)] = cljs.core.rest((state_32259[(4)])));

return statearr_32303;
})();
var state_32259__$1 = state_32259;
var statearr_32304_33959 = state_32259__$1;
(statearr_32304_33959[(2)] = inst_32233);

(statearr_32304_33959[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (5))){
var inst_32243 = (state_32259[(2)]);
var state_32259__$1 = (function (){var statearr_32305 = state_32259;
(statearr_32305[(13)] = inst_32243);

return statearr_32305;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32259__$1,(13),dchan);
} else {
if((state_val_32260 === (14))){
var inst_32248 = cljs.core.async.close_BANG_(out);
var state_32259__$1 = state_32259;
var statearr_32306_33960 = state_32259__$1;
(statearr_32306_33960[(2)] = inst_32248);

(statearr_32306_33960[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (16))){
var inst_32255 = (state_32259[(2)]);
var state_32259__$1 = state_32259;
var statearr_32307_33962 = state_32259__$1;
(statearr_32307_33962[(2)] = inst_32255);

(statearr_32307_33962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (10))){
var inst_32214 = (state_32259[(7)]);
var inst_32236 = (state_32259[(2)]);
var inst_32237 = (inst_32214 + (1));
var inst_32214__$1 = inst_32237;
var state_32259__$1 = (function (){var statearr_32308 = state_32259;
(statearr_32308[(7)] = inst_32214__$1);

(statearr_32308[(14)] = inst_32236);

return statearr_32308;
})();
var statearr_32309_33964 = state_32259__$1;
(statearr_32309_33964[(2)] = null);

(statearr_32309_33964[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32260 === (8))){
var inst_32241 = (state_32259[(2)]);
var state_32259__$1 = state_32259;
var statearr_32310_33965 = state_32259__$1;
(statearr_32310_33965[(2)] = inst_32241);

(statearr_32310_33965[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_32311 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32311[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_32311[(1)] = (1));

return statearr_32311;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_32259){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_32259);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e32312){var ex__29918__auto__ = e32312;
var statearr_32313_33966 = state_32259;
(statearr_32313_33966[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_32259[(4)]))){
var statearr_32314_33967 = state_32259;
(statearr_32314_33967[(1)] = cljs.core.first((state_32259[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33968 = state_32259;
state_32259 = G__33968;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_32259){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_32259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_32315 = f__30153__auto__();
(statearr_32315[(6)] = c__30152__auto___33926);

return statearr_32315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32319 = arguments.length;
switch (G__32319) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30152__auto___33970 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_32351){
var state_val_32352 = (state_32351[(1)]);
if((state_val_32352 === (7))){
var inst_32331 = (state_32351[(7)]);
var inst_32330 = (state_32351[(8)]);
var inst_32330__$1 = (state_32351[(2)]);
var inst_32331__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32330__$1,(0),null);
var inst_32332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32330__$1,(1),null);
var inst_32333 = (inst_32331__$1 == null);
var state_32351__$1 = (function (){var statearr_32353 = state_32351;
(statearr_32353[(7)] = inst_32331__$1);

(statearr_32353[(9)] = inst_32332);

(statearr_32353[(8)] = inst_32330__$1);

return statearr_32353;
})();
if(cljs.core.truth_(inst_32333)){
var statearr_32354_33972 = state_32351__$1;
(statearr_32354_33972[(1)] = (8));

} else {
var statearr_32355_33973 = state_32351__$1;
(statearr_32355_33973[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32352 === (1))){
var inst_32320 = cljs.core.vec(chs);
var inst_32321 = inst_32320;
var state_32351__$1 = (function (){var statearr_32356 = state_32351;
(statearr_32356[(10)] = inst_32321);

return statearr_32356;
})();
var statearr_32357_33975 = state_32351__$1;
(statearr_32357_33975[(2)] = null);

(statearr_32357_33975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32352 === (4))){
var inst_32321 = (state_32351[(10)]);
var state_32351__$1 = state_32351;
return cljs.core.async.ioc_alts_BANG_(state_32351__$1,(7),inst_32321);
} else {
if((state_val_32352 === (6))){
var inst_32347 = (state_32351[(2)]);
var state_32351__$1 = state_32351;
var statearr_32358_33977 = state_32351__$1;
(statearr_32358_33977[(2)] = inst_32347);

(statearr_32358_33977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32352 === (3))){
var inst_32349 = (state_32351[(2)]);
var state_32351__$1 = state_32351;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32351__$1,inst_32349);
} else {
if((state_val_32352 === (2))){
var inst_32321 = (state_32351[(10)]);
var inst_32323 = cljs.core.count(inst_32321);
var inst_32324 = (inst_32323 > (0));
var state_32351__$1 = state_32351;
if(cljs.core.truth_(inst_32324)){
var statearr_32360_33979 = state_32351__$1;
(statearr_32360_33979[(1)] = (4));

} else {
var statearr_32361_33980 = state_32351__$1;
(statearr_32361_33980[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32352 === (11))){
var inst_32321 = (state_32351[(10)]);
var inst_32340 = (state_32351[(2)]);
var tmp32359 = inst_32321;
var inst_32321__$1 = tmp32359;
var state_32351__$1 = (function (){var statearr_32362 = state_32351;
(statearr_32362[(11)] = inst_32340);

(statearr_32362[(10)] = inst_32321__$1);

return statearr_32362;
})();
var statearr_32363_33981 = state_32351__$1;
(statearr_32363_33981[(2)] = null);

(statearr_32363_33981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32352 === (9))){
var inst_32331 = (state_32351[(7)]);
var state_32351__$1 = state_32351;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32351__$1,(11),out,inst_32331);
} else {
if((state_val_32352 === (5))){
var inst_32345 = cljs.core.async.close_BANG_(out);
var state_32351__$1 = state_32351;
var statearr_32364_33989 = state_32351__$1;
(statearr_32364_33989[(2)] = inst_32345);

(statearr_32364_33989[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32352 === (10))){
var inst_32343 = (state_32351[(2)]);
var state_32351__$1 = state_32351;
var statearr_32365_33990 = state_32351__$1;
(statearr_32365_33990[(2)] = inst_32343);

(statearr_32365_33990[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32352 === (8))){
var inst_32331 = (state_32351[(7)]);
var inst_32332 = (state_32351[(9)]);
var inst_32330 = (state_32351[(8)]);
var inst_32321 = (state_32351[(10)]);
var inst_32335 = (function (){var cs = inst_32321;
var vec__32326 = inst_32330;
var v = inst_32331;
var c = inst_32332;
return (function (p1__32316_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__32316_SHARP_);
});
})();
var inst_32336 = cljs.core.filterv(inst_32335,inst_32321);
var inst_32321__$1 = inst_32336;
var state_32351__$1 = (function (){var statearr_32370 = state_32351;
(statearr_32370[(10)] = inst_32321__$1);

return statearr_32370;
})();
var statearr_32372_33992 = state_32351__$1;
(statearr_32372_33992[(2)] = null);

(statearr_32372_33992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_32376 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32376[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_32376[(1)] = (1));

return statearr_32376;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_32351){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_32351);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e32377){var ex__29918__auto__ = e32377;
var statearr_32379_33993 = state_32351;
(statearr_32379_33993[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_32351[(4)]))){
var statearr_32382_33994 = state_32351;
(statearr_32382_33994[(1)] = cljs.core.first((state_32351[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33996 = state_32351;
state_32351 = G__33996;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_32351){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_32351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_32383 = f__30153__auto__();
(statearr_32383[(6)] = c__30152__auto___33970);

return statearr_32383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32387 = arguments.length;
switch (G__32387) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30152__auto___34006 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_32411){
var state_val_32412 = (state_32411[(1)]);
if((state_val_32412 === (7))){
var inst_32393 = (state_32411[(7)]);
var inst_32393__$1 = (state_32411[(2)]);
var inst_32394 = (inst_32393__$1 == null);
var inst_32395 = cljs.core.not(inst_32394);
var state_32411__$1 = (function (){var statearr_32413 = state_32411;
(statearr_32413[(7)] = inst_32393__$1);

return statearr_32413;
})();
if(inst_32395){
var statearr_32414_34008 = state_32411__$1;
(statearr_32414_34008[(1)] = (8));

} else {
var statearr_32415_34009 = state_32411__$1;
(statearr_32415_34009[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (1))){
var inst_32388 = (0);
var state_32411__$1 = (function (){var statearr_32416 = state_32411;
(statearr_32416[(8)] = inst_32388);

return statearr_32416;
})();
var statearr_32417_34010 = state_32411__$1;
(statearr_32417_34010[(2)] = null);

(statearr_32417_34010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (4))){
var state_32411__$1 = state_32411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32411__$1,(7),ch);
} else {
if((state_val_32412 === (6))){
var inst_32406 = (state_32411[(2)]);
var state_32411__$1 = state_32411;
var statearr_32418_34012 = state_32411__$1;
(statearr_32418_34012[(2)] = inst_32406);

(statearr_32418_34012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (3))){
var inst_32408 = (state_32411[(2)]);
var inst_32409 = cljs.core.async.close_BANG_(out);
var state_32411__$1 = (function (){var statearr_32420 = state_32411;
(statearr_32420[(9)] = inst_32408);

return statearr_32420;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32411__$1,inst_32409);
} else {
if((state_val_32412 === (2))){
var inst_32388 = (state_32411[(8)]);
var inst_32390 = (inst_32388 < n);
var state_32411__$1 = state_32411;
if(cljs.core.truth_(inst_32390)){
var statearr_32421_34013 = state_32411__$1;
(statearr_32421_34013[(1)] = (4));

} else {
var statearr_32422_34014 = state_32411__$1;
(statearr_32422_34014[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (11))){
var inst_32388 = (state_32411[(8)]);
var inst_32398 = (state_32411[(2)]);
var inst_32399 = (inst_32388 + (1));
var inst_32388__$1 = inst_32399;
var state_32411__$1 = (function (){var statearr_32424 = state_32411;
(statearr_32424[(8)] = inst_32388__$1);

(statearr_32424[(10)] = inst_32398);

return statearr_32424;
})();
var statearr_32426_34018 = state_32411__$1;
(statearr_32426_34018[(2)] = null);

(statearr_32426_34018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (9))){
var state_32411__$1 = state_32411;
var statearr_32427_34032 = state_32411__$1;
(statearr_32427_34032[(2)] = null);

(statearr_32427_34032[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (5))){
var state_32411__$1 = state_32411;
var statearr_32428_34033 = state_32411__$1;
(statearr_32428_34033[(2)] = null);

(statearr_32428_34033[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (10))){
var inst_32403 = (state_32411[(2)]);
var state_32411__$1 = state_32411;
var statearr_32430_34034 = state_32411__$1;
(statearr_32430_34034[(2)] = inst_32403);

(statearr_32430_34034[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32412 === (8))){
var inst_32393 = (state_32411[(7)]);
var state_32411__$1 = state_32411;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32411__$1,(11),out,inst_32393);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_32432 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32432[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_32432[(1)] = (1));

return statearr_32432;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_32411){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_32411);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e32433){var ex__29918__auto__ = e32433;
var statearr_32434_34035 = state_32411;
(statearr_32434_34035[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_32411[(4)]))){
var statearr_32435_34036 = state_32411;
(statearr_32435_34036[(1)] = cljs.core.first((state_32411[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34037 = state_32411;
state_32411 = G__34037;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_32411){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_32411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_32436 = f__30153__auto__();
(statearr_32436[(6)] = c__30152__auto___34006);

return statearr_32436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32438 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32438 = (function (f,ch,meta32439){
this.f = f;
this.ch = ch;
this.meta32439 = meta32439;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32438.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32440,meta32439__$1){
var self__ = this;
var _32440__$1 = this;
return (new cljs.core.async.t_cljs$core$async32438(self__.f,self__.ch,meta32439__$1));
}));

(cljs.core.async.t_cljs$core$async32438.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32440){
var self__ = this;
var _32440__$1 = this;
return self__.meta32439;
}));

(cljs.core.async.t_cljs$core$async32438.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32438.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32438.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32438.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32438.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32442 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32442 = (function (f,ch,meta32439,_,fn1,meta32443){
this.f = f;
this.ch = ch;
this.meta32439 = meta32439;
this._ = _;
this.fn1 = fn1;
this.meta32443 = meta32443;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32442.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32444,meta32443__$1){
var self__ = this;
var _32444__$1 = this;
return (new cljs.core.async.t_cljs$core$async32442(self__.f,self__.ch,self__.meta32439,self__._,self__.fn1,meta32443__$1));
}));

(cljs.core.async.t_cljs$core$async32442.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32444){
var self__ = this;
var _32444__$1 = this;
return self__.meta32443;
}));

(cljs.core.async.t_cljs$core$async32442.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32442.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async32442.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async32442.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__32437_SHARP_){
var G__32447 = (((p1__32437_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__32437_SHARP_) : self__.f.call(null,p1__32437_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__32447) : f1.call(null,G__32447));
});
}));

(cljs.core.async.t_cljs$core$async32442.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32439","meta32439",411362408,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32438","cljs.core.async/t_cljs$core$async32438",-994968700,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32443","meta32443",-510484461,null)], null);
}));

(cljs.core.async.t_cljs$core$async32442.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32442.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32442");

(cljs.core.async.t_cljs$core$async32442.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async32442");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32442.
 */
cljs.core.async.__GT_t_cljs$core$async32442 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32442(f__$1,ch__$1,meta32439__$1,___$2,fn1__$1,meta32443){
return (new cljs.core.async.t_cljs$core$async32442(f__$1,ch__$1,meta32439__$1,___$2,fn1__$1,meta32443));
});

}

return (new cljs.core.async.t_cljs$core$async32442(self__.f,self__.ch,self__.meta32439,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__32448 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32448) : self__.f.call(null,G__32448));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async32438.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32438.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async32438.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32439","meta32439",411362408,null)], null);
}));

(cljs.core.async.t_cljs$core$async32438.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32438.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32438");

(cljs.core.async.t_cljs$core$async32438.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async32438");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32438.
 */
cljs.core.async.__GT_t_cljs$core$async32438 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32438(f__$1,ch__$1,meta32439){
return (new cljs.core.async.t_cljs$core$async32438(f__$1,ch__$1,meta32439));
});

}

return (new cljs.core.async.t_cljs$core$async32438(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32461 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32461 = (function (f,ch,meta32462){
this.f = f;
this.ch = ch;
this.meta32462 = meta32462;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32461.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32463,meta32462__$1){
var self__ = this;
var _32463__$1 = this;
return (new cljs.core.async.t_cljs$core$async32461(self__.f,self__.ch,meta32462__$1));
}));

(cljs.core.async.t_cljs$core$async32461.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32463){
var self__ = this;
var _32463__$1 = this;
return self__.meta32462;
}));

(cljs.core.async.t_cljs$core$async32461.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32461.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32461.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32461.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32461.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32461.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async32461.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32462","meta32462",-627842635,null)], null);
}));

(cljs.core.async.t_cljs$core$async32461.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32461.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32461");

(cljs.core.async.t_cljs$core$async32461.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async32461");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32461.
 */
cljs.core.async.__GT_t_cljs$core$async32461 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32461(f__$1,ch__$1,meta32462){
return (new cljs.core.async.t_cljs$core$async32461(f__$1,ch__$1,meta32462));
});

}

return (new cljs.core.async.t_cljs$core$async32461(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32465 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32465 = (function (p,ch,meta32466){
this.p = p;
this.ch = ch;
this.meta32466 = meta32466;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32465.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32467,meta32466__$1){
var self__ = this;
var _32467__$1 = this;
return (new cljs.core.async.t_cljs$core$async32465(self__.p,self__.ch,meta32466__$1));
}));

(cljs.core.async.t_cljs$core$async32465.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32467){
var self__ = this;
var _32467__$1 = this;
return self__.meta32466;
}));

(cljs.core.async.t_cljs$core$async32465.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32465.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32465.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32465.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32465.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32465.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32465.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async32465.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32466","meta32466",2015955036,null)], null);
}));

(cljs.core.async.t_cljs$core$async32465.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32465.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32465");

(cljs.core.async.t_cljs$core$async32465.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async32465");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32465.
 */
cljs.core.async.__GT_t_cljs$core$async32465 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32465(p__$1,ch__$1,meta32466){
return (new cljs.core.async.t_cljs$core$async32465(p__$1,ch__$1,meta32466));
});

}

return (new cljs.core.async.t_cljs$core$async32465(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32478 = arguments.length;
switch (G__32478) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30152__auto___34070 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_32501){
var state_val_32502 = (state_32501[(1)]);
if((state_val_32502 === (7))){
var inst_32497 = (state_32501[(2)]);
var state_32501__$1 = state_32501;
var statearr_32503_34071 = state_32501__$1;
(statearr_32503_34071[(2)] = inst_32497);

(statearr_32503_34071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (1))){
var state_32501__$1 = state_32501;
var statearr_32504_34072 = state_32501__$1;
(statearr_32504_34072[(2)] = null);

(statearr_32504_34072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (4))){
var inst_32483 = (state_32501[(7)]);
var inst_32483__$1 = (state_32501[(2)]);
var inst_32484 = (inst_32483__$1 == null);
var state_32501__$1 = (function (){var statearr_32505 = state_32501;
(statearr_32505[(7)] = inst_32483__$1);

return statearr_32505;
})();
if(cljs.core.truth_(inst_32484)){
var statearr_32506_34073 = state_32501__$1;
(statearr_32506_34073[(1)] = (5));

} else {
var statearr_32507_34074 = state_32501__$1;
(statearr_32507_34074[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (6))){
var inst_32483 = (state_32501[(7)]);
var inst_32488 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32483) : p.call(null,inst_32483));
var state_32501__$1 = state_32501;
if(cljs.core.truth_(inst_32488)){
var statearr_32508_34075 = state_32501__$1;
(statearr_32508_34075[(1)] = (8));

} else {
var statearr_32509_34076 = state_32501__$1;
(statearr_32509_34076[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (3))){
var inst_32499 = (state_32501[(2)]);
var state_32501__$1 = state_32501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32501__$1,inst_32499);
} else {
if((state_val_32502 === (2))){
var state_32501__$1 = state_32501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32501__$1,(4),ch);
} else {
if((state_val_32502 === (11))){
var inst_32491 = (state_32501[(2)]);
var state_32501__$1 = state_32501;
var statearr_32511_34077 = state_32501__$1;
(statearr_32511_34077[(2)] = inst_32491);

(statearr_32511_34077[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (9))){
var state_32501__$1 = state_32501;
var statearr_32512_34102 = state_32501__$1;
(statearr_32512_34102[(2)] = null);

(statearr_32512_34102[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (5))){
var inst_32486 = cljs.core.async.close_BANG_(out);
var state_32501__$1 = state_32501;
var statearr_32513_34103 = state_32501__$1;
(statearr_32513_34103[(2)] = inst_32486);

(statearr_32513_34103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (10))){
var inst_32494 = (state_32501[(2)]);
var state_32501__$1 = (function (){var statearr_32514 = state_32501;
(statearr_32514[(8)] = inst_32494);

return statearr_32514;
})();
var statearr_32515_34104 = state_32501__$1;
(statearr_32515_34104[(2)] = null);

(statearr_32515_34104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (8))){
var inst_32483 = (state_32501[(7)]);
var state_32501__$1 = state_32501;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32501__$1,(11),out,inst_32483);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_32516 = [null,null,null,null,null,null,null,null,null];
(statearr_32516[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_32516[(1)] = (1));

return statearr_32516;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_32501){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_32501);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e32517){var ex__29918__auto__ = e32517;
var statearr_32518_34109 = state_32501;
(statearr_32518_34109[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_32501[(4)]))){
var statearr_32519_34110 = state_32501;
(statearr_32519_34110[(1)] = cljs.core.first((state_32501[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34111 = state_32501;
state_32501 = G__34111;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_32501){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_32501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_32522 = f__30153__auto__();
(statearr_32522[(6)] = c__30152__auto___34070);

return statearr_32522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32527 = arguments.length;
switch (G__32527) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30152__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_32590){
var state_val_32591 = (state_32590[(1)]);
if((state_val_32591 === (7))){
var inst_32586 = (state_32590[(2)]);
var state_32590__$1 = state_32590;
var statearr_32592_34177 = state_32590__$1;
(statearr_32592_34177[(2)] = inst_32586);

(statearr_32592_34177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (20))){
var inst_32556 = (state_32590[(7)]);
var inst_32567 = (state_32590[(2)]);
var inst_32568 = cljs.core.next(inst_32556);
var inst_32542 = inst_32568;
var inst_32543 = null;
var inst_32544 = (0);
var inst_32545 = (0);
var state_32590__$1 = (function (){var statearr_32593 = state_32590;
(statearr_32593[(8)] = inst_32545);

(statearr_32593[(9)] = inst_32543);

(statearr_32593[(10)] = inst_32544);

(statearr_32593[(11)] = inst_32542);

(statearr_32593[(12)] = inst_32567);

return statearr_32593;
})();
var statearr_32594_34178 = state_32590__$1;
(statearr_32594_34178[(2)] = null);

(statearr_32594_34178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (1))){
var state_32590__$1 = state_32590;
var statearr_32595_34179 = state_32590__$1;
(statearr_32595_34179[(2)] = null);

(statearr_32595_34179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (4))){
var inst_32531 = (state_32590[(13)]);
var inst_32531__$1 = (state_32590[(2)]);
var inst_32532 = (inst_32531__$1 == null);
var state_32590__$1 = (function (){var statearr_32596 = state_32590;
(statearr_32596[(13)] = inst_32531__$1);

return statearr_32596;
})();
if(cljs.core.truth_(inst_32532)){
var statearr_32597_34180 = state_32590__$1;
(statearr_32597_34180[(1)] = (5));

} else {
var statearr_32598_34181 = state_32590__$1;
(statearr_32598_34181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (15))){
var state_32590__$1 = state_32590;
var statearr_32602_34182 = state_32590__$1;
(statearr_32602_34182[(2)] = null);

(statearr_32602_34182[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (21))){
var state_32590__$1 = state_32590;
var statearr_32603_34184 = state_32590__$1;
(statearr_32603_34184[(2)] = null);

(statearr_32603_34184[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (13))){
var inst_32545 = (state_32590[(8)]);
var inst_32543 = (state_32590[(9)]);
var inst_32544 = (state_32590[(10)]);
var inst_32542 = (state_32590[(11)]);
var inst_32552 = (state_32590[(2)]);
var inst_32553 = (inst_32545 + (1));
var tmp32599 = inst_32543;
var tmp32600 = inst_32544;
var tmp32601 = inst_32542;
var inst_32542__$1 = tmp32601;
var inst_32543__$1 = tmp32599;
var inst_32544__$1 = tmp32600;
var inst_32545__$1 = inst_32553;
var state_32590__$1 = (function (){var statearr_32608 = state_32590;
(statearr_32608[(8)] = inst_32545__$1);

(statearr_32608[(9)] = inst_32543__$1);

(statearr_32608[(10)] = inst_32544__$1);

(statearr_32608[(11)] = inst_32542__$1);

(statearr_32608[(14)] = inst_32552);

return statearr_32608;
})();
var statearr_32611_34190 = state_32590__$1;
(statearr_32611_34190[(2)] = null);

(statearr_32611_34190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (22))){
var state_32590__$1 = state_32590;
var statearr_32614_34191 = state_32590__$1;
(statearr_32614_34191[(2)] = null);

(statearr_32614_34191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (6))){
var inst_32531 = (state_32590[(13)]);
var inst_32540 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32531) : f.call(null,inst_32531));
var inst_32541 = cljs.core.seq(inst_32540);
var inst_32542 = inst_32541;
var inst_32543 = null;
var inst_32544 = (0);
var inst_32545 = (0);
var state_32590__$1 = (function (){var statearr_32615 = state_32590;
(statearr_32615[(8)] = inst_32545);

(statearr_32615[(9)] = inst_32543);

(statearr_32615[(10)] = inst_32544);

(statearr_32615[(11)] = inst_32542);

return statearr_32615;
})();
var statearr_32620_34192 = state_32590__$1;
(statearr_32620_34192[(2)] = null);

(statearr_32620_34192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (17))){
var inst_32556 = (state_32590[(7)]);
var inst_32560 = cljs.core.chunk_first(inst_32556);
var inst_32561 = cljs.core.chunk_rest(inst_32556);
var inst_32562 = cljs.core.count(inst_32560);
var inst_32542 = inst_32561;
var inst_32543 = inst_32560;
var inst_32544 = inst_32562;
var inst_32545 = (0);
var state_32590__$1 = (function (){var statearr_32626 = state_32590;
(statearr_32626[(8)] = inst_32545);

(statearr_32626[(9)] = inst_32543);

(statearr_32626[(10)] = inst_32544);

(statearr_32626[(11)] = inst_32542);

return statearr_32626;
})();
var statearr_32628_34208 = state_32590__$1;
(statearr_32628_34208[(2)] = null);

(statearr_32628_34208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (3))){
var inst_32588 = (state_32590[(2)]);
var state_32590__$1 = state_32590;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32590__$1,inst_32588);
} else {
if((state_val_32591 === (12))){
var inst_32576 = (state_32590[(2)]);
var state_32590__$1 = state_32590;
var statearr_32633_34210 = state_32590__$1;
(statearr_32633_34210[(2)] = inst_32576);

(statearr_32633_34210[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (2))){
var state_32590__$1 = state_32590;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32590__$1,(4),in$);
} else {
if((state_val_32591 === (23))){
var inst_32584 = (state_32590[(2)]);
var state_32590__$1 = state_32590;
var statearr_32634_34211 = state_32590__$1;
(statearr_32634_34211[(2)] = inst_32584);

(statearr_32634_34211[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (19))){
var inst_32571 = (state_32590[(2)]);
var state_32590__$1 = state_32590;
var statearr_32635_34225 = state_32590__$1;
(statearr_32635_34225[(2)] = inst_32571);

(statearr_32635_34225[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (11))){
var inst_32542 = (state_32590[(11)]);
var inst_32556 = (state_32590[(7)]);
var inst_32556__$1 = cljs.core.seq(inst_32542);
var state_32590__$1 = (function (){var statearr_32640 = state_32590;
(statearr_32640[(7)] = inst_32556__$1);

return statearr_32640;
})();
if(inst_32556__$1){
var statearr_32643_34226 = state_32590__$1;
(statearr_32643_34226[(1)] = (14));

} else {
var statearr_32644_34227 = state_32590__$1;
(statearr_32644_34227[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (9))){
var inst_32578 = (state_32590[(2)]);
var inst_32579 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_32590__$1 = (function (){var statearr_32649 = state_32590;
(statearr_32649[(15)] = inst_32578);

return statearr_32649;
})();
if(cljs.core.truth_(inst_32579)){
var statearr_32650_34228 = state_32590__$1;
(statearr_32650_34228[(1)] = (21));

} else {
var statearr_32651_34229 = state_32590__$1;
(statearr_32651_34229[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (5))){
var inst_32534 = cljs.core.async.close_BANG_(out);
var state_32590__$1 = state_32590;
var statearr_32654_34230 = state_32590__$1;
(statearr_32654_34230[(2)] = inst_32534);

(statearr_32654_34230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (14))){
var inst_32556 = (state_32590[(7)]);
var inst_32558 = cljs.core.chunked_seq_QMARK_(inst_32556);
var state_32590__$1 = state_32590;
if(inst_32558){
var statearr_32655_34231 = state_32590__$1;
(statearr_32655_34231[(1)] = (17));

} else {
var statearr_32656_34232 = state_32590__$1;
(statearr_32656_34232[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (16))){
var inst_32574 = (state_32590[(2)]);
var state_32590__$1 = state_32590;
var statearr_32660_34243 = state_32590__$1;
(statearr_32660_34243[(2)] = inst_32574);

(statearr_32660_34243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32591 === (10))){
var inst_32545 = (state_32590[(8)]);
var inst_32543 = (state_32590[(9)]);
var inst_32550 = cljs.core._nth(inst_32543,inst_32545);
var state_32590__$1 = state_32590;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32590__$1,(13),out,inst_32550);
} else {
if((state_val_32591 === (18))){
var inst_32556 = (state_32590[(7)]);
var inst_32565 = cljs.core.first(inst_32556);
var state_32590__$1 = state_32590;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32590__$1,(20),out,inst_32565);
} else {
if((state_val_32591 === (8))){
var inst_32545 = (state_32590[(8)]);
var inst_32544 = (state_32590[(10)]);
var inst_32547 = (inst_32545 < inst_32544);
var inst_32548 = inst_32547;
var state_32590__$1 = state_32590;
if(cljs.core.truth_(inst_32548)){
var statearr_32665_34244 = state_32590__$1;
(statearr_32665_34244[(1)] = (10));

} else {
var statearr_32666_34245 = state_32590__$1;
(statearr_32666_34245[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29915__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29915__auto____0 = (function (){
var statearr_32667 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32667[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29915__auto__);

(statearr_32667[(1)] = (1));

return statearr_32667;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29915__auto____1 = (function (state_32590){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_32590);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e32668){var ex__29918__auto__ = e32668;
var statearr_32669_34246 = state_32590;
(statearr_32669_34246[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_32590[(4)]))){
var statearr_32672_34259 = state_32590;
(statearr_32672_34259[(1)] = cljs.core.first((state_32590[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34260 = state_32590;
state_32590 = G__34260;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29915__auto__ = function(state_32590){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29915__auto____1.call(this,state_32590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29915__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29915__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_32675 = f__30153__auto__();
(statearr_32675[(6)] = c__30152__auto__);

return statearr_32675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));

return c__30152__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32677 = arguments.length;
switch (G__32677) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32685 = arguments.length;
switch (G__32685) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32699 = arguments.length;
switch (G__32699) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30152__auto___34280 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_32734){
var state_val_32735 = (state_32734[(1)]);
if((state_val_32735 === (7))){
var inst_32729 = (state_32734[(2)]);
var state_32734__$1 = state_32734;
var statearr_32739_34281 = state_32734__$1;
(statearr_32739_34281[(2)] = inst_32729);

(statearr_32739_34281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32735 === (1))){
var inst_32710 = null;
var state_32734__$1 = (function (){var statearr_32740 = state_32734;
(statearr_32740[(7)] = inst_32710);

return statearr_32740;
})();
var statearr_32741_34282 = state_32734__$1;
(statearr_32741_34282[(2)] = null);

(statearr_32741_34282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32735 === (4))){
var inst_32714 = (state_32734[(8)]);
var inst_32714__$1 = (state_32734[(2)]);
var inst_32715 = (inst_32714__$1 == null);
var inst_32716 = cljs.core.not(inst_32715);
var state_32734__$1 = (function (){var statearr_32752 = state_32734;
(statearr_32752[(8)] = inst_32714__$1);

return statearr_32752;
})();
if(inst_32716){
var statearr_32753_34298 = state_32734__$1;
(statearr_32753_34298[(1)] = (5));

} else {
var statearr_32754_34299 = state_32734__$1;
(statearr_32754_34299[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32735 === (6))){
var state_32734__$1 = state_32734;
var statearr_32756_34300 = state_32734__$1;
(statearr_32756_34300[(2)] = null);

(statearr_32756_34300[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32735 === (3))){
var inst_32731 = (state_32734[(2)]);
var inst_32732 = cljs.core.async.close_BANG_(out);
var state_32734__$1 = (function (){var statearr_32757 = state_32734;
(statearr_32757[(9)] = inst_32731);

return statearr_32757;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32734__$1,inst_32732);
} else {
if((state_val_32735 === (2))){
var state_32734__$1 = state_32734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32734__$1,(4),ch);
} else {
if((state_val_32735 === (11))){
var inst_32714 = (state_32734[(8)]);
var inst_32723 = (state_32734[(2)]);
var inst_32710 = inst_32714;
var state_32734__$1 = (function (){var statearr_32758 = state_32734;
(statearr_32758[(10)] = inst_32723);

(statearr_32758[(7)] = inst_32710);

return statearr_32758;
})();
var statearr_32762_34304 = state_32734__$1;
(statearr_32762_34304[(2)] = null);

(statearr_32762_34304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32735 === (9))){
var inst_32714 = (state_32734[(8)]);
var state_32734__$1 = state_32734;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32734__$1,(11),out,inst_32714);
} else {
if((state_val_32735 === (5))){
var inst_32714 = (state_32734[(8)]);
var inst_32710 = (state_32734[(7)]);
var inst_32718 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32714,inst_32710);
var state_32734__$1 = state_32734;
if(inst_32718){
var statearr_32767_34309 = state_32734__$1;
(statearr_32767_34309[(1)] = (8));

} else {
var statearr_32768_34310 = state_32734__$1;
(statearr_32768_34310[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32735 === (10))){
var inst_32726 = (state_32734[(2)]);
var state_32734__$1 = state_32734;
var statearr_32769_34311 = state_32734__$1;
(statearr_32769_34311[(2)] = inst_32726);

(statearr_32769_34311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32735 === (8))){
var inst_32710 = (state_32734[(7)]);
var tmp32765 = inst_32710;
var inst_32710__$1 = tmp32765;
var state_32734__$1 = (function (){var statearr_32771 = state_32734;
(statearr_32771[(7)] = inst_32710__$1);

return statearr_32771;
})();
var statearr_32772_34312 = state_32734__$1;
(statearr_32772_34312[(2)] = null);

(statearr_32772_34312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_32774 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32774[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_32774[(1)] = (1));

return statearr_32774;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_32734){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_32734);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e32776){var ex__29918__auto__ = e32776;
var statearr_32778_34314 = state_32734;
(statearr_32778_34314[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_32734[(4)]))){
var statearr_32779_34315 = state_32734;
(statearr_32779_34315[(1)] = cljs.core.first((state_32734[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34316 = state_32734;
state_32734 = G__34316;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_32734){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_32734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_32781 = f__30153__auto__();
(statearr_32781[(6)] = c__30152__auto___34280);

return statearr_32781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__32788 = arguments.length;
switch (G__32788) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30152__auto___34322 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_32839){
var state_val_32840 = (state_32839[(1)]);
if((state_val_32840 === (7))){
var inst_32833 = (state_32839[(2)]);
var state_32839__$1 = state_32839;
var statearr_32844_34323 = state_32839__$1;
(statearr_32844_34323[(2)] = inst_32833);

(statearr_32844_34323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32840 === (1))){
var inst_32789 = (new Array(n));
var inst_32792 = inst_32789;
var inst_32793 = (0);
var state_32839__$1 = (function (){var statearr_32845 = state_32839;
(statearr_32845[(7)] = inst_32793);

(statearr_32845[(8)] = inst_32792);

return statearr_32845;
})();
var statearr_32846_34324 = state_32839__$1;
(statearr_32846_34324[(2)] = null);

(statearr_32846_34324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32840 === (4))){
var inst_32801 = (state_32839[(9)]);
var inst_32801__$1 = (state_32839[(2)]);
var inst_32803 = (inst_32801__$1 == null);
var inst_32804 = cljs.core.not(inst_32803);
var state_32839__$1 = (function (){var statearr_32847 = state_32839;
(statearr_32847[(9)] = inst_32801__$1);

return statearr_32847;
})();
if(inst_32804){
var statearr_32848_34325 = state_32839__$1;
(statearr_32848_34325[(1)] = (5));

} else {
var statearr_32849_34326 = state_32839__$1;
(statearr_32849_34326[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32840 === (15))){
var inst_32827 = (state_32839[(2)]);
var state_32839__$1 = state_32839;
var statearr_32854_34327 = state_32839__$1;
(statearr_32854_34327[(2)] = inst_32827);

(statearr_32854_34327[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32840 === (13))){
var state_32839__$1 = state_32839;
var statearr_32864_34328 = state_32839__$1;
(statearr_32864_34328[(2)] = null);

(statearr_32864_34328[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32840 === (6))){
var inst_32793 = (state_32839[(7)]);
var inst_32822 = (inst_32793 > (0));
var state_32839__$1 = state_32839;
if(cljs.core.truth_(inst_32822)){
var statearr_32865_34329 = state_32839__$1;
(statearr_32865_34329[(1)] = (12));

} else {
var statearr_32866_34330 = state_32839__$1;
(statearr_32866_34330[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32840 === (3))){
var inst_32835 = (state_32839[(2)]);
var state_32839__$1 = state_32839;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32839__$1,inst_32835);
} else {
if((state_val_32840 === (12))){
var inst_32792 = (state_32839[(8)]);
var inst_32825 = cljs.core.vec(inst_32792);
var state_32839__$1 = state_32839;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32839__$1,(15),out,inst_32825);
} else {
if((state_val_32840 === (2))){
var state_32839__$1 = state_32839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32839__$1,(4),ch);
} else {
if((state_val_32840 === (11))){
var inst_32816 = (state_32839[(2)]);
var inst_32817 = (new Array(n));
var inst_32792 = inst_32817;
var inst_32793 = (0);
var state_32839__$1 = (function (){var statearr_32877 = state_32839;
(statearr_32877[(7)] = inst_32793);

(statearr_32877[(10)] = inst_32816);

(statearr_32877[(8)] = inst_32792);

return statearr_32877;
})();
var statearr_32878_34331 = state_32839__$1;
(statearr_32878_34331[(2)] = null);

(statearr_32878_34331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32840 === (9))){
var inst_32792 = (state_32839[(8)]);
var inst_32814 = cljs.core.vec(inst_32792);
var state_32839__$1 = state_32839;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32839__$1,(11),out,inst_32814);
} else {
if((state_val_32840 === (5))){
var inst_32793 = (state_32839[(7)]);
var inst_32801 = (state_32839[(9)]);
var inst_32808 = (state_32839[(11)]);
var inst_32792 = (state_32839[(8)]);
var inst_32806 = (inst_32792[inst_32793] = inst_32801);
var inst_32808__$1 = (inst_32793 + (1));
var inst_32809 = (inst_32808__$1 < n);
var state_32839__$1 = (function (){var statearr_32897 = state_32839;
(statearr_32897[(12)] = inst_32806);

(statearr_32897[(11)] = inst_32808__$1);

return statearr_32897;
})();
if(cljs.core.truth_(inst_32809)){
var statearr_32898_34332 = state_32839__$1;
(statearr_32898_34332[(1)] = (8));

} else {
var statearr_32900_34333 = state_32839__$1;
(statearr_32900_34333[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32840 === (14))){
var inst_32830 = (state_32839[(2)]);
var inst_32831 = cljs.core.async.close_BANG_(out);
var state_32839__$1 = (function (){var statearr_32904 = state_32839;
(statearr_32904[(13)] = inst_32830);

return statearr_32904;
})();
var statearr_32905_34334 = state_32839__$1;
(statearr_32905_34334[(2)] = inst_32831);

(statearr_32905_34334[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32840 === (10))){
var inst_32820 = (state_32839[(2)]);
var state_32839__$1 = state_32839;
var statearr_32908_34335 = state_32839__$1;
(statearr_32908_34335[(2)] = inst_32820);

(statearr_32908_34335[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32840 === (8))){
var inst_32808 = (state_32839[(11)]);
var inst_32792 = (state_32839[(8)]);
var tmp32902 = inst_32792;
var inst_32792__$1 = tmp32902;
var inst_32793 = inst_32808;
var state_32839__$1 = (function (){var statearr_32912 = state_32839;
(statearr_32912[(7)] = inst_32793);

(statearr_32912[(8)] = inst_32792__$1);

return statearr_32912;
})();
var statearr_32913_34339 = state_32839__$1;
(statearr_32913_34339[(2)] = null);

(statearr_32913_34339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_32917 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32917[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_32917[(1)] = (1));

return statearr_32917;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_32839){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_32839);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e32922){var ex__29918__auto__ = e32922;
var statearr_32923_34342 = state_32839;
(statearr_32923_34342[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_32839[(4)]))){
var statearr_32924_34343 = state_32839;
(statearr_32924_34343[(1)] = cljs.core.first((state_32839[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34349 = state_32839;
state_32839 = G__34349;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_32839){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_32839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_32931 = f__30153__auto__();
(statearr_32931[(6)] = c__30152__auto___34322);

return statearr_32931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__32972 = arguments.length;
switch (G__32972) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30152__auto___34410 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30153__auto__ = (function (){var switch__29914__auto__ = (function (state_33035){
var state_val_33036 = (state_33035[(1)]);
if((state_val_33036 === (7))){
var inst_33030 = (state_33035[(2)]);
var state_33035__$1 = state_33035;
var statearr_33039_34416 = state_33035__$1;
(statearr_33039_34416[(2)] = inst_33030);

(statearr_33039_34416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33036 === (1))){
var inst_32977 = [];
var inst_32978 = inst_32977;
var inst_32979 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33035__$1 = (function (){var statearr_33042 = state_33035;
(statearr_33042[(7)] = inst_32978);

(statearr_33042[(8)] = inst_32979);

return statearr_33042;
})();
var statearr_33043_34429 = state_33035__$1;
(statearr_33043_34429[(2)] = null);

(statearr_33043_34429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33036 === (4))){
var inst_32982 = (state_33035[(9)]);
var inst_32982__$1 = (state_33035[(2)]);
var inst_32988 = (inst_32982__$1 == null);
var inst_32989 = cljs.core.not(inst_32988);
var state_33035__$1 = (function (){var statearr_33044 = state_33035;
(statearr_33044[(9)] = inst_32982__$1);

return statearr_33044;
})();
if(inst_32989){
var statearr_33045_34434 = state_33035__$1;
(statearr_33045_34434[(1)] = (5));

} else {
var statearr_33046_34438 = state_33035__$1;
(statearr_33046_34438[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33036 === (15))){
var inst_33022 = (state_33035[(2)]);
var state_33035__$1 = state_33035;
var statearr_33047_34439 = state_33035__$1;
(statearr_33047_34439[(2)] = inst_33022);

(statearr_33047_34439[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33036 === (13))){
var state_33035__$1 = state_33035;
var statearr_33048_34444 = state_33035__$1;
(statearr_33048_34444[(2)] = null);

(statearr_33048_34444[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33036 === (6))){
var inst_32978 = (state_33035[(7)]);
var inst_33017 = inst_32978.length;
var inst_33018 = (inst_33017 > (0));
var state_33035__$1 = state_33035;
if(cljs.core.truth_(inst_33018)){
var statearr_33049_34447 = state_33035__$1;
(statearr_33049_34447[(1)] = (12));

} else {
var statearr_33051_34448 = state_33035__$1;
(statearr_33051_34448[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33036 === (3))){
var inst_33032 = (state_33035[(2)]);
var state_33035__$1 = state_33035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33035__$1,inst_33032);
} else {
if((state_val_33036 === (12))){
var inst_32978 = (state_33035[(7)]);
var inst_33020 = cljs.core.vec(inst_32978);
var state_33035__$1 = state_33035;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33035__$1,(15),out,inst_33020);
} else {
if((state_val_33036 === (2))){
var state_33035__$1 = state_33035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33035__$1,(4),ch);
} else {
if((state_val_33036 === (11))){
var inst_32982 = (state_33035[(9)]);
var inst_32991 = (state_33035[(10)]);
var inst_33010 = (state_33035[(2)]);
var inst_33011 = [];
var inst_33012 = inst_33011.push(inst_32982);
var inst_32978 = inst_33011;
var inst_32979 = inst_32991;
var state_33035__$1 = (function (){var statearr_33055 = state_33035;
(statearr_33055[(7)] = inst_32978);

(statearr_33055[(8)] = inst_32979);

(statearr_33055[(11)] = inst_33010);

(statearr_33055[(12)] = inst_33012);

return statearr_33055;
})();
var statearr_33056_34458 = state_33035__$1;
(statearr_33056_34458[(2)] = null);

(statearr_33056_34458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33036 === (9))){
var inst_32978 = (state_33035[(7)]);
var inst_33008 = cljs.core.vec(inst_32978);
var state_33035__$1 = state_33035;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33035__$1,(11),out,inst_33008);
} else {
if((state_val_33036 === (5))){
var inst_32982 = (state_33035[(9)]);
var inst_32979 = (state_33035[(8)]);
var inst_32991 = (state_33035[(10)]);
var inst_32991__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32982) : f.call(null,inst_32982));
var inst_32999 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32991__$1,inst_32979);
var inst_33000 = cljs.core.keyword_identical_QMARK_(inst_32979,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_33001 = ((inst_32999) || (inst_33000));
var state_33035__$1 = (function (){var statearr_33061 = state_33035;
(statearr_33061[(10)] = inst_32991__$1);

return statearr_33061;
})();
if(cljs.core.truth_(inst_33001)){
var statearr_33062_34475 = state_33035__$1;
(statearr_33062_34475[(1)] = (8));

} else {
var statearr_33063_34476 = state_33035__$1;
(statearr_33063_34476[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33036 === (14))){
var inst_33026 = (state_33035[(2)]);
var inst_33027 = cljs.core.async.close_BANG_(out);
var state_33035__$1 = (function (){var statearr_33065 = state_33035;
(statearr_33065[(13)] = inst_33026);

return statearr_33065;
})();
var statearr_33066_34478 = state_33035__$1;
(statearr_33066_34478[(2)] = inst_33027);

(statearr_33066_34478[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33036 === (10))){
var inst_33015 = (state_33035[(2)]);
var state_33035__$1 = state_33035;
var statearr_33081_34479 = state_33035__$1;
(statearr_33081_34479[(2)] = inst_33015);

(statearr_33081_34479[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33036 === (8))){
var inst_32978 = (state_33035[(7)]);
var inst_32982 = (state_33035[(9)]);
var inst_32991 = (state_33035[(10)]);
var inst_33005 = inst_32978.push(inst_32982);
var tmp33064 = inst_32978;
var inst_32978__$1 = tmp33064;
var inst_32979 = inst_32991;
var state_33035__$1 = (function (){var statearr_33082 = state_33035;
(statearr_33082[(7)] = inst_32978__$1);

(statearr_33082[(8)] = inst_32979);

(statearr_33082[(14)] = inst_33005);

return statearr_33082;
})();
var statearr_33083_34485 = state_33035__$1;
(statearr_33083_34485[(2)] = null);

(statearr_33083_34485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29915__auto__ = null;
var cljs$core$async$state_machine__29915__auto____0 = (function (){
var statearr_33084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33084[(0)] = cljs$core$async$state_machine__29915__auto__);

(statearr_33084[(1)] = (1));

return statearr_33084;
});
var cljs$core$async$state_machine__29915__auto____1 = (function (state_33035){
while(true){
var ret_value__29916__auto__ = (function (){try{while(true){
var result__29917__auto__ = switch__29914__auto__(state_33035);
if(cljs.core.keyword_identical_QMARK_(result__29917__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29917__auto__;
}
break;
}
}catch (e33085){var ex__29918__auto__ = e33085;
var statearr_33088_34489 = state_33035;
(statearr_33088_34489[(2)] = ex__29918__auto__);


if(cljs.core.seq((state_33035[(4)]))){
var statearr_33089_34491 = state_33035;
(statearr_33089_34491[(1)] = cljs.core.first((state_33035[(4)])));

} else {
throw ex__29918__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29916__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34496 = state_33035;
state_33035 = G__34496;
continue;
} else {
return ret_value__29916__auto__;
}
break;
}
});
cljs$core$async$state_machine__29915__auto__ = function(state_33035){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29915__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29915__auto____1.call(this,state_33035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29915__auto____0;
cljs$core$async$state_machine__29915__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29915__auto____1;
return cljs$core$async$state_machine__29915__auto__;
})()
})();
var state__30154__auto__ = (function (){var statearr_33090 = f__30153__auto__();
(statearr_33090[(6)] = c__30152__auto___34410);

return statearr_33090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30154__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
