/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZMQQueue
implements Runnable {
    private final ZMQ.Poller poller;
    private final ZMQ.Socket inSocket;
    private final ZMQ.Socket outSocket;

    public ZMQQueue(ZMQ.Context context, ZMQ.Socket socket, ZMQ.Socket socket2) {
        this.inSocket = socket;
        this.outSocket = socket2;
        this.poller = context.poller(2);
        this.poller.register(socket, 1);
        this.poller.register(socket2, 1);
    }

    @Override
    public void run() {
        byte[] byArray = null;
        boolean bl = true;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.poller.poll(250L) < 1L) continue;
                if (this.poller.pollin(0)) {
                    bl = true;
                    while (bl) {
                        byArray = this.inSocket.recv(0);
                        bl = this.inSocket.hasReceiveMore();
                        if (byArray == null) continue;
                        this.outSocket.send(byArray, bl ? 2 : 0);
                    }
                }
                if (!this.poller.pollin(1)) continue;
                bl = true;
                while (bl) {
                    byArray = this.outSocket.recv(0);
                    bl = this.outSocket.hasReceiveMore();
                    if (byArray == null) continue;
                    this.inSocket.send(byArray, bl ? 2 : 0);
                }
            }
            catch (ZMQException zMQException) {
                if (ZMQ.Error.ETERM.getCode() == (long)zMQException.getErrorCode()) break;
                throw zMQException;
            }
        }
    }
}

