(ns jtk-dvlp.async.interop.callback
  #?(:clj
     (:require
      [clojure.walk :refer [postwalk]])

     :cljs
     (:require
      [clojure.walk :refer [postwalk]])))


#?(:clj
   (defn- replace-symbol
     [search replacement x]
     ;; (println x)
     (if (= x search)
       replacement
       x)))

#?(:clj
   (defmacro cb->c
     "TODO"
     [[f & forms]]
     (let [put-resolution!
           (gensym 'put-resolution)

           put-rejection!
           (gensym 'put-rejection)

           marks-given?
           (->> forms
                (flatten)
                (some #{'callback 'resolve 'reject}))

           forms'
           (if marks-given?
             (->> forms
                  (postwalk (partial replace-symbol 'callback put-resolution!))
                  (postwalk (partial replace-symbol 'resolve put-resolution!))
                  (postwalk (partial replace-symbol 'reject put-rejection!)))
             (-> forms (vec) (conj put-resolution!)))]

       (if (:ns &env)
         `(let [c#
                (cljs.core.async/chan)

                ~put-resolution!
                (partial cljs.core.async/put! c#)

                ~put-rejection!
                (partial cljs.core.async/put! c#)]

            (try
              (~f ~@forms')
              (catch js/Error e#
                (~put-rejection! e#)))
            c#)
         `(let [c#
                (clojure.core.async/chan)

                ~put-resolution!
                (partial clojure.core.async/put! c#)

                ~put-rejection!
                (partial clojure.core.async/put! c#)]

            (try
              (~f ~@forms')
              (catch Throwable e#
                (~put-rejection! e#)))
            c#)))))
