(defproject junegunn/hbase-clj "0.1.0-SNAPSHOT"
  :description "HBase Clojure client"
  :url "http://github.com/junegunn/hbase-clj"
  :license {:name "MIT"}
  :repositories [["cloudera-releases"
                  "https://repository.cloudera.com/artifactory/cloudera-repos"]]
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [org.apache.hbase/hbase-client "1.2.0" :exclusions [org.slf4j/slf4j-log4j12]]
                 [org.slf4j/slf4j-api "1.7.21"]]
  :plugins [[codox "0.8.12"]           ; lein doc
            [jonase/eastwood "0.2.1"]] ; lein eastwood
  :codox {:defaults {:doc/format :markdown}}
  :target-path "target/%s"
  :jvm-opts ["-Dclojure.compiler.direct-linking=true"
             "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005"]
  :resource-paths []
  ; :repl-options {:init-ns user}
  :profiles
  {:uberjar {:aot :all}
   :repl {:dependencies [;; Logging and debugging
                         [org.clojure/tools.logging "0.3.1"]
                         [org.clojure/tools.trace "0.7.9"]

                         ;; Minicluster
                         [org.apache.hbase/hbase-testing-util "1.2.0"]

                         ;; Asynchbase
                         [org.hbase/asynchbase "1.7.2"]
                         [com.stumbleupon/async "1.4.1"
                          :exclusions [org.slf4j/slf4j-api]]
                         [io.netty/netty "3.9.4.Final"]

                         ;; JDBC
                         [org.clojure/java.jdbc "0.6.0-rc2"]

                         ;; Histogram
                         [org.hdrhistogram/HdrHistogram "2.1.8"]

                         ;; For REPL
                         [org.clojure/tools.nrepl "0.2.12"]
                         [reply "0.3.7"]
                         [net.cgrand/parsley "0.9.3" :exclusions [org.clojure/clojure]]

                         ;; Dependencies
                         [com.cemerick/pomegranate "0.3.0"]

                         ;; HTTP
                         [http-kit "2.1.18"]

                         ;; JSON
                         [org.clojure/data.json "0.2.6"]

                         ;; Batch processing
                         [junegunn/grouper "0.1.0"]]
          :main ^:skip-aot hbase-clj.repl
          :source-paths ["src-repl"]
          :resource-paths ["resources"]
          :jvm-opts ["-Xmx4g"
                     "-XX:+UseG1GC"
                     "-XX:MaxGCPauseMillis=300"
                     "-XX:+ParallelRefProcEnabled"
                     "-XX:-ResizePLAB"
                     ;"-javaagent:/Users/jg/github/memory-measurer/dist/object-explorer.jar"
                     ;"-XX:+UnlockCommercialFeatures"
                     ;"-XX:+FlightRecorder"
                     ]}})
