# Rendering forms and Validating form data

We have created a small utility library for rendering and validating forms.

A `Form` is map of `form-fields` and `checks`. Form fields are individual items in a form. Each form field has its own checks.

For example, we want to create a user registration form. We would need 3 fields: `email`, `password` and `confirm-password`. The `email` field should check for valid email address and the `password` and `confirm-password` field should be over 6 characters. At total form level, we would also need to check that `password` is equal to `confirm-password`.


## Defining Form Fields

A `FormField` is a `map` containing `name`, `input-type`, `label`, `value`, `checks`, `error-msg` etc. To create this map, we can use the `FormField` function in `forms.core`.

`FormField` function needs the `name` and map of optional params. We can provide `:label` in params, or it will automatically parse it from name. We can also pass a dictionary of `:attrs` to pass additional html attributes for field rendering. The form field will be a non-blank field unless we provide `:optional` param.

```clojure
(require '[utilities.forms.core as form]
         '[utilities.forms.checks :as check])

; Email field
(form/FormField 'email' {:checks [check/email?]})

; Password field
(form/FormField 'password' {:attrs {:type "password"}
                            :checks [(partial check/min-length? 6)]})

; Optional phone-number field
(form/FormField 'phone-number' {:optional? true
                                :checks [check/number?]})

; Textarea field for long message
(form/FormField 'message' {:field-type :textarea
                           :attrs {:cols 60 :rows 5}})

; Select box to select a plan from various plans
(form/FormField 'plan' {:field-type :select
                        :options {"hobby" "Hobby (limited usage)"
                                  "personal" "Unlimited for 1 Person"
                                  "family" "Unlimited for 4"}})

; Checkbox for agreeing terms and conditions
(form/FormField 'agree-terms' {:field-type :checkbox})


; Optional Checkbox for receiving updates
(form/FormField 'agree-terms' {:field-type :checkbox
                               :optional? true
                               :value true})
```

## Form level validations

The `field` checks checked the field value in standalone. Database level checks or cross-field checks are provided in the `Form` map.