(ns utilities.exceptions
    (:require [ring.util.response :as res]))

(defn raise
    "Throws Exception with given message"
    [cause msg]
    (throw (ex-info msg {cause true})))


(defn cause?
    "Returns true if the cause of error matches the given cause"
    [^Exception e cause]
    (get (ex-data e) cause))


(defn message
    "Returns message from given exception"
    [^Exception e]
    (.getMessage e))


(defn exceptions-middleware
    "Provides middleware to return page not found if cause is :404"
    [handler]
    (fn [request]
        (try
            (handler request)
            (catch Exception e
                (if (cause? e :404)
                    (res/not-found "Resource not found")
                    (throw e))))))
