(ns {{ name }} .handler
    (:require [compojure.core :refer [GET routes]]
              [compojure.route :as route]
              [ring.util.response :refer [redirect]]
              [utilities.auth.middleware :refer [wrap-user]]
              [utilities.exceptions :refer [exceptions-middleware]]
              [ring.middleware.defaults :refer [wrap-defaults site-defaults]]
              [utilities.settings :as settings]
              [utilities.routing :as r]
              [{{ name }}.urls :refer [urls]]
              [{{ name }}.pages :refer [page-not-found]]))


; compojure.routes returns ring-handler function
; path-handler function takes map of request, inspect the method and path
; and matches it with appropriate view function
(def path-handler
    (let [users     (r/handlers urls)
          default   [; static routes
                     (route/resources "/static/" {:root "public"})
                     ; Redirect missing slashes
                     (GET ":page{/[^/]+}" [page]
                         (redirect (str page "/") 301))
                     (route/not-found page-not-found)]
          handlers  (concat users default)]
        (apply routes handlers)))


; Middlewares are higher level functions that add functionality to handlers
; First argument to middleware is handler function.
; It should return new handler function that should call original handler
; eg: https://github.com/ring-clojure/ring/wiki/Concepts#middleware

; disabling csrf in testing
(def default-middlewares
  (if settings/in-testing?
    (assoc site-defaults :security false)
    site-defaults))


(def app
  (-> path-handler
      (wrap-user)
      (wrap-defaults default-middlewares)
      (exceptions-middleware)))
