(ns utilities.routing
    (:require [utilities.templates :as t]
              [compojure.core :as c]))


; Define urls as nil if not already defined
; names-p is map of url name and its broken path
(defonce names-p nil)


(defn names-broken-path
    "Returns a map of url name and broken path for given urls"
    [urls]
    (into {} (for [[name path _] (partition 3 urls)]
                 [name (t/break-text path)])))


(defn set-urls
    "Sets urls to given urls for reverse handling"
    [urls]
    (def names-p (names-broken-path urls)))



(defn get-url
    "Generates a function which provides url for given name and context"
    [name context]
    (let [path (get names-p name)]
        (t/fill-broken-text path context)))


(defn- get-vals
    "Returns collection of values from map for given keys"
    [coll keys]
    (for [key keys]
        (get coll key)))


(defn handlers
    "Returns handlers to be passed to compojure.routes for given urls vector"
    [urls]
    (let [names-p (names-broken-path urls)]
        (for [[n _ f] (partition 3 urls)]
            (let [p     (get names-p n)
                  args  (filter keyword? p)
                  ; replace our placeholder with compujure-keyword syntax
                  path  (t/fill-broken-text p (zipmap args
                                                      (map str args)))]
                (c/ANY path request
                     (if args
                         (apply f request
                                (get-vals (:route-params request) args))
                         (f request)))))))