(ns utilities.auth.core
  (:require [ring.util.response :as response]))

(defmacro when-authenticated?
  "Redirects user to login page if not authenticated"
  [request & body]
  `(if (:authenticated? (:user ~request))
     ~@body
     (let [redirect-uri# (str "/login/?next=" (:uri ~request))]
       (response/redirect redirect-uri#))))
