(ns leiningen.new.jurassic-web
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]
            [clojure.java.io :as io]))


(def render (renderer "jurassic-web"))

(defn- copy-same
  "Copies file from resource as it is to new project"
  [f]
  [f (render f)])


(defn jurassic-web
  "Create the structure for new project"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' jurassic-web project.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             [".gitignore"  (render "gitignore")]
             [".editorconfig"  (render "editorconfig")]
             ["README.md"  (render "README.md")]

             ["resources/db/changelog.xml" (render "db/changelog.xml")]

             ["resources/public/css/normalize.css" (render "css/normalize.css")]
             ["resources/public/css/style.css" (render "css/style.css")]

             ["resources/html/base.html" (render "html/base.html")]
             ["resources/html/components/hello.html" (render "html/components/hello.html")]

             ["resources/simplelogger.properties" (render "simplelogger.properties")]

             ; docs
             (copy-same "doc/forms.md")
             (copy-same "doc/intro.md")
             (copy-same "doc/migrations.md")
             (copy-same "doc/querying.md")
             (copy-same "doc/routing.md")
             (copy-same "doc/structuring.md")
             (copy-same "doc/templating.md")
             (copy-same "doc/concepts.md")
             (copy-same "doc/testing.md")

             ; utilities
             (copy-same "src/utilities/db.clj")
             (copy-same "src/utilities/exceptions.clj")
             (copy-same "src/utilities/files.clj")
             (copy-same "src/utilities/migrations.clj")
             (copy-same "src/utilities/routing.clj")
             (copy-same "src/utilities/settings.clj")
             (copy-same "src/utilities/templates.clj")
             (copy-same "src/utilities/testing.clj")
             (copy-same "src/utilities/auth/core.clj")
             (copy-same "src/utilities/auth/middleware.clj")
             (copy-same "src/utilities/forms/core.clj")
             (copy-same "src/utilities/forms/checks.clj")
             (copy-same "src/utilities/forms/components.clj")
             (copy-same "src/utilities/jsoup.clj")
             (copy-same "src/utilities/responses.clj")

             ; tests for utilities
             (copy-same "test/utilities/db_test.clj")
             (copy-same "test/utilities/files_test.clj")
             (copy-same "test/utilities/forms_test.clj")
             (copy-same "test/utilities/routing_test.clj")
             (copy-same "test/utilities/settings_test.clj")
             (copy-same "test/utilities/templates_test.clj")
             (copy-same "test/utilities/forms/checks_test.clj")
             (copy-same "test/utilities/forms/core_test.clj")
             (copy-same "test/utilities/forms_test.clj")
             (copy-same "test/utilities/jsoup_test.clj")
             (copy-same "test/utilities/responses_test.clj")

             ; Files requiring parsing
             ["src/{{sanitized}}/pages.clj" (render "project/pages.clj" data)]
             ["src/{{sanitized}}/urls.clj" (render "project/urls.clj" data)]
             ["src/{{sanitized}}/handler.clj" (render "project/handler.clj" data)])))
