# Creating and maintaining Database migrations

One of the nicest features of Django is automatic database migrations. The feature was developed by Andrew Godwin and it is fabulous. It not just detects new columns and models, but also detects renames and dependencies. It is the most elegant solution for maintaining schemas as all the table specs are in text and laid right in front. It shows all the indexes, unique constraints and column specs.

The Java alternative to migrations is `Liquibase`. Here we maintain a `db-changelog.xml` file which contains all the migrations. Unlike Django, these migrations need to be created manually.

## Creating migrations

The `db-changelog.xml` uses the `Liquibase` xml schema which provides validation as well as autocomplete in IDE. We can easitly define changes in columns, tables and default values using it.

### Alternative for large changes

I like to use `mysql-workbench` for creating migrations. I include `db-diagram.mwb` file in the source code. This is the model-diagram file used by workbench. I make the changes in the diagram using the graphical interface, and then generate the change sql for migration using the synchronize option of workbench.

The primary steps are like:

```
- Open `db-diagram.mwb` file in MySQL workbench.
- Make changes to the diagram.
- Select Database > Synchronize with any source >
    Model diagram as source
    Live Database as Destination
    Alter script file
    Copy commands
- Edit `db-changelog.xml` file and paste commands.
- Remove db name in the pasted commands.
- lein migrate
```