(ns utilities.forms.checks-test
  (:require [clojure.test :refer :all]
            [utilities.forms.checks :refer :all]
            [utilities.db :as db]
            [utilities.testing :as t]
            [utilities.exceptions :as ex]))


(deftest test-min-length?
  (testing "good length"
    (are [value]
      (= (min-length? 6 value) true)
      "foo@bar"
      "123456"
      "   1    "))

  (testing "bad lengths"
    (are [value]
      (thrown-with-msg? Exception #"Value must be minimum 6 characters"
                        (min-length? 6 value))
      "foo"
      ""
      nil)))
