(ns {{ name }}.pages
  (:require [hiccup.core :refer [html]]
            [utilities.templates :as t]))


(def ^:private normal-css
  (t/hash-links ["css/normalize.css" "css/style.css"]))


(defn normal
  "Renders template using base.html as base"
  [request title template context]
  (let [file    (str "html/content/" template)
        content (t/fill-in-file file context)]
    (t/fill-in-file "html/base.html"
                    {:title   title
                     :css     normal-css
                     :content content
                     :request request})))


(defn page-not-found
  "Render Page not found"
  [request]
  (let [uri (:uri request)]
    (normal request "Page Not Found" "route-404.html" nil)))
