(ns utilities.cache
  (:require [clojure.core.cache :as cache]))


;; since the caches are immutable, you would normally wrap them in an atom
(def C2 (atom (cache/lru-cache-factory {:a 1, :b 2})))


(defn touch
  [name]
  (swap! C2 cache/evict name))


(defn through-cache
  [name f & args]
  (let [name (keyword name)
        cb    (fn [& _] (apply f args))]
    (swap! C2 cache/through-cache name cb)
    (get @C2 name)))

