(ns utilities.settings-test
  (:require [utilities.settings :refer :all]
            [clojure.test :refer :all]))


(def called-count 0)

(defn inc-call
  []
  (def called-count (inc called-count)))


(deftest test-macro
  (testing "memoized macro"
    (let [f (memoize-in-prod inc-call)]
      (f)
      (is (= called-count 1))
      (f)
      (is (= called-count 1))))

  (testing "not in dev mode"
    (is (= in-production? true)))

  (testing "in test mode"
    (is (= in-testing? true))))
