(ns utilities.settings
  (:require
    ; Register clj-time jdbc protocol extension
    [clj-time.jdbc]))


(def salt (or (System/getenv "JURASSIC_SALT")
              "SecRet!#12343@Salt"))


(def in-production?
  (= (System/getenv "LEIN_NO_DEV") "yes"))

; Bound to true during testing
(def in-testing? false)

; Dynamic as over-ridden during testing
(def mysql-db (System/getenv "JURASSIC_MYSQL_DATABASE"))

(def mysql-host-port (System/getenv "JURASSIC_MYSQL_HOST"))
(def mysql-username (System/getenv "JURASSIC_MYSQL_USER"))
(def mysql-password (System/getenv "JURASSIC_MYSQL_PASSWORD"))


(defn db-spec
  "Returns db-spec required for database operations"
  []
  {:classname   "com.mysql.cj.jdbc.Driver"
   :subprotocol "mysql"
   :subname     (str "//" mysql-host-port "/" mysql-db)
   :user        mysql-username
   :password    mysql-password})


(defn memoize-in-prod
  "Memoizes a function in production"
  [f]
  (if in-production?
    (memoize f)
    f))
