(ns {{ name }}.pages
  (:require [hiccup.core :refer [html]]
            [utilities.templates :as t]))


(def ^:private normal-css
  (t/hash-links ["css/normalize.css" "css/style.css"]))

(defn child-content
      [template context]
      (t/fill-in-file (str "html/content/" template) context))


(defn render-in-base
      [request css js template context]
      (t/fill-in-file
        "html/base.html"
        {:title       (:title context)
         :css         css
         :content     (child-content template context)
         :js          js
         :request     request}))


(defn render
      [request template context]
      (render-in-base request normal-css nil template context))


(defn render
  "Renders template using base.html as base"
  [request template context]
  (let [file    (str "html/content/" template)
        content (t/fill-in-file file context)]
    (t/fill-in-file "html/base.html"
                    {:title   title
                     :css     normal-css
                     :content content
                     :request request})))


(defn page-not-found
  "Render Page not found"
  [request]
  (let [uri (:uri request)]
    (render request "route-404.html"
            {:title "Page not found"})))
