(ns utilities.forms.validations-test
  (:require [clojure.test :refer :all]
            [utilities.forms.validations :refer :all]
            [utilities.forms.core :as f]))


(deftest test-min-length?
  (testing "good length"
    (are [value]
      (= (validate-min-length 6 value) ::f/is-clean)
      "foo@bar"
      "123456"
      "   1    "))

  (testing "bad lengths"
    (are [value]
      (= (validate-min-length 6 value) "Value must be minimum 6 characters")
      "foo"
      ""
      nil)))
