(defproject {{ name }} "0.1.0-SNAPSHOT"
  :description "ADD YOUR {{ name }} description"
  :url "https://www.{{ name }}.com"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :aliases {"development-server" ["run" "-m" "{{ name }}.server/start-development"]
            "production-server"  ["run" "-m" "{{ name }}.server/start-production"]
            "migrate" ["run" "-m" "utilities.migrations/migrate"]
            "migrations" ["run" "-m" "utilities.migrations/validate"]
            "truncate" ["run" "-m" "utilities.testing/truncate"]
            "reset-db" ["run" "-m" "utilities.testing/reset-db"]
            "test" ["run" "-m" "utilities.testing/run"]}
  :dependencies [[org.clojure/clojure "1.10.0"]
                 ; Ring handler
                 [compojure "1.6.1"]
                 [ring/ring-defaults "0.3.2"]
                 ; Components Templating
                 [hiccup "1.0.5"]
                 [stencil "0.5.0"]
                 ; Json responses
                 [ring/ring-json "0.4.0"]
                 [org.clojure/data.json "0.2.6"]
                 ; Authentication
                 [buddy/buddy-hashers "1.3.0"]
                 ; Static files hash
                 [digest "1.4.9"]
                 ; Cache
                 [org.clojure/core.cache "0.7.2"]
                 ; Database
                 [mysql/mysql-connector-java "8.0.15"]
                 [org.clojure/java.jdbc "0.7.9"]
                 ; Connection pooling
                 [com.zaxxer/HikariCP "3.3.1"]
                 ; Liquibase for migrations
                 [org.liquibase/liquibase-core "3.6.3"
                  :exclusions [ch.qos.logback/logback-classic]]
                 ; Loggging dependencies
                 ; redirect slf4j used by java libs
                 [com.fzakaria/slf4j-timbre "0.3.13"]
                 ; required by slf4j-timbre
                 [org.slf4j/slf4j-api "1.7.26"]
                 ; Logs as data
                 [com.taoensso/timbre "4.10.0"]
                 ; testing
                 [org.clojure/tools.namespace "0.2.11"]
                 ; html parsing
                 [clj-http "3.9.1"]
                 [org.jsoup/jsoup "1.11.3"]
                 ; Emails
                 [com.draines/postal "2.0.3"]
                 ; server
                 [ring-server "0.5.0"]]
  :profiles {:dev {:dependencies [[javax.servlet/servlet-api "2.5"]
                                  ; testing
                                  [ring/ring-mock "0.3.2"]
                                  [peridot "0.5.1"]]}})
