(ns utilities.routing-test
  (:require [utilities.routing :as routes]
            [clojure.test :refer :all]
            [stencil.parser :as p]))

(defn set-test-urls
  [test]
  (with-redefs [routes/url-paths (atom {:home (p/parse "/")
                                        :foo (p/parse "/foo/{{id}}/bar/")})]
    (test)))

(use-fixtures :each set-test-urls)


(deftest routing-testing

  (testing "reverse urls"
    (is (= (routes/get-url :foo {:id 12, :baz "baz"})
           "/foo/12/bar/"))
    (is (= (routes/get-url :home {:id 12})
           "/")))

  (testing "errors in reversing"
    (is (= (routes/get-url :foo {}) "/foo//bar/"))))
