// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__20567){
var map__20568 = p__20567;
var map__20568__$1 = ((((!((map__20568 == null)))?(((((map__20568.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20568.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20568):map__20568);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20568__$1,cljs.core.cst$kw$operation);
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20568__$1,cljs.core.cst$kw$op_DASH_type);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20568__$1,cljs.core.cst$kw$tags);
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20568__$1,cljs.core.cst$kw$child_DASH_of);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$id,re_frame.trace.next_id(),cljs.core.cst$kw$operation,operation,cljs.core.cst$kw$op_DASH_type,op_type,cljs.core.cst$kw$tags,tags,cljs.core.cst$kw$child_DASH_of,(function (){var or__3949__auto__ = child_of;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),cljs.core.cst$kw$start,re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__20570_20584 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__20571_20585 = null;
var count__20572_20586 = (0);
var i__20573_20587 = (0);
while(true){
if((i__20573_20587 < count__20572_20586)){
var vec__20574_20588 = chunk__20571_20585.cljs$core$IIndexed$_nth$arity$2(null,i__20573_20587);
var k_20589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20574_20588,(0),null);
var cb_20590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20574_20588,(1),null);
try{var G__20578_20591 = cljs.core.deref(re_frame.trace.traces);
(cb_20590.cljs$core$IFn$_invoke$arity$1 ? cb_20590.cljs$core$IFn$_invoke$arity$1(G__20578_20591) : cb_20590.call(null,G__20578_20591));
}catch (e20577){var e_20592 = e20577;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_20589,"while storing",cljs.core.deref(re_frame.trace.traces),e_20592], 0));
}

var G__20593 = seq__20570_20584;
var G__20594 = chunk__20571_20585;
var G__20595 = count__20572_20586;
var G__20596 = (i__20573_20587 + (1));
seq__20570_20584 = G__20593;
chunk__20571_20585 = G__20594;
count__20572_20586 = G__20595;
i__20573_20587 = G__20596;
continue;
} else {
var temp__5735__auto___20597 = cljs.core.seq(seq__20570_20584);
if(temp__5735__auto___20597){
var seq__20570_20598__$1 = temp__5735__auto___20597;
if(cljs.core.chunked_seq_QMARK_(seq__20570_20598__$1)){
var c__4351__auto___20599 = cljs.core.chunk_first(seq__20570_20598__$1);
var G__20600 = cljs.core.chunk_rest(seq__20570_20598__$1);
var G__20601 = c__4351__auto___20599;
var G__20602 = cljs.core.count(c__4351__auto___20599);
var G__20603 = (0);
seq__20570_20584 = G__20600;
chunk__20571_20585 = G__20601;
count__20572_20586 = G__20602;
i__20573_20587 = G__20603;
continue;
} else {
var vec__20579_20604 = cljs.core.first(seq__20570_20598__$1);
var k_20605 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20579_20604,(0),null);
var cb_20606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20579_20604,(1),null);
try{var G__20583_20607 = cljs.core.deref(re_frame.trace.traces);
(cb_20606.cljs$core$IFn$_invoke$arity$1 ? cb_20606.cljs$core$IFn$_invoke$arity$1(G__20583_20607) : cb_20606.call(null,G__20583_20607));
}catch (e20582){var e_20608 = e20582;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_20605,"while storing",cljs.core.deref(re_frame.trace.traces),e_20608], 0));
}

var G__20609 = cljs.core.next(seq__20570_20598__$1);
var G__20610 = null;
var G__20611 = (0);
var G__20612 = (0);
seq__20570_20584 = G__20609;
chunk__20571_20585 = G__20610;
count__20572_20586 = G__20611;
i__20573_20587 = G__20612;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});
