// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('reitit.frontend.controllers');
goog.require('cljs.core');
goog.require('cljs.core.constants');
reitit.frontend.controllers.pad_same_length = (function reitit$frontend$controllers$pad_same_length(a,b){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a,cljs.core.take.cljs$core$IFn$_invoke$arity$2((cljs.core.count(b) - cljs.core.count(a)),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)));
});
reitit.frontend.controllers.params_warning = (new cljs.core.Delay((function (){
return console.warn("Reitit-frontend controller :params is deprecated. Replace with :identity or :parameters option.");
}),null));
/**
 * Get controller identity given controller and match.
 * 
 *   To select interesting properties from Match :parameters option can be set.
 *   Value should be param-type => [param-key]
 *   Resulting value is map of param-type => param-key => value.
 * 
 *   For other uses, :identity option can be used to provide function from
 *   Match to identity.
 * 
 *   Default value is nil, i.e. controller identity doesn't depend on Match.
 */
reitit.frontend.controllers.get_identity = (function reitit$frontend$controllers$get_identity(p__20055,match){
var map__20056 = p__20055;
var map__20056__$1 = ((((!((map__20056 == null)))?(((((map__20056.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20056.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20056):map__20056);
var identity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20056__$1,cljs.core.cst$kw$identity);
var parameters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20056__$1,cljs.core.cst$kw$parameters);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20056__$1,cljs.core.cst$kw$params);
if(cljs.core.not((function (){var and__3938__auto__ = identity;
if(cljs.core.truth_(and__3938__auto__)){
return parameters;
} else {
return and__3938__auto__;
}
})())){
} else {
throw (new Error(["Assert failed: ","Use either :identity or :parameters for controller, not both.","\n","(not (and identity parameters))"].join('')));
}

if(cljs.core.truth_(params)){
cljs.core.deref(reitit.frontend.controllers.params_warning);
} else {
}

if(cljs.core.truth_(parameters)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4324__auto__ = ((function (map__20056,map__20056__$1,identity,parameters,params){
return (function reitit$frontend$controllers$get_identity_$_iter__20058(s__20059){
return (new cljs.core.LazySeq(null,((function (map__20056,map__20056__$1,identity,parameters,params){
return (function (){
var s__20059__$1 = s__20059;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__20059__$1);
if(temp__5735__auto__){
var s__20059__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__20059__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__20059__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__20061 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__20060 = (0);
while(true){
if((i__20060 < size__4323__auto__)){
var vec__20062 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__20060);
var param_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20062,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20062,(1),null);
cljs.core.chunk_append(b__20061,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_type,cljs.core.select_keys(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$parameters.cljs$core$IFn$_invoke$arity$1(match),param_type),ks)], null));

var G__20068 = (i__20060 + (1));
i__20060 = G__20068;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__20061),reitit$frontend$controllers$get_identity_$_iter__20058(cljs.core.chunk_rest(s__20059__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__20061),null);
}
} else {
var vec__20065 = cljs.core.first(s__20059__$2);
var param_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20065,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20065,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_type,cljs.core.select_keys(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$parameters.cljs$core$IFn$_invoke$arity$1(match),param_type),ks)], null),reitit$frontend$controllers$get_identity_$_iter__20058(cljs.core.rest(s__20059__$2)));
}
} else {
return null;
}
break;
}
});})(map__20056,map__20056__$1,identity,parameters,params))
,null,null));
});})(map__20056,map__20056__$1,identity,parameters,params))
;
return iter__4324__auto__(parameters);
})());
} else {
if(cljs.core.truth_(identity)){
return (identity.cljs$core$IFn$_invoke$arity$1 ? identity.cljs$core$IFn$_invoke$arity$1(match) : identity.call(null,match));
} else {
if(cljs.core.truth_(params)){
return (params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(match) : params.call(null,match));
} else {
return null;

}
}
}
});
/**
 * Run side-effects (:start or :stop) for controller.
 *   The side-effect function is called with controller identity value.
 */
reitit.frontend.controllers.apply_controller = (function reitit$frontend$controllers$apply_controller(controller,method){
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(controller,method);
if(cljs.core.truth_(temp__5735__auto__)){
var f = temp__5735__auto__;
var G__20069 = cljs.core.cst$kw$reitit$frontend$controllers_SLASH_identity.cljs$core$IFn$_invoke$arity$1(controller);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__20069) : f.call(null,G__20069));
} else {
return null;
}
});
/**
 * Applies changes between current controllers and
 *   those previously enabled. Reinitializes controllers whose
 *   identity has changed.
 */
reitit.frontend.controllers.apply_controllers = (function reitit$frontend$controllers$apply_controllers(old_controllers,new_match){
var new_controllers = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (controller){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(controller,cljs.core.cst$kw$reitit$frontend$controllers_SLASH_identity,reitit.frontend.controllers.get_identity(controller,new_match));
}),cljs.core.cst$kw$controllers.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(new_match)));
var changed_controllers = cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (new_controllers){
return (function (old,new$){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old,new$)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old,cljs.core.cst$kw$new,new$], null);
} else {
return null;
}
});})(new_controllers))
,reitit.frontend.controllers.pad_same_length(old_controllers,new_controllers),reitit.frontend.controllers.pad_same_length(new_controllers,old_controllers))));
var seq__20070_20078 = cljs.core.seq(cljs.core.reverse(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$old,changed_controllers)));
var chunk__20071_20079 = null;
var count__20072_20080 = (0);
var i__20073_20081 = (0);
while(true){
if((i__20073_20081 < count__20072_20080)){
var controller_20082 = chunk__20071_20079.cljs$core$IIndexed$_nth$arity$2(null,i__20073_20081);
reitit.frontend.controllers.apply_controller(controller_20082,cljs.core.cst$kw$stop);


var G__20083 = seq__20070_20078;
var G__20084 = chunk__20071_20079;
var G__20085 = count__20072_20080;
var G__20086 = (i__20073_20081 + (1));
seq__20070_20078 = G__20083;
chunk__20071_20079 = G__20084;
count__20072_20080 = G__20085;
i__20073_20081 = G__20086;
continue;
} else {
var temp__5735__auto___20087 = cljs.core.seq(seq__20070_20078);
if(temp__5735__auto___20087){
var seq__20070_20088__$1 = temp__5735__auto___20087;
if(cljs.core.chunked_seq_QMARK_(seq__20070_20088__$1)){
var c__4351__auto___20089 = cljs.core.chunk_first(seq__20070_20088__$1);
var G__20090 = cljs.core.chunk_rest(seq__20070_20088__$1);
var G__20091 = c__4351__auto___20089;
var G__20092 = cljs.core.count(c__4351__auto___20089);
var G__20093 = (0);
seq__20070_20078 = G__20090;
chunk__20071_20079 = G__20091;
count__20072_20080 = G__20092;
i__20073_20081 = G__20093;
continue;
} else {
var controller_20094 = cljs.core.first(seq__20070_20088__$1);
reitit.frontend.controllers.apply_controller(controller_20094,cljs.core.cst$kw$stop);


var G__20095 = cljs.core.next(seq__20070_20088__$1);
var G__20096 = null;
var G__20097 = (0);
var G__20098 = (0);
seq__20070_20078 = G__20095;
chunk__20071_20079 = G__20096;
count__20072_20080 = G__20097;
i__20073_20081 = G__20098;
continue;
}
} else {
}
}
break;
}

var seq__20074_20099 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$new,changed_controllers));
var chunk__20075_20100 = null;
var count__20076_20101 = (0);
var i__20077_20102 = (0);
while(true){
if((i__20077_20102 < count__20076_20101)){
var controller_20103 = chunk__20075_20100.cljs$core$IIndexed$_nth$arity$2(null,i__20077_20102);
reitit.frontend.controllers.apply_controller(controller_20103,cljs.core.cst$kw$start);


var G__20104 = seq__20074_20099;
var G__20105 = chunk__20075_20100;
var G__20106 = count__20076_20101;
var G__20107 = (i__20077_20102 + (1));
seq__20074_20099 = G__20104;
chunk__20075_20100 = G__20105;
count__20076_20101 = G__20106;
i__20077_20102 = G__20107;
continue;
} else {
var temp__5735__auto___20108 = cljs.core.seq(seq__20074_20099);
if(temp__5735__auto___20108){
var seq__20074_20109__$1 = temp__5735__auto___20108;
if(cljs.core.chunked_seq_QMARK_(seq__20074_20109__$1)){
var c__4351__auto___20110 = cljs.core.chunk_first(seq__20074_20109__$1);
var G__20111 = cljs.core.chunk_rest(seq__20074_20109__$1);
var G__20112 = c__4351__auto___20110;
var G__20113 = cljs.core.count(c__4351__auto___20110);
var G__20114 = (0);
seq__20074_20099 = G__20111;
chunk__20075_20100 = G__20112;
count__20076_20101 = G__20113;
i__20077_20102 = G__20114;
continue;
} else {
var controller_20115 = cljs.core.first(seq__20074_20109__$1);
reitit.frontend.controllers.apply_controller(controller_20115,cljs.core.cst$kw$start);


var G__20116 = cljs.core.next(seq__20074_20109__$1);
var G__20117 = null;
var G__20118 = (0);
var G__20119 = (0);
seq__20074_20099 = G__20116;
chunk__20075_20100 = G__20117;
count__20076_20101 = G__20118;
i__20077_20102 = G__20119;
continue;
}
} else {
}
}
break;
}

return new_controllers;
});
