// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('spec_tools.visitor');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.spec.alpha');
goog.require('spec_tools.core');
goog.require('spec_tools.parse');
goog.require('spec_tools.impl');
goog.require('spec_tools.form');
spec_tools.visitor.spec_dispatch = (function spec_tools$visitor$spec_dispatch(spec,accept,options){
if(cljs.core.truth_((function (){var or__3949__auto__ = cljs.spec.alpha.spec_QMARK_(spec);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = cljs.spec.alpha.regex_QMARK_(spec);
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
return (spec instanceof cljs.core.Keyword);
}
}
})())){
var form = cljs.spec.alpha.form(spec);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$kw$cljs$spec$alpha_SLASH_unknown)){
if(cljs.core.seq_QMARK_(form)){
return spec_tools.impl.normalize_symbol(cljs.core.first(form));
} else {
return (spec_tools.visitor.spec_dispatch.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.spec_dispatch.cljs$core$IFn$_invoke$arity$3(form,accept,options) : spec_tools.visitor.spec_dispatch.call(null,form,accept,options));
}
} else {
return spec;
}
} else {
if(cljs.core.set_QMARK_(spec)){
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set;
} else {
if(cljs.core.seq_QMARK_(spec)){
return spec_tools.impl.normalize_symbol(cljs.core.first(spec_tools.impl.strip_fn_if_needed(spec)));
} else {
if((spec instanceof cljs.core.Symbol)){
return spec_tools.impl.normalize_symbol(spec);
} else {
return spec_tools.impl.normalize_symbol((spec_tools.form.resolve_form.cljs$core$IFn$_invoke$arity$1 ? spec_tools.form.resolve_form.cljs$core$IFn$_invoke$arity$1(spec) : spec_tools.form.resolve_form.call(null,spec)));

}
}
}
}
});
if((typeof spec_tools !== 'undefined') && (typeof spec_tools.visitor !== 'undefined') && (typeof spec_tools.visitor.visit_spec !== 'undefined')){
} else {
spec_tools.visitor.visit_spec = (function (){var method_table__4414__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4415__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4416__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4417__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4418__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$default,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default], null),cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("spec-tools.visitor","visit-spec"),spec_tools.visitor.spec_dispatch,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default,hierarchy__4418__auto__,method_table__4414__auto__,prefer_table__4415__auto__,method_cache__4416__auto__,cached_hierarchy__4417__auto__));
})();
}
/**
 * Walk a spec definition. Takes 2-3 arguments, the spec and the accept
 *   function, and optionally a options map, and returns the result of
 *   calling the accept function. Options map can be used to pass in context-
 *   specific information to to sub-visits & accepts.
 * 
 *   The accept function is called with 4 arguments: the dispatch term for the
 *   spec (see below), the spec itself, vector with the results of
 *   recursively walking the children of the spec and the options map.
 * 
 *   The dispatch term is one of the following
 *   * if the spec is a function call: a fully qualified symbol for the function
 *  with the following exceptions:
 *  - cljs.core symbols are converted to clojure.core symbols
 *  - cljs.spec.alpha symbols are converted to clojure.spec.alpha symbols
 *   * if the spec is a set: :spec-tools.visitor/set
 *   * otherwise: the spec itself
 */
spec_tools.visitor.visit = (function spec_tools$visitor$visit(var_args){
var G__19343 = arguments.length;
switch (G__19343) {
case 2:
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$2 = (function (spec,accept){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(spec,accept,null);
});

spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3 = (function (spec,accept,p__19344){
var map__19345 = p__19344;
var map__19345__$1 = ((((!((map__19345 == null)))?(((((map__19345.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19345.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19345):map__19345);
var options = map__19345__$1;
var visited = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19345__$1,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_visited);
if(cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(visited,spec))){
var options__$1 = (((spec instanceof cljs.core.Keyword))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(options,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_visited,cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),spec):options);
return (spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3(spec,accept,options__$1) : spec_tools.visitor.visit_spec.call(null,spec,accept,options__$1));
} else {
return (spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3(null,accept,options) : spec_tools.visitor.visit_spec.call(null,null,accept,options));
}
});

spec_tools.visitor.visit.cljs$lang$maxFixedArity = 3;

spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set,(function (spec,accept,options){
var G__19348 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set;
var G__19349 = spec;
var G__19350 = cljs.core.vec((((spec instanceof cljs.core.Keyword))?spec_tools.impl.extract_form(spec):spec));
var G__19351 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19348,G__19349,G__19350,G__19351) : accept.call(null,G__19348,G__19349,G__19350,G__19351));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys,(function (spec,accept,options){
var keys = spec_tools.impl.extract_keys(spec_tools.impl.extract_form(spec));
var G__19353 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys;
var G__19354 = spec;
var G__19355 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19353,G__19354,keys){
return (function (p1__19352_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19352_SHARP_,accept,options);
});})(G__19353,G__19354,keys))
,keys);
var G__19356 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19353,G__19354,G__19355,G__19356) : accept.call(null,G__19353,G__19354,G__19355,G__19356));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_or,(function (spec,accept,options){
var vec__19358 = spec_tools.impl.extract_form(spec);
var seq__19359 = cljs.core.seq(vec__19358);
var first__19360 = cljs.core.first(seq__19359);
var seq__19359__$1 = cljs.core.next(seq__19359);
var _ = first__19360;
var map__19361 = seq__19359__$1;
var map__19361__$1 = ((((!((map__19361 == null)))?(((((map__19361.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19361.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19361):map__19361);
var inner_spec_map = map__19361__$1;
var G__19363 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_or;
var G__19364 = spec;
var G__19365 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19363,G__19364,vec__19358,seq__19359,first__19360,seq__19359__$1,_,map__19361,map__19361__$1,inner_spec_map){
return (function (p1__19357_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19357_SHARP_,accept,options);
});})(G__19363,G__19364,vec__19358,seq__19359,first__19360,seq__19359__$1,_,map__19361,map__19361__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__19366 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19363,G__19364,G__19365,G__19366) : accept.call(null,G__19363,G__19364,G__19365,G__19366));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_and,(function (spec,accept,options){
var vec__19368 = spec_tools.impl.extract_form(spec);
var seq__19369 = cljs.core.seq(vec__19368);
var first__19370 = cljs.core.first(seq__19369);
var seq__19369__$1 = cljs.core.next(seq__19369);
var _ = first__19370;
var inner_specs = seq__19369__$1;
var G__19371 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_and;
var G__19372 = spec;
var G__19373 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19371,G__19372,vec__19368,seq__19369,first__19370,seq__19369__$1,_,inner_specs){
return (function (p1__19367_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19367_SHARP_,accept,options);
});})(G__19371,G__19372,vec__19368,seq__19369,first__19370,seq__19369__$1,_,inner_specs))
,inner_specs);
var G__19374 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19371,G__19372,G__19373,G__19374) : accept.call(null,G__19371,G__19372,G__19373,G__19374));
}));
spec_tools.visitor.visit_merge = (function spec_tools$visitor$visit_merge(spec,accept,options){
var vec__19376 = spec_tools.impl.extract_form(spec);
var seq__19377 = cljs.core.seq(vec__19376);
var first__19378 = cljs.core.first(seq__19377);
var seq__19377__$1 = cljs.core.next(seq__19377);
var _ = first__19378;
var inner_specs = seq__19377__$1;
var G__19379 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_merge;
var G__19380 = spec;
var G__19381 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19379,G__19380,vec__19376,seq__19377,first__19378,seq__19377__$1,_,inner_specs){
return (function (p1__19375_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19375_SHARP_,accept,options);
});})(G__19379,G__19380,vec__19376,seq__19377,first__19378,seq__19377__$1,_,inner_specs))
,inner_specs);
var G__19382 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19379,G__19380,G__19381,G__19382) : accept.call(null,G__19379,G__19380,G__19381,G__19382));
});
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_merge,(function (spec,accept,options){
return spec_tools.visitor.visit_merge(spec,accept,options);
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$spec_DASH_tools$core_SLASH_merge,(function (spec,accept,options){
return spec_tools.visitor.visit_merge(spec,accept,options);
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_every,(function (spec,accept,options){
var vec__19383 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19383,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19383,(1),null);
var G__19386 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_every;
var G__19387 = spec;
var G__19388 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19389 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19386,G__19387,G__19388,G__19389) : accept.call(null,G__19386,G__19387,G__19388,G__19389));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_every_DASH_kv,(function (spec,accept,options){
var vec__19391 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19391,(0),null);
var inner_spec1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19391,(1),null);
var inner_spec2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19391,(2),null);
var G__19394 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_every_DASH_kv;
var G__19395 = spec;
var G__19396 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19394,G__19395,vec__19391,_,inner_spec1,inner_spec2){
return (function (p1__19390_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19390_SHARP_,accept,options);
});})(G__19394,G__19395,vec__19391,_,inner_spec1,inner_spec2))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [inner_spec1,inner_spec2], null));
var G__19397 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19394,G__19395,G__19396,G__19397) : accept.call(null,G__19394,G__19395,G__19396,G__19397));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_coll_DASH_of,(function (spec,accept,options){
var form = spec_tools.impl.extract_form(spec);
var pred = cljs.core.second(form);
var map__19398 = spec_tools.parse.parse_spec(form);
var map__19398__$1 = ((((!((map__19398 == null)))?(((((map__19398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19398.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19398):map__19398);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19398__$1,cljs.core.cst$kw$type);
var dispatch = (function (){var G__19400 = type;
var G__19400__$1 = (((G__19400 instanceof cljs.core.Keyword))?G__19400.fqn:null);
switch (G__19400__$1) {
case "map-of":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_map_DASH_of;

break;
case "set":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set_DASH_of;

break;
case "vector":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_vector_DASH_of;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19400__$1)].join('')));

}
})();
var G__19401 = dispatch;
var G__19402 = spec;
var G__19403 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(pred,accept,options)], null);
var G__19404 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19401,G__19402,G__19403,G__19404) : accept.call(null,G__19401,G__19402,G__19403,G__19404));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_map_DASH_of,(function (spec,accept,options){
var vec__19407 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19407,(0),null);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19407,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19407,(2),null);
var G__19410 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_map_DASH_of;
var G__19411 = spec;
var G__19412 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19410,G__19411,vec__19407,_,k,v){
return (function (p1__19406_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19406_SHARP_,accept,options);
});})(G__19410,G__19411,vec__19407,_,k,v))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
var G__19413 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19410,G__19411,G__19412,G__19413) : accept.call(null,G__19410,G__19411,G__19412,G__19413));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__STAR_,(function (spec,accept,options){
var vec__19414 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19414,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19414,(1),null);
var G__19417 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__STAR_;
var G__19418 = spec;
var G__19419 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19420 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19417,G__19418,G__19419,G__19420) : accept.call(null,G__19417,G__19418,G__19419,G__19420));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__PLUS_,(function (spec,accept,options){
var vec__19421 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19421,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19421,(1),null);
var G__19424 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__PLUS_;
var G__19425 = spec;
var G__19426 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19427 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19424,G__19425,G__19426,G__19427) : accept.call(null,G__19424,G__19425,G__19426,G__19427));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__QMARK_,(function (spec,accept,options){
var vec__19428 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19428,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19428,(1),null);
var G__19431 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__QMARK_;
var G__19432 = spec;
var G__19433 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19434 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19431,G__19432,G__19433,G__19434) : accept.call(null,G__19431,G__19432,G__19433,G__19434));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_alt,(function (spec,accept,options){
var vec__19436 = spec_tools.impl.extract_form(spec);
var seq__19437 = cljs.core.seq(vec__19436);
var first__19438 = cljs.core.first(seq__19437);
var seq__19437__$1 = cljs.core.next(seq__19437);
var _ = first__19438;
var map__19439 = seq__19437__$1;
var map__19439__$1 = ((((!((map__19439 == null)))?(((((map__19439.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19439.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19439):map__19439);
var inner_spec_map = map__19439__$1;
var G__19441 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_alt;
var G__19442 = spec;
var G__19443 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19441,G__19442,vec__19436,seq__19437,first__19438,seq__19437__$1,_,map__19439,map__19439__$1,inner_spec_map){
return (function (p1__19435_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19435_SHARP_,accept,options);
});})(G__19441,G__19442,vec__19436,seq__19437,first__19438,seq__19437__$1,_,map__19439,map__19439__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__19444 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19441,G__19442,G__19443,G__19444) : accept.call(null,G__19441,G__19442,G__19443,G__19444));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_cat,(function (spec,accept,options){
var vec__19446 = spec_tools.impl.extract_form(spec);
var seq__19447 = cljs.core.seq(vec__19446);
var first__19448 = cljs.core.first(seq__19447);
var seq__19447__$1 = cljs.core.next(seq__19447);
var _ = first__19448;
var map__19449 = seq__19447__$1;
var map__19449__$1 = ((((!((map__19449 == null)))?(((((map__19449.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19449.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19449):map__19449);
var inner_spec_map = map__19449__$1;
var G__19451 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_cat;
var G__19452 = spec;
var G__19453 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19451,G__19452,vec__19446,seq__19447,first__19448,seq__19447__$1,_,map__19449,map__19449__$1,inner_spec_map){
return (function (p1__19445_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19445_SHARP_,accept,options);
});})(G__19451,G__19452,vec__19446,seq__19447,first__19448,seq__19447__$1,_,map__19449,map__19449__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__19454 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19451,G__19452,G__19453,G__19454) : accept.call(null,G__19451,G__19452,G__19453,G__19454));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__AMPERSAND_,(function (spec,accept,options){
var vec__19455 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19455,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19455,(1),null);
var G__19458 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__AMPERSAND_;
var G__19459 = spec;
var G__19460 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19461 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19458,G__19459,G__19460,G__19461) : accept.call(null,G__19458,G__19459,G__19460,G__19461));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_tuple,(function (spec,accept,options){
var vec__19463 = spec_tools.impl.extract_form(spec);
var seq__19464 = cljs.core.seq(vec__19463);
var first__19465 = cljs.core.first(seq__19464);
var seq__19464__$1 = cljs.core.next(seq__19464);
var _ = first__19465;
var inner_specs = seq__19464__$1;
var G__19466 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_tuple;
var G__19467 = spec;
var G__19468 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19466,G__19467,vec__19463,seq__19464,first__19465,seq__19464__$1,_,inner_specs){
return (function (p1__19462_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19462_SHARP_,accept,options);
});})(G__19466,G__19467,vec__19463,seq__19464,first__19465,seq__19464__$1,_,inner_specs))
,inner_specs);
var G__19469 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19466,G__19467,G__19468,G__19469) : accept.call(null,G__19466,G__19467,G__19468,G__19469));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys_STAR_,(function (spec,accept,options){
var keys = spec_tools.impl.extract_keys(spec_tools.impl.extract_form(spec));
var G__19471 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys_STAR_;
var G__19472 = spec;
var G__19473 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19471,G__19472,keys){
return (function (p1__19470_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19470_SHARP_,accept,options);
});})(G__19471,G__19472,keys))
,keys);
var G__19474 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19471,G__19472,G__19473,G__19474) : accept.call(null,G__19471,G__19472,G__19473,G__19474));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_nilable,(function (spec,accept,options){
var vec__19475 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19475,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19475,(1),null);
var G__19478 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_nilable;
var G__19479 = spec;
var G__19480 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19481 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19478,G__19479,G__19480,G__19481) : accept.call(null,G__19478,G__19479,G__19480,G__19481));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$spec_DASH_tools$core_SLASH_spec,(function (spec,accept,options){
var vec__19482 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19482,(0),null);
var map__19485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19482,(1),null);
var map__19485__$1 = ((((!((map__19485 == null)))?(((((map__19485.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19485.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19485):map__19485);
var inner_spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19485__$1,cljs.core.cst$kw$spec);
var G__19487 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_spec;
var G__19488 = spec;
var G__19489 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19490 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19487,G__19488,G__19489,G__19490) : accept.call(null,G__19487,G__19488,G__19489,G__19490));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default,(function (spec,accept,options){
var G__19491 = spec_tools.visitor.spec_dispatch(spec,accept,options);
var G__19492 = spec;
var G__19493 = null;
var G__19494 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19491,G__19492,G__19493,G__19494) : accept.call(null,G__19491,G__19492,G__19493,G__19494));
}));
/**
 * a visitor that collects all registered specs. Returns
 *   a map of spec-name => spec.
 */
spec_tools.visitor.spec_collector = (function spec_tools$visitor$spec_collector(){
var specs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (specs){
return (function (_,spec,___$1,___$2){
var temp__5733__auto__ = cljs.spec.alpha.get_spec(spec);
if(cljs.core.truth_(temp__5733__auto__)){
var s = temp__5733__auto__;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(specs,cljs.core.assoc,spec,s);
} else {
return cljs.core.deref(specs);
}
});
;})(specs))
});
