// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('reitit.frontend.controllers');
goog.require('cljs.core');
goog.require('cljs.core.constants');
reitit.frontend.controllers.pad_same_length = (function reitit$frontend$controllers$pad_same_length(a,b){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a,cljs.core.take.cljs$core$IFn$_invoke$arity$2((cljs.core.count(b) - cljs.core.count(a)),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)));
});
reitit.frontend.controllers.params_warning = (new cljs.core.Delay((function (){
return console.warn("Reitit-frontend controller :params is deprecated. Replace with :identity or :parameters option.");
}),null));
/**
 * Get controller identity given controller and match.
 * 
 *   To select interesting properties from Match :parameters option can be set.
 *   Value should be param-type => [param-key]
 *   Resulting value is map of param-type => param-key => value.
 * 
 *   For other uses, :identity option can be used to provide function from
 *   Match to identity.
 * 
 *   Default value is nil, i.e. controller identity doesn't depend on Match.
 */
reitit.frontend.controllers.get_identity = (function reitit$frontend$controllers$get_identity(p__21305,match){
var map__21306 = p__21305;
var map__21306__$1 = ((((!((map__21306 == null)))?(((((map__21306.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21306.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21306):map__21306);
var identity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21306__$1,cljs.core.cst$kw$identity);
var parameters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21306__$1,cljs.core.cst$kw$parameters);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21306__$1,cljs.core.cst$kw$params);
if(cljs.core.not((function (){var and__3938__auto__ = identity;
if(cljs.core.truth_(and__3938__auto__)){
return parameters;
} else {
return and__3938__auto__;
}
})())){
} else {
throw (new Error(["Assert failed: ","Use either :identity or :parameters for controller, not both.","\n","(not (and identity parameters))"].join('')));
}

if(cljs.core.truth_(params)){
cljs.core.deref(reitit.frontend.controllers.params_warning);
} else {
}

if(cljs.core.truth_(parameters)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4324__auto__ = ((function (map__21306,map__21306__$1,identity,parameters,params){
return (function reitit$frontend$controllers$get_identity_$_iter__21308(s__21309){
return (new cljs.core.LazySeq(null,((function (map__21306,map__21306__$1,identity,parameters,params){
return (function (){
var s__21309__$1 = s__21309;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__21309__$1);
if(temp__5735__auto__){
var s__21309__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__21309__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__21309__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__21311 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__21310 = (0);
while(true){
if((i__21310 < size__4323__auto__)){
var vec__21312 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__21310);
var param_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21312,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21312,(1),null);
cljs.core.chunk_append(b__21311,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_type,cljs.core.select_keys(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$parameters.cljs$core$IFn$_invoke$arity$1(match),param_type),ks)], null));

var G__21318 = (i__21310 + (1));
i__21310 = G__21318;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__21311),reitit$frontend$controllers$get_identity_$_iter__21308(cljs.core.chunk_rest(s__21309__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__21311),null);
}
} else {
var vec__21315 = cljs.core.first(s__21309__$2);
var param_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21315,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21315,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_type,cljs.core.select_keys(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$parameters.cljs$core$IFn$_invoke$arity$1(match),param_type),ks)], null),reitit$frontend$controllers$get_identity_$_iter__21308(cljs.core.rest(s__21309__$2)));
}
} else {
return null;
}
break;
}
});})(map__21306,map__21306__$1,identity,parameters,params))
,null,null));
});})(map__21306,map__21306__$1,identity,parameters,params))
;
return iter__4324__auto__(parameters);
})());
} else {
if(cljs.core.truth_(identity)){
return (identity.cljs$core$IFn$_invoke$arity$1 ? identity.cljs$core$IFn$_invoke$arity$1(match) : identity.call(null,match));
} else {
if(cljs.core.truth_(params)){
return (params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(match) : params.call(null,match));
} else {
return null;

}
}
}
});
/**
 * Run side-effects (:start or :stop) for controller.
 *   The side-effect function is called with controller identity value.
 */
reitit.frontend.controllers.apply_controller = (function reitit$frontend$controllers$apply_controller(controller,method){
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(controller,method);
if(cljs.core.truth_(temp__5735__auto__)){
var f = temp__5735__auto__;
var G__21319 = cljs.core.cst$kw$reitit$frontend$controllers_SLASH_identity.cljs$core$IFn$_invoke$arity$1(controller);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__21319) : f.call(null,G__21319));
} else {
return null;
}
});
/**
 * Applies changes between current controllers and
 *   those previously enabled. Reinitializes controllers whose
 *   identity has changed.
 */
reitit.frontend.controllers.apply_controllers = (function reitit$frontend$controllers$apply_controllers(old_controllers,new_match){
var new_controllers = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (controller){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(controller,cljs.core.cst$kw$reitit$frontend$controllers_SLASH_identity,reitit.frontend.controllers.get_identity(controller,new_match));
}),cljs.core.cst$kw$controllers.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(new_match)));
var changed_controllers = cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (new_controllers){
return (function (old,new$){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old,new$)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old,cljs.core.cst$kw$new,new$], null);
} else {
return null;
}
});})(new_controllers))
,reitit.frontend.controllers.pad_same_length(old_controllers,new_controllers),reitit.frontend.controllers.pad_same_length(new_controllers,old_controllers))));
var seq__21320_21328 = cljs.core.seq(cljs.core.reverse(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$old,changed_controllers)));
var chunk__21321_21329 = null;
var count__21322_21330 = (0);
var i__21323_21331 = (0);
while(true){
if((i__21323_21331 < count__21322_21330)){
var controller_21332 = chunk__21321_21329.cljs$core$IIndexed$_nth$arity$2(null,i__21323_21331);
reitit.frontend.controllers.apply_controller(controller_21332,cljs.core.cst$kw$stop);


var G__21333 = seq__21320_21328;
var G__21334 = chunk__21321_21329;
var G__21335 = count__21322_21330;
var G__21336 = (i__21323_21331 + (1));
seq__21320_21328 = G__21333;
chunk__21321_21329 = G__21334;
count__21322_21330 = G__21335;
i__21323_21331 = G__21336;
continue;
} else {
var temp__5735__auto___21337 = cljs.core.seq(seq__21320_21328);
if(temp__5735__auto___21337){
var seq__21320_21338__$1 = temp__5735__auto___21337;
if(cljs.core.chunked_seq_QMARK_(seq__21320_21338__$1)){
var c__4351__auto___21339 = cljs.core.chunk_first(seq__21320_21338__$1);
var G__21340 = cljs.core.chunk_rest(seq__21320_21338__$1);
var G__21341 = c__4351__auto___21339;
var G__21342 = cljs.core.count(c__4351__auto___21339);
var G__21343 = (0);
seq__21320_21328 = G__21340;
chunk__21321_21329 = G__21341;
count__21322_21330 = G__21342;
i__21323_21331 = G__21343;
continue;
} else {
var controller_21344 = cljs.core.first(seq__21320_21338__$1);
reitit.frontend.controllers.apply_controller(controller_21344,cljs.core.cst$kw$stop);


var G__21345 = cljs.core.next(seq__21320_21338__$1);
var G__21346 = null;
var G__21347 = (0);
var G__21348 = (0);
seq__21320_21328 = G__21345;
chunk__21321_21329 = G__21346;
count__21322_21330 = G__21347;
i__21323_21331 = G__21348;
continue;
}
} else {
}
}
break;
}

var seq__21324_21349 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$new,changed_controllers));
var chunk__21325_21350 = null;
var count__21326_21351 = (0);
var i__21327_21352 = (0);
while(true){
if((i__21327_21352 < count__21326_21351)){
var controller_21353 = chunk__21325_21350.cljs$core$IIndexed$_nth$arity$2(null,i__21327_21352);
reitit.frontend.controllers.apply_controller(controller_21353,cljs.core.cst$kw$start);


var G__21354 = seq__21324_21349;
var G__21355 = chunk__21325_21350;
var G__21356 = count__21326_21351;
var G__21357 = (i__21327_21352 + (1));
seq__21324_21349 = G__21354;
chunk__21325_21350 = G__21355;
count__21326_21351 = G__21356;
i__21327_21352 = G__21357;
continue;
} else {
var temp__5735__auto___21358 = cljs.core.seq(seq__21324_21349);
if(temp__5735__auto___21358){
var seq__21324_21359__$1 = temp__5735__auto___21358;
if(cljs.core.chunked_seq_QMARK_(seq__21324_21359__$1)){
var c__4351__auto___21360 = cljs.core.chunk_first(seq__21324_21359__$1);
var G__21361 = cljs.core.chunk_rest(seq__21324_21359__$1);
var G__21362 = c__4351__auto___21360;
var G__21363 = cljs.core.count(c__4351__auto___21360);
var G__21364 = (0);
seq__21324_21349 = G__21361;
chunk__21325_21350 = G__21362;
count__21326_21351 = G__21363;
i__21327_21352 = G__21364;
continue;
} else {
var controller_21365 = cljs.core.first(seq__21324_21359__$1);
reitit.frontend.controllers.apply_controller(controller_21365,cljs.core.cst$kw$start);


var G__21366 = cljs.core.next(seq__21324_21359__$1);
var G__21367 = null;
var G__21368 = (0);
var G__21369 = (0);
seq__21324_21349 = G__21366;
chunk__21325_21350 = G__21367;
count__21326_21351 = G__21368;
i__21327_21352 = G__21369;
continue;
}
} else {
}
}
break;
}

return new_controllers;
});
