// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('fork.logic');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.core');
fork.logic.element_value = (function fork$logic$element_value(evt){
var type = evt.target.type;
var G__33471 = type;
switch (G__33471) {
case "checkbox":
return evt.target.checked;

break;
default:
return evt.target.value;

}
});
fork.logic.set_values = (function fork$logic$set_values(new_values,state){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p1__33473_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__33473_SHARP_,cljs.core.cst$kw$values,cljs.core.merge,new_values),cljs.core.cst$kw$touched,(function (x,y){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,x,y);
}),cljs.core.keys(new_values));
}));
});
fork.logic.set_touched = (function fork$logic$set_touched(names,state){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(state,cljs.core.update,cljs.core.cst$kw$touched,(function (x,y){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,x,y);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([names], 0));
});
fork.logic.set_untouched = (function fork$logic$set_untouched(names,state){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(state,cljs.core.update,cljs.core.cst$kw$touched,(function (x,y){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.disj,x,y);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([names], 0));
});
fork.logic.disable_logic = (function fork$logic$disable_logic(current_set,ks){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,(function (){var fexpr__33474 = cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.into,cljs.core.PersistentHashSet.EMPTY);
return (fexpr__33474.cljs$core$IFn$_invoke$arity$1 ? fexpr__33474.cljs$core$IFn$_invoke$arity$1(current_set) : fexpr__33474.call(null,current_set));
})(),ks);
});
fork.logic.enable_logic = (function fork$logic$enable_logic(current_set,ks){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.disj,current_set,ks);
});
fork.logic.local_disable = (function fork$logic$local_disable(var_args){
var args__4534__auto__ = [];
var len__4531__auto___33482 = arguments.length;
var i__4532__auto___33483 = (0);
while(true){
if((i__4532__auto___33483 < len__4531__auto___33482)){
args__4534__auto__.push((arguments[i__4532__auto___33483]));

var G__33484 = (i__4532__auto___33483 + (1));
i__4532__auto___33483 = G__33484;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return fork.logic.local_disable.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

fork.logic.local_disable.cljs$core$IFn$_invoke$arity$variadic = (function (state,p__33478){
var vec__33479 = p__33478;
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33479,(0),null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$disabled_QMARK_,((function (vec__33479,ks){
return (function (p1__33475_SHARP_){
return fork.logic.disable_logic(p1__33475_SHARP_,ks);
});})(vec__33479,ks))
);
});

fork.logic.local_disable.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fork.logic.local_disable.cljs$lang$applyTo = (function (seq33476){
var G__33477 = cljs.core.first(seq33476);
var seq33476__$1 = cljs.core.next(seq33476);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33477,seq33476__$1);
});

fork.logic.local_enable = (function fork$logic$local_enable(var_args){
var args__4534__auto__ = [];
var len__4531__auto___33492 = arguments.length;
var i__4532__auto___33493 = (0);
while(true){
if((i__4532__auto___33493 < len__4531__auto___33492)){
args__4534__auto__.push((arguments[i__4532__auto___33493]));

var G__33494 = (i__4532__auto___33493 + (1));
i__4532__auto___33493 = G__33494;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return fork.logic.local_enable.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

fork.logic.local_enable.cljs$core$IFn$_invoke$arity$variadic = (function (state,p__33488){
var vec__33489 = p__33488;
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33489,(0),null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$disabled_QMARK_,((function (vec__33489,ks){
return (function (p1__33485_SHARP_){
return fork.logic.enable_logic(p1__33485_SHARP_,ks);
});})(vec__33489,ks))
);
});

fork.logic.local_enable.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fork.logic.local_enable.cljs$lang$applyTo = (function (seq33486){
var G__33487 = cljs.core.first(seq33486);
var seq33486__$1 = cljs.core.next(seq33486);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33487,seq33486__$1);
});

fork.logic.disabled_QMARK_ = (function fork$logic$disabled_QMARK_(state,k){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$disabled_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)),k);
});
fork.logic.handle_validation = (function fork$logic$handle_validation(state,validation){
var values = cljs.core.cst$kw$values.cljs$core$IFn$_invoke$arity$1(state);
var resolved = (validation.cljs$core$IFn$_invoke$arity$1 ? validation.cljs$core$IFn$_invoke$arity$1(values) : validation.call(null,values));
if(cljs.core.every_QMARK_(cljs.core.empty_QMARK_,resolved)){
return null;
} else {
return resolved;
}
});
fork.logic.handle_change = (function fork$logic$handle_change(evt,state){
var input_key = evt.target.getAttribute("name");
var input_value = fork.logic.element_value(evt);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(state,cljs.core.update,cljs.core.cst$kw$values,cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([input_key,input_value], 0));
});
fork.logic.handle_blur = (function fork$logic$handle_blur(evt,state){
var input_key = evt.target.name;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(state,cljs.core.update,cljs.core.cst$kw$touched,cljs.core.conj,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([input_key], 0));
});
fork.logic.on_submit_state_updates = (function fork$logic$on_submit_state_updates(state,form_id){
var input_names = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__33495_SHARP_){
return p1__33495_SHARP_.getAttribute("name");
}),cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.getElementById(form_id).elements)));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (input_names){
return (function (p1__33496_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__33496_SHARP_,cljs.core.cst$kw$touched,((function (input_names){
return (function (x,y){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,x,y);
});})(input_names))
,input_names),cljs.core.cst$kw$submit_DASH_count,cljs.core.inc);
});})(input_names))
);
});
fork.logic.dirty_QMARK_ = (function fork$logic$dirty_QMARK_(values,initial_values){
if(((cljs.core.seq(values)) && (cljs.core.seq(initial_values)))){
return cljs.core.every_QMARK_(cljs.core.false_QMARK_,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p__33497){
var vec__33498 = p__33497;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33498,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33498,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,(function (){var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(initial_values,k);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})());
}),values));
} else {
if(cljs.core.seq(values)){
return !((cljs.core.some(cljs.core.not_empty,cljs.core.vals(values)) == null));
} else {
if(((cljs.core.empty_QMARK_(values)) && (cljs.core.empty_QMARK_(initial_values)))){
return false;
} else {
return true;

}
}
}
});
fork.logic.handle_submit = (function fork$logic$handle_submit(evt,p__33502){
var map__33503 = p__33502;
var map__33503__$1 = ((((!((map__33503 == null)))?(((((map__33503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33503.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33503):map__33503);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33503__$1,cljs.core.cst$kw$state);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33503__$1,cljs.core.cst$kw$db);
var on_submit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33503__$1,cljs.core.cst$kw$on_DASH_submit);
var prevent_default_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33503__$1,cljs.core.cst$kw$prevent_DASH_default_QMARK_);
var initial_values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33503__$1,cljs.core.cst$kw$initial_DASH_values);
var touched_values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33503__$1,cljs.core.cst$kw$touched_DASH_values);
var validation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33503__$1,cljs.core.cst$kw$validation);
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33503__$1,cljs.core.cst$kw$form_DASH_id);
if(cljs.core.truth_(prevent_default_QMARK_)){
evt.preventDefault();
} else {
}

fork.logic.on_submit_state_updates(state,form_id);

if((((validation == null)) && (cljs.core.every_QMARK_(((function (map__33503,map__33503__$1,state,db,on_submit,prevent_default_QMARK_,initial_values,touched_values,validation,form_id){
return (function (p1__33501_SHARP_){
return cljs.core.cst$kw$waiting_QMARK_.cljs$core$IFn$_invoke$arity$1(p1__33501_SHARP_) === false;
});})(map__33503,map__33503__$1,state,db,on_submit,prevent_default_QMARK_,initial_values,touched_values,validation,form_id))
,cljs.core.vals(cljs.core.cst$kw$server.cljs$core$IFn$_invoke$arity$1(db)))))){
var G__33505 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$values,cljs.core.cst$kw$values.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)),cljs.core.cst$kw$dirty_QMARK_,fork.logic.dirty_QMARK_(cljs.core.cst$kw$values.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([initial_values,touched_values], 0)))], null);
return (on_submit.cljs$core$IFn$_invoke$arity$1 ? on_submit.cljs$core$IFn$_invoke$arity$1(G__33505) : on_submit.call(null,G__33505));
} else {
return null;
}
});
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fork$logic_SLASH_server_DASH_set_DASH_waiting,(function (db,p__33506){
var vec__33507 = p__33506;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33507,(0),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33507,(1),null);
var input_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33507,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [path,cljs.core.cst$kw$server,input_key,cljs.core.cst$kw$waiting_QMARK_], null),true);
}));
fork.logic.send_server_request = (function fork$logic$send_server_request(evt,http_fn,p__33510){
var map__33511 = p__33510;
var map__33511__$1 = ((((!((map__33511 == null)))?(((((map__33511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33511):map__33511);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33511__$1,cljs.core.cst$kw$state);
var path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33511__$1,cljs.core.cst$kw$path);
var debounce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33511__$1,cljs.core.cst$kw$debounce);
var throttle = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33511__$1,cljs.core.cst$kw$throttle);
var input_key = evt.target.getAttribute("name");
var input_value = fork.logic.element_value(evt);
var new_values = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$values.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)),cljs.core.PersistentArrayMap.createAsIfByAssoc([input_key,input_value])], 0));
var G__33513_33514 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fork$logic_SLASH_server_DASH_set_DASH_waiting,path,input_key], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33513_33514) : re_frame.core.dispatch.call(null,G__33513_33514));

if(cljs.core.truth_(debounce)){
clearTimeout(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$debounce,input_key], null)));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$debounce,input_key], null),((function (input_key,input_value,new_values,map__33511,map__33511__$1,state,path,debounce,throttle){
return (function (){
return setTimeout(((function (input_key,input_value,new_values,map__33511,map__33511__$1,state,path,debounce,throttle){
return (function (){
return (http_fn.cljs$core$IFn$_invoke$arity$1 ? http_fn.cljs$core$IFn$_invoke$arity$1(new_values) : http_fn.call(null,new_values));
});})(input_key,input_value,new_values,map__33511,map__33511__$1,state,path,debounce,throttle))
,debounce);
});})(input_key,input_value,new_values,map__33511,map__33511__$1,state,path,debounce,throttle))
);
} else {
if(cljs.core.truth_(throttle)){
if(cljs.core.not(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$throttle,input_key], null)))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$throttle,input_key], null),((function (input_key,input_value,new_values,map__33511,map__33511__$1,state,path,debounce,throttle){
return (function (){
return setTimeout(((function (input_key,input_value,new_values,map__33511,map__33511__$1,state,path,debounce,throttle){
return (function (){
(http_fn.cljs$core$IFn$_invoke$arity$1 ? http_fn.cljs$core$IFn$_invoke$arity$1(new_values) : http_fn.call(null,new_values));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(state,cljs.core.update,cljs.core.cst$kw$throttle,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([input_key], 0));
});})(input_key,input_value,new_values,map__33511,map__33511__$1,state,path,debounce,throttle))
,throttle);
});})(input_key,input_value,new_values,map__33511,map__33511__$1,state,path,debounce,throttle))
);
} else {
return null;
}
} else {
return (http_fn.cljs$core$IFn$_invoke$arity$1 ? http_fn.cljs$core$IFn$_invoke$arity$1(new_values) : http_fn.call(null,new_values));

}
}
});
/**
 * Set global variables in reframe db when submitting.
 */
fork.logic.on_submit = (function fork$logic$on_submit(path){
var G__33516 = cljs.core.cst$kw$id;
var G__33517 = cljs.core.cst$kw$on_DASH_submit;
var G__33518 = cljs.core.cst$kw$before;
var G__33519 = ((function (G__33516,G__33517,G__33518){
return (function (context){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(context,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coeffects,cljs.core.cst$kw$db], null),((function (G__33516,G__33517,G__33518){
return (function (p1__33515_SHARP_){
return cljs.core.assoc_in(p1__33515_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [path,cljs.core.cst$kw$submitting_QMARK_], null),true);
});})(G__33516,G__33517,G__33518))
);
});})(G__33516,G__33517,G__33518))
;
return (re_frame.core.__GT_interceptor.cljs$core$IFn$_invoke$arity$4 ? re_frame.core.__GT_interceptor.cljs$core$IFn$_invoke$arity$4(G__33516,G__33517,G__33518,G__33519) : re_frame.core.__GT_interceptor.call(null,G__33516,G__33517,G__33518,G__33519));
});
/**
 * Clean form state or a list of specified keys from reframe db.
 */
fork.logic.clean = (function fork$logic$clean(var_args){
var args__4534__auto__ = [];
var len__4531__auto___33530 = arguments.length;
var i__4532__auto___33531 = (0);
while(true){
if((i__4532__auto___33531 < len__4531__auto___33530)){
args__4534__auto__.push((arguments[i__4532__auto___33531]));

var G__33532 = (i__4532__auto___33531 + (1));
i__4532__auto___33531 = G__33532;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return fork.logic.clean.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

fork.logic.clean.cljs$core$IFn$_invoke$arity$variadic = (function (path,p__33522){
var vec__33523 = p__33522;
var sub_path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33523,(0),null);
var G__33526 = cljs.core.cst$kw$id;
var G__33527 = cljs.core.cst$kw$clean;
var G__33528 = cljs.core.cst$kw$after;
var G__33529 = ((function (G__33526,G__33527,G__33528,vec__33523,sub_path){
return (function (context){
if(cljs.core.truth_(sub_path)){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(context,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$effects,cljs.core.cst$kw$db,path], null),cljs.core.butlast(sub_path)),cljs.core.dissoc,cljs.core.last(sub_path));
} else {
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(context,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$effects,cljs.core.cst$kw$db], null),cljs.core.dissoc,path);
}
});})(G__33526,G__33527,G__33528,vec__33523,sub_path))
;
return (re_frame.core.__GT_interceptor.cljs$core$IFn$_invoke$arity$4 ? re_frame.core.__GT_interceptor.cljs$core$IFn$_invoke$arity$4(G__33526,G__33527,G__33528,G__33529) : re_frame.core.__GT_interceptor.call(null,G__33526,G__33527,G__33528,G__33529));
});

fork.logic.clean.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fork.logic.clean.cljs$lang$applyTo = (function (seq33520){
var G__33521 = cljs.core.first(seq33520);
var seq33520__$1 = cljs.core.next(seq33520);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33521,seq33520__$1);
});

var G__33533_33539 = cljs.core.cst$kw$fork$logic_SLASH_db;
var G__33534_33540 = ((function (G__33533_33539){
return (function (db,p__33535){
var vec__33536 = p__33535;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33536,(0),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33536,(1),null);
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,path);
});})(G__33533_33539))
;
(re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2(G__33533_33539,G__33534_33540) : re_frame.core.reg_sub.call(null,G__33533_33539,G__33534_33540));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fork$logic_SLASH_clean,(function (db,p__33541){
var vec__33542 = p__33541;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33542,(0),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33542,(1),null);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(db,path);
}));
fork.logic.set_submitting = (function fork$logic$set_submitting(db,path,bool){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [path,cljs.core.cst$kw$submitting_QMARK_], null),bool);
});
fork.logic.set_waiting = (function fork$logic$set_waiting(db,path,input_name,bool){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [path,cljs.core.cst$kw$server,input_name,cljs.core.cst$kw$waiting_QMARK_], null),bool);
});
fork.logic.set_status_code = (function fork$logic$set_status_code(db,path,status_code){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [path,cljs.core.cst$kw$status_DASH_code], null),status_code);
});
