// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__21876){
var map__21877 = p__21876;
var map__21877__$1 = ((((!((map__21877 == null)))?(((((map__21877.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21877.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21877):map__21877);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21877__$1,cljs.core.cst$kw$operation);
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21877__$1,cljs.core.cst$kw$op_DASH_type);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21877__$1,cljs.core.cst$kw$tags);
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21877__$1,cljs.core.cst$kw$child_DASH_of);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$id,re_frame.trace.next_id(),cljs.core.cst$kw$operation,operation,cljs.core.cst$kw$op_DASH_type,op_type,cljs.core.cst$kw$tags,tags,cljs.core.cst$kw$child_DASH_of,(function (){var or__3949__auto__ = child_of;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),cljs.core.cst$kw$start,re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__21879_21893 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__21880_21894 = null;
var count__21881_21895 = (0);
var i__21882_21896 = (0);
while(true){
if((i__21882_21896 < count__21881_21895)){
var vec__21883_21897 = chunk__21880_21894.cljs$core$IIndexed$_nth$arity$2(null,i__21882_21896);
var k_21898 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21883_21897,(0),null);
var cb_21899 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21883_21897,(1),null);
try{var G__21887_21900 = cljs.core.deref(re_frame.trace.traces);
(cb_21899.cljs$core$IFn$_invoke$arity$1 ? cb_21899.cljs$core$IFn$_invoke$arity$1(G__21887_21900) : cb_21899.call(null,G__21887_21900));
}catch (e21886){var e_21901 = e21886;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_21898,"while storing",cljs.core.deref(re_frame.trace.traces),e_21901], 0));
}

var G__21902 = seq__21879_21893;
var G__21903 = chunk__21880_21894;
var G__21904 = count__21881_21895;
var G__21905 = (i__21882_21896 + (1));
seq__21879_21893 = G__21902;
chunk__21880_21894 = G__21903;
count__21881_21895 = G__21904;
i__21882_21896 = G__21905;
continue;
} else {
var temp__5735__auto___21906 = cljs.core.seq(seq__21879_21893);
if(temp__5735__auto___21906){
var seq__21879_21907__$1 = temp__5735__auto___21906;
if(cljs.core.chunked_seq_QMARK_(seq__21879_21907__$1)){
var c__4351__auto___21908 = cljs.core.chunk_first(seq__21879_21907__$1);
var G__21909 = cljs.core.chunk_rest(seq__21879_21907__$1);
var G__21910 = c__4351__auto___21908;
var G__21911 = cljs.core.count(c__4351__auto___21908);
var G__21912 = (0);
seq__21879_21893 = G__21909;
chunk__21880_21894 = G__21910;
count__21881_21895 = G__21911;
i__21882_21896 = G__21912;
continue;
} else {
var vec__21888_21913 = cljs.core.first(seq__21879_21907__$1);
var k_21914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21888_21913,(0),null);
var cb_21915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21888_21913,(1),null);
try{var G__21892_21916 = cljs.core.deref(re_frame.trace.traces);
(cb_21915.cljs$core$IFn$_invoke$arity$1 ? cb_21915.cljs$core$IFn$_invoke$arity$1(G__21892_21916) : cb_21915.call(null,G__21892_21916));
}catch (e21891){var e_21917 = e21891;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_21914,"while storing",cljs.core.deref(re_frame.trace.traces),e_21917], 0));
}

var G__21918 = cljs.core.next(seq__21879_21907__$1);
var G__21919 = null;
var G__21920 = (0);
var G__21921 = (0);
seq__21879_21893 = G__21918;
chunk__21880_21894 = G__21919;
count__21881_21895 = G__21920;
i__21882_21896 = G__21921;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});
