// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('spec_tools.visitor');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.spec.alpha');
goog.require('spec_tools.core');
goog.require('spec_tools.parse');
goog.require('spec_tools.impl');
goog.require('spec_tools.form');
spec_tools.visitor.spec_dispatch = (function spec_tools$visitor$spec_dispatch(spec,accept,options){
if(cljs.core.truth_((function (){var or__3949__auto__ = cljs.spec.alpha.spec_QMARK_(spec);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = cljs.spec.alpha.regex_QMARK_(spec);
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
return (spec instanceof cljs.core.Keyword);
}
}
})())){
var form = cljs.spec.alpha.form(spec);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$kw$cljs$spec$alpha_SLASH_unknown)){
if(cljs.core.seq_QMARK_(form)){
return spec_tools.impl.normalize_symbol(cljs.core.first(form));
} else {
return (spec_tools.visitor.spec_dispatch.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.spec_dispatch.cljs$core$IFn$_invoke$arity$3(form,accept,options) : spec_tools.visitor.spec_dispatch.call(null,form,accept,options));
}
} else {
return spec;
}
} else {
if(cljs.core.set_QMARK_(spec)){
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set;
} else {
if(cljs.core.seq_QMARK_(spec)){
return spec_tools.impl.normalize_symbol(cljs.core.first(spec_tools.impl.strip_fn_if_needed(spec)));
} else {
if((spec instanceof cljs.core.Symbol)){
return spec_tools.impl.normalize_symbol(spec);
} else {
return spec_tools.impl.normalize_symbol((spec_tools.form.resolve_form.cljs$core$IFn$_invoke$arity$1 ? spec_tools.form.resolve_form.cljs$core$IFn$_invoke$arity$1(spec) : spec_tools.form.resolve_form.call(null,spec)));

}
}
}
}
});
if((typeof spec_tools !== 'undefined') && (typeof spec_tools.visitor !== 'undefined') && (typeof spec_tools.visitor.visit_spec !== 'undefined')){
} else {
spec_tools.visitor.visit_spec = (function (){var method_table__4414__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4415__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4416__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4417__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4418__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$default,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default], null),cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("spec-tools.visitor","visit-spec"),spec_tools.visitor.spec_dispatch,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default,hierarchy__4418__auto__,method_table__4414__auto__,prefer_table__4415__auto__,method_cache__4416__auto__,cached_hierarchy__4417__auto__));
})();
}
/**
 * Walk a spec definition. Takes 2-3 arguments, the spec and the accept
 *   function, and optionally a options map, and returns the result of
 *   calling the accept function. Options map can be used to pass in context-
 *   specific information to to sub-visits & accepts.
 * 
 *   The accept function is called with 4 arguments: the dispatch term for the
 *   spec (see below), the spec itself, vector with the results of
 *   recursively walking the children of the spec and the options map.
 * 
 *   The dispatch term is one of the following
 *   * if the spec is a function call: a fully qualified symbol for the function
 *  with the following exceptions:
 *  - cljs.core symbols are converted to clojure.core symbols
 *  - cljs.spec.alpha symbols are converted to clojure.spec.alpha symbols
 *   * if the spec is a set: :spec-tools.visitor/set
 *   * otherwise: the spec itself
 */
spec_tools.visitor.visit = (function spec_tools$visitor$visit(var_args){
var G__20035 = arguments.length;
switch (G__20035) {
case 2:
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$2 = (function (spec,accept){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(spec,accept,null);
});

spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3 = (function (spec,accept,p__20036){
var map__20037 = p__20036;
var map__20037__$1 = ((((!((map__20037 == null)))?(((((map__20037.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20037.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20037):map__20037);
var options = map__20037__$1;
var visited = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20037__$1,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_visited);
if(cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(visited,spec))){
var options__$1 = (((spec instanceof cljs.core.Keyword))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(options,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_visited,cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),spec):options);
return (spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3(spec,accept,options__$1) : spec_tools.visitor.visit_spec.call(null,spec,accept,options__$1));
} else {
return (spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3(null,accept,options) : spec_tools.visitor.visit_spec.call(null,null,accept,options));
}
});

spec_tools.visitor.visit.cljs$lang$maxFixedArity = 3;

spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set,(function (spec,accept,options){
var G__20040 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set;
var G__20041 = spec;
var G__20042 = cljs.core.vec((((spec instanceof cljs.core.Keyword))?spec_tools.impl.extract_form(spec):spec));
var G__20043 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20040,G__20041,G__20042,G__20043) : accept.call(null,G__20040,G__20041,G__20042,G__20043));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys,(function (spec,accept,options){
var keys = spec_tools.impl.extract_keys(spec_tools.impl.extract_form(spec));
var G__20045 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys;
var G__20046 = spec;
var G__20047 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__20045,G__20046,keys){
return (function (p1__20044_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__20044_SHARP_,accept,options);
});})(G__20045,G__20046,keys))
,keys);
var G__20048 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20045,G__20046,G__20047,G__20048) : accept.call(null,G__20045,G__20046,G__20047,G__20048));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_or,(function (spec,accept,options){
var vec__20050 = spec_tools.impl.extract_form(spec);
var seq__20051 = cljs.core.seq(vec__20050);
var first__20052 = cljs.core.first(seq__20051);
var seq__20051__$1 = cljs.core.next(seq__20051);
var _ = first__20052;
var map__20053 = seq__20051__$1;
var map__20053__$1 = ((((!((map__20053 == null)))?(((((map__20053.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20053.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20053):map__20053);
var inner_spec_map = map__20053__$1;
var G__20055 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_or;
var G__20056 = spec;
var G__20057 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__20055,G__20056,vec__20050,seq__20051,first__20052,seq__20051__$1,_,map__20053,map__20053__$1,inner_spec_map){
return (function (p1__20049_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__20049_SHARP_,accept,options);
});})(G__20055,G__20056,vec__20050,seq__20051,first__20052,seq__20051__$1,_,map__20053,map__20053__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__20058 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20055,G__20056,G__20057,G__20058) : accept.call(null,G__20055,G__20056,G__20057,G__20058));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_and,(function (spec,accept,options){
var vec__20060 = spec_tools.impl.extract_form(spec);
var seq__20061 = cljs.core.seq(vec__20060);
var first__20062 = cljs.core.first(seq__20061);
var seq__20061__$1 = cljs.core.next(seq__20061);
var _ = first__20062;
var inner_specs = seq__20061__$1;
var G__20063 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_and;
var G__20064 = spec;
var G__20065 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__20063,G__20064,vec__20060,seq__20061,first__20062,seq__20061__$1,_,inner_specs){
return (function (p1__20059_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__20059_SHARP_,accept,options);
});})(G__20063,G__20064,vec__20060,seq__20061,first__20062,seq__20061__$1,_,inner_specs))
,inner_specs);
var G__20066 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20063,G__20064,G__20065,G__20066) : accept.call(null,G__20063,G__20064,G__20065,G__20066));
}));
spec_tools.visitor.visit_merge = (function spec_tools$visitor$visit_merge(spec,accept,options){
var vec__20068 = spec_tools.impl.extract_form(spec);
var seq__20069 = cljs.core.seq(vec__20068);
var first__20070 = cljs.core.first(seq__20069);
var seq__20069__$1 = cljs.core.next(seq__20069);
var _ = first__20070;
var inner_specs = seq__20069__$1;
var G__20071 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_merge;
var G__20072 = spec;
var G__20073 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__20071,G__20072,vec__20068,seq__20069,first__20070,seq__20069__$1,_,inner_specs){
return (function (p1__20067_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__20067_SHARP_,accept,options);
});})(G__20071,G__20072,vec__20068,seq__20069,first__20070,seq__20069__$1,_,inner_specs))
,inner_specs);
var G__20074 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20071,G__20072,G__20073,G__20074) : accept.call(null,G__20071,G__20072,G__20073,G__20074));
});
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_merge,(function (spec,accept,options){
return spec_tools.visitor.visit_merge(spec,accept,options);
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$spec_DASH_tools$core_SLASH_merge,(function (spec,accept,options){
return spec_tools.visitor.visit_merge(spec,accept,options);
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_every,(function (spec,accept,options){
var vec__20075 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20075,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20075,(1),null);
var G__20078 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_every;
var G__20079 = spec;
var G__20080 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__20081 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20078,G__20079,G__20080,G__20081) : accept.call(null,G__20078,G__20079,G__20080,G__20081));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_every_DASH_kv,(function (spec,accept,options){
var vec__20083 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20083,(0),null);
var inner_spec1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20083,(1),null);
var inner_spec2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20083,(2),null);
var G__20086 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_every_DASH_kv;
var G__20087 = spec;
var G__20088 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__20086,G__20087,vec__20083,_,inner_spec1,inner_spec2){
return (function (p1__20082_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__20082_SHARP_,accept,options);
});})(G__20086,G__20087,vec__20083,_,inner_spec1,inner_spec2))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [inner_spec1,inner_spec2], null));
var G__20089 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20086,G__20087,G__20088,G__20089) : accept.call(null,G__20086,G__20087,G__20088,G__20089));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_coll_DASH_of,(function (spec,accept,options){
var form = spec_tools.impl.extract_form(spec);
var pred = cljs.core.second(form);
var map__20090 = spec_tools.parse.parse_spec(form);
var map__20090__$1 = ((((!((map__20090 == null)))?(((((map__20090.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20090.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20090):map__20090);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20090__$1,cljs.core.cst$kw$type);
var dispatch = (function (){var G__20092 = type;
var G__20092__$1 = (((G__20092 instanceof cljs.core.Keyword))?G__20092.fqn:null);
switch (G__20092__$1) {
case "map-of":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_map_DASH_of;

break;
case "set":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set_DASH_of;

break;
case "vector":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_vector_DASH_of;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20092__$1)].join('')));

}
})();
var G__20093 = dispatch;
var G__20094 = spec;
var G__20095 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(pred,accept,options)], null);
var G__20096 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20093,G__20094,G__20095,G__20096) : accept.call(null,G__20093,G__20094,G__20095,G__20096));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_map_DASH_of,(function (spec,accept,options){
var vec__20099 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20099,(0),null);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20099,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20099,(2),null);
var G__20102 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_map_DASH_of;
var G__20103 = spec;
var G__20104 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__20102,G__20103,vec__20099,_,k,v){
return (function (p1__20098_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__20098_SHARP_,accept,options);
});})(G__20102,G__20103,vec__20099,_,k,v))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
var G__20105 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20102,G__20103,G__20104,G__20105) : accept.call(null,G__20102,G__20103,G__20104,G__20105));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__STAR_,(function (spec,accept,options){
var vec__20106 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20106,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20106,(1),null);
var G__20109 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__STAR_;
var G__20110 = spec;
var G__20111 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__20112 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20109,G__20110,G__20111,G__20112) : accept.call(null,G__20109,G__20110,G__20111,G__20112));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__PLUS_,(function (spec,accept,options){
var vec__20113 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20113,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20113,(1),null);
var G__20116 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__PLUS_;
var G__20117 = spec;
var G__20118 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__20119 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20116,G__20117,G__20118,G__20119) : accept.call(null,G__20116,G__20117,G__20118,G__20119));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__QMARK_,(function (spec,accept,options){
var vec__20120 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20120,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20120,(1),null);
var G__20123 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__QMARK_;
var G__20124 = spec;
var G__20125 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__20126 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20123,G__20124,G__20125,G__20126) : accept.call(null,G__20123,G__20124,G__20125,G__20126));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_alt,(function (spec,accept,options){
var vec__20128 = spec_tools.impl.extract_form(spec);
var seq__20129 = cljs.core.seq(vec__20128);
var first__20130 = cljs.core.first(seq__20129);
var seq__20129__$1 = cljs.core.next(seq__20129);
var _ = first__20130;
var map__20131 = seq__20129__$1;
var map__20131__$1 = ((((!((map__20131 == null)))?(((((map__20131.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20131.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20131):map__20131);
var inner_spec_map = map__20131__$1;
var G__20133 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_alt;
var G__20134 = spec;
var G__20135 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__20133,G__20134,vec__20128,seq__20129,first__20130,seq__20129__$1,_,map__20131,map__20131__$1,inner_spec_map){
return (function (p1__20127_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__20127_SHARP_,accept,options);
});})(G__20133,G__20134,vec__20128,seq__20129,first__20130,seq__20129__$1,_,map__20131,map__20131__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__20136 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20133,G__20134,G__20135,G__20136) : accept.call(null,G__20133,G__20134,G__20135,G__20136));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_cat,(function (spec,accept,options){
var vec__20138 = spec_tools.impl.extract_form(spec);
var seq__20139 = cljs.core.seq(vec__20138);
var first__20140 = cljs.core.first(seq__20139);
var seq__20139__$1 = cljs.core.next(seq__20139);
var _ = first__20140;
var map__20141 = seq__20139__$1;
var map__20141__$1 = ((((!((map__20141 == null)))?(((((map__20141.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20141.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20141):map__20141);
var inner_spec_map = map__20141__$1;
var G__20143 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_cat;
var G__20144 = spec;
var G__20145 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__20143,G__20144,vec__20138,seq__20139,first__20140,seq__20139__$1,_,map__20141,map__20141__$1,inner_spec_map){
return (function (p1__20137_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__20137_SHARP_,accept,options);
});})(G__20143,G__20144,vec__20138,seq__20139,first__20140,seq__20139__$1,_,map__20141,map__20141__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__20146 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20143,G__20144,G__20145,G__20146) : accept.call(null,G__20143,G__20144,G__20145,G__20146));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__AMPERSAND_,(function (spec,accept,options){
var vec__20147 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20147,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20147,(1),null);
var G__20150 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__AMPERSAND_;
var G__20151 = spec;
var G__20152 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__20153 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20150,G__20151,G__20152,G__20153) : accept.call(null,G__20150,G__20151,G__20152,G__20153));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_tuple,(function (spec,accept,options){
var vec__20155 = spec_tools.impl.extract_form(spec);
var seq__20156 = cljs.core.seq(vec__20155);
var first__20157 = cljs.core.first(seq__20156);
var seq__20156__$1 = cljs.core.next(seq__20156);
var _ = first__20157;
var inner_specs = seq__20156__$1;
var G__20158 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_tuple;
var G__20159 = spec;
var G__20160 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__20158,G__20159,vec__20155,seq__20156,first__20157,seq__20156__$1,_,inner_specs){
return (function (p1__20154_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__20154_SHARP_,accept,options);
});})(G__20158,G__20159,vec__20155,seq__20156,first__20157,seq__20156__$1,_,inner_specs))
,inner_specs);
var G__20161 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20158,G__20159,G__20160,G__20161) : accept.call(null,G__20158,G__20159,G__20160,G__20161));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys_STAR_,(function (spec,accept,options){
var keys = spec_tools.impl.extract_keys(spec_tools.impl.extract_form(spec));
var G__20163 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys_STAR_;
var G__20164 = spec;
var G__20165 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__20163,G__20164,keys){
return (function (p1__20162_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__20162_SHARP_,accept,options);
});})(G__20163,G__20164,keys))
,keys);
var G__20166 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20163,G__20164,G__20165,G__20166) : accept.call(null,G__20163,G__20164,G__20165,G__20166));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_nilable,(function (spec,accept,options){
var vec__20167 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20167,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20167,(1),null);
var G__20170 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_nilable;
var G__20171 = spec;
var G__20172 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__20173 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20170,G__20171,G__20172,G__20173) : accept.call(null,G__20170,G__20171,G__20172,G__20173));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$spec_DASH_tools$core_SLASH_spec,(function (spec,accept,options){
var vec__20174 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20174,(0),null);
var map__20177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20174,(1),null);
var map__20177__$1 = ((((!((map__20177 == null)))?(((((map__20177.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20177.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20177):map__20177);
var inner_spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20177__$1,cljs.core.cst$kw$spec);
var G__20179 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_spec;
var G__20180 = spec;
var G__20181 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__20182 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20179,G__20180,G__20181,G__20182) : accept.call(null,G__20179,G__20180,G__20181,G__20182));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default,(function (spec,accept,options){
var G__20183 = spec_tools.visitor.spec_dispatch(spec,accept,options);
var G__20184 = spec;
var G__20185 = null;
var G__20186 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__20183,G__20184,G__20185,G__20186) : accept.call(null,G__20183,G__20184,G__20185,G__20186));
}));
/**
 * a visitor that collects all registered specs. Returns
 *   a map of spec-name => spec.
 */
spec_tools.visitor.spec_collector = (function spec_tools$visitor$spec_collector(){
var specs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (specs){
return (function (_,spec,___$1,___$2){
var temp__5733__auto__ = cljs.spec.alpha.get_spec(spec);
if(cljs.core.truth_(temp__5733__auto__)){
var s = temp__5733__auto__;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(specs,cljs.core.assoc,spec,s);
} else {
return cljs.core.deref(specs);
}
});
;})(specs))
});
