// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('ajax.xml_http_request');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('ajax.protocols');
goog.require('goog.string');
ajax.xml_http_request.ready_state = (function ajax$xml_http_request$ready_state(e){
var G__28003 = e.target.readyState;
var fexpr__28002 = new cljs.core.PersistentArrayMap(null, 5, [(0),cljs.core.cst$kw$not_DASH_initialized,(1),cljs.core.cst$kw$connection_DASH_established,(2),cljs.core.cst$kw$request_DASH_received,(3),cljs.core.cst$kw$processing_DASH_request,(4),cljs.core.cst$kw$response_DASH_ready], null);
return (fexpr__28002.cljs$core$IFn$_invoke$arity$1 ? fexpr__28002.cljs$core$IFn$_invoke$arity$1(G__28003) : fexpr__28002.call(null,G__28003));
});
ajax.xml_http_request.append = (function ajax$xml_http_request$append(current,next){
if(cljs.core.truth_(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current),", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(next)].join('');
} else {
return next;
}
});
ajax.xml_http_request.process_headers = (function ajax$xml_http_request$process_headers(header_str){
if(cljs.core.truth_(header_str)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (headers,header_line){
if(cljs.core.truth_(goog.string.isEmptyOrWhitespace(header_line))){
return headers;
} else {
var key_value = goog.string.splitLimit(header_line,": ",(2));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(headers,(key_value[(0)]),ajax.xml_http_request.append,(key_value[(1)]));
}
}),cljs.core.PersistentArrayMap.EMPTY,header_str.split("\r\n"));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
ajax.xml_http_request.xmlhttprequest = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?(function (){var xmlhttprequest = require("xmlhttprequest").XMLHttpRequest;
goog.object.set(global,"XMLHttpRequest",xmlhttprequest);

return xmlhttprequest;
})():XMLHttpRequest);
ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$ = cljs.core.PROTOCOL_SENTINEL;

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$_js_ajax_request$arity$3 = (function (this$,p__28005,handler){
var map__28006 = p__28005;
var map__28006__$1 = ((((!((map__28006 == null)))?(((((map__28006.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28006.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28006):map__28006);
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28006__$1,cljs.core.cst$kw$uri);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28006__$1,cljs.core.cst$kw$method);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28006__$1,cljs.core.cst$kw$body);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28006__$1,cljs.core.cst$kw$headers);
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28006__$1,cljs.core.cst$kw$timeout,(0));
var with_credentials = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28006__$1,cljs.core.cst$kw$with_DASH_credentials,false);
var response_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28006__$1,cljs.core.cst$kw$response_DASH_format);
var this$__$1 = this;
this$__$1.withCredentials = with_credentials;

this$__$1.onreadystatechange = ((function (this$__$1,map__28006,map__28006__$1,uri,method,body,headers,timeout,with_credentials,response_format){
return (function (p1__28004_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$response_DASH_ready,ajax.xml_http_request.ready_state(p1__28004_SHARP_))){
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(this$__$1) : handler.call(null,this$__$1));
} else {
return null;
}
});})(this$__$1,map__28006,map__28006__$1,uri,method,body,headers,timeout,with_credentials,response_format))
;

this$__$1.open(method,uri,true);

this$__$1.timeout = timeout;

var temp__5735__auto___28018 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(response_format);
if(cljs.core.truth_(temp__5735__auto___28018)){
var response_type_28019 = temp__5735__auto___28018;
this$__$1.responseType = cljs.core.name(response_type_28019);
} else {
}

var seq__28008_28020 = cljs.core.seq(headers);
var chunk__28009_28021 = null;
var count__28010_28022 = (0);
var i__28011_28023 = (0);
while(true){
if((i__28011_28023 < count__28010_28022)){
var vec__28012_28024 = chunk__28009_28021.cljs$core$IIndexed$_nth$arity$2(null,i__28011_28023);
var k_28025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28012_28024,(0),null);
var v_28026 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28012_28024,(1),null);
this$__$1.setRequestHeader(k_28025,v_28026);


var G__28027 = seq__28008_28020;
var G__28028 = chunk__28009_28021;
var G__28029 = count__28010_28022;
var G__28030 = (i__28011_28023 + (1));
seq__28008_28020 = G__28027;
chunk__28009_28021 = G__28028;
count__28010_28022 = G__28029;
i__28011_28023 = G__28030;
continue;
} else {
var temp__5735__auto___28031 = cljs.core.seq(seq__28008_28020);
if(temp__5735__auto___28031){
var seq__28008_28032__$1 = temp__5735__auto___28031;
if(cljs.core.chunked_seq_QMARK_(seq__28008_28032__$1)){
var c__4351__auto___28033 = cljs.core.chunk_first(seq__28008_28032__$1);
var G__28034 = cljs.core.chunk_rest(seq__28008_28032__$1);
var G__28035 = c__4351__auto___28033;
var G__28036 = cljs.core.count(c__4351__auto___28033);
var G__28037 = (0);
seq__28008_28020 = G__28034;
chunk__28009_28021 = G__28035;
count__28010_28022 = G__28036;
i__28011_28023 = G__28037;
continue;
} else {
var vec__28015_28038 = cljs.core.first(seq__28008_28032__$1);
var k_28039 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28015_28038,(0),null);
var v_28040 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28015_28038,(1),null);
this$__$1.setRequestHeader(k_28039,v_28040);


var G__28041 = cljs.core.next(seq__28008_28032__$1);
var G__28042 = null;
var G__28043 = (0);
var G__28044 = (0);
seq__28008_28020 = G__28041;
chunk__28009_28021 = G__28042;
count__28010_28022 = G__28043;
i__28011_28023 = G__28044;
continue;
}
} else {
}
}
break;
}

this$__$1.send((function (){var or__3949__auto__ = body;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})());

return this$__$1;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$ = cljs.core.PROTOCOL_SENTINEL;

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort();
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$ = cljs.core.PROTOCOL_SENTINEL;

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.response;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.status;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.statusText;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_all_headers$arity$1 = (function (this$){
var this$__$1 = this;
return ajax.xml_http_request.process_headers(this$__$1.getAllResponseHeaders());
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),this$__$1.readyState);
});
