// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = cljs.core.cst$kw$fx;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$id,cljs.core.cst$kw$do_DASH_fx,cljs.core.cst$kw$after,(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_20731 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$event_SLASH_do_DASH_fx], null));

try{try{var seq__20732 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__20733 = null;
var count__20734 = (0);
var i__20735 = (0);
while(true){
if((i__20735 < count__20734)){
var vec__20736 = chunk__20733.cljs$core$IIndexed$_nth$arity$2(null,i__20735);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20736,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20736,(1),null);
var temp__5733__auto___20752 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20752)){
var effect_fn_20753 = temp__5733__auto___20752;
(effect_fn_20753.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20753.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20753.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20754 = seq__20732;
var G__20755 = chunk__20733;
var G__20756 = count__20734;
var G__20757 = (i__20735 + (1));
seq__20732 = G__20754;
chunk__20733 = G__20755;
count__20734 = G__20756;
i__20735 = G__20757;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20732);
if(temp__5735__auto__){
var seq__20732__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20732__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20732__$1);
var G__20758 = cljs.core.chunk_rest(seq__20732__$1);
var G__20759 = c__4351__auto__;
var G__20760 = cljs.core.count(c__4351__auto__);
var G__20761 = (0);
seq__20732 = G__20758;
chunk__20733 = G__20759;
count__20734 = G__20760;
i__20735 = G__20761;
continue;
} else {
var vec__20739 = cljs.core.first(seq__20732__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20739,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20739,(1),null);
var temp__5733__auto___20762 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20762)){
var effect_fn_20763 = temp__5733__auto___20762;
(effect_fn_20763.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20763.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20763.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20764 = cljs.core.next(seq__20732__$1);
var G__20765 = null;
var G__20766 = (0);
var G__20767 = (0);
seq__20732 = G__20764;
chunk__20733 = G__20765;
count__20734 = G__20766;
i__20735 = G__20767;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__20557__auto___20768 = re_frame.interop.now();
var duration__20558__auto___20769 = (end__20557__auto___20768 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__20558__auto___20769,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__20557__auto___20768);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_20731;
}} else {
var seq__20742 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__20743 = null;
var count__20744 = (0);
var i__20745 = (0);
while(true){
if((i__20745 < count__20744)){
var vec__20746 = chunk__20743.cljs$core$IIndexed$_nth$arity$2(null,i__20745);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20746,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20746,(1),null);
var temp__5733__auto___20770 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20770)){
var effect_fn_20771 = temp__5733__auto___20770;
(effect_fn_20771.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20771.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20771.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20772 = seq__20742;
var G__20773 = chunk__20743;
var G__20774 = count__20744;
var G__20775 = (i__20745 + (1));
seq__20742 = G__20772;
chunk__20743 = G__20773;
count__20744 = G__20774;
i__20745 = G__20775;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20742);
if(temp__5735__auto__){
var seq__20742__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20742__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20742__$1);
var G__20776 = cljs.core.chunk_rest(seq__20742__$1);
var G__20777 = c__4351__auto__;
var G__20778 = cljs.core.count(c__4351__auto__);
var G__20779 = (0);
seq__20742 = G__20776;
chunk__20743 = G__20777;
count__20744 = G__20778;
i__20745 = G__20779;
continue;
} else {
var vec__20749 = cljs.core.first(seq__20742__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20749,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20749,(1),null);
var temp__5733__auto___20780 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___20780)){
var effect_fn_20781 = temp__5733__auto___20780;
(effect_fn_20781.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20781.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20781.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20782 = cljs.core.next(seq__20742__$1);
var G__20783 = null;
var G__20784 = (0);
var G__20785 = (0);
seq__20742 = G__20782;
chunk__20743 = G__20783;
count__20744 = G__20784;
i__20745 = G__20785;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_later,(function (value){
var seq__20786 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__20787 = null;
var count__20788 = (0);
var i__20789 = (0);
while(true){
if((i__20789 < count__20788)){
var map__20790 = chunk__20787.cljs$core$IIndexed$_nth$arity$2(null,i__20789);
var map__20790__$1 = ((((!((map__20790 == null)))?(((((map__20790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20790.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20790):map__20790);
var effect = map__20790__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20790__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20790__$1,cljs.core.cst$kw$dispatch);
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__20786,chunk__20787,count__20788,i__20789,map__20790,map__20790__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__20786,chunk__20787,count__20788,i__20789,map__20790,map__20790__$1,effect,ms,dispatch))
,ms);
}


var G__20794 = seq__20786;
var G__20795 = chunk__20787;
var G__20796 = count__20788;
var G__20797 = (i__20789 + (1));
seq__20786 = G__20794;
chunk__20787 = G__20795;
count__20788 = G__20796;
i__20789 = G__20797;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20786);
if(temp__5735__auto__){
var seq__20786__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20786__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20786__$1);
var G__20798 = cljs.core.chunk_rest(seq__20786__$1);
var G__20799 = c__4351__auto__;
var G__20800 = cljs.core.count(c__4351__auto__);
var G__20801 = (0);
seq__20786 = G__20798;
chunk__20787 = G__20799;
count__20788 = G__20800;
i__20789 = G__20801;
continue;
} else {
var map__20792 = cljs.core.first(seq__20786__$1);
var map__20792__$1 = ((((!((map__20792 == null)))?(((((map__20792.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20792.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20792):map__20792);
var effect = map__20792__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20792__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20792__$1,cljs.core.cst$kw$dispatch);
if(((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__20786,chunk__20787,count__20788,i__20789,map__20792,map__20792__$1,effect,ms,dispatch,seq__20786__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__20786,chunk__20787,count__20788,i__20789,map__20792,map__20792__$1,effect,ms,dispatch,seq__20786__$1,temp__5735__auto__))
,ms);
}


var G__20802 = cljs.core.next(seq__20786__$1);
var G__20803 = null;
var G__20804 = (0);
var G__20805 = (0);
seq__20786 = G__20802;
chunk__20787 = G__20803;
count__20788 = G__20804;
i__20789 = G__20805;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch,(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_n,(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__20806 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__20807 = null;
var count__20808 = (0);
var i__20809 = (0);
while(true){
if((i__20809 < count__20808)){
var event = chunk__20807.cljs$core$IIndexed$_nth$arity$2(null,i__20809);
re_frame.router.dispatch(event);


var G__20810 = seq__20806;
var G__20811 = chunk__20807;
var G__20812 = count__20808;
var G__20813 = (i__20809 + (1));
seq__20806 = G__20810;
chunk__20807 = G__20811;
count__20808 = G__20812;
i__20809 = G__20813;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20806);
if(temp__5735__auto__){
var seq__20806__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20806__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20806__$1);
var G__20814 = cljs.core.chunk_rest(seq__20806__$1);
var G__20815 = c__4351__auto__;
var G__20816 = cljs.core.count(c__4351__auto__);
var G__20817 = (0);
seq__20806 = G__20814;
chunk__20807 = G__20815;
count__20808 = G__20816;
i__20809 = G__20817;
continue;
} else {
var event = cljs.core.first(seq__20806__$1);
re_frame.router.dispatch(event);


var G__20818 = cljs.core.next(seq__20806__$1);
var G__20819 = null;
var G__20820 = (0);
var G__20821 = (0);
seq__20806 = G__20818;
chunk__20807 = G__20819;
count__20808 = G__20820;
i__20809 = G__20821;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$deregister_DASH_event_DASH_handler,(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__20822 = cljs.core.seq(value);
var chunk__20823 = null;
var count__20824 = (0);
var i__20825 = (0);
while(true){
if((i__20825 < count__20824)){
var event = chunk__20823.cljs$core$IIndexed$_nth$arity$2(null,i__20825);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__20826 = seq__20822;
var G__20827 = chunk__20823;
var G__20828 = count__20824;
var G__20829 = (i__20825 + (1));
seq__20822 = G__20826;
chunk__20823 = G__20827;
count__20824 = G__20828;
i__20825 = G__20829;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__20822);
if(temp__5735__auto__){
var seq__20822__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20822__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__20822__$1);
var G__20830 = cljs.core.chunk_rest(seq__20822__$1);
var G__20831 = c__4351__auto__;
var G__20832 = cljs.core.count(c__4351__auto__);
var G__20833 = (0);
seq__20822 = G__20830;
chunk__20823 = G__20831;
count__20824 = G__20832;
i__20825 = G__20833;
continue;
} else {
var event = cljs.core.first(seq__20822__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));


var G__20834 = cljs.core.next(seq__20822__$1);
var G__20835 = null;
var G__20836 = (0);
var G__20837 = (0);
seq__20822 = G__20834;
chunk__20823 = G__20835;
count__20824 = G__20836;
i__20825 = G__20837;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$db,(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));
