// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('reitit.frontend.controllers');
goog.require('cljs.core');
goog.require('cljs.core.constants');
reitit.frontend.controllers.pad_same_length = (function reitit$frontend$controllers$pad_same_length(a,b){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a,cljs.core.take.cljs$core$IFn$_invoke$arity$2((cljs.core.count(b) - cljs.core.count(a)),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)));
});
reitit.frontend.controllers.params_warning = (new cljs.core.Delay((function (){
return console.warn("Reitit-frontend controller :params is deprecated. Replace with :identity or :parameters option.");
}),null));
/**
 * Get controller identity given controller and match.
 * 
 *   To select interesting properties from Match :parameters option can be set.
 *   Value should be param-type => [param-key]
 *   Resulting value is map of param-type => param-key => value.
 * 
 *   For other uses, :identity option can be used to provide function from
 *   Match to identity.
 * 
 *   Default value is nil, i.e. controller identity doesn't depend on Match.
 */
reitit.frontend.controllers.get_identity = (function reitit$frontend$controllers$get_identity(p__20067,match){
var map__20068 = p__20067;
var map__20068__$1 = ((((!((map__20068 == null)))?(((((map__20068.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20068.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20068):map__20068);
var identity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20068__$1,cljs.core.cst$kw$identity);
var parameters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20068__$1,cljs.core.cst$kw$parameters);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20068__$1,cljs.core.cst$kw$params);
if(cljs.core.not((function (){var and__3938__auto__ = identity;
if(cljs.core.truth_(and__3938__auto__)){
return parameters;
} else {
return and__3938__auto__;
}
})())){
} else {
throw (new Error(["Assert failed: ","Use either :identity or :parameters for controller, not both.","\n","(not (and identity parameters))"].join('')));
}

if(cljs.core.truth_(params)){
cljs.core.deref(reitit.frontend.controllers.params_warning);
} else {
}

if(cljs.core.truth_(parameters)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4324__auto__ = ((function (map__20068,map__20068__$1,identity,parameters,params){
return (function reitit$frontend$controllers$get_identity_$_iter__20070(s__20071){
return (new cljs.core.LazySeq(null,((function (map__20068,map__20068__$1,identity,parameters,params){
return (function (){
var s__20071__$1 = s__20071;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__20071__$1);
if(temp__5735__auto__){
var s__20071__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__20071__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__20071__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__20073 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__20072 = (0);
while(true){
if((i__20072 < size__4323__auto__)){
var vec__20074 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__20072);
var param_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20074,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20074,(1),null);
cljs.core.chunk_append(b__20073,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_type,cljs.core.select_keys(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$parameters.cljs$core$IFn$_invoke$arity$1(match),param_type),ks)], null));

var G__20080 = (i__20072 + (1));
i__20072 = G__20080;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__20073),reitit$frontend$controllers$get_identity_$_iter__20070(cljs.core.chunk_rest(s__20071__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__20073),null);
}
} else {
var vec__20077 = cljs.core.first(s__20071__$2);
var param_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20077,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20077,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_type,cljs.core.select_keys(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$parameters.cljs$core$IFn$_invoke$arity$1(match),param_type),ks)], null),reitit$frontend$controllers$get_identity_$_iter__20070(cljs.core.rest(s__20071__$2)));
}
} else {
return null;
}
break;
}
});})(map__20068,map__20068__$1,identity,parameters,params))
,null,null));
});})(map__20068,map__20068__$1,identity,parameters,params))
;
return iter__4324__auto__(parameters);
})());
} else {
if(cljs.core.truth_(identity)){
return (identity.cljs$core$IFn$_invoke$arity$1 ? identity.cljs$core$IFn$_invoke$arity$1(match) : identity.call(null,match));
} else {
if(cljs.core.truth_(params)){
return (params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(match) : params.call(null,match));
} else {
return null;

}
}
}
});
/**
 * Run side-effects (:start or :stop) for controller.
 *   The side-effect function is called with controller identity value.
 */
reitit.frontend.controllers.apply_controller = (function reitit$frontend$controllers$apply_controller(controller,method){
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(controller,method);
if(cljs.core.truth_(temp__5735__auto__)){
var f = temp__5735__auto__;
var G__20081 = cljs.core.cst$kw$reitit$frontend$controllers_SLASH_identity.cljs$core$IFn$_invoke$arity$1(controller);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__20081) : f.call(null,G__20081));
} else {
return null;
}
});
/**
 * Applies changes between current controllers and
 *   those previously enabled. Reinitializes controllers whose
 *   identity has changed.
 */
reitit.frontend.controllers.apply_controllers = (function reitit$frontend$controllers$apply_controllers(old_controllers,new_match){
var new_controllers = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (controller){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(controller,cljs.core.cst$kw$reitit$frontend$controllers_SLASH_identity,reitit.frontend.controllers.get_identity(controller,new_match));
}),cljs.core.cst$kw$controllers.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(new_match)));
var changed_controllers = cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (new_controllers){
return (function (old,new$){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old,new$)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old,cljs.core.cst$kw$new,new$], null);
} else {
return null;
}
});})(new_controllers))
,reitit.frontend.controllers.pad_same_length(old_controllers,new_controllers),reitit.frontend.controllers.pad_same_length(new_controllers,old_controllers))));
var seq__20082_20090 = cljs.core.seq(cljs.core.reverse(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$old,changed_controllers)));
var chunk__20083_20091 = null;
var count__20084_20092 = (0);
var i__20085_20093 = (0);
while(true){
if((i__20085_20093 < count__20084_20092)){
var controller_20094 = chunk__20083_20091.cljs$core$IIndexed$_nth$arity$2(null,i__20085_20093);
reitit.frontend.controllers.apply_controller(controller_20094,cljs.core.cst$kw$stop);


var G__20095 = seq__20082_20090;
var G__20096 = chunk__20083_20091;
var G__20097 = count__20084_20092;
var G__20098 = (i__20085_20093 + (1));
seq__20082_20090 = G__20095;
chunk__20083_20091 = G__20096;
count__20084_20092 = G__20097;
i__20085_20093 = G__20098;
continue;
} else {
var temp__5735__auto___20099 = cljs.core.seq(seq__20082_20090);
if(temp__5735__auto___20099){
var seq__20082_20100__$1 = temp__5735__auto___20099;
if(cljs.core.chunked_seq_QMARK_(seq__20082_20100__$1)){
var c__4351__auto___20101 = cljs.core.chunk_first(seq__20082_20100__$1);
var G__20102 = cljs.core.chunk_rest(seq__20082_20100__$1);
var G__20103 = c__4351__auto___20101;
var G__20104 = cljs.core.count(c__4351__auto___20101);
var G__20105 = (0);
seq__20082_20090 = G__20102;
chunk__20083_20091 = G__20103;
count__20084_20092 = G__20104;
i__20085_20093 = G__20105;
continue;
} else {
var controller_20106 = cljs.core.first(seq__20082_20100__$1);
reitit.frontend.controllers.apply_controller(controller_20106,cljs.core.cst$kw$stop);


var G__20107 = cljs.core.next(seq__20082_20100__$1);
var G__20108 = null;
var G__20109 = (0);
var G__20110 = (0);
seq__20082_20090 = G__20107;
chunk__20083_20091 = G__20108;
count__20084_20092 = G__20109;
i__20085_20093 = G__20110;
continue;
}
} else {
}
}
break;
}

var seq__20086_20111 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$new,changed_controllers));
var chunk__20087_20112 = null;
var count__20088_20113 = (0);
var i__20089_20114 = (0);
while(true){
if((i__20089_20114 < count__20088_20113)){
var controller_20115 = chunk__20087_20112.cljs$core$IIndexed$_nth$arity$2(null,i__20089_20114);
reitit.frontend.controllers.apply_controller(controller_20115,cljs.core.cst$kw$start);


var G__20116 = seq__20086_20111;
var G__20117 = chunk__20087_20112;
var G__20118 = count__20088_20113;
var G__20119 = (i__20089_20114 + (1));
seq__20086_20111 = G__20116;
chunk__20087_20112 = G__20117;
count__20088_20113 = G__20118;
i__20089_20114 = G__20119;
continue;
} else {
var temp__5735__auto___20120 = cljs.core.seq(seq__20086_20111);
if(temp__5735__auto___20120){
var seq__20086_20121__$1 = temp__5735__auto___20120;
if(cljs.core.chunked_seq_QMARK_(seq__20086_20121__$1)){
var c__4351__auto___20122 = cljs.core.chunk_first(seq__20086_20121__$1);
var G__20123 = cljs.core.chunk_rest(seq__20086_20121__$1);
var G__20124 = c__4351__auto___20122;
var G__20125 = cljs.core.count(c__4351__auto___20122);
var G__20126 = (0);
seq__20086_20111 = G__20123;
chunk__20087_20112 = G__20124;
count__20088_20113 = G__20125;
i__20089_20114 = G__20126;
continue;
} else {
var controller_20127 = cljs.core.first(seq__20086_20121__$1);
reitit.frontend.controllers.apply_controller(controller_20127,cljs.core.cst$kw$start);


var G__20128 = cljs.core.next(seq__20086_20121__$1);
var G__20129 = null;
var G__20130 = (0);
var G__20131 = (0);
seq__20086_20111 = G__20128;
chunk__20087_20112 = G__20129;
count__20088_20113 = G__20130;
i__20089_20114 = G__20131;
continue;
}
} else {
}
}
break;
}

return new_controllers;
});
