// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('spec_tools.visitor');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.spec.alpha');
goog.require('spec_tools.core');
goog.require('spec_tools.parse');
goog.require('spec_tools.impl');
goog.require('spec_tools.form');
spec_tools.visitor.spec_dispatch = (function spec_tools$visitor$spec_dispatch(spec,accept,options){
if(cljs.core.truth_((function (){var or__3949__auto__ = cljs.spec.alpha.spec_QMARK_(spec);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = cljs.spec.alpha.regex_QMARK_(spec);
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
return (spec instanceof cljs.core.Keyword);
}
}
})())){
var form = cljs.spec.alpha.form(spec);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$kw$cljs$spec$alpha_SLASH_unknown)){
if(cljs.core.seq_QMARK_(form)){
return spec_tools.impl.normalize_symbol(cljs.core.first(form));
} else {
return (spec_tools.visitor.spec_dispatch.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.spec_dispatch.cljs$core$IFn$_invoke$arity$3(form,accept,options) : spec_tools.visitor.spec_dispatch.call(null,form,accept,options));
}
} else {
return spec;
}
} else {
if(cljs.core.set_QMARK_(spec)){
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set;
} else {
if(cljs.core.seq_QMARK_(spec)){
return spec_tools.impl.normalize_symbol(cljs.core.first(spec_tools.impl.strip_fn_if_needed(spec)));
} else {
if((spec instanceof cljs.core.Symbol)){
return spec_tools.impl.normalize_symbol(spec);
} else {
return spec_tools.impl.normalize_symbol((spec_tools.form.resolve_form.cljs$core$IFn$_invoke$arity$1 ? spec_tools.form.resolve_form.cljs$core$IFn$_invoke$arity$1(spec) : spec_tools.form.resolve_form.call(null,spec)));

}
}
}
}
});
if((typeof spec_tools !== 'undefined') && (typeof spec_tools.visitor !== 'undefined') && (typeof spec_tools.visitor.visit_spec !== 'undefined')){
} else {
spec_tools.visitor.visit_spec = (function (){var method_table__4414__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4415__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4416__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4417__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4418__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$default,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default], null),cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("spec-tools.visitor","visit-spec"),spec_tools.visitor.spec_dispatch,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default,hierarchy__4418__auto__,method_table__4414__auto__,prefer_table__4415__auto__,method_cache__4416__auto__,cached_hierarchy__4417__auto__));
})();
}
/**
 * Walk a spec definition. Takes 2-3 arguments, the spec and the accept
 *   function, and optionally a options map, and returns the result of
 *   calling the accept function. Options map can be used to pass in context-
 *   specific information to to sub-visits & accepts.
 * 
 *   The accept function is called with 4 arguments: the dispatch term for the
 *   spec (see below), the spec itself, vector with the results of
 *   recursively walking the children of the spec and the options map.
 * 
 *   The dispatch term is one of the following
 *   * if the spec is a function call: a fully qualified symbol for the function
 *  with the following exceptions:
 *  - cljs.core symbols are converted to clojure.core symbols
 *  - cljs.spec.alpha symbols are converted to clojure.spec.alpha symbols
 *   * if the spec is a set: :spec-tools.visitor/set
 *   * otherwise: the spec itself
 */
spec_tools.visitor.visit = (function spec_tools$visitor$visit(var_args){
var G__19355 = arguments.length;
switch (G__19355) {
case 2:
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$2 = (function (spec,accept){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(spec,accept,null);
});

spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3 = (function (spec,accept,p__19356){
var map__19357 = p__19356;
var map__19357__$1 = ((((!((map__19357 == null)))?(((((map__19357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19357.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19357):map__19357);
var options = map__19357__$1;
var visited = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19357__$1,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_visited);
if(cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(visited,spec))){
var options__$1 = (((spec instanceof cljs.core.Keyword))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(options,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_visited,cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),spec):options);
return (spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3(spec,accept,options__$1) : spec_tools.visitor.visit_spec.call(null,spec,accept,options__$1));
} else {
return (spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3(null,accept,options) : spec_tools.visitor.visit_spec.call(null,null,accept,options));
}
});

spec_tools.visitor.visit.cljs$lang$maxFixedArity = 3;

spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set,(function (spec,accept,options){
var G__19360 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set;
var G__19361 = spec;
var G__19362 = cljs.core.vec((((spec instanceof cljs.core.Keyword))?spec_tools.impl.extract_form(spec):spec));
var G__19363 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19360,G__19361,G__19362,G__19363) : accept.call(null,G__19360,G__19361,G__19362,G__19363));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys,(function (spec,accept,options){
var keys = spec_tools.impl.extract_keys(spec_tools.impl.extract_form(spec));
var G__19365 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys;
var G__19366 = spec;
var G__19367 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19365,G__19366,keys){
return (function (p1__19364_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19364_SHARP_,accept,options);
});})(G__19365,G__19366,keys))
,keys);
var G__19368 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19365,G__19366,G__19367,G__19368) : accept.call(null,G__19365,G__19366,G__19367,G__19368));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_or,(function (spec,accept,options){
var vec__19370 = spec_tools.impl.extract_form(spec);
var seq__19371 = cljs.core.seq(vec__19370);
var first__19372 = cljs.core.first(seq__19371);
var seq__19371__$1 = cljs.core.next(seq__19371);
var _ = first__19372;
var map__19373 = seq__19371__$1;
var map__19373__$1 = ((((!((map__19373 == null)))?(((((map__19373.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19373.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19373):map__19373);
var inner_spec_map = map__19373__$1;
var G__19375 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_or;
var G__19376 = spec;
var G__19377 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19375,G__19376,vec__19370,seq__19371,first__19372,seq__19371__$1,_,map__19373,map__19373__$1,inner_spec_map){
return (function (p1__19369_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19369_SHARP_,accept,options);
});})(G__19375,G__19376,vec__19370,seq__19371,first__19372,seq__19371__$1,_,map__19373,map__19373__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__19378 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19375,G__19376,G__19377,G__19378) : accept.call(null,G__19375,G__19376,G__19377,G__19378));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_and,(function (spec,accept,options){
var vec__19380 = spec_tools.impl.extract_form(spec);
var seq__19381 = cljs.core.seq(vec__19380);
var first__19382 = cljs.core.first(seq__19381);
var seq__19381__$1 = cljs.core.next(seq__19381);
var _ = first__19382;
var inner_specs = seq__19381__$1;
var G__19383 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_and;
var G__19384 = spec;
var G__19385 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19383,G__19384,vec__19380,seq__19381,first__19382,seq__19381__$1,_,inner_specs){
return (function (p1__19379_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19379_SHARP_,accept,options);
});})(G__19383,G__19384,vec__19380,seq__19381,first__19382,seq__19381__$1,_,inner_specs))
,inner_specs);
var G__19386 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19383,G__19384,G__19385,G__19386) : accept.call(null,G__19383,G__19384,G__19385,G__19386));
}));
spec_tools.visitor.visit_merge = (function spec_tools$visitor$visit_merge(spec,accept,options){
var vec__19388 = spec_tools.impl.extract_form(spec);
var seq__19389 = cljs.core.seq(vec__19388);
var first__19390 = cljs.core.first(seq__19389);
var seq__19389__$1 = cljs.core.next(seq__19389);
var _ = first__19390;
var inner_specs = seq__19389__$1;
var G__19391 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_merge;
var G__19392 = spec;
var G__19393 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19391,G__19392,vec__19388,seq__19389,first__19390,seq__19389__$1,_,inner_specs){
return (function (p1__19387_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19387_SHARP_,accept,options);
});})(G__19391,G__19392,vec__19388,seq__19389,first__19390,seq__19389__$1,_,inner_specs))
,inner_specs);
var G__19394 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19391,G__19392,G__19393,G__19394) : accept.call(null,G__19391,G__19392,G__19393,G__19394));
});
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_merge,(function (spec,accept,options){
return spec_tools.visitor.visit_merge(spec,accept,options);
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$spec_DASH_tools$core_SLASH_merge,(function (spec,accept,options){
return spec_tools.visitor.visit_merge(spec,accept,options);
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_every,(function (spec,accept,options){
var vec__19395 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19395,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19395,(1),null);
var G__19398 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_every;
var G__19399 = spec;
var G__19400 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19401 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19398,G__19399,G__19400,G__19401) : accept.call(null,G__19398,G__19399,G__19400,G__19401));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_every_DASH_kv,(function (spec,accept,options){
var vec__19403 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19403,(0),null);
var inner_spec1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19403,(1),null);
var inner_spec2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19403,(2),null);
var G__19406 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_every_DASH_kv;
var G__19407 = spec;
var G__19408 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19406,G__19407,vec__19403,_,inner_spec1,inner_spec2){
return (function (p1__19402_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19402_SHARP_,accept,options);
});})(G__19406,G__19407,vec__19403,_,inner_spec1,inner_spec2))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [inner_spec1,inner_spec2], null));
var G__19409 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19406,G__19407,G__19408,G__19409) : accept.call(null,G__19406,G__19407,G__19408,G__19409));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_coll_DASH_of,(function (spec,accept,options){
var form = spec_tools.impl.extract_form(spec);
var pred = cljs.core.second(form);
var map__19410 = spec_tools.parse.parse_spec(form);
var map__19410__$1 = ((((!((map__19410 == null)))?(((((map__19410.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19410.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19410):map__19410);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19410__$1,cljs.core.cst$kw$type);
var dispatch = (function (){var G__19412 = type;
var G__19412__$1 = (((G__19412 instanceof cljs.core.Keyword))?G__19412.fqn:null);
switch (G__19412__$1) {
case "map-of":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_map_DASH_of;

break;
case "set":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set_DASH_of;

break;
case "vector":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_vector_DASH_of;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19412__$1)].join('')));

}
})();
var G__19413 = dispatch;
var G__19414 = spec;
var G__19415 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(pred,accept,options)], null);
var G__19416 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19413,G__19414,G__19415,G__19416) : accept.call(null,G__19413,G__19414,G__19415,G__19416));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_map_DASH_of,(function (spec,accept,options){
var vec__19419 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19419,(0),null);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19419,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19419,(2),null);
var G__19422 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_map_DASH_of;
var G__19423 = spec;
var G__19424 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19422,G__19423,vec__19419,_,k,v){
return (function (p1__19418_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19418_SHARP_,accept,options);
});})(G__19422,G__19423,vec__19419,_,k,v))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
var G__19425 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19422,G__19423,G__19424,G__19425) : accept.call(null,G__19422,G__19423,G__19424,G__19425));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__STAR_,(function (spec,accept,options){
var vec__19426 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19426,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19426,(1),null);
var G__19429 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__STAR_;
var G__19430 = spec;
var G__19431 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19432 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19429,G__19430,G__19431,G__19432) : accept.call(null,G__19429,G__19430,G__19431,G__19432));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__PLUS_,(function (spec,accept,options){
var vec__19433 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19433,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19433,(1),null);
var G__19436 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__PLUS_;
var G__19437 = spec;
var G__19438 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19439 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19436,G__19437,G__19438,G__19439) : accept.call(null,G__19436,G__19437,G__19438,G__19439));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__QMARK_,(function (spec,accept,options){
var vec__19440 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19440,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19440,(1),null);
var G__19443 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__QMARK_;
var G__19444 = spec;
var G__19445 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19446 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19443,G__19444,G__19445,G__19446) : accept.call(null,G__19443,G__19444,G__19445,G__19446));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_alt,(function (spec,accept,options){
var vec__19448 = spec_tools.impl.extract_form(spec);
var seq__19449 = cljs.core.seq(vec__19448);
var first__19450 = cljs.core.first(seq__19449);
var seq__19449__$1 = cljs.core.next(seq__19449);
var _ = first__19450;
var map__19451 = seq__19449__$1;
var map__19451__$1 = ((((!((map__19451 == null)))?(((((map__19451.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19451.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19451):map__19451);
var inner_spec_map = map__19451__$1;
var G__19453 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_alt;
var G__19454 = spec;
var G__19455 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19453,G__19454,vec__19448,seq__19449,first__19450,seq__19449__$1,_,map__19451,map__19451__$1,inner_spec_map){
return (function (p1__19447_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19447_SHARP_,accept,options);
});})(G__19453,G__19454,vec__19448,seq__19449,first__19450,seq__19449__$1,_,map__19451,map__19451__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__19456 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19453,G__19454,G__19455,G__19456) : accept.call(null,G__19453,G__19454,G__19455,G__19456));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_cat,(function (spec,accept,options){
var vec__19458 = spec_tools.impl.extract_form(spec);
var seq__19459 = cljs.core.seq(vec__19458);
var first__19460 = cljs.core.first(seq__19459);
var seq__19459__$1 = cljs.core.next(seq__19459);
var _ = first__19460;
var map__19461 = seq__19459__$1;
var map__19461__$1 = ((((!((map__19461 == null)))?(((((map__19461.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19461.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19461):map__19461);
var inner_spec_map = map__19461__$1;
var G__19463 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_cat;
var G__19464 = spec;
var G__19465 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19463,G__19464,vec__19458,seq__19459,first__19460,seq__19459__$1,_,map__19461,map__19461__$1,inner_spec_map){
return (function (p1__19457_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19457_SHARP_,accept,options);
});})(G__19463,G__19464,vec__19458,seq__19459,first__19460,seq__19459__$1,_,map__19461,map__19461__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__19466 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19463,G__19464,G__19465,G__19466) : accept.call(null,G__19463,G__19464,G__19465,G__19466));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__AMPERSAND_,(function (spec,accept,options){
var vec__19467 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19467,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19467,(1),null);
var G__19470 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__AMPERSAND_;
var G__19471 = spec;
var G__19472 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19473 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19470,G__19471,G__19472,G__19473) : accept.call(null,G__19470,G__19471,G__19472,G__19473));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_tuple,(function (spec,accept,options){
var vec__19475 = spec_tools.impl.extract_form(spec);
var seq__19476 = cljs.core.seq(vec__19475);
var first__19477 = cljs.core.first(seq__19476);
var seq__19476__$1 = cljs.core.next(seq__19476);
var _ = first__19477;
var inner_specs = seq__19476__$1;
var G__19478 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_tuple;
var G__19479 = spec;
var G__19480 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19478,G__19479,vec__19475,seq__19476,first__19477,seq__19476__$1,_,inner_specs){
return (function (p1__19474_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19474_SHARP_,accept,options);
});})(G__19478,G__19479,vec__19475,seq__19476,first__19477,seq__19476__$1,_,inner_specs))
,inner_specs);
var G__19481 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19478,G__19479,G__19480,G__19481) : accept.call(null,G__19478,G__19479,G__19480,G__19481));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys_STAR_,(function (spec,accept,options){
var keys = spec_tools.impl.extract_keys(spec_tools.impl.extract_form(spec));
var G__19483 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys_STAR_;
var G__19484 = spec;
var G__19485 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19483,G__19484,keys){
return (function (p1__19482_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19482_SHARP_,accept,options);
});})(G__19483,G__19484,keys))
,keys);
var G__19486 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19483,G__19484,G__19485,G__19486) : accept.call(null,G__19483,G__19484,G__19485,G__19486));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_nilable,(function (spec,accept,options){
var vec__19487 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19487,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19487,(1),null);
var G__19490 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_nilable;
var G__19491 = spec;
var G__19492 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19493 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19490,G__19491,G__19492,G__19493) : accept.call(null,G__19490,G__19491,G__19492,G__19493));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$spec_DASH_tools$core_SLASH_spec,(function (spec,accept,options){
var vec__19494 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19494,(0),null);
var map__19497 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19494,(1),null);
var map__19497__$1 = ((((!((map__19497 == null)))?(((((map__19497.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19497.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19497):map__19497);
var inner_spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19497__$1,cljs.core.cst$kw$spec);
var G__19499 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_spec;
var G__19500 = spec;
var G__19501 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19502 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19499,G__19500,G__19501,G__19502) : accept.call(null,G__19499,G__19500,G__19501,G__19502));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default,(function (spec,accept,options){
var G__19503 = spec_tools.visitor.spec_dispatch(spec,accept,options);
var G__19504 = spec;
var G__19505 = null;
var G__19506 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19503,G__19504,G__19505,G__19506) : accept.call(null,G__19503,G__19504,G__19505,G__19506));
}));
/**
 * a visitor that collects all registered specs. Returns
 *   a map of spec-name => spec.
 */
spec_tools.visitor.spec_collector = (function spec_tools$visitor$spec_collector(){
var specs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (specs){
return (function (_,spec,___$1,___$2){
var temp__5733__auto__ = cljs.spec.alpha.get_spec(spec);
if(cljs.core.truth_(temp__5733__auto__)){
var s = temp__5733__auto__;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(specs,cljs.core.assoc,spec,s);
} else {
return cljs.core.deref(specs);
}
});
;})(specs))
});
