// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('crux.ui.common');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.pprint');
goog.require('clojure.string');
goog.require('crux.ui.navigation');
goog.require('reitit.frontend');
goog.require('reitit.frontend.easy');
goog.require('tick.alpha.api');
goog.require('tick.format');
goog.require('clojure.walk');
goog.require('tick.locale_en_us');
/**
 * k: page handler i.e. :entity
 *   params: path-params map
 *   query: query-params map i.e. {:find '[?eid]'}
 */
crux.ui.common.route__GT_url = (function crux$ui$common$route__GT_url(var_args){
var G__27850 = arguments.length;
switch (G__27850) {
case 1:
return crux.ui.common.route__GT_url.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return crux.ui.common.route__GT_url.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return crux.ui.common.route__GT_url.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

crux.ui.common.route__GT_url.cljs$core$IFn$_invoke$arity$1 = (function (k){
return crux.ui.common.route__GT_url.cljs$core$IFn$_invoke$arity$3(k,null,null);
});

crux.ui.common.route__GT_url.cljs$core$IFn$_invoke$arity$2 = (function (k,params){
return crux.ui.common.route__GT_url.cljs$core$IFn$_invoke$arity$3(k,params,null);
});

crux.ui.common.route__GT_url.cljs$core$IFn$_invoke$arity$3 = (function (k,params,query){
return reitit.frontend.easy.href.cljs$core$IFn$_invoke$arity$3(k,params,query);
});

crux.ui.common.route__GT_url.cljs$lang$maxFixedArity = 3;

/**
 * url: abosolute string path i.e. '/_entity?eid=...'
 */
crux.ui.common.url__GT_route = (function crux$ui$common$url__GT_route(url){
return reitit.frontend.match_by_path((crux.ui.navigation.router.cljs$core$IFn$_invoke$arity$0 ? crux.ui.navigation.router.cljs$core$IFn$_invoke$arity$0() : crux.ui.navigation.router.call(null)),url);
});
crux.ui.common.iso_format_datetime = (function crux$ui$common$iso_format_datetime(dt){
if(cljs.core.truth_(dt)){
return tick.alpha.api.format.cljs$core$IFn$_invoke$arity$2(tick.format.formatter.cljs$core$IFn$_invoke$arity$1("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"),tick.alpha.api.zoned_date_time.cljs$core$IFn$_invoke$arity$1(tick.alpha.api.inst.cljs$core$IFn$_invoke$arity$1(dt)));
} else {
return null;
}
});
/**
 * d: 2020-04-28
 *   t: 15:45:45.935
 */
crux.ui.common.date_time__GT_datetime = (function crux$ui$common$date_time__GT_datetime(d,t){
var G__27852 = (cljs.core.truth_((function (){var and__3938__auto__ = cljs.core.not_empty(d);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not_empty(t);
} else {
return and__3938__auto__;
}
})())?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(tick.alpha.api.date.cljs$core$IFn$_invoke$arity$1(d)),"T",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tick.alpha.api.time.cljs$core$IFn$_invoke$arity$1(t))].join(''):null);
if((G__27852 == null)){
return null;
} else {
return tick.alpha.api.instant.cljs$core$IFn$_invoke$arity$1(G__27852);
}
});
/**
 * dt: 2020-04-28T15:45:45.935
 */
crux.ui.common.datetime__GT_date_time = (function crux$ui$common$datetime__GT_date_time(dt){
if(cljs.core.truth_(cljs.core.not_empty(dt))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$date,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(tick.alpha.api.date.cljs$core$IFn$_invoke$arity$1(dt))].join(''),cljs.core.cst$kw$time,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(tick.alpha.api.time.cljs$core$IFn$_invoke$arity$1(dt))].join('')], null);
} else {
return null;
}
});
crux.ui.common.vectorize = (function crux$ui$common$vectorize(ks,m){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__27854){
var vec__27855 = p__27854;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27855,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27855,(1),null);
if(cljs.core.truth_((function (){var and__3938__auto__ = cljs.core.some(((function (vec__27855,k,v){
return (function (p1__27853_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,p1__27853_SHARP_);
});})(vec__27855,k,v))
,ks);
if(cljs.core.truth_(and__3938__auto__)){
return typeof v === 'string';
} else {
return and__3938__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[v],null))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null);
}
}),m);
});
crux.ui.common.query_params__GT_formatted_edn_string = (function crux$ui$common$query_params__GT_formatted_edn_string(query_params_map){
var temp__5735__auto__ = cljs.core.not_empty((function (){try{return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__27860){
var vec__27861 = p__27860;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27861,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27861,(1),null);
if(cljs.core.vector_QMARK_(v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vec__27861,k,v){
return (function (p1__27858_SHARP_){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(p1__27858_SHARP_);
});})(vec__27861,k,v))
,v)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(v)], null);
}
}),crux.ui.common.vectorize(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$where,cljs.core.cst$kw$args,cljs.core.cst$kw$order_DASH_by], null),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_params_map,cljs.core.cst$kw$valid_DASH_time,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$transaction_DASH_time], 0)))));
}catch (e27859){var _ = e27859;
return cljs.core.PersistentArrayMap.EMPTY;
}})());
if(cljs.core.truth_(temp__5735__auto__)){
var formatted = temp__5735__auto__;
var sb__4462__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_27864_27867 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_27865_27868 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_27864_27867,_STAR_print_fn_STAR_27865_27868,sb__4462__auto__,formatted,temp__5735__auto__){
return (function (x__4463__auto__){
return sb__4462__auto__.append(x__4463__auto__);
});})(_STAR_print_newline_STAR_27864_27867,_STAR_print_fn_STAR_27865_27868,sb__4462__auto__,formatted,temp__5735__auto__))
;

try{var _STAR_print_pprint_dispatch_STAR_27866_27869 = cljs.pprint._STAR_print_pprint_dispatch_STAR_;
cljs.pprint._STAR_print_pprint_dispatch_STAR_ = cljs.pprint.code_dispatch;

try{cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(formatted);
}finally {cljs.pprint._STAR_print_pprint_dispatch_STAR_ = _STAR_print_pprint_dispatch_STAR_27866_27869;
}}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_27865_27868;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_27864_27867;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4462__auto__)].join('');
} else {
return null;
}
});
crux.ui.common.edn__GT_query_params = (function crux$ui$common$edn__GT_query_params(edn){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__27870){
var vec__27871 = p__27870;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27871,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27871,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$where,k)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$args,k)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$order_DASH_by,k))))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.str,v):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join(''))], null);
}),edn));
});
crux.ui.common.scroll_top = (function crux$ui$common$scroll_top(){
document.body.scrollTop = (0);

return document.documentElement.scrollTop = (0);
});
crux.ui.common.arrow_svg = (function crux$ui$common$arrow_svg(toggled_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$class,(cljs.core.truth_(toggled_QMARK_)?"arrow-toggle":"arrow-untoggle"),cljs.core.cst$kw$height,"24",cljs.core.cst$kw$id,"arrow",cljs.core.cst$kw$viewBox,"0 0 24 24",cljs.core.cst$kw$width,"24"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$fill,"#111111"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$path,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$d,"M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"], null)], null)], null)], null);
});
crux.ui.common.sort_map = (function crux$ui$common$sort_map(map){
return clojure.walk.postwalk((function (map__$1){
var G__27874 = map__$1;
if(cljs.core.map_QMARK_(map__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),G__27874);
} else {
return G__27874;
}
}),map);
});
