// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('reitit.frontend.controllers');
goog.require('cljs.core');
goog.require('cljs.core.constants');
reitit.frontend.controllers.pad_same_length = (function reitit$frontend$controllers$pad_same_length(a,b){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a,cljs.core.take.cljs$core$IFn$_invoke$arity$2((cljs.core.count(b) - cljs.core.count(a)),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)));
});
reitit.frontend.controllers.params_warning = (new cljs.core.Delay((function (){
return console.warn("Reitit-frontend controller :params is deprecated. Replace with :identity or :parameters option.");
}),null));
/**
 * Get controller identity given controller and match.
 * 
 *   To select interesting properties from Match :parameters option can be set.
 *   Value should be param-type => [param-key]
 *   Resulting value is map of param-type => param-key => value.
 * 
 *   For other uses, :identity option can be used to provide function from
 *   Match to identity.
 * 
 *   Default value is nil, i.e. controller identity doesn't depend on Match.
 */
reitit.frontend.controllers.get_identity = (function reitit$frontend$controllers$get_identity(p__20228,match){
var map__20229 = p__20228;
var map__20229__$1 = ((((!((map__20229 == null)))?(((((map__20229.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20229.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20229):map__20229);
var identity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20229__$1,cljs.core.cst$kw$identity);
var parameters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20229__$1,cljs.core.cst$kw$parameters);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20229__$1,cljs.core.cst$kw$params);
if(cljs.core.not((function (){var and__3938__auto__ = identity;
if(cljs.core.truth_(and__3938__auto__)){
return parameters;
} else {
return and__3938__auto__;
}
})())){
} else {
throw (new Error(["Assert failed: ","Use either :identity or :parameters for controller, not both.","\n","(not (and identity parameters))"].join('')));
}

if(cljs.core.truth_(params)){
cljs.core.deref(reitit.frontend.controllers.params_warning);
} else {
}

if(cljs.core.truth_(parameters)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4324__auto__ = ((function (map__20229,map__20229__$1,identity,parameters,params){
return (function reitit$frontend$controllers$get_identity_$_iter__20231(s__20232){
return (new cljs.core.LazySeq(null,((function (map__20229,map__20229__$1,identity,parameters,params){
return (function (){
var s__20232__$1 = s__20232;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__20232__$1);
if(temp__5735__auto__){
var s__20232__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__20232__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__20232__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__20234 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__20233 = (0);
while(true){
if((i__20233 < size__4323__auto__)){
var vec__20235 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__20233);
var param_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20235,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20235,(1),null);
cljs.core.chunk_append(b__20234,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_type,cljs.core.select_keys(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$parameters.cljs$core$IFn$_invoke$arity$1(match),param_type),ks)], null));

var G__20241 = (i__20233 + (1));
i__20233 = G__20241;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__20234),reitit$frontend$controllers$get_identity_$_iter__20231(cljs.core.chunk_rest(s__20232__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__20234),null);
}
} else {
var vec__20238 = cljs.core.first(s__20232__$2);
var param_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20238,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20238,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_type,cljs.core.select_keys(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$parameters.cljs$core$IFn$_invoke$arity$1(match),param_type),ks)], null),reitit$frontend$controllers$get_identity_$_iter__20231(cljs.core.rest(s__20232__$2)));
}
} else {
return null;
}
break;
}
});})(map__20229,map__20229__$1,identity,parameters,params))
,null,null));
});})(map__20229,map__20229__$1,identity,parameters,params))
;
return iter__4324__auto__(parameters);
})());
} else {
if(cljs.core.truth_(identity)){
return (identity.cljs$core$IFn$_invoke$arity$1 ? identity.cljs$core$IFn$_invoke$arity$1(match) : identity.call(null,match));
} else {
if(cljs.core.truth_(params)){
return (params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(match) : params.call(null,match));
} else {
return null;

}
}
}
});
/**
 * Run side-effects (:start or :stop) for controller.
 *   The side-effect function is called with controller identity value.
 */
reitit.frontend.controllers.apply_controller = (function reitit$frontend$controllers$apply_controller(controller,method){
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(controller,method);
if(cljs.core.truth_(temp__5735__auto__)){
var f = temp__5735__auto__;
var G__20242 = cljs.core.cst$kw$reitit$frontend$controllers_SLASH_identity.cljs$core$IFn$_invoke$arity$1(controller);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__20242) : f.call(null,G__20242));
} else {
return null;
}
});
/**
 * Applies changes between current controllers and
 *   those previously enabled. Reinitializes controllers whose
 *   identity has changed.
 */
reitit.frontend.controllers.apply_controllers = (function reitit$frontend$controllers$apply_controllers(old_controllers,new_match){
var new_controllers = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (controller){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(controller,cljs.core.cst$kw$reitit$frontend$controllers_SLASH_identity,reitit.frontend.controllers.get_identity(controller,new_match));
}),cljs.core.cst$kw$controllers.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(new_match)));
var changed_controllers = cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (new_controllers){
return (function (old,new$){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old,new$)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old,cljs.core.cst$kw$new,new$], null);
} else {
return null;
}
});})(new_controllers))
,reitit.frontend.controllers.pad_same_length(old_controllers,new_controllers),reitit.frontend.controllers.pad_same_length(new_controllers,old_controllers))));
var seq__20243_20251 = cljs.core.seq(cljs.core.reverse(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$old,changed_controllers)));
var chunk__20244_20252 = null;
var count__20245_20253 = (0);
var i__20246_20254 = (0);
while(true){
if((i__20246_20254 < count__20245_20253)){
var controller_20255 = chunk__20244_20252.cljs$core$IIndexed$_nth$arity$2(null,i__20246_20254);
reitit.frontend.controllers.apply_controller(controller_20255,cljs.core.cst$kw$stop);


var G__20256 = seq__20243_20251;
var G__20257 = chunk__20244_20252;
var G__20258 = count__20245_20253;
var G__20259 = (i__20246_20254 + (1));
seq__20243_20251 = G__20256;
chunk__20244_20252 = G__20257;
count__20245_20253 = G__20258;
i__20246_20254 = G__20259;
continue;
} else {
var temp__5735__auto___20260 = cljs.core.seq(seq__20243_20251);
if(temp__5735__auto___20260){
var seq__20243_20261__$1 = temp__5735__auto___20260;
if(cljs.core.chunked_seq_QMARK_(seq__20243_20261__$1)){
var c__4351__auto___20262 = cljs.core.chunk_first(seq__20243_20261__$1);
var G__20263 = cljs.core.chunk_rest(seq__20243_20261__$1);
var G__20264 = c__4351__auto___20262;
var G__20265 = cljs.core.count(c__4351__auto___20262);
var G__20266 = (0);
seq__20243_20251 = G__20263;
chunk__20244_20252 = G__20264;
count__20245_20253 = G__20265;
i__20246_20254 = G__20266;
continue;
} else {
var controller_20267 = cljs.core.first(seq__20243_20261__$1);
reitit.frontend.controllers.apply_controller(controller_20267,cljs.core.cst$kw$stop);


var G__20268 = cljs.core.next(seq__20243_20261__$1);
var G__20269 = null;
var G__20270 = (0);
var G__20271 = (0);
seq__20243_20251 = G__20268;
chunk__20244_20252 = G__20269;
count__20245_20253 = G__20270;
i__20246_20254 = G__20271;
continue;
}
} else {
}
}
break;
}

var seq__20247_20272 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$new,changed_controllers));
var chunk__20248_20273 = null;
var count__20249_20274 = (0);
var i__20250_20275 = (0);
while(true){
if((i__20250_20275 < count__20249_20274)){
var controller_20276 = chunk__20248_20273.cljs$core$IIndexed$_nth$arity$2(null,i__20250_20275);
reitit.frontend.controllers.apply_controller(controller_20276,cljs.core.cst$kw$start);


var G__20277 = seq__20247_20272;
var G__20278 = chunk__20248_20273;
var G__20279 = count__20249_20274;
var G__20280 = (i__20250_20275 + (1));
seq__20247_20272 = G__20277;
chunk__20248_20273 = G__20278;
count__20249_20274 = G__20279;
i__20250_20275 = G__20280;
continue;
} else {
var temp__5735__auto___20281 = cljs.core.seq(seq__20247_20272);
if(temp__5735__auto___20281){
var seq__20247_20282__$1 = temp__5735__auto___20281;
if(cljs.core.chunked_seq_QMARK_(seq__20247_20282__$1)){
var c__4351__auto___20283 = cljs.core.chunk_first(seq__20247_20282__$1);
var G__20284 = cljs.core.chunk_rest(seq__20247_20282__$1);
var G__20285 = c__4351__auto___20283;
var G__20286 = cljs.core.count(c__4351__auto___20283);
var G__20287 = (0);
seq__20247_20272 = G__20284;
chunk__20248_20273 = G__20285;
count__20249_20274 = G__20286;
i__20250_20275 = G__20287;
continue;
} else {
var controller_20288 = cljs.core.first(seq__20247_20282__$1);
reitit.frontend.controllers.apply_controller(controller_20288,cljs.core.cst$kw$start);


var G__20289 = cljs.core.next(seq__20247_20282__$1);
var G__20290 = null;
var G__20291 = (0);
var G__20292 = (0);
seq__20247_20272 = G__20289;
chunk__20248_20273 = G__20290;
count__20249_20274 = G__20291;
i__20250_20275 = G__20292;
continue;
}
} else {
}
}
break;
}

return new_controllers;
});
