// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('spec_tools.visitor');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.spec.alpha');
goog.require('spec_tools.core');
goog.require('spec_tools.parse');
goog.require('spec_tools.impl');
goog.require('spec_tools.form');
spec_tools.visitor.spec_dispatch = (function spec_tools$visitor$spec_dispatch(spec,accept,options){
if(cljs.core.truth_((function (){var or__3949__auto__ = cljs.spec.alpha.spec_QMARK_(spec);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
var or__3949__auto____$1 = cljs.spec.alpha.regex_QMARK_(spec);
if(cljs.core.truth_(or__3949__auto____$1)){
return or__3949__auto____$1;
} else {
return (spec instanceof cljs.core.Keyword);
}
}
})())){
var form = cljs.spec.alpha.form(spec);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$kw$cljs$spec$alpha_SLASH_unknown)){
if(cljs.core.seq_QMARK_(form)){
return spec_tools.impl.normalize_symbol(cljs.core.first(form));
} else {
return (spec_tools.visitor.spec_dispatch.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.spec_dispatch.cljs$core$IFn$_invoke$arity$3(form,accept,options) : spec_tools.visitor.spec_dispatch.call(null,form,accept,options));
}
} else {
return spec;
}
} else {
if(cljs.core.set_QMARK_(spec)){
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set;
} else {
if(cljs.core.seq_QMARK_(spec)){
return spec_tools.impl.normalize_symbol(cljs.core.first(spec_tools.impl.strip_fn_if_needed(spec)));
} else {
if((spec instanceof cljs.core.Symbol)){
return spec_tools.impl.normalize_symbol(spec);
} else {
return spec_tools.impl.normalize_symbol((spec_tools.form.resolve_form.cljs$core$IFn$_invoke$arity$1 ? spec_tools.form.resolve_form.cljs$core$IFn$_invoke$arity$1(spec) : spec_tools.form.resolve_form.call(null,spec)));

}
}
}
}
});
if((typeof spec_tools !== 'undefined') && (typeof spec_tools.visitor !== 'undefined') && (typeof spec_tools.visitor.visit_spec !== 'undefined')){
} else {
spec_tools.visitor.visit_spec = (function (){var method_table__4414__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4415__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4416__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4417__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4418__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$default,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default], null),cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("spec-tools.visitor","visit-spec"),spec_tools.visitor.spec_dispatch,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default,hierarchy__4418__auto__,method_table__4414__auto__,prefer_table__4415__auto__,method_cache__4416__auto__,cached_hierarchy__4417__auto__));
})();
}
/**
 * Walk a spec definition. Takes 2-3 arguments, the spec and the accept
 *   function, and optionally a options map, and returns the result of
 *   calling the accept function. Options map can be used to pass in context-
 *   specific information to to sub-visits & accepts.
 * 
 *   The accept function is called with 4 arguments: the dispatch term for the
 *   spec (see below), the spec itself, vector with the results of
 *   recursively walking the children of the spec and the options map.
 * 
 *   The dispatch term is one of the following
 *   * if the spec is a function call: a fully qualified symbol for the function
 *  with the following exceptions:
 *  - cljs.core symbols are converted to clojure.core symbols
 *  - cljs.spec.alpha symbols are converted to clojure.spec.alpha symbols
 *   * if the spec is a set: :spec-tools.visitor/set
 *   * otherwise: the spec itself
 */
spec_tools.visitor.visit = (function spec_tools$visitor$visit(var_args){
var G__19516 = arguments.length;
switch (G__19516) {
case 2:
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$2 = (function (spec,accept){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(spec,accept,null);
});

spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3 = (function (spec,accept,p__19517){
var map__19518 = p__19517;
var map__19518__$1 = ((((!((map__19518 == null)))?(((((map__19518.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19518.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19518):map__19518);
var options = map__19518__$1;
var visited = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19518__$1,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_visited);
if(cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(visited,spec))){
var options__$1 = (((spec instanceof cljs.core.Keyword))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(options,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_visited,cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),spec):options);
return (spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3(spec,accept,options__$1) : spec_tools.visitor.visit_spec.call(null,spec,accept,options__$1));
} else {
return (spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3 ? spec_tools.visitor.visit_spec.cljs$core$IFn$_invoke$arity$3(null,accept,options) : spec_tools.visitor.visit_spec.call(null,null,accept,options));
}
});

spec_tools.visitor.visit.cljs$lang$maxFixedArity = 3;

spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set,(function (spec,accept,options){
var G__19521 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set;
var G__19522 = spec;
var G__19523 = cljs.core.vec((((spec instanceof cljs.core.Keyword))?spec_tools.impl.extract_form(spec):spec));
var G__19524 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19521,G__19522,G__19523,G__19524) : accept.call(null,G__19521,G__19522,G__19523,G__19524));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys,(function (spec,accept,options){
var keys = spec_tools.impl.extract_keys(spec_tools.impl.extract_form(spec));
var G__19526 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys;
var G__19527 = spec;
var G__19528 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19526,G__19527,keys){
return (function (p1__19525_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19525_SHARP_,accept,options);
});})(G__19526,G__19527,keys))
,keys);
var G__19529 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19526,G__19527,G__19528,G__19529) : accept.call(null,G__19526,G__19527,G__19528,G__19529));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_or,(function (spec,accept,options){
var vec__19531 = spec_tools.impl.extract_form(spec);
var seq__19532 = cljs.core.seq(vec__19531);
var first__19533 = cljs.core.first(seq__19532);
var seq__19532__$1 = cljs.core.next(seq__19532);
var _ = first__19533;
var map__19534 = seq__19532__$1;
var map__19534__$1 = ((((!((map__19534 == null)))?(((((map__19534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19534.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19534):map__19534);
var inner_spec_map = map__19534__$1;
var G__19536 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_or;
var G__19537 = spec;
var G__19538 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19536,G__19537,vec__19531,seq__19532,first__19533,seq__19532__$1,_,map__19534,map__19534__$1,inner_spec_map){
return (function (p1__19530_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19530_SHARP_,accept,options);
});})(G__19536,G__19537,vec__19531,seq__19532,first__19533,seq__19532__$1,_,map__19534,map__19534__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__19539 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19536,G__19537,G__19538,G__19539) : accept.call(null,G__19536,G__19537,G__19538,G__19539));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_and,(function (spec,accept,options){
var vec__19541 = spec_tools.impl.extract_form(spec);
var seq__19542 = cljs.core.seq(vec__19541);
var first__19543 = cljs.core.first(seq__19542);
var seq__19542__$1 = cljs.core.next(seq__19542);
var _ = first__19543;
var inner_specs = seq__19542__$1;
var G__19544 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_and;
var G__19545 = spec;
var G__19546 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19544,G__19545,vec__19541,seq__19542,first__19543,seq__19542__$1,_,inner_specs){
return (function (p1__19540_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19540_SHARP_,accept,options);
});})(G__19544,G__19545,vec__19541,seq__19542,first__19543,seq__19542__$1,_,inner_specs))
,inner_specs);
var G__19547 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19544,G__19545,G__19546,G__19547) : accept.call(null,G__19544,G__19545,G__19546,G__19547));
}));
spec_tools.visitor.visit_merge = (function spec_tools$visitor$visit_merge(spec,accept,options){
var vec__19549 = spec_tools.impl.extract_form(spec);
var seq__19550 = cljs.core.seq(vec__19549);
var first__19551 = cljs.core.first(seq__19550);
var seq__19550__$1 = cljs.core.next(seq__19550);
var _ = first__19551;
var inner_specs = seq__19550__$1;
var G__19552 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_merge;
var G__19553 = spec;
var G__19554 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19552,G__19553,vec__19549,seq__19550,first__19551,seq__19550__$1,_,inner_specs){
return (function (p1__19548_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19548_SHARP_,accept,options);
});})(G__19552,G__19553,vec__19549,seq__19550,first__19551,seq__19550__$1,_,inner_specs))
,inner_specs);
var G__19555 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19552,G__19553,G__19554,G__19555) : accept.call(null,G__19552,G__19553,G__19554,G__19555));
});
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_merge,(function (spec,accept,options){
return spec_tools.visitor.visit_merge(spec,accept,options);
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$spec_DASH_tools$core_SLASH_merge,(function (spec,accept,options){
return spec_tools.visitor.visit_merge(spec,accept,options);
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_every,(function (spec,accept,options){
var vec__19556 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19556,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19556,(1),null);
var G__19559 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_every;
var G__19560 = spec;
var G__19561 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19562 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19559,G__19560,G__19561,G__19562) : accept.call(null,G__19559,G__19560,G__19561,G__19562));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_every_DASH_kv,(function (spec,accept,options){
var vec__19564 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19564,(0),null);
var inner_spec1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19564,(1),null);
var inner_spec2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19564,(2),null);
var G__19567 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_every_DASH_kv;
var G__19568 = spec;
var G__19569 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19567,G__19568,vec__19564,_,inner_spec1,inner_spec2){
return (function (p1__19563_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19563_SHARP_,accept,options);
});})(G__19567,G__19568,vec__19564,_,inner_spec1,inner_spec2))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [inner_spec1,inner_spec2], null));
var G__19570 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19567,G__19568,G__19569,G__19570) : accept.call(null,G__19567,G__19568,G__19569,G__19570));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_coll_DASH_of,(function (spec,accept,options){
var form = spec_tools.impl.extract_form(spec);
var pred = cljs.core.second(form);
var map__19571 = spec_tools.parse.parse_spec(form);
var map__19571__$1 = ((((!((map__19571 == null)))?(((((map__19571.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19571.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19571):map__19571);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19571__$1,cljs.core.cst$kw$type);
var dispatch = (function (){var G__19573 = type;
var G__19573__$1 = (((G__19573 instanceof cljs.core.Keyword))?G__19573.fqn:null);
switch (G__19573__$1) {
case "map-of":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_map_DASH_of;

break;
case "set":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_set_DASH_of;

break;
case "vector":
return cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_vector_DASH_of;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19573__$1)].join('')));

}
})();
var G__19574 = dispatch;
var G__19575 = spec;
var G__19576 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(pred,accept,options)], null);
var G__19577 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19574,G__19575,G__19576,G__19577) : accept.call(null,G__19574,G__19575,G__19576,G__19577));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_map_DASH_of,(function (spec,accept,options){
var vec__19580 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19580,(0),null);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19580,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19580,(2),null);
var G__19583 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_map_DASH_of;
var G__19584 = spec;
var G__19585 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19583,G__19584,vec__19580,_,k,v){
return (function (p1__19579_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19579_SHARP_,accept,options);
});})(G__19583,G__19584,vec__19580,_,k,v))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));
var G__19586 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19583,G__19584,G__19585,G__19586) : accept.call(null,G__19583,G__19584,G__19585,G__19586));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__STAR_,(function (spec,accept,options){
var vec__19587 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19587,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19587,(1),null);
var G__19590 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__STAR_;
var G__19591 = spec;
var G__19592 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19593 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19590,G__19591,G__19592,G__19593) : accept.call(null,G__19590,G__19591,G__19592,G__19593));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__PLUS_,(function (spec,accept,options){
var vec__19594 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19594,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19594,(1),null);
var G__19597 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__PLUS_;
var G__19598 = spec;
var G__19599 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19600 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19597,G__19598,G__19599,G__19600) : accept.call(null,G__19597,G__19598,G__19599,G__19600));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__QMARK_,(function (spec,accept,options){
var vec__19601 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19601,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19601,(1),null);
var G__19604 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__QMARK_;
var G__19605 = spec;
var G__19606 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19607 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19604,G__19605,G__19606,G__19607) : accept.call(null,G__19604,G__19605,G__19606,G__19607));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_alt,(function (spec,accept,options){
var vec__19609 = spec_tools.impl.extract_form(spec);
var seq__19610 = cljs.core.seq(vec__19609);
var first__19611 = cljs.core.first(seq__19610);
var seq__19610__$1 = cljs.core.next(seq__19610);
var _ = first__19611;
var map__19612 = seq__19610__$1;
var map__19612__$1 = ((((!((map__19612 == null)))?(((((map__19612.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19612.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19612):map__19612);
var inner_spec_map = map__19612__$1;
var G__19614 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_alt;
var G__19615 = spec;
var G__19616 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19614,G__19615,vec__19609,seq__19610,first__19611,seq__19610__$1,_,map__19612,map__19612__$1,inner_spec_map){
return (function (p1__19608_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19608_SHARP_,accept,options);
});})(G__19614,G__19615,vec__19609,seq__19610,first__19611,seq__19610__$1,_,map__19612,map__19612__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__19617 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19614,G__19615,G__19616,G__19617) : accept.call(null,G__19614,G__19615,G__19616,G__19617));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_cat,(function (spec,accept,options){
var vec__19619 = spec_tools.impl.extract_form(spec);
var seq__19620 = cljs.core.seq(vec__19619);
var first__19621 = cljs.core.first(seq__19620);
var seq__19620__$1 = cljs.core.next(seq__19620);
var _ = first__19621;
var map__19622 = seq__19620__$1;
var map__19622__$1 = ((((!((map__19622 == null)))?(((((map__19622.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19622.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19622):map__19622);
var inner_spec_map = map__19622__$1;
var G__19624 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_cat;
var G__19625 = spec;
var G__19626 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19624,G__19625,vec__19619,seq__19620,first__19621,seq__19620__$1,_,map__19622,map__19622__$1,inner_spec_map){
return (function (p1__19618_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19618_SHARP_,accept,options);
});})(G__19624,G__19625,vec__19619,seq__19620,first__19621,seq__19620__$1,_,map__19622,map__19622__$1,inner_spec_map))
,cljs.core.vals(inner_spec_map));
var G__19627 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19624,G__19625,G__19626,G__19627) : accept.call(null,G__19624,G__19625,G__19626,G__19627));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH__AMPERSAND_,(function (spec,accept,options){
var vec__19628 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19628,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19628,(1),null);
var G__19631 = cljs.core.cst$sym$clojure$spec$alpha_SLASH__AMPERSAND_;
var G__19632 = spec;
var G__19633 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19634 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19631,G__19632,G__19633,G__19634) : accept.call(null,G__19631,G__19632,G__19633,G__19634));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_tuple,(function (spec,accept,options){
var vec__19636 = spec_tools.impl.extract_form(spec);
var seq__19637 = cljs.core.seq(vec__19636);
var first__19638 = cljs.core.first(seq__19637);
var seq__19637__$1 = cljs.core.next(seq__19637);
var _ = first__19638;
var inner_specs = seq__19637__$1;
var G__19639 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_tuple;
var G__19640 = spec;
var G__19641 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19639,G__19640,vec__19636,seq__19637,first__19638,seq__19637__$1,_,inner_specs){
return (function (p1__19635_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19635_SHARP_,accept,options);
});})(G__19639,G__19640,vec__19636,seq__19637,first__19638,seq__19637__$1,_,inner_specs))
,inner_specs);
var G__19642 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19639,G__19640,G__19641,G__19642) : accept.call(null,G__19639,G__19640,G__19641,G__19642));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys_STAR_,(function (spec,accept,options){
var keys = spec_tools.impl.extract_keys(spec_tools.impl.extract_form(spec));
var G__19644 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_keys_STAR_;
var G__19645 = spec;
var G__19646 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__19644,G__19645,keys){
return (function (p1__19643_SHARP_){
return spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(p1__19643_SHARP_,accept,options);
});})(G__19644,G__19645,keys))
,keys);
var G__19647 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19644,G__19645,G__19646,G__19647) : accept.call(null,G__19644,G__19645,G__19646,G__19647));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$clojure$spec$alpha_SLASH_nilable,(function (spec,accept,options){
var vec__19648 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19648,(0),null);
var inner_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19648,(1),null);
var G__19651 = cljs.core.cst$sym$clojure$spec$alpha_SLASH_nilable;
var G__19652 = spec;
var G__19653 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19654 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19651,G__19652,G__19653,G__19654) : accept.call(null,G__19651,G__19652,G__19653,G__19654));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$sym$spec_DASH_tools$core_SLASH_spec,(function (spec,accept,options){
var vec__19655 = spec_tools.impl.extract_form(spec);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19655,(0),null);
var map__19658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19655,(1),null);
var map__19658__$1 = ((((!((map__19658 == null)))?(((((map__19658.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19658.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19658):map__19658);
var inner_spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19658__$1,cljs.core.cst$kw$spec);
var G__19660 = cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_spec;
var G__19661 = spec;
var G__19662 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec_tools.visitor.visit.cljs$core$IFn$_invoke$arity$3(inner_spec,accept,options)], null);
var G__19663 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19660,G__19661,G__19662,G__19663) : accept.call(null,G__19660,G__19661,G__19662,G__19663));
}));
spec_tools.visitor.visit_spec.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$spec_DASH_tools$visitor_SLASH_default,(function (spec,accept,options){
var G__19664 = spec_tools.visitor.spec_dispatch(spec,accept,options);
var G__19665 = spec;
var G__19666 = null;
var G__19667 = options;
return (accept.cljs$core$IFn$_invoke$arity$4 ? accept.cljs$core$IFn$_invoke$arity$4(G__19664,G__19665,G__19666,G__19667) : accept.call(null,G__19664,G__19665,G__19666,G__19667));
}));
/**
 * a visitor that collects all registered specs. Returns
 *   a map of spec-name => spec.
 */
spec_tools.visitor.spec_collector = (function spec_tools$visitor$spec_collector(){
var specs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (specs){
return (function (_,spec,___$1,___$2){
var temp__5733__auto__ = cljs.spec.alpha.get_spec(spec);
if(cljs.core.truth_(temp__5733__auto__)){
var s = temp__5733__auto__;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(specs,cljs.core.assoc,spec,s);
} else {
return cljs.core.deref(specs);
}
});
;})(specs))
});
