// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('ajax.xml_http_request');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('ajax.protocols');
goog.require('goog.string');
ajax.xml_http_request.ready_state = (function ajax$xml_http_request$ready_state(e){
var G__28195 = e.target.readyState;
var fexpr__28194 = new cljs.core.PersistentArrayMap(null, 5, [(0),cljs.core.cst$kw$not_DASH_initialized,(1),cljs.core.cst$kw$connection_DASH_established,(2),cljs.core.cst$kw$request_DASH_received,(3),cljs.core.cst$kw$processing_DASH_request,(4),cljs.core.cst$kw$response_DASH_ready], null);
return (fexpr__28194.cljs$core$IFn$_invoke$arity$1 ? fexpr__28194.cljs$core$IFn$_invoke$arity$1(G__28195) : fexpr__28194.call(null,G__28195));
});
ajax.xml_http_request.append = (function ajax$xml_http_request$append(current,next){
if(cljs.core.truth_(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current),", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(next)].join('');
} else {
return next;
}
});
ajax.xml_http_request.process_headers = (function ajax$xml_http_request$process_headers(header_str){
if(cljs.core.truth_(header_str)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (headers,header_line){
if(cljs.core.truth_(goog.string.isEmptyOrWhitespace(header_line))){
return headers;
} else {
var key_value = goog.string.splitLimit(header_line,": ",(2));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(headers,(key_value[(0)]),ajax.xml_http_request.append,(key_value[(1)]));
}
}),cljs.core.PersistentArrayMap.EMPTY,header_str.split("\r\n"));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
ajax.xml_http_request.xmlhttprequest = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?(function (){var xmlhttprequest = require("xmlhttprequest").XMLHttpRequest;
goog.object.set(global,"XMLHttpRequest",xmlhttprequest);

return xmlhttprequest;
})():XMLHttpRequest);
ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$ = cljs.core.PROTOCOL_SENTINEL;

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$_js_ajax_request$arity$3 = (function (this$,p__28197,handler){
var map__28198 = p__28197;
var map__28198__$1 = ((((!((map__28198 == null)))?(((((map__28198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28198.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28198):map__28198);
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28198__$1,cljs.core.cst$kw$uri);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28198__$1,cljs.core.cst$kw$method);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28198__$1,cljs.core.cst$kw$body);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28198__$1,cljs.core.cst$kw$headers);
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28198__$1,cljs.core.cst$kw$timeout,(0));
var with_credentials = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28198__$1,cljs.core.cst$kw$with_DASH_credentials,false);
var response_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28198__$1,cljs.core.cst$kw$response_DASH_format);
var this$__$1 = this;
this$__$1.withCredentials = with_credentials;

this$__$1.onreadystatechange = ((function (this$__$1,map__28198,map__28198__$1,uri,method,body,headers,timeout,with_credentials,response_format){
return (function (p1__28196_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$response_DASH_ready,ajax.xml_http_request.ready_state(p1__28196_SHARP_))){
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(this$__$1) : handler.call(null,this$__$1));
} else {
return null;
}
});})(this$__$1,map__28198,map__28198__$1,uri,method,body,headers,timeout,with_credentials,response_format))
;

this$__$1.open(method,uri,true);

this$__$1.timeout = timeout;

var temp__5735__auto___28210 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(response_format);
if(cljs.core.truth_(temp__5735__auto___28210)){
var response_type_28211 = temp__5735__auto___28210;
this$__$1.responseType = cljs.core.name(response_type_28211);
} else {
}

var seq__28200_28212 = cljs.core.seq(headers);
var chunk__28201_28213 = null;
var count__28202_28214 = (0);
var i__28203_28215 = (0);
while(true){
if((i__28203_28215 < count__28202_28214)){
var vec__28204_28216 = chunk__28201_28213.cljs$core$IIndexed$_nth$arity$2(null,i__28203_28215);
var k_28217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28204_28216,(0),null);
var v_28218 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28204_28216,(1),null);
this$__$1.setRequestHeader(k_28217,v_28218);


var G__28219 = seq__28200_28212;
var G__28220 = chunk__28201_28213;
var G__28221 = count__28202_28214;
var G__28222 = (i__28203_28215 + (1));
seq__28200_28212 = G__28219;
chunk__28201_28213 = G__28220;
count__28202_28214 = G__28221;
i__28203_28215 = G__28222;
continue;
} else {
var temp__5735__auto___28223 = cljs.core.seq(seq__28200_28212);
if(temp__5735__auto___28223){
var seq__28200_28224__$1 = temp__5735__auto___28223;
if(cljs.core.chunked_seq_QMARK_(seq__28200_28224__$1)){
var c__4351__auto___28225 = cljs.core.chunk_first(seq__28200_28224__$1);
var G__28226 = cljs.core.chunk_rest(seq__28200_28224__$1);
var G__28227 = c__4351__auto___28225;
var G__28228 = cljs.core.count(c__4351__auto___28225);
var G__28229 = (0);
seq__28200_28212 = G__28226;
chunk__28201_28213 = G__28227;
count__28202_28214 = G__28228;
i__28203_28215 = G__28229;
continue;
} else {
var vec__28207_28230 = cljs.core.first(seq__28200_28224__$1);
var k_28231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28207_28230,(0),null);
var v_28232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28207_28230,(1),null);
this$__$1.setRequestHeader(k_28231,v_28232);


var G__28233 = cljs.core.next(seq__28200_28224__$1);
var G__28234 = null;
var G__28235 = (0);
var G__28236 = (0);
seq__28200_28212 = G__28233;
chunk__28201_28213 = G__28234;
count__28202_28214 = G__28235;
i__28203_28215 = G__28236;
continue;
}
} else {
}
}
break;
}

this$__$1.send((function (){var or__3949__auto__ = body;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})());

return this$__$1;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$ = cljs.core.PROTOCOL_SENTINEL;

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort();
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$ = cljs.core.PROTOCOL_SENTINEL;

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.response;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.status;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.statusText;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_all_headers$arity$1 = (function (this$){
var this$__$1 = this;
return ajax.xml_http_request.process_headers(this$__$1.getAllResponseHeaders());
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),this$__$1.readyState);
});
