// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__21006){
var vec__21007 = p__21006;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21007,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21007,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__21010 = clojure.data.diff(va,vb);
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21010,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21010,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21010,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = ((in_a) && (in_b) && (((!((ab == null))) || ((((va == null)) && ((vb == null)))))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((((in_a) && (((!((a_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),((((in_b) && (((!((b_STAR_ == null))) || (!(same))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__21014 = arguments.length;
switch (G__21014) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__4037__auto__ = cljs.core.count(a);
var y__4038__auto__ = cljs.core.count(b);
return ((x__4037__auto__ > y__4038__auto__) ? x__4037__auto__ : y__4038__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if(((!((x == null))) && (!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null))))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__4243__auto__ = (((x == null))?null:x);
var m__4244__auto__ = (clojure.data.equality_partition[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto__.call(null,x));
} else {
var m__4244__auto____$1 = (clojure.data.equality_partition["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4244__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if(((!((a == null))) && (!((a.clojure$data$Diff$diff_similar$arity$2 == null))))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__4243__auto__ = (((a == null))?null:a);
var m__4244__auto__ = (clojure.data.diff_similar[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__4244__auto__.call(null,a,b));
} else {
var m__4244__auto____$1 = (clojure.data.diff_similar["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(a,b) : m__4244__auto____$1.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__21016_21040 = clojure.data.equality_partition;
var G__21017_21041 = "null";
var G__21018_21042 = ((function (G__21016_21040,G__21017_21041){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__21016_21040,G__21017_21041))
;
goog.object.set(G__21016_21040,G__21017_21041,G__21018_21042);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__21019_21043 = clojure.data.equality_partition;
var G__21020_21044 = "string";
var G__21021_21045 = ((function (G__21019_21043,G__21020_21044){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__21019_21043,G__21020_21044))
;
goog.object.set(G__21019_21043,G__21020_21044,G__21021_21045);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__21022_21046 = clojure.data.equality_partition;
var G__21023_21047 = "number";
var G__21024_21048 = ((function (G__21022_21046,G__21023_21047){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__21022_21046,G__21023_21047))
;
goog.object.set(G__21022_21046,G__21023_21047,G__21024_21048);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__21025_21049 = clojure.data.equality_partition;
var G__21026_21050 = "array";
var G__21027_21051 = ((function (G__21025_21049,G__21026_21050){
return (function (x){
return cljs.core.cst$kw$sequential;
});})(G__21025_21049,G__21026_21050))
;
goog.object.set(G__21025_21049,G__21026_21050,G__21027_21051);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__21028_21052 = clojure.data.equality_partition;
var G__21029_21053 = "function";
var G__21030_21054 = ((function (G__21028_21052,G__21029_21053){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__21028_21052,G__21029_21053))
;
goog.object.set(G__21028_21052,G__21029_21053,G__21030_21054);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__21031_21055 = clojure.data.equality_partition;
var G__21032_21056 = "boolean";
var G__21033_21057 = ((function (G__21031_21055,G__21032_21056){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__21031_21055,G__21032_21056))
;
goog.object.set(G__21031_21055,G__21032_21056,G__21033_21057);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__21034_21058 = clojure.data.equality_partition;
var G__21035_21059 = "_";
var G__21036_21060 = ((function (G__21034_21058,G__21035_21059){
return (function (x){
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return cljs.core.cst$kw$map;
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return cljs.core.cst$kw$set;
} else {
if(((!((x == null)))?(((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return cljs.core.cst$kw$sequential;
} else {
return cljs.core.cst$kw$atom;

}
}
}
});})(G__21034_21058,G__21035_21059))
;
goog.object.set(G__21034_21058,G__21035_21059,G__21036_21060);
goog.object.set(clojure.data.Diff,"null",true);

var G__21061_21085 = clojure.data.diff_similar;
var G__21062_21086 = "null";
var G__21063_21087 = ((function (G__21061_21085,G__21062_21086){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__21061_21085,G__21062_21086))
;
goog.object.set(G__21061_21085,G__21062_21086,G__21063_21087);

goog.object.set(clojure.data.Diff,"string",true);

var G__21064_21088 = clojure.data.diff_similar;
var G__21065_21089 = "string";
var G__21066_21090 = ((function (G__21064_21088,G__21065_21089){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__21064_21088,G__21065_21089))
;
goog.object.set(G__21064_21088,G__21065_21089,G__21066_21090);

goog.object.set(clojure.data.Diff,"number",true);

var G__21067_21091 = clojure.data.diff_similar;
var G__21068_21092 = "number";
var G__21069_21093 = ((function (G__21067_21091,G__21068_21092){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__21067_21091,G__21068_21092))
;
goog.object.set(G__21067_21091,G__21068_21092,G__21069_21093);

goog.object.set(clojure.data.Diff,"array",true);

var G__21070_21094 = clojure.data.diff_similar;
var G__21071_21095 = "array";
var G__21072_21096 = ((function (G__21070_21094,G__21071_21095){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__21070_21094,G__21071_21095))
;
goog.object.set(G__21070_21094,G__21071_21095,G__21072_21096);

goog.object.set(clojure.data.Diff,"function",true);

var G__21073_21097 = clojure.data.diff_similar;
var G__21074_21098 = "function";
var G__21075_21099 = ((function (G__21073_21097,G__21074_21098){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__21073_21097,G__21074_21098))
;
goog.object.set(G__21073_21097,G__21074_21098,G__21075_21099);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__21076_21100 = clojure.data.diff_similar;
var G__21077_21101 = "boolean";
var G__21078_21102 = ((function (G__21076_21100,G__21077_21101){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__21076_21100,G__21077_21101))
;
goog.object.set(G__21076_21100,G__21077_21101,G__21078_21102);

goog.object.set(clojure.data.Diff,"_",true);

var G__21079_21103 = clojure.data.diff_similar;
var G__21080_21104 = "_";
var G__21081_21105 = ((function (G__21079_21103,G__21080_21104){
return (function (a,b){
var fexpr__21083 = (function (){var G__21084 = clojure.data.equality_partition(a);
var G__21084__$1 = (((G__21084 instanceof cljs.core.Keyword))?G__21084.fqn:null);
switch (G__21084__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__21084__$1)].join('')));

}
})();
return (fexpr__21083.cljs$core$IFn$_invoke$arity$2 ? fexpr__21083.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__21083.call(null,a,b));
});})(G__21079_21103,G__21080_21104))
;
goog.object.set(G__21079_21103,G__21080_21104,G__21081_21105);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});
