// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('crux.ui.views');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.pprint');
goog.require('cljs.reader');
goog.require('crux.ui.events');
goog.require('crux.ui.codemirror');
goog.require('crux.ui.common');
goog.require('crux.ui.subscriptions');
goog.require('crux.ui.uikit.table');
goog.require('crux.ui.tab_bar');
goog.require('crux.ui.collapsible');
goog.require('fork.core');
goog.require('reagent.core');
goog.require('re_frame.core');
crux.ui.views.vt_tt_inputs = (function crux$ui$views$vt_tt_inputs(p__29288,component){
var map__29289 = p__29288;
var map__29289__$1 = ((((!((map__29289 == null)))?(((((map__29289.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29289.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29289):map__29289);
var values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29289__$1,cljs.core.cst$kw$values);
var touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29289__$1,cljs.core.cst$kw$touched);
var errors = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29289__$1,cljs.core.cst$kw$errors);
var handle_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29289__$1,cljs.core.cst$kw$handle_DASH_change);
var handle_blur = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29289__$1,cljs.core.cst$kw$handle_DASH_blur);
var show_vt_QMARK_ = cljs.core.deref((function (){var G__29291 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_show_DASH_vt_QMARK_,component], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29291) : re_frame.core.subscribe.call(null,G__29291));
})());
var show_tt_QMARK_ = cljs.core.deref((function (){var G__29292 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_show_DASH_tt_QMARK_,component], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29292) : re_frame.core.subscribe.call(null,G__29292));
})());
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$crux_DASH_time,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$checkbox,cljs.core.cst$kw$checked,show_vt_QMARK_,cljs.core.cst$kw$on_DASH_change,((function (show_vt_QMARK_,show_tt_QMARK_,map__29289,map__29289__$1,values,touched,errors,handle_change,handle_blur){
return (function (){
var G__29293 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_toggle_DASH_show_DASH_vt,component,show_vt_QMARK_], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__29293) : re_frame.core.dispatch.call(null,G__29293));
});})(show_vt_QMARK_,show_tt_QMARK_,map__29289,map__29289__$1,values,touched,errors,handle_change,handle_blur))
], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_group_DASH_label$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,"Valid Time"], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_(show_vt_QMARK_)?null:"hidden")], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$input$input_DASH_time,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"date",cljs.core.cst$kw$name,"vtd",cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"vtd"),cljs.core.cst$kw$on_DASH_change,handle_change,cljs.core.cst$kw$on_DASH_blur,handle_blur], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$input$input_DASH_time,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"time",cljs.core.cst$kw$name,"vtt",cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"vtt"),cljs.core.cst$kw$on_DASH_change,handle_change,cljs.core.cst$kw$on_DASH_blur,handle_blur], null)], null),(cljs.core.truth_((function (){var and__3938__auto__ = (function (){var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(touched,"vtd");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(touched,"vtt");
}
})();
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"vt");
} else {
return and__3938__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$input_DASH_error,cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"vt")], null):null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$crux_DASH_time,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$checkbox,cljs.core.cst$kw$checked,show_tt_QMARK_,cljs.core.cst$kw$on_DASH_change,((function (show_vt_QMARK_,show_tt_QMARK_,map__29289,map__29289__$1,values,touched,errors,handle_change,handle_blur){
return (function (){
var G__29294 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_toggle_DASH_show_DASH_tt,component,show_tt_QMARK_], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__29294) : re_frame.core.dispatch.call(null,G__29294));
});})(show_vt_QMARK_,show_tt_QMARK_,map__29289,map__29289__$1,values,touched,errors,handle_change,handle_blur))
], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_group_DASH_label$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,"Transaction Time"], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_(show_tt_QMARK_)?null:"hidden")], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$input$input_DASH_time,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"date",cljs.core.cst$kw$name,"ttd",cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"ttd"),cljs.core.cst$kw$on_DASH_change,handle_change,cljs.core.cst$kw$on_DASH_blur,handle_blur], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$input$input_DASH_time,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"time",cljs.core.cst$kw$name,"ttt",cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"ttt"),cljs.core.cst$kw$on_DASH_change,handle_change,cljs.core.cst$kw$on_DASH_blur,handle_blur], null)], null),(cljs.core.truth_((function (){var and__3938__auto__ = (function (){var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(touched,"ttd");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(touched,"ttt");
}
})();
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"tt");
} else {
return and__3938__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$input_DASH_error,cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"tt")], null):null)], null)], null)], null);
});
crux.ui.views.vt_tt_entity_box = (function crux$ui$views$vt_tt_entity_box(vt,tt){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_vt_DASH_tt,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_vt_DASH_tt__title,"Valid Time"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_vt_DASH_tt__value,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(vt)].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_vt_DASH_tt__title,"Transaction Time"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_vt_DASH_tt__value,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(tt)].join('')], null)], null);
});
crux.ui.views.query_validation = (function crux$ui$views$query_validation(values){
var empty_string_QMARK_ = (function (p1__29295_SHARP_){
return cljs.core.empty_QMARK_(clojure.string.trim((function (){var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,p1__29295_SHARP_);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})()));
});
var invalid_query_QMARK_ = (function (){try{var query_edn = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"q"));
if((query_edn == null)){
return "Query box is empty";
} else {
if(!(cljs.core.contains_QMARK_(query_edn,cljs.core.cst$kw$find))){
return "Query doesn't contain a 'find' clause";
} else {
if(!(cljs.core.contains_QMARK_(query_edn,cljs.core.cst$kw$where))){
return "Query doesn't contain a 'where' clause";
} else {
return null;
}
}
}
}catch (e29300){if((e29300 instanceof Error)){
var e = e29300;
return ["Error reading query - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e.message)].join('');
} else {
throw e29300;

}
}})();
var validation = new cljs.core.PersistentArrayMap(null, 3, ["q",invalid_query_QMARK_,"vt",(cljs.core.truth_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,(function (){var fexpr__29301 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(((function (empty_string_QMARK_,invalid_query_QMARK_){
return (function (p1__29296_SHARP_){
return (p1__29296_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29296_SHARP_.cljs$core$IFn$_invoke$arity$1("vtd") : p1__29296_SHARP_.call(null,"vtd"));
});})(empty_string_QMARK_,invalid_query_QMARK_))
,((function (empty_string_QMARK_,invalid_query_QMARK_){
return (function (p1__29297_SHARP_){
return (p1__29297_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29297_SHARP_.cljs$core$IFn$_invoke$arity$1("vtt") : p1__29297_SHARP_.call(null,"vtt"));
});})(empty_string_QMARK_,invalid_query_QMARK_))
);
return (fexpr__29301.cljs$core$IFn$_invoke$arity$1 ? fexpr__29301.cljs$core$IFn$_invoke$arity$1(empty_string_QMARK_) : fexpr__29301.call(null,empty_string_QMARK_));
})()))?"Fill out both inputs or none":null),"tt",(cljs.core.truth_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,(function (){var fexpr__29302 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(((function (empty_string_QMARK_,invalid_query_QMARK_){
return (function (p1__29298_SHARP_){
return (p1__29298_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29298_SHARP_.cljs$core$IFn$_invoke$arity$1("ttd") : p1__29298_SHARP_.call(null,"ttd"));
});})(empty_string_QMARK_,invalid_query_QMARK_))
,((function (empty_string_QMARK_,invalid_query_QMARK_){
return (function (p1__29299_SHARP_){
return (p1__29299_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29299_SHARP_.cljs$core$IFn$_invoke$arity$1("ttt") : p1__29299_SHARP_.call(null,"ttt"));
});})(empty_string_QMARK_,invalid_query_QMARK_))
);
return (fexpr__29302.cljs$core$IFn$_invoke$arity$1 ? fexpr__29302.cljs$core$IFn$_invoke$arity$1(empty_string_QMARK_) : fexpr__29302.call(null,empty_string_QMARK_));
})()))?"Fill out both inputs or none":null)], null);
if(cljs.core.truth_(cljs.core.some(cljs.core.some_QMARK_,cljs.core.vals(validation)))){
return validation;
} else {
return null;
}
});
crux.ui.views.submit_form_on_keypress = (function crux$ui$views$submit_form_on_keypress(evt,form_id){
if(cljs.core.truth_((function (){var and__3938__auto__ = evt.ctrlKey;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((13),evt.keyCode);
} else {
return and__3938__auto__;
}
})())){
var form_button = document.querySelector([cljs.core.str.cljs$core$IFn$_invoke$arity$1(form_id)," button"].join(''));
return form_button.click();
} else {
return null;
}
});
crux.ui.views.edit_query = (function crux$ui$views$edit_query(_props){
var cm_instance = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
return ((function (cm_instance){
return (function (p__29304){
var map__29305 = p__29304;
var map__29305__$1 = ((((!((map__29305 == null)))?(((((map__29305.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29305.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29305):map__29305);
var props = map__29305__$1;
var values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29305__$1,cljs.core.cst$kw$values);
var errors = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29305__$1,cljs.core.cst$kw$errors);
var touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29305__$1,cljs.core.cst$kw$touched);
var set_values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29305__$1,cljs.core.cst$kw$set_DASH_values);
var set_touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29305__$1,cljs.core.cst$kw$set_DASH_touched);
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29305__$1,cljs.core.cst$kw$form_DASH_id);
var handle_submit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29305__$1,cljs.core.cst$kw$handle_DASH_submit);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_textarea,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_mirror,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"q"),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$cm_DASH_instance,cm_instance,cljs.core.cst$kw$class,"cm-textarea__query",cljs.core.cst$kw$on_DASH_change,((function (map__29305,map__29305__$1,props,values,errors,touched,set_values,set_touched,form_id,handle_submit,cm_instance){
return (function (p1__29303_SHARP_){
var G__29307 = new cljs.core.PersistentArrayMap(null, 1, ["q",p1__29303_SHARP_], null);
return (set_values.cljs$core$IFn$_invoke$arity$1 ? set_values.cljs$core$IFn$_invoke$arity$1(G__29307) : set_values.call(null,G__29307));
});})(map__29305,map__29305__$1,props,values,errors,touched,set_values,set_touched,form_id,handle_submit,cm_instance))
,cljs.core.cst$kw$on_DASH_blur,((function (map__29305,map__29305__$1,props,values,errors,touched,set_values,set_touched,form_id,handle_submit,cm_instance){
return (function (){
return (set_touched.cljs$core$IFn$_invoke$arity$1 ? set_touched.cljs$core$IFn$_invoke$arity$1("q") : set_touched.call(null,"q"));
});})(map__29305,map__29305__$1,props,values,errors,touched,set_values,set_touched,form_id,handle_submit,cm_instance))
], null)], null)], null),(cljs.core.truth_((function (){var and__3938__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(touched,"q");
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"q");
} else {
return and__3938__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$input_DASH_error,cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"q")], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_inputs,props,cljs.core.cst$kw$query], null)], null);
});
;})(cm_instance))
});
crux.ui.views.query_history = (function crux$ui$views$query_history(){
var query_history_list = cljs.core.deref((function (){var G__29308 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_form_DASH_history], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29308) : re_frame.core.subscribe.call(null,G__29308));
})());
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_pane__history_DASH_scrollable,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (query_history_list){
return (function (idx,p__29309){
var map__29310 = p__29309;
var map__29310__$1 = ((((!((map__29310 == null)))?(((((map__29310.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29310.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29310):map__29310);
var history_q = map__29310__$1;
var q = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29310__$1,"q");
var valid_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29310__$1,"valid-time");
var transaction_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29310__$1,"transaction-time");
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_pane__history_DASH_scrollable_DASH_el,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_pane__history_DASH_delete,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (map__29310,map__29310__$1,history_q,q,valid_time,transaction_time,query_history_list){
return (function (){
var G__29312 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_remove_DASH_query_DASH_from_DASH_local_DASH_storage,idx], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__29312) : re_frame.core.dispatch.call(null,G__29312));
});})(map__29310,map__29310__$1,history_q,q,valid_time,transaction_time,query_history_list))
], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fas$fa_DASH_trash_DASH_alt], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_pane__history_DASH_scrollable_DASH_el_DASH_left,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (map__29310,map__29310__$1,history_q,q,valid_time,transaction_time,query_history_list){
return (function (){
var G__29313 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_go_DASH_to_DASH_historical_DASH_query,history_q], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__29313) : re_frame.core.dispatch.call(null,G__29313));
});})(map__29310,map__29310__$1,history_q,q,valid_time,transaction_time,query_history_list))
], null),(cljs.core.truth_(valid_time)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin_DASH_bottom,"1rem"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$form_DASH_pane__history_DASH_headings,"Valid Time: "], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$form_DASH_pane__history_DASH_txt,valid_time], null)], null):null),(cljs.core.truth_(transaction_time)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$form_DASH_pane__history_DASH_headings,"Transaction Time: "], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$form_DASH_pane__history_DASH_txt,transaction_time], null)], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin_DASH_top,"1rem"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_mirror_static,q,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,"cm-textarea__query"], null)], null)], null)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null));
});})(query_history_list))
,query_history_list)], null);
});
crux.ui.views.query_form = (function crux$ui$views$query_form(){
var form_id = "#form-query";
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (form_id){
return (function (){
return document.querySelector(form_id).addEventListener("keydown",((function (form_id){
return (function (p1__29314_SHARP_){
return crux.ui.views.submit_form_on_keypress(p1__29314_SHARP_,form_id);
});})(form_id))
,true);
});})(form_id))
,cljs.core.cst$kw$component_DASH_will_DASH_unmount,((function (form_id){
return (function (){
return document.querySelector(form_id).removeEventListener("keydown",((function (form_id){
return (function (p1__29315_SHARP_){
return crux.ui.views.submit_form_on_keypress(p1__29315_SHARP_,form_id);
});})(form_id))
,true);
});})(form_id))
,cljs.core.cst$kw$reagent_DASH_render,((function (form_id){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fork.core.form,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$form_DASH_id,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(form_id,(1)),cljs.core.cst$kw$validation,crux.ui.views.query_validation,cljs.core.cst$kw$prevent_DASH_default_QMARK_,true,cljs.core.cst$kw$clean_DASH_on_DASH_unmount_QMARK_,true,cljs.core.cst$kw$initial_DASH_values,cljs.core.deref((function (){var G__29317 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_initial_DASH_values_DASH_query], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29317) : re_frame.core.subscribe.call(null,G__29317));
})()),cljs.core.cst$kw$on_DASH_submit,((function (form_id){
return (function (p1__29316_SHARP_){
var G__29318 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_go_DASH_to_DASH_query_DASH_view,p1__29316_SHARP_], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__29318) : re_frame.core.dispatch.call(null,G__29318));
});})(form_id))
], null),((function (form_id){
return (function (p__29319){
var map__29320 = p__29319;
var map__29320__$1 = ((((!((map__29320 == null)))?(((((map__29320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29320.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29320):map__29320);
var props = map__29320__$1;
var values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29320__$1,cljs.core.cst$kw$values);
var errors = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29320__$1,cljs.core.cst$kw$errors);
var touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29320__$1,cljs.core.cst$kw$touched);
var set_values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29320__$1,cljs.core.cst$kw$set_DASH_values);
var set_touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29320__$1,cljs.core.cst$kw$set_DASH_touched);
var form_id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29320__$1,cljs.core.cst$kw$form_DASH_id);
var handle_submit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29320__$1,cljs.core.cst$kw$handle_DASH_submit);
var loading_QMARK_ = cljs.core.deref((function (){var G__29322 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_result_DASH_pane_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29322) : re_frame.core.subscribe.call(null,G__29322));
})());
var disabled_QMARK_ = (function (){var or__3949__auto__ = loading_QMARK_;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.some(cljs.core.some_QMARK_,cljs.core.vals(errors));
}
})();
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id,form_id__$1,cljs.core.cst$kw$on_DASH_submit,handle_submit], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.collapsible.collapsible,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$views_SLASH_query_DASH_form,cljs.core.cst$kw$crux$ui$views_SLASH_query_DASH_editor], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,"Query Editor"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.tab_bar.tab_bar,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tabs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$k,cljs.core.cst$kw$edit_DASH_query,cljs.core.cst$kw$label,"Edit Query"], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$k,cljs.core.cst$kw$recent_DASH_queries,cljs.core.cst$kw$label,"Recent Queries"], null)], null),cljs.core.cst$kw$current_DASH_tab,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_form_DASH_tab], null),cljs.core.cst$kw$on_DASH_tab_DASH_selected,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_query_DASH_form_DASH_tab_DASH_selected], null)], null)], null),(function (){var G__29323 = cljs.core.deref((function (){var G__29324 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_form_DASH_tab], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29324) : re_frame.core.subscribe.call(null,G__29324));
})());
var G__29323__$1 = (((G__29323 instanceof cljs.core.Keyword))?G__29323.fqn:null);
switch (G__29323__$1) {
case "edit-query":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.edit_query,props], null);

break;
case "recent-queries":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.query_history], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29323__$1)].join('')));

}
})()], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$button,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$class,(cljs.core.truth_(disabled_QMARK_)?null:"form__button"),cljs.core.cst$kw$disabled,disabled_QMARK_], null),"Run Query"], null)], null)], null);
});})(form_id))
], null);
});})(form_id))
], null));
});
crux.ui.views.query_table = (function crux$ui$views$query_table(){
var map__29326 = cljs.core.deref((function (){var G__29327 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_data_DASH_table], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29327) : re_frame.core.subscribe.call(null,G__29327));
})());
var map__29326__$1 = ((((!((map__29326 == null)))?(((((map__29326.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29326.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29326):map__29326);
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29326__$1,cljs.core.cst$kw$error);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29326__$1,cljs.core.cst$kw$data);
var loading_QMARK_ = cljs.core.deref((function (){var G__29329 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_result_DASH_pane_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29329) : re_frame.core.subscribe.call(null,G__29329));
})());
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,(cljs.core.truth_(error)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$error_DASH_box,error], null):(cljs.core.truth_((function (){var and__3938__auto__ = cljs.core.cst$kw$rows.cljs$core$IFn$_invoke$arity$1(data);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.empty_QMARK_(cljs.core.cst$kw$rows.cljs$core$IFn$_invoke$arity$1(data));
} else {
return and__3938__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$no_DASH_results,"No results found!"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$query_DASH_table_DASH_downloads,"Download as:",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$query_DASH_table_DASH_downloads__link,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,cljs.core.deref((function (){var G__29330 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_data_DASH_download_DASH_link,"csv"], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29330) : re_frame.core.subscribe.call(null,G__29330));
})())], null),"CSV"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$query_DASH_table_DASH_downloads__link,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,cljs.core.deref((function (){var G__29331 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_data_DASH_download_DASH_link,"tsv"], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29331) : re_frame.core.subscribe.call(null,G__29331));
})())], null),"TSV"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.uikit.table.table,data], null)], null)
))], null);
});
crux.ui.views.query_pane = (function crux$ui$views$query_pane(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.query_form], null),(cljs.core.truth_(cljs.core.deref((function (){var G__29332 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_submitted_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29332) : re_frame.core.subscribe.call(null,G__29332));
})()))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.query_table], null):null)], null);
});
crux.ui.views.entity_validation = (function crux$ui$views$entity_validation(values){
var empty_string_QMARK_ = (function (p1__29333_SHARP_){
return cljs.core.empty_QMARK_(clojure.string.trim((function (){var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,p1__29333_SHARP_);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})()));
});
var validation = new cljs.core.PersistentArrayMap(null, 3, ["eid",(cljs.core.truth_(empty_string_QMARK_("eid"))?"Entity id is empty":null),"vt",(cljs.core.truth_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,(function (){var fexpr__29338 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(((function (empty_string_QMARK_){
return (function (p1__29334_SHARP_){
return (p1__29334_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29334_SHARP_.cljs$core$IFn$_invoke$arity$1("vtd") : p1__29334_SHARP_.call(null,"vtd"));
});})(empty_string_QMARK_))
,((function (empty_string_QMARK_){
return (function (p1__29335_SHARP_){
return (p1__29335_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29335_SHARP_.cljs$core$IFn$_invoke$arity$1("vtt") : p1__29335_SHARP_.call(null,"vtt"));
});})(empty_string_QMARK_))
);
return (fexpr__29338.cljs$core$IFn$_invoke$arity$1 ? fexpr__29338.cljs$core$IFn$_invoke$arity$1(empty_string_QMARK_) : fexpr__29338.call(null,empty_string_QMARK_));
})()))?"Fill out both inputs or none":null),"tt",(cljs.core.truth_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,(function (){var fexpr__29339 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(((function (empty_string_QMARK_){
return (function (p1__29336_SHARP_){
return (p1__29336_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29336_SHARP_.cljs$core$IFn$_invoke$arity$1("ttd") : p1__29336_SHARP_.call(null,"ttd"));
});})(empty_string_QMARK_))
,((function (empty_string_QMARK_){
return (function (p1__29337_SHARP_){
return (p1__29337_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29337_SHARP_.cljs$core$IFn$_invoke$arity$1("ttt") : p1__29337_SHARP_.call(null,"ttt"));
});})(empty_string_QMARK_))
);
return (fexpr__29339.cljs$core$IFn$_invoke$arity$1 ? fexpr__29339.cljs$core$IFn$_invoke$arity$1(empty_string_QMARK_) : fexpr__29339.call(null,empty_string_QMARK_));
})()))?"Fill out both inputs or none":null)], null);
if(cljs.core.truth_(cljs.core.some(cljs.core.some_QMARK_,cljs.core.vals(validation)))){
return validation;
} else {
return null;
}
});
crux.ui.views.entity_form = (function crux$ui$views$entity_form(){
var form_id = "#form-entity";
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (form_id){
return (function (){
return document.querySelector(form_id).addEventListener("keydown",((function (form_id){
return (function (p1__29340_SHARP_){
return crux.ui.views.submit_form_on_keypress(p1__29340_SHARP_,form_id);
});})(form_id))
,true);
});})(form_id))
,cljs.core.cst$kw$component_DASH_will_DASH_unmount,((function (form_id){
return (function (){
return document.querySelector(form_id).removeEventListener("keydown",((function (form_id){
return (function (p1__29341_SHARP_){
return crux.ui.views.submit_form_on_keypress(p1__29341_SHARP_,form_id);
});})(form_id))
,true);
});})(form_id))
,cljs.core.cst$kw$reagent_DASH_render,((function (form_id){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fork.core.form,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$form_DASH_id,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(form_id,(1)),cljs.core.cst$kw$prevent_DASH_default_QMARK_,true,cljs.core.cst$kw$clean_DASH_on_DASH_unmount_QMARK_,true,cljs.core.cst$kw$validation,crux.ui.views.entity_validation,cljs.core.cst$kw$initial_DASH_values,cljs.core.deref((function (){var G__29343 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_initial_DASH_values_DASH_entity], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29343) : re_frame.core.subscribe.call(null,G__29343));
})()),cljs.core.cst$kw$on_DASH_submit,((function (form_id){
return (function (p1__29342_SHARP_){
var G__29344 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_go_DASH_to_DASH_entity_DASH_view,p1__29342_SHARP_], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__29344) : re_frame.core.dispatch.call(null,G__29344));
});})(form_id))
], null),((function (form_id){
return (function (p__29345){
var map__29346 = p__29345;
var map__29346__$1 = ((((!((map__29346 == null)))?(((((map__29346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29346.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29346):map__29346);
var props = map__29346__$1;
var form_id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29346__$1,cljs.core.cst$kw$form_DASH_id);
var handle_blur = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29346__$1,cljs.core.cst$kw$handle_DASH_blur);
var set_values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29346__$1,cljs.core.cst$kw$set_DASH_values);
var errors = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29346__$1,cljs.core.cst$kw$errors);
var handle_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29346__$1,cljs.core.cst$kw$handle_DASH_change);
var handle_submit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29346__$1,cljs.core.cst$kw$handle_DASH_submit);
var set_touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29346__$1,cljs.core.cst$kw$set_DASH_touched);
var touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29346__$1,cljs.core.cst$kw$touched);
var values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29346__$1,cljs.core.cst$kw$values);
var loading_QMARK_ = cljs.core.deref((function (){var G__29348 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29348) : re_frame.core.subscribe.call(null,G__29348));
})());
var disabled_QMARK_ = (function (){var or__3949__auto__ = loading_QMARK_;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.some(cljs.core.some_QMARK_,cljs.core.vals(errors));
}
})();
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id,form_id__$1,cljs.core.cst$kw$on_DASH_submit,handle_submit], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_form__input_DASH_line,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$padding_DASH_right,"1rem"], null)], null),"Entity ID:"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$monospace$entity_DASH_form__input,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$type,"text",cljs.core.cst$kw$name,"eid",cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"eid"),cljs.core.cst$kw$placeholder,":foo",cljs.core.cst$kw$on_DASH_change,handle_change,cljs.core.cst$kw$on_DASH_blur,handle_blur], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_inputs,props,cljs.core.cst$kw$entity], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$button_DASH_line,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$button,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$class,(cljs.core.truth_(disabled_QMARK_)?null:"form__button"),cljs.core.cst$kw$disabled,disabled_QMARK_], null),"Fetch"], null)], null)], null);
});})(form_id))
], null);
});})(form_id))
], null));
});
crux.ui.views.entity_document = (function crux$ui$views$entity_document(){
var _BANG_raw_edn_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return ((function (_BANG_raw_edn_QMARK_){
return (function (){
var map__29349 = cljs.core.deref((function (){var G__29350 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_document], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29350) : re_frame.core.subscribe.call(null,G__29350));
})());
var map__29349__$1 = ((((!((map__29349 == null)))?(((((map__29349.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29349.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29349):map__29349);
var eid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29349__$1,cljs.core.cst$kw$eid);
var vt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29349__$1,cljs.core.cst$kw$vt);
var tt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29349__$1,cljs.core.cst$kw$tt);
var document = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29349__$1,cljs.core.cst$kw$document);
var linked_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29349__$1,cljs.core.cst$kw$linked_DASH_entities);
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29349__$1,cljs.core.cst$kw$error);
var loading_QMARK_ = cljs.core.deref((function (){var G__29352 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29352) : re_frame.core.subscribe.call(null,G__29352));
})());
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_diffs__options,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_checkbox__group,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_diffs__checkbox,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$checked,cljs.core.deref(_BANG_raw_edn_QMARK_),cljs.core.cst$kw$on_DASH_change,((function (map__29349,map__29349__$1,eid,vt,tt,document,linked_entities,error,loading_QMARK_,_BANG_raw_edn_QMARK_){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(_BANG_raw_edn_QMARK_,cljs.core.not);
});})(map__29349,map__29349__$1,eid,vt,tt,document,linked_entities,error,loading_QMARK_,_BANG_raw_edn_QMARK_))
,cljs.core.cst$kw$type,"checkbox"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,"Raw EDN"], null)], null)], null),(cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map$entity_DASH_map_DASH__DASH_loading,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fas$fa_DASH_spinner$entity_DASH_map__load_DASH_icon], null)], null):(cljs.core.truth_(error)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$error_DASH_box,error], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map__container,(cljs.core.truth_(cljs.core.deref(_BANG_raw_edn_QMARK_))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_raw_DASH_edn,(function (){var sb__4462__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_29353_29355 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_29354_29356 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_29353_29355,_STAR_print_fn_STAR_29354_29356,sb__4462__auto__,map__29349,map__29349__$1,eid,vt,tt,document,linked_entities,error,loading_QMARK_,_BANG_raw_edn_QMARK_){
return (function (x__4463__auto__){
return sb__4462__auto__.append(x__4463__auto__);
});})(_STAR_print_newline_STAR_29353_29355,_STAR_print_fn_STAR_29354_29356,sb__4462__auto__,map__29349,map__29349__$1,eid,vt,tt,document,linked_entities,error,loading_QMARK_,_BANG_raw_edn_QMARK_))
;

try{cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(document);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_29354_29356;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_29353_29355;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4462__auto__)].join('');
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$views_SLASH_div$entity_DASH_map,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,document,linked_entities], null)], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,vt,tt], null)], null)))], null);
});
;})(_BANG_raw_edn_QMARK_))
});
crux.ui.views.entity_history_document = (function crux$ui$views$entity_history_document(){
var _BANG_diffs_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return ((function (_BANG_diffs_QMARK_){
return (function (){
var diffs_QMARK_ = cljs.core.deref(_BANG_diffs_QMARK_);
var entity_error = cljs.core.deref((function (){var G__29358 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_document_DASH_error], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29358) : re_frame.core.subscribe.call(null,G__29358));
})());
var loading_QMARK_ = cljs.core.deref((function (){var G__29359 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29359) : re_frame.core.subscribe.call(null,G__29359));
})());
var map__29357 = cljs.core.deref((function (){var G__29360 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_current_DASH_route], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29360) : re_frame.core.subscribe.call(null,G__29360));
})());
var map__29357__$1 = ((((!((map__29357 == null)))?(((((map__29357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29357.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29357):map__29357);
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29357__$1,cljs.core.cst$kw$query_DASH_params);
var path_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29357__$1,cljs.core.cst$kw$path_DASH_params);
var asc_order_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("asc",cljs.core.cst$kw$sort_DASH_order.cljs$core$IFn$_invoke$arity$1(query_params));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_diffs__options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$select$history_DASH_sorting_DASH_group,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,"diffs-order",cljs.core.cst$kw$value,cljs.core.cst$kw$sort_DASH_order.cljs$core$IFn$_invoke$arity$1(query_params),cljs.core.cst$kw$on_DASH_change,((function (diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function (){
var G__29362 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$navigate,cljs.core.cst$kw$entity,path_params,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_params,cljs.core.cst$kw$sort_DASH_order,((asc_order_QMARK_)?"desc":"asc"))], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__29362) : re_frame.core.dispatch.call(null,G__29362));
});})(diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"asc"], null),"Ascending"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"desc"], null),"Descending"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_checkbox__group,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_diffs__checkbox,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$checked,diffs_QMARK_,cljs.core.cst$kw$on_DASH_change,((function (diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(_BANG_diffs_QMARK_,cljs.core.not);
});})(diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
,cljs.core.cst$kw$type,"checkbox"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,"Diffs"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_histories__container,(cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map$entity_DASH_map_DASH__DASH_loading,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fas$fa_DASH_spinner$entity_DASH_map__load_DASH_icon], null)], null):(cljs.core.truth_(entity_error)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$error_DASH_box,entity_error], null):((cljs.core.not(diffs_QMARK_))?(function (){var map__29363 = cljs.core.deref((function (){var G__29364 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_history], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29364) : re_frame.core.subscribe.call(null,G__29364));
})());
var map__29363__$1 = ((((!((map__29363 == null)))?(((((map__29363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29363.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29363):map__29363);
var entity_history = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29363__$1,cljs.core.cst$kw$entity_DASH_history);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_histories,(function (){var iter__4324__auto__ = ((function (map__29363,map__29363__$1,entity_history,diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function crux$ui$views$entity_history_document_$_iter__29366(s__29367){
return (new cljs.core.LazySeq(null,((function (map__29363,map__29363__$1,entity_history,diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function (){
var s__29367__$1 = s__29367;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__29367__$1);
if(temp__5735__auto__){
var s__29367__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29367__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__29367__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__29369 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__29368 = (0);
while(true){
if((i__29368 < size__4323__auto__)){
var map__29370 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__29368);
var map__29370__$1 = ((((!((map__29370 == null)))?(((((map__29370.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29370.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29370):map__29370);
var history_elem = map__29370__$1;
var tx_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29370__$1,cljs.core.cst$kw$crux$tx_SLASH_tx_DASH_time);
var valid_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29370__$1,cljs.core.cst$kw$crux$db_SLASH_valid_DASH_time);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29370__$1,cljs.core.cst$kw$crux$db_SLASH_doc);
cljs.core.chunk_append(b__29369,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_history__container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,doc,cljs.core.PersistentArrayMap.EMPTY], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,valid_time,tx_time], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,history_elem], null)));

var G__29385 = (i__29368 + (1));
i__29368 = G__29385;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29369),crux$ui$views$entity_history_document_$_iter__29366(cljs.core.chunk_rest(s__29367__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29369),null);
}
} else {
var map__29372 = cljs.core.first(s__29367__$2);
var map__29372__$1 = ((((!((map__29372 == null)))?(((((map__29372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29372.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29372):map__29372);
var history_elem = map__29372__$1;
var tx_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29372__$1,cljs.core.cst$kw$crux$tx_SLASH_tx_DASH_time);
var valid_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29372__$1,cljs.core.cst$kw$crux$db_SLASH_valid_DASH_time);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29372__$1,cljs.core.cst$kw$crux$db_SLASH_doc);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_history__container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,doc,cljs.core.PersistentArrayMap.EMPTY], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,valid_time,tx_time], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,history_elem], null)),crux$ui$views$entity_history_document_$_iter__29366(cljs.core.rest(s__29367__$2)));
}
} else {
return null;
}
break;
}
});})(map__29363,map__29363__$1,entity_history,diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
,null,null));
});})(map__29363,map__29363__$1,entity_history,diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
;
return iter__4324__auto__(entity_history);
})()], null);
})():(cljs.core.truth_(diffs_QMARK_)?(function (){var map__29374 = cljs.core.deref((function (){var G__29375 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_history_DASH_diffs], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29375) : re_frame.core.subscribe.call(null,G__29375));
})());
var map__29374__$1 = ((((!((map__29374 == null)))?(((((map__29374.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29374.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29374):map__29374);
var up_to_date_doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29374__$1,cljs.core.cst$kw$up_DASH_to_DASH_date_DASH_doc);
var history_diffs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29374__$1,cljs.core.cst$kw$history_DASH_diffs);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_histories,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_history__container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,cljs.core.cst$kw$crux$db_SLASH_doc.cljs$core$IFn$_invoke$arity$1(up_to_date_doc),cljs.core.PersistentArrayMap.EMPTY], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,cljs.core.cst$kw$crux$db_SLASH_valid_DASH_time.cljs$core$IFn$_invoke$arity$1(up_to_date_doc),cljs.core.cst$kw$crux$tx_SLASH_tx_DASH_time.cljs$core$IFn$_invoke$arity$1(up_to_date_doc)], null)], null),(function (){var iter__4324__auto__ = ((function (map__29374,map__29374__$1,up_to_date_doc,history_diffs,diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function crux$ui$views$entity_history_document_$_iter__29377(s__29378){
return (new cljs.core.LazySeq(null,((function (map__29374,map__29374__$1,up_to_date_doc,history_diffs,diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function (){
var s__29378__$1 = s__29378;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__29378__$1);
if(temp__5735__auto__){
var s__29378__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29378__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__29378__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__29380 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__29379 = (0);
while(true){
if((i__29379 < size__4323__auto__)){
var map__29381 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__29379);
var map__29381__$1 = ((((!((map__29381 == null)))?(((((map__29381.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29381.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29381):map__29381);
var history_elem = map__29381__$1;
var additions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29381__$1,cljs.core.cst$kw$additions);
var deletions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29381__$1,cljs.core.cst$kw$deletions);
var tx_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29381__$1,cljs.core.cst$kw$crux$tx_SLASH_tx_DASH_time);
var valid_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29381__$1,cljs.core.cst$kw$crux$db_SLASH_valid_DASH_time);
cljs.core.chunk_append(b__29380,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_history__container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map__diffs_DASH_group,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map,(cljs.core.truth_(additions)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"green"], null)], null),"+ Additions:"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,additions,cljs.core.PersistentArrayMap.EMPTY], null)], null):null),(cljs.core.truth_(deletions)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"red"], null)], null),"- Deletions:"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,deletions,cljs.core.PersistentArrayMap.EMPTY], null)], null):null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,valid_time,tx_time], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,history_elem], null)));

var G__29386 = (i__29379 + (1));
i__29379 = G__29386;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29380),crux$ui$views$entity_history_document_$_iter__29377(cljs.core.chunk_rest(s__29378__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29380),null);
}
} else {
var map__29383 = cljs.core.first(s__29378__$2);
var map__29383__$1 = ((((!((map__29383 == null)))?(((((map__29383.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29383.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29383):map__29383);
var history_elem = map__29383__$1;
var additions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29383__$1,cljs.core.cst$kw$additions);
var deletions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29383__$1,cljs.core.cst$kw$deletions);
var tx_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29383__$1,cljs.core.cst$kw$crux$tx_SLASH_tx_DASH_time);
var valid_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29383__$1,cljs.core.cst$kw$crux$db_SLASH_valid_DASH_time);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_history__container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map__diffs_DASH_group,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map,(cljs.core.truth_(additions)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"green"], null)], null),"+ Additions:"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,additions,cljs.core.PersistentArrayMap.EMPTY], null)], null):null),(cljs.core.truth_(deletions)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"red"], null)], null),"- Deletions:"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,deletions,cljs.core.PersistentArrayMap.EMPTY], null)], null):null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,valid_time,tx_time], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,history_elem], null)),crux$ui$views$entity_history_document_$_iter__29377(cljs.core.rest(s__29378__$2)));
}
} else {
return null;
}
break;
}
});})(map__29374,map__29374__$1,up_to_date_doc,history_diffs,diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
,null,null));
});})(map__29374,map__29374__$1,up_to_date_doc,history_diffs,diffs_QMARK_,entity_error,loading_QMARK_,map__29357,map__29357__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
;
return iter__4324__auto__(history_diffs);
})()], null);
})():null
))))], null)], null);
});
;})(_BANG_diffs_QMARK_))
});
crux.ui.views.entity_pane = (function crux$ui$views$entity_pane(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.entity_form], null),(cljs.core.truth_(cljs.core.deref((function (){var G__29387 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_eid_DASH_submitted_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29387) : re_frame.core.subscribe.call(null,G__29387));
})()))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.tab_bar.tab_bar,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tabs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$k,cljs.core.cst$kw$document,cljs.core.cst$kw$label,"Document",cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_set_DASH_entity_DASH_pane_DASH_document], null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$k,cljs.core.cst$kw$history,cljs.core.cst$kw$label,"History",cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_set_DASH_entity_DASH_pane_DASH_history], null)], null)], null),cljs.core.cst$kw$current_DASH_tab,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_pane_DASH_tab], null),cljs.core.cst$kw$on_DASH_tab_DASH_selected,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_entity_DASH_pane_DASH_tab_DASH_selected], null)], null)], null),(function (){var G__29388 = cljs.core.deref((function (){var G__29389 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_pane_DASH_tab], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29389) : re_frame.core.subscribe.call(null,G__29389));
})());
var G__29388__$1 = (((G__29388 instanceof cljs.core.Keyword))?G__29388.fqn:null);
switch (G__29388__$1) {
case "document":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.entity_document], null);

break;
case "history":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.entity_history_document], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29388__$1)].join('')));

}
})()], null):null)], null);
});
crux.ui.views.console_pane = (function crux$ui$views$console_pane(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.tab_bar.tab_bar,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tabs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$k,cljs.core.cst$kw$query,cljs.core.cst$kw$label,"Query"], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$k,cljs.core.cst$kw$entity,cljs.core.cst$kw$label,"Entity"], null)], null),cljs.core.cst$kw$current_DASH_tab,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_console_DASH_tab], null),cljs.core.cst$kw$on_DASH_tab_DASH_selected,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_console_DASH_tab_DASH_selected], null)], null)], null),(function (){var G__29391 = cljs.core.deref((function (){var G__29392 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_console_DASH_tab], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29392) : re_frame.core.subscribe.call(null,G__29392));
})());
var G__29391__$1 = (((G__29391 instanceof cljs.core.Keyword))?G__29391.fqn:null);
switch (G__29391__$1) {
case "query":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.query_pane], null);

break;
case "entity":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.entity_pane], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29391__$1)].join('')));

}
})()], null);
});
crux.ui.views.status_map__GT_html_elements = (function crux$ui$views$status_map__GT_html_elements(status_map){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dl$node_DASH_info__content], null),cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__29394){
var vec__29395 = p__29394;
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29395,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29395,(1),null);
if(cljs.core.truth_(value)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dt,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$b,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('')], null)], null),((cljs.core.map_QMARK_(value))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dd,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dl], null),cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(((function (vec__29395,key,value){
return (function (p__29398){
var vec__29399 = p__29398;
var key__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29399,(0),null);
var value__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29399,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dt,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$b,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(key__$1)].join('')], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dd,(function (){var sb__4462__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_29402_29406 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_29403_29407 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_29402_29406,_STAR_print_fn_STAR_29403_29407,sb__4462__auto__,vec__29399,key__$1,value__$1,vec__29395,key,value){
return (function (x__4463__auto__){
return sb__4462__auto__.append(x__4463__auto__);
});})(_STAR_print_newline_STAR_29402_29406,_STAR_print_fn_STAR_29403_29407,sb__4462__auto__,vec__29399,key__$1,value__$1,vec__29395,key,value))
;

try{cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(value__$1);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_29403_29407;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_29402_29406;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4462__auto__)].join('');
})()], null)], null);
});})(vec__29395,key,value))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dd,(function (){var sb__4462__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_29404_29408 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_29405_29409 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_29404_29408,_STAR_print_fn_STAR_29405_29409,sb__4462__auto__,vec__29395,key,value){
return (function (x__4463__auto__){
return sb__4462__auto__.append(x__4463__auto__);
});})(_STAR_print_newline_STAR_29404_29408,_STAR_print_fn_STAR_29405_29409,sb__4462__auto__,vec__29395,key,value))
;

try{cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(value);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_29405_29409;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_29404_29408;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4462__auto__)].join('');
})()], null)
)], null);
} else {
return null;
}
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([crux.ui.common.sort_map(status_map)], 0)));
});
crux.ui.views.status_page = (function crux$ui$views$status_page(){
var status_map = cljs.core.deref((function (){var G__29410 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_node_DASH_status], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29410) : re_frame.core.subscribe.call(null,G__29410));
})());
var options_map = cljs.core.deref((function (){var G__29411 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_node_DASH_options], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29411) : re_frame.core.subscribe.call(null,G__29411));
})());
var loading_QMARK_ = cljs.core.deref((function (){var G__29412 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_node_DASH_status_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29412) : re_frame.core.subscribe.call(null,G__29412));
})());
if(((!((loading_QMARK_ == null))) && (cljs.core.not(loading_QMARK_)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$node_DASH_info__container,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$node_DASH_info,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h2$node_DASH_info__title,"Node Status"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.status_map__GT_html_elements,status_map], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$node_DASH_info,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h2$node_DASH_info__title,"Node Options"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.status_map__GT_html_elements,options_map], null)], null)], null);
} else {
return null;
}
});
crux.ui.views.root_page = (function crux$ui$views$root_page(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$root_DASH_page,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$root_DASH_background], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$root_DASH_contents,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h1$root_DASH_title,"Welcome to the Crux Console!"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h2$root_DASH_video__title,"Take a short video tour:"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$iframe$root_DASH_video,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,"https://www.youtube.com/embed/StXLmWvb5Xs",cljs.core.cst$kw$allow,"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$root_DASH_get_DASH_started,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,crux.ui.common.route__GT_url.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$query)], null),"Start exploring your Crux node"], null)], null)], null);
});
crux.ui.views.view = (function crux$ui$views$view(){
var map__29413 = cljs.core.deref((function (){var G__29415 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_current_DASH_route], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__29415) : re_frame.core.subscribe.call(null,G__29415));
})());
var map__29413__$1 = ((((!((map__29413 == null)))?(((((map__29413.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29413.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29413):map__29413);
var map__29414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29413__$1,cljs.core.cst$kw$data);
var map__29414__$1 = ((((!((map__29414 == null)))?(((((map__29414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29414):map__29414);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29414__$1,cljs.core.cst$kw$name);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$container$page_DASH_pane,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$kw$homepage))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.root_page], null):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$kw$status))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.status_page], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.console_pane], null)
))], null);
});
