// Compiled by ClojureScript 1.10.339 {:static-fns true, :optimize-constants true}
goog.provide('crux.ui.views');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.pprint');
goog.require('cljs.reader');
goog.require('crux.ui.events');
goog.require('crux.ui.codemirror');
goog.require('crux.ui.common');
goog.require('crux.ui.subscriptions');
goog.require('crux.ui.uikit.table');
goog.require('crux.ui.tab_bar');
goog.require('crux.ui.collapsible');
goog.require('fork.core');
goog.require('reagent.core');
goog.require('re_frame.core');
crux.ui.views.vt_tt_inputs = (function crux$ui$views$vt_tt_inputs(p__23516,component){
var map__23517 = p__23516;
var map__23517__$1 = ((((!((map__23517 == null)))?(((((map__23517.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23517.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23517):map__23517);
var values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23517__$1,cljs.core.cst$kw$values);
var touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23517__$1,cljs.core.cst$kw$touched);
var errors = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23517__$1,cljs.core.cst$kw$errors);
var handle_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23517__$1,cljs.core.cst$kw$handle_DASH_change);
var handle_blur = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23517__$1,cljs.core.cst$kw$handle_DASH_blur);
var show_vt_QMARK_ = cljs.core.deref((function (){var G__23519 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_show_DASH_vt_QMARK_,component], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23519) : re_frame.core.subscribe.call(null,G__23519));
})());
var show_tt_QMARK_ = cljs.core.deref((function (){var G__23520 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_show_DASH_tt_QMARK_,component], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23520) : re_frame.core.subscribe.call(null,G__23520));
})());
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$crux_DASH_time,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$checkbox,cljs.core.cst$kw$checked,show_vt_QMARK_,cljs.core.cst$kw$on_DASH_change,((function (show_vt_QMARK_,show_tt_QMARK_,map__23517,map__23517__$1,values,touched,errors,handle_change,handle_blur){
return (function (){
var G__23521 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_toggle_DASH_show_DASH_vt,component,show_vt_QMARK_], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__23521) : re_frame.core.dispatch.call(null,G__23521));
});})(show_vt_QMARK_,show_tt_QMARK_,map__23517,map__23517__$1,values,touched,errors,handle_change,handle_blur))
], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_group_DASH_label$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,"Valid Time"], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_(show_vt_QMARK_)?null:"hidden")], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$input$input_DASH_time,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"date",cljs.core.cst$kw$name,"vtd",cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"vtd"),cljs.core.cst$kw$on_DASH_change,handle_change,cljs.core.cst$kw$on_DASH_blur,handle_blur], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$input$input_DASH_time,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"time",cljs.core.cst$kw$name,"vtt",cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"vtt"),cljs.core.cst$kw$on_DASH_change,handle_change,cljs.core.cst$kw$on_DASH_blur,handle_blur], null)], null),(cljs.core.truth_((function (){var and__3938__auto__ = (function (){var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(touched,"vtd");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(touched,"vtt");
}
})();
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"vt");
} else {
return and__3938__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$input_DASH_error,cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"vt")], null):null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$crux_DASH_time,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$checkbox,cljs.core.cst$kw$checked,show_tt_QMARK_,cljs.core.cst$kw$on_DASH_change,((function (show_vt_QMARK_,show_tt_QMARK_,map__23517,map__23517__$1,values,touched,errors,handle_change,handle_blur){
return (function (){
var G__23522 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_toggle_DASH_show_DASH_tt,component,show_tt_QMARK_], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__23522) : re_frame.core.dispatch.call(null,G__23522));
});})(show_vt_QMARK_,show_tt_QMARK_,map__23517,map__23517__$1,values,touched,errors,handle_change,handle_blur))
], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_group_DASH_label$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,"Transaction Time"], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_(show_tt_QMARK_)?null:"hidden")], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$input$input_DASH_time,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"date",cljs.core.cst$kw$name,"ttd",cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"ttd"),cljs.core.cst$kw$on_DASH_change,handle_change,cljs.core.cst$kw$on_DASH_blur,handle_blur], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$input$input_DASH_time,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"time",cljs.core.cst$kw$name,"ttt",cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"ttt"),cljs.core.cst$kw$on_DASH_change,handle_change,cljs.core.cst$kw$on_DASH_blur,handle_blur], null)], null),(cljs.core.truth_((function (){var and__3938__auto__ = (function (){var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(touched,"ttd");
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(touched,"ttt");
}
})();
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"tt");
} else {
return and__3938__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$input_DASH_error,cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"tt")], null):null)], null)], null)], null);
});
crux.ui.views.vt_tt_entity_box = (function crux$ui$views$vt_tt_entity_box(vt,tt){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_vt_DASH_tt,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_vt_DASH_tt__title,"Valid Time"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_vt_DASH_tt__value,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(vt)].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_vt_DASH_tt__title,"Transaction Time"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_vt_DASH_tt__value,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(tt)].join('')], null)], null);
});
crux.ui.views.query_validation = (function crux$ui$views$query_validation(values){
var empty_string_QMARK_ = (function (p1__23523_SHARP_){
return cljs.core.empty_QMARK_(clojure.string.trim((function (){var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,p1__23523_SHARP_);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})()));
});
var invalid_query_QMARK_ = (function (){try{var query_edn = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"q"));
if((query_edn == null)){
return "Query box is empty";
} else {
if(!(cljs.core.contains_QMARK_(query_edn,cljs.core.cst$kw$find))){
return "Query doesn't contain a 'find' clause";
} else {
if(!(cljs.core.contains_QMARK_(query_edn,cljs.core.cst$kw$where))){
return "Query doesn't contain a 'where' clause";
} else {
return null;
}
}
}
}catch (e23528){if((e23528 instanceof Error)){
var e = e23528;
return ["Error reading query - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e.message)].join('');
} else {
throw e23528;

}
}})();
var validation = new cljs.core.PersistentArrayMap(null, 3, ["q",invalid_query_QMARK_,"vt",(cljs.core.truth_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,(function (){var fexpr__23529 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(((function (empty_string_QMARK_,invalid_query_QMARK_){
return (function (p1__23524_SHARP_){
return (p1__23524_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23524_SHARP_.cljs$core$IFn$_invoke$arity$1("vtd") : p1__23524_SHARP_.call(null,"vtd"));
});})(empty_string_QMARK_,invalid_query_QMARK_))
,((function (empty_string_QMARK_,invalid_query_QMARK_){
return (function (p1__23525_SHARP_){
return (p1__23525_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23525_SHARP_.cljs$core$IFn$_invoke$arity$1("vtt") : p1__23525_SHARP_.call(null,"vtt"));
});})(empty_string_QMARK_,invalid_query_QMARK_))
);
return (fexpr__23529.cljs$core$IFn$_invoke$arity$1 ? fexpr__23529.cljs$core$IFn$_invoke$arity$1(empty_string_QMARK_) : fexpr__23529.call(null,empty_string_QMARK_));
})()))?"Fill out both inputs or none":null),"tt",(cljs.core.truth_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,(function (){var fexpr__23530 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(((function (empty_string_QMARK_,invalid_query_QMARK_){
return (function (p1__23526_SHARP_){
return (p1__23526_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23526_SHARP_.cljs$core$IFn$_invoke$arity$1("ttd") : p1__23526_SHARP_.call(null,"ttd"));
});})(empty_string_QMARK_,invalid_query_QMARK_))
,((function (empty_string_QMARK_,invalid_query_QMARK_){
return (function (p1__23527_SHARP_){
return (p1__23527_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23527_SHARP_.cljs$core$IFn$_invoke$arity$1("ttt") : p1__23527_SHARP_.call(null,"ttt"));
});})(empty_string_QMARK_,invalid_query_QMARK_))
);
return (fexpr__23530.cljs$core$IFn$_invoke$arity$1 ? fexpr__23530.cljs$core$IFn$_invoke$arity$1(empty_string_QMARK_) : fexpr__23530.call(null,empty_string_QMARK_));
})()))?"Fill out both inputs or none":null)], null);
if(cljs.core.truth_(cljs.core.some(cljs.core.some_QMARK_,cljs.core.vals(validation)))){
return validation;
} else {
return null;
}
});
crux.ui.views.submit_form_on_keypress = (function crux$ui$views$submit_form_on_keypress(evt,form_id){
if(cljs.core.truth_((function (){var and__3938__auto__ = evt.ctrlKey;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((13),evt.keyCode);
} else {
return and__3938__auto__;
}
})())){
var form_button = document.querySelector([cljs.core.str.cljs$core$IFn$_invoke$arity$1(form_id)," button"].join(''));
return form_button.click();
} else {
return null;
}
});
crux.ui.views.edit_query = (function crux$ui$views$edit_query(_props){
var cm_instance = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
return ((function (cm_instance){
return (function (p__23532){
var map__23533 = p__23532;
var map__23533__$1 = ((((!((map__23533 == null)))?(((((map__23533.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23533.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23533):map__23533);
var props = map__23533__$1;
var values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23533__$1,cljs.core.cst$kw$values);
var errors = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23533__$1,cljs.core.cst$kw$errors);
var touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23533__$1,cljs.core.cst$kw$touched);
var set_values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23533__$1,cljs.core.cst$kw$set_DASH_values);
var set_touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23533__$1,cljs.core.cst$kw$set_DASH_touched);
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23533__$1,cljs.core.cst$kw$form_DASH_id);
var handle_submit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23533__$1,cljs.core.cst$kw$handle_DASH_submit);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_textarea,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_mirror,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"q"),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$cm_DASH_instance,cm_instance,cljs.core.cst$kw$class,"cm-textarea__query",cljs.core.cst$kw$on_DASH_change,((function (map__23533,map__23533__$1,props,values,errors,touched,set_values,set_touched,form_id,handle_submit,cm_instance){
return (function (p1__23531_SHARP_){
var G__23535 = new cljs.core.PersistentArrayMap(null, 1, ["q",p1__23531_SHARP_], null);
return (set_values.cljs$core$IFn$_invoke$arity$1 ? set_values.cljs$core$IFn$_invoke$arity$1(G__23535) : set_values.call(null,G__23535));
});})(map__23533,map__23533__$1,props,values,errors,touched,set_values,set_touched,form_id,handle_submit,cm_instance))
,cljs.core.cst$kw$on_DASH_blur,((function (map__23533,map__23533__$1,props,values,errors,touched,set_values,set_touched,form_id,handle_submit,cm_instance){
return (function (){
return (set_touched.cljs$core$IFn$_invoke$arity$1 ? set_touched.cljs$core$IFn$_invoke$arity$1("q") : set_touched.call(null,"q"));
});})(map__23533,map__23533__$1,props,values,errors,touched,set_values,set_touched,form_id,handle_submit,cm_instance))
], null)], null)], null),(cljs.core.truth_((function (){var and__3938__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(touched,"q");
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"q");
} else {
return and__3938__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$input_DASH_error,cljs.core.get.cljs$core$IFn$_invoke$arity$2(errors,"q")], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_inputs,props,cljs.core.cst$kw$query], null)], null);
});
;})(cm_instance))
});
crux.ui.views.query_history = (function crux$ui$views$query_history(){
var query_history_list = cljs.core.deref((function (){var G__23536 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_form_DASH_history], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23536) : re_frame.core.subscribe.call(null,G__23536));
})());
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_pane__history_DASH_scrollable,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (query_history_list){
return (function (idx,p__23537){
var map__23538 = p__23537;
var map__23538__$1 = ((((!((map__23538 == null)))?(((((map__23538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23538):map__23538);
var history_q = map__23538__$1;
var q = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23538__$1,"q");
var valid_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23538__$1,"valid-time");
var transaction_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23538__$1,"transaction-time");
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_pane__history_DASH_scrollable_DASH_el,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_pane__history_DASH_delete,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (map__23538,map__23538__$1,history_q,q,valid_time,transaction_time,query_history_list){
return (function (){
var G__23540 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_remove_DASH_query_DASH_from_DASH_local_DASH_storage,idx], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__23540) : re_frame.core.dispatch.call(null,G__23540));
});})(map__23538,map__23538__$1,history_q,q,valid_time,transaction_time,query_history_list))
], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fas$fa_DASH_trash_DASH_alt], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_pane__history_DASH_scrollable_DASH_el_DASH_left,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (map__23538,map__23538__$1,history_q,q,valid_time,transaction_time,query_history_list){
return (function (){
var G__23541 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_go_DASH_to_DASH_historical_DASH_query,history_q], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__23541) : re_frame.core.dispatch.call(null,G__23541));
});})(map__23538,map__23538__$1,history_q,q,valid_time,transaction_time,query_history_list))
], null),(cljs.core.truth_(valid_time)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin_DASH_bottom,"1rem"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$form_DASH_pane__history_DASH_headings,"Valid Time: "], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$form_DASH_pane__history_DASH_txt,valid_time], null)], null):null),(cljs.core.truth_(transaction_time)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$form_DASH_pane__history_DASH_headings,"Transaction Time: "], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$form_DASH_pane__history_DASH_txt,transaction_time], null)], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin_DASH_top,"1rem"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_mirror_static,q,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,"cm-textarea__query"], null)], null)], null)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null));
});})(query_history_list))
,query_history_list)], null);
});
crux.ui.views.query_form = (function crux$ui$views$query_form(){
var form_id = "#form-query";
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (form_id){
return (function (){
return document.querySelector(form_id).addEventListener("keydown",((function (form_id){
return (function (p1__23542_SHARP_){
return crux.ui.views.submit_form_on_keypress(p1__23542_SHARP_,form_id);
});})(form_id))
,true);
});})(form_id))
,cljs.core.cst$kw$component_DASH_will_DASH_unmount,((function (form_id){
return (function (){
return document.querySelector(form_id).removeEventListener("keydown",((function (form_id){
return (function (p1__23543_SHARP_){
return crux.ui.views.submit_form_on_keypress(p1__23543_SHARP_,form_id);
});})(form_id))
,true);
});})(form_id))
,cljs.core.cst$kw$reagent_DASH_render,((function (form_id){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fork.core.form,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$form_DASH_id,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(form_id,(1)),cljs.core.cst$kw$validation,crux.ui.views.query_validation,cljs.core.cst$kw$prevent_DASH_default_QMARK_,true,cljs.core.cst$kw$clean_DASH_on_DASH_unmount_QMARK_,true,cljs.core.cst$kw$initial_DASH_values,cljs.core.deref((function (){var G__23545 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_initial_DASH_values_DASH_query], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23545) : re_frame.core.subscribe.call(null,G__23545));
})()),cljs.core.cst$kw$on_DASH_submit,((function (form_id){
return (function (p1__23544_SHARP_){
var G__23546 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_go_DASH_to_DASH_query_DASH_view,p1__23544_SHARP_], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__23546) : re_frame.core.dispatch.call(null,G__23546));
});})(form_id))
], null),((function (form_id){
return (function (p__23547){
var map__23548 = p__23547;
var map__23548__$1 = ((((!((map__23548 == null)))?(((((map__23548.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23548.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23548):map__23548);
var props = map__23548__$1;
var values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23548__$1,cljs.core.cst$kw$values);
var errors = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23548__$1,cljs.core.cst$kw$errors);
var touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23548__$1,cljs.core.cst$kw$touched);
var set_values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23548__$1,cljs.core.cst$kw$set_DASH_values);
var set_touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23548__$1,cljs.core.cst$kw$set_DASH_touched);
var form_id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23548__$1,cljs.core.cst$kw$form_DASH_id);
var handle_submit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23548__$1,cljs.core.cst$kw$handle_DASH_submit);
var loading_QMARK_ = cljs.core.deref((function (){var G__23550 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_result_DASH_pane_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23550) : re_frame.core.subscribe.call(null,G__23550));
})());
var disabled_QMARK_ = (function (){var or__3949__auto__ = loading_QMARK_;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.some(cljs.core.some_QMARK_,cljs.core.vals(errors));
}
})();
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id,form_id__$1,cljs.core.cst$kw$on_DASH_submit,handle_submit], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.collapsible.collapsible,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$views_SLASH_query_DASH_form,cljs.core.cst$kw$crux$ui$views_SLASH_query_DASH_editor], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,"Query Editor"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.tab_bar.tab_bar,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tabs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$k,cljs.core.cst$kw$edit_DASH_query,cljs.core.cst$kw$label,"Edit Query"], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$k,cljs.core.cst$kw$recent_DASH_queries,cljs.core.cst$kw$label,"Recent Queries"], null)], null),cljs.core.cst$kw$current_DASH_tab,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_form_DASH_tab], null),cljs.core.cst$kw$on_DASH_tab_DASH_selected,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_query_DASH_form_DASH_tab_DASH_selected], null)], null)], null),(function (){var G__23551 = cljs.core.deref((function (){var G__23552 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_form_DASH_tab], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23552) : re_frame.core.subscribe.call(null,G__23552));
})());
var G__23551__$1 = (((G__23551 instanceof cljs.core.Keyword))?G__23551.fqn:null);
switch (G__23551__$1) {
case "edit-query":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.edit_query,props], null);

break;
case "recent-queries":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.query_history], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23551__$1)].join('')));

}
})()], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$button,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$class,(cljs.core.truth_(disabled_QMARK_)?null:"form__button"),cljs.core.cst$kw$disabled,disabled_QMARK_], null),"Run Query"], null)], null)], null);
});})(form_id))
], null);
});})(form_id))
], null));
});
crux.ui.views.query_table = (function crux$ui$views$query_table(){
var map__23554 = cljs.core.deref((function (){var G__23555 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_data_DASH_table], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23555) : re_frame.core.subscribe.call(null,G__23555));
})());
var map__23554__$1 = ((((!((map__23554 == null)))?(((((map__23554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23554.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23554):map__23554);
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23554__$1,cljs.core.cst$kw$error);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23554__$1,cljs.core.cst$kw$data);
var loading_QMARK_ = cljs.core.deref((function (){var G__23557 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_result_DASH_pane_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23557) : re_frame.core.subscribe.call(null,G__23557));
})());
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,(cljs.core.truth_(error)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$error_DASH_box,error], null):(cljs.core.truth_((function (){var and__3938__auto__ = cljs.core.cst$kw$rows.cljs$core$IFn$_invoke$arity$1(data);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.empty_QMARK_(cljs.core.cst$kw$rows.cljs$core$IFn$_invoke$arity$1(data));
} else {
return and__3938__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$no_DASH_results,"No results found!"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$query_DASH_table_DASH_downloads,"Download as:",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$query_DASH_table_DASH_downloads__link,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,cljs.core.deref((function (){var G__23558 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_data_DASH_download_DASH_link,"csv"], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23558) : re_frame.core.subscribe.call(null,G__23558));
})())], null),"CSV"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$query_DASH_table_DASH_downloads__link,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,cljs.core.deref((function (){var G__23559 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_data_DASH_download_DASH_link,"tsv"], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23559) : re_frame.core.subscribe.call(null,G__23559));
})())], null),"TSV"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.uikit.table.table,data], null)], null)
))], null);
});
crux.ui.views.query_pane = (function crux$ui$views$query_pane(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.query_form], null),(cljs.core.truth_(cljs.core.deref((function (){var G__23560 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_query_DASH_submitted_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23560) : re_frame.core.subscribe.call(null,G__23560));
})()))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.query_table], null):null)], null);
});
crux.ui.views.entity_validation = (function crux$ui$views$entity_validation(values){
var empty_string_QMARK_ = (function (p1__23561_SHARP_){
return cljs.core.empty_QMARK_(clojure.string.trim((function (){var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,p1__23561_SHARP_);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "";
}
})()));
});
var validation = new cljs.core.PersistentArrayMap(null, 3, ["eid",(cljs.core.truth_(empty_string_QMARK_("eid"))?"Entity id is empty":null),"vt",(cljs.core.truth_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,(function (){var fexpr__23566 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(((function (empty_string_QMARK_){
return (function (p1__23562_SHARP_){
return (p1__23562_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23562_SHARP_.cljs$core$IFn$_invoke$arity$1("vtd") : p1__23562_SHARP_.call(null,"vtd"));
});})(empty_string_QMARK_))
,((function (empty_string_QMARK_){
return (function (p1__23563_SHARP_){
return (p1__23563_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23563_SHARP_.cljs$core$IFn$_invoke$arity$1("vtt") : p1__23563_SHARP_.call(null,"vtt"));
});})(empty_string_QMARK_))
);
return (fexpr__23566.cljs$core$IFn$_invoke$arity$1 ? fexpr__23566.cljs$core$IFn$_invoke$arity$1(empty_string_QMARK_) : fexpr__23566.call(null,empty_string_QMARK_));
})()))?"Fill out both inputs or none":null),"tt",(cljs.core.truth_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,(function (){var fexpr__23567 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(((function (empty_string_QMARK_){
return (function (p1__23564_SHARP_){
return (p1__23564_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23564_SHARP_.cljs$core$IFn$_invoke$arity$1("ttd") : p1__23564_SHARP_.call(null,"ttd"));
});})(empty_string_QMARK_))
,((function (empty_string_QMARK_){
return (function (p1__23565_SHARP_){
return (p1__23565_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23565_SHARP_.cljs$core$IFn$_invoke$arity$1("ttt") : p1__23565_SHARP_.call(null,"ttt"));
});})(empty_string_QMARK_))
);
return (fexpr__23567.cljs$core$IFn$_invoke$arity$1 ? fexpr__23567.cljs$core$IFn$_invoke$arity$1(empty_string_QMARK_) : fexpr__23567.call(null,empty_string_QMARK_));
})()))?"Fill out both inputs or none":null)], null);
if(cljs.core.truth_(cljs.core.some(cljs.core.some_QMARK_,cljs.core.vals(validation)))){
return validation;
} else {
return null;
}
});
crux.ui.views.entity_form = (function crux$ui$views$entity_form(){
var form_id = "#form-entity";
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (form_id){
return (function (){
return document.querySelector(form_id).addEventListener("keydown",((function (form_id){
return (function (p1__23568_SHARP_){
return crux.ui.views.submit_form_on_keypress(p1__23568_SHARP_,form_id);
});})(form_id))
,true);
});})(form_id))
,cljs.core.cst$kw$component_DASH_will_DASH_unmount,((function (form_id){
return (function (){
return document.querySelector(form_id).removeEventListener("keydown",((function (form_id){
return (function (p1__23569_SHARP_){
return crux.ui.views.submit_form_on_keypress(p1__23569_SHARP_,form_id);
});})(form_id))
,true);
});})(form_id))
,cljs.core.cst$kw$reagent_DASH_render,((function (form_id){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fork.core.form,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$form_DASH_id,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(form_id,(1)),cljs.core.cst$kw$prevent_DASH_default_QMARK_,true,cljs.core.cst$kw$clean_DASH_on_DASH_unmount_QMARK_,true,cljs.core.cst$kw$validation,crux.ui.views.entity_validation,cljs.core.cst$kw$initial_DASH_values,cljs.core.deref((function (){var G__23571 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_initial_DASH_values_DASH_entity], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23571) : re_frame.core.subscribe.call(null,G__23571));
})()),cljs.core.cst$kw$on_DASH_submit,((function (form_id){
return (function (p1__23570_SHARP_){
var G__23572 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_go_DASH_to_DASH_entity_DASH_view,p1__23570_SHARP_], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__23572) : re_frame.core.dispatch.call(null,G__23572));
});})(form_id))
], null),((function (form_id){
return (function (p__23573){
var map__23574 = p__23573;
var map__23574__$1 = ((((!((map__23574 == null)))?(((((map__23574.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23574.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23574):map__23574);
var props = map__23574__$1;
var form_id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23574__$1,cljs.core.cst$kw$form_DASH_id);
var handle_blur = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23574__$1,cljs.core.cst$kw$handle_DASH_blur);
var set_values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23574__$1,cljs.core.cst$kw$set_DASH_values);
var errors = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23574__$1,cljs.core.cst$kw$errors);
var handle_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23574__$1,cljs.core.cst$kw$handle_DASH_change);
var handle_submit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23574__$1,cljs.core.cst$kw$handle_DASH_submit);
var set_touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23574__$1,cljs.core.cst$kw$set_DASH_touched);
var touched = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23574__$1,cljs.core.cst$kw$touched);
var values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23574__$1,cljs.core.cst$kw$values);
var loading_QMARK_ = cljs.core.deref((function (){var G__23576 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23576) : re_frame.core.subscribe.call(null,G__23576));
})());
var disabled_QMARK_ = (function (){var or__3949__auto__ = loading_QMARK_;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.some(cljs.core.some_QMARK_,cljs.core.vals(errors));
}
})();
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id,form_id__$1,cljs.core.cst$kw$on_DASH_submit,handle_submit], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_form__input_DASH_line,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$padding_DASH_right,"1rem"], null)], null),"Entity ID:"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$monospace$entity_DASH_form__input,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$type,"text",cljs.core.cst$kw$name,"eid",cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(values,"eid"),cljs.core.cst$kw$placeholder,":foo",cljs.core.cst$kw$on_DASH_change,handle_change,cljs.core.cst$kw$on_DASH_blur,handle_blur], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_inputs,props,cljs.core.cst$kw$entity], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$button_DASH_line,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$button,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$class,(cljs.core.truth_(disabled_QMARK_)?null:"form__button"),cljs.core.cst$kw$disabled,disabled_QMARK_], null),"Fetch"], null)], null)], null);
});})(form_id))
], null);
});})(form_id))
], null));
});
crux.ui.views.entity_document = (function crux$ui$views$entity_document(){
var _BANG_raw_edn_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return ((function (_BANG_raw_edn_QMARK_){
return (function (){
var map__23577 = cljs.core.deref((function (){var G__23578 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_document], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23578) : re_frame.core.subscribe.call(null,G__23578));
})());
var map__23577__$1 = ((((!((map__23577 == null)))?(((((map__23577.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23577.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23577):map__23577);
var eid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23577__$1,cljs.core.cst$kw$eid);
var vt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23577__$1,cljs.core.cst$kw$vt);
var tt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23577__$1,cljs.core.cst$kw$tt);
var document = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23577__$1,cljs.core.cst$kw$document);
var linked_entities = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23577__$1,cljs.core.cst$kw$linked_DASH_entities);
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23577__$1,cljs.core.cst$kw$error);
var loading_QMARK_ = cljs.core.deref((function (){var G__23580 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23580) : re_frame.core.subscribe.call(null,G__23580));
})());
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_diffs__options,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_checkbox__group,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_diffs__checkbox,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$checked,cljs.core.deref(_BANG_raw_edn_QMARK_),cljs.core.cst$kw$on_DASH_change,((function (map__23577,map__23577__$1,eid,vt,tt,document,linked_entities,error,loading_QMARK_,_BANG_raw_edn_QMARK_){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(_BANG_raw_edn_QMARK_,cljs.core.not);
});})(map__23577,map__23577__$1,eid,vt,tt,document,linked_entities,error,loading_QMARK_,_BANG_raw_edn_QMARK_))
,cljs.core.cst$kw$type,"checkbox"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,"Raw EDN"], null)], null)], null),(cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map$entity_DASH_map_DASH__DASH_loading,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fas$fa_DASH_spinner$entity_DASH_map__load_DASH_icon], null)], null):(cljs.core.truth_(error)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$error_DASH_box,error], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map__container,(cljs.core.truth_(cljs.core.deref(_BANG_raw_edn_QMARK_))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_raw_DASH_edn,(function (){var sb__4462__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_23581_23583 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_23582_23584 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_23581_23583,_STAR_print_fn_STAR_23582_23584,sb__4462__auto__,map__23577,map__23577__$1,eid,vt,tt,document,linked_entities,error,loading_QMARK_,_BANG_raw_edn_QMARK_){
return (function (x__4463__auto__){
return sb__4462__auto__.append(x__4463__auto__);
});})(_STAR_print_newline_STAR_23581_23583,_STAR_print_fn_STAR_23582_23584,sb__4462__auto__,map__23577,map__23577__$1,eid,vt,tt,document,linked_entities,error,loading_QMARK_,_BANG_raw_edn_QMARK_))
;

try{cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(document);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_23582_23584;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_23581_23583;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4462__auto__)].join('');
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$views_SLASH_div$entity_DASH_map,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,document,linked_entities], null)], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,vt,tt], null)], null)))], null);
});
;})(_BANG_raw_edn_QMARK_))
});
crux.ui.views.entity_history_document = (function crux$ui$views$entity_history_document(){
var _BANG_diffs_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return ((function (_BANG_diffs_QMARK_){
return (function (){
var diffs_QMARK_ = cljs.core.deref(_BANG_diffs_QMARK_);
var entity_error = cljs.core.deref((function (){var G__23586 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_document_DASH_error], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23586) : re_frame.core.subscribe.call(null,G__23586));
})());
var loading_QMARK_ = cljs.core.deref((function (){var G__23587 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23587) : re_frame.core.subscribe.call(null,G__23587));
})());
var map__23585 = cljs.core.deref((function (){var G__23588 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_current_DASH_route], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23588) : re_frame.core.subscribe.call(null,G__23588));
})());
var map__23585__$1 = ((((!((map__23585 == null)))?(((((map__23585.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23585.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23585):map__23585);
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23585__$1,cljs.core.cst$kw$query_DASH_params);
var path_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23585__$1,cljs.core.cst$kw$path_DASH_params);
var asc_order_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("asc",cljs.core.cst$kw$sort_DASH_order.cljs$core$IFn$_invoke$arity$1(query_params));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_diffs__options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$select$history_DASH_sorting_DASH_group,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,"diffs-order",cljs.core.cst$kw$value,cljs.core.cst$kw$sort_DASH_order.cljs$core$IFn$_invoke$arity$1(query_params),cljs.core.cst$kw$on_DASH_change,((function (diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function (){
var G__23590 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$navigate,cljs.core.cst$kw$entity,path_params,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_params,cljs.core.cst$kw$sort_DASH_order,((asc_order_QMARK_)?"desc":"asc"))], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__23590) : re_frame.core.dispatch.call(null,G__23590));
});})(diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"asc"], null),"Ascending"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"desc"], null),"Descending"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_checkbox__group,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$history_DASH_diffs__checkbox,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$checked,diffs_QMARK_,cljs.core.cst$kw$on_DASH_change,((function (diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(_BANG_diffs_QMARK_,cljs.core.not);
});})(diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
,cljs.core.cst$kw$type,"checkbox"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,"Diffs"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_histories__container,(cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map$entity_DASH_map_DASH__DASH_loading,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fas$fa_DASH_spinner$entity_DASH_map__load_DASH_icon], null)], null):(cljs.core.truth_(entity_error)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$error_DASH_box,entity_error], null):((cljs.core.not(diffs_QMARK_))?(function (){var map__23591 = cljs.core.deref((function (){var G__23592 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_history], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23592) : re_frame.core.subscribe.call(null,G__23592));
})());
var map__23591__$1 = ((((!((map__23591 == null)))?(((((map__23591.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23591.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23591):map__23591);
var entity_history = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23591__$1,cljs.core.cst$kw$entity_DASH_history);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_histories,(function (){var iter__4324__auto__ = ((function (map__23591,map__23591__$1,entity_history,diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function crux$ui$views$entity_history_document_$_iter__23594(s__23595){
return (new cljs.core.LazySeq(null,((function (map__23591,map__23591__$1,entity_history,diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function (){
var s__23595__$1 = s__23595;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__23595__$1);
if(temp__5735__auto__){
var s__23595__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__23595__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__23595__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__23597 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__23596 = (0);
while(true){
if((i__23596 < size__4323__auto__)){
var map__23598 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__23596);
var map__23598__$1 = ((((!((map__23598 == null)))?(((((map__23598.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23598.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23598):map__23598);
var history_elem = map__23598__$1;
var tx_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23598__$1,cljs.core.cst$kw$crux$tx_SLASH_tx_DASH_time);
var valid_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23598__$1,cljs.core.cst$kw$crux$db_SLASH_valid_DASH_time);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23598__$1,cljs.core.cst$kw$crux$db_SLASH_doc);
cljs.core.chunk_append(b__23597,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_history__container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,doc,cljs.core.PersistentArrayMap.EMPTY], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,valid_time,tx_time], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,history_elem], null)));

var G__23613 = (i__23596 + (1));
i__23596 = G__23613;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__23597),crux$ui$views$entity_history_document_$_iter__23594(cljs.core.chunk_rest(s__23595__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__23597),null);
}
} else {
var map__23600 = cljs.core.first(s__23595__$2);
var map__23600__$1 = ((((!((map__23600 == null)))?(((((map__23600.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23600.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23600):map__23600);
var history_elem = map__23600__$1;
var tx_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23600__$1,cljs.core.cst$kw$crux$tx_SLASH_tx_DASH_time);
var valid_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23600__$1,cljs.core.cst$kw$crux$db_SLASH_valid_DASH_time);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23600__$1,cljs.core.cst$kw$crux$db_SLASH_doc);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_history__container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,doc,cljs.core.PersistentArrayMap.EMPTY], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,valid_time,tx_time], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,history_elem], null)),crux$ui$views$entity_history_document_$_iter__23594(cljs.core.rest(s__23595__$2)));
}
} else {
return null;
}
break;
}
});})(map__23591,map__23591__$1,entity_history,diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
,null,null));
});})(map__23591,map__23591__$1,entity_history,diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
;
return iter__4324__auto__(entity_history);
})()], null);
})():(cljs.core.truth_(diffs_QMARK_)?(function (){var map__23602 = cljs.core.deref((function (){var G__23603 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_result_DASH_pane_DASH_history_DASH_diffs], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23603) : re_frame.core.subscribe.call(null,G__23603));
})());
var map__23602__$1 = ((((!((map__23602 == null)))?(((((map__23602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23602.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23602):map__23602);
var up_to_date_doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23602__$1,cljs.core.cst$kw$up_DASH_to_DASH_date_DASH_doc);
var history_diffs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23602__$1,cljs.core.cst$kw$history_DASH_diffs);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_histories,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_history__container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,cljs.core.cst$kw$crux$db_SLASH_doc.cljs$core$IFn$_invoke$arity$1(up_to_date_doc),cljs.core.PersistentArrayMap.EMPTY], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,cljs.core.cst$kw$crux$db_SLASH_valid_DASH_time.cljs$core$IFn$_invoke$arity$1(up_to_date_doc),cljs.core.cst$kw$crux$tx_SLASH_tx_DASH_time.cljs$core$IFn$_invoke$arity$1(up_to_date_doc)], null)], null),(function (){var iter__4324__auto__ = ((function (map__23602,map__23602__$1,up_to_date_doc,history_diffs,diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function crux$ui$views$entity_history_document_$_iter__23605(s__23606){
return (new cljs.core.LazySeq(null,((function (map__23602,map__23602__$1,up_to_date_doc,history_diffs,diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_){
return (function (){
var s__23606__$1 = s__23606;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__23606__$1);
if(temp__5735__auto__){
var s__23606__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__23606__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__23606__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__23608 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__23607 = (0);
while(true){
if((i__23607 < size__4323__auto__)){
var map__23609 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__23607);
var map__23609__$1 = ((((!((map__23609 == null)))?(((((map__23609.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23609.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23609):map__23609);
var history_elem = map__23609__$1;
var additions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23609__$1,cljs.core.cst$kw$additions);
var deletions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23609__$1,cljs.core.cst$kw$deletions);
var tx_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23609__$1,cljs.core.cst$kw$crux$tx_SLASH_tx_DASH_time);
var valid_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23609__$1,cljs.core.cst$kw$crux$db_SLASH_valid_DASH_time);
cljs.core.chunk_append(b__23608,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_history__container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map__diffs_DASH_group,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map,(cljs.core.truth_(additions)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"green"], null)], null),"+ Additions:"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,additions,cljs.core.PersistentArrayMap.EMPTY], null)], null):null),(cljs.core.truth_(deletions)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"red"], null)], null),"- Deletions:"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,deletions,cljs.core.PersistentArrayMap.EMPTY], null)], null):null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,valid_time,tx_time], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,history_elem], null)));

var G__23614 = (i__23607 + (1));
i__23607 = G__23614;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__23608),crux$ui$views$entity_history_document_$_iter__23605(cljs.core.chunk_rest(s__23606__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__23608),null);
}
} else {
var map__23611 = cljs.core.first(s__23606__$2);
var map__23611__$1 = ((((!((map__23611 == null)))?(((((map__23611.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23611.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23611):map__23611);
var history_elem = map__23611__$1;
var additions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23611__$1,cljs.core.cst$kw$additions);
var deletions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23611__$1,cljs.core.cst$kw$deletions);
var tx_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23611__$1,cljs.core.cst$kw$crux$tx_SLASH_tx_DASH_time);
var valid_time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23611__$1,cljs.core.cst$kw$crux$db_SLASH_valid_DASH_time);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_history__container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map__diffs_DASH_group,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$entity_DASH_map,(cljs.core.truth_(additions)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"green"], null)], null),"+ Additions:"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,additions,cljs.core.PersistentArrayMap.EMPTY], null)], null):null),(cljs.core.truth_(deletions)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"red"], null)], null),"- Deletions:"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.codemirror.code_snippet,deletions,cljs.core.PersistentArrayMap.EMPTY], null)], null):null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.vt_tt_entity_box,valid_time,tx_time], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,history_elem], null)),crux$ui$views$entity_history_document_$_iter__23605(cljs.core.rest(s__23606__$2)));
}
} else {
return null;
}
break;
}
});})(map__23602,map__23602__$1,up_to_date_doc,history_diffs,diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
,null,null));
});})(map__23602,map__23602__$1,up_to_date_doc,history_diffs,diffs_QMARK_,entity_error,loading_QMARK_,map__23585,map__23585__$1,query_params,path_params,asc_order_QMARK_,_BANG_diffs_QMARK_))
;
return iter__4324__auto__(history_diffs);
})()], null);
})():null
))))], null)], null);
});
;})(_BANG_diffs_QMARK_))
});
crux.ui.views.entity_pane = (function crux$ui$views$entity_pane(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.entity_form], null),(cljs.core.truth_(cljs.core.deref((function (){var G__23615 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_eid_DASH_submitted_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23615) : re_frame.core.subscribe.call(null,G__23615));
})()))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.tab_bar.tab_bar,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tabs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$k,cljs.core.cst$kw$document,cljs.core.cst$kw$label,"Document",cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_set_DASH_entity_DASH_pane_DASH_document], null)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$k,cljs.core.cst$kw$history,cljs.core.cst$kw$label,"History",cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_set_DASH_entity_DASH_pane_DASH_history], null)], null)], null),cljs.core.cst$kw$current_DASH_tab,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_pane_DASH_tab], null),cljs.core.cst$kw$on_DASH_tab_DASH_selected,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_entity_DASH_pane_DASH_tab_DASH_selected], null)], null)], null),(function (){var G__23616 = cljs.core.deref((function (){var G__23617 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_entity_DASH_pane_DASH_tab], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23617) : re_frame.core.subscribe.call(null,G__23617));
})());
var G__23616__$1 = (((G__23616 instanceof cljs.core.Keyword))?G__23616.fqn:null);
switch (G__23616__$1) {
case "document":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.entity_document], null);

break;
case "history":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.entity_history_document], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23616__$1)].join('')));

}
})()], null):null)], null);
});
crux.ui.views.console_pane = (function crux$ui$views$console_pane(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$_LT__GT_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.tab_bar.tab_bar,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$tabs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$k,cljs.core.cst$kw$query,cljs.core.cst$kw$label,"Query"], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$k,cljs.core.cst$kw$entity,cljs.core.cst$kw$label,"Entity"], null)], null),cljs.core.cst$kw$current_DASH_tab,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_console_DASH_tab], null),cljs.core.cst$kw$on_DASH_tab_DASH_selected,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$events_SLASH_console_DASH_tab_DASH_selected], null)], null)], null),(function (){var G__23619 = cljs.core.deref((function (){var G__23620 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_console_DASH_tab], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23620) : re_frame.core.subscribe.call(null,G__23620));
})());
var G__23619__$1 = (((G__23619 instanceof cljs.core.Keyword))?G__23619.fqn:null);
switch (G__23619__$1) {
case "query":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.query_pane], null);

break;
case "entity":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.entity_pane], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23619__$1)].join('')));

}
})()], null);
});
crux.ui.views.status_map__GT_html_elements = (function crux$ui$views$status_map__GT_html_elements(status_map){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dl$node_DASH_info__content], null),cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__23622){
var vec__23623 = p__23622;
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23623,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23623,(1),null);
if(cljs.core.truth_(value)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dt,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$b,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('')], null)], null),((cljs.core.map_QMARK_(value))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dd,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dl], null),cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(((function (vec__23623,key,value){
return (function (p__23626){
var vec__23627 = p__23626;
var key__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23627,(0),null);
var value__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23627,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dt,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$b,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(key__$1)].join('')], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dd,(function (){var sb__4462__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_23630_23634 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_23631_23635 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_23630_23634,_STAR_print_fn_STAR_23631_23635,sb__4462__auto__,vec__23627,key__$1,value__$1,vec__23623,key,value){
return (function (x__4463__auto__){
return sb__4462__auto__.append(x__4463__auto__);
});})(_STAR_print_newline_STAR_23630_23634,_STAR_print_fn_STAR_23631_23635,sb__4462__auto__,vec__23627,key__$1,value__$1,vec__23623,key,value))
;

try{cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(value__$1);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_23631_23635;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_23630_23634;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4462__auto__)].join('');
})()], null)], null);
});})(vec__23623,key,value))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dd,(function (){var sb__4462__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_23632_23636 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_23633_23637 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_23632_23636,_STAR_print_fn_STAR_23633_23637,sb__4462__auto__,vec__23623,key,value){
return (function (x__4463__auto__){
return sb__4462__auto__.append(x__4463__auto__);
});})(_STAR_print_newline_STAR_23632_23636,_STAR_print_fn_STAR_23633_23637,sb__4462__auto__,vec__23623,key,value))
;

try{cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(value);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_23633_23637;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_23632_23636;
}
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4462__auto__)].join('');
})()], null)
)], null);
} else {
return null;
}
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([crux.ui.common.sort_map(status_map)], 0)));
});
crux.ui.views.status_page = (function crux$ui$views$status_page(){
var status_map = cljs.core.deref((function (){var G__23638 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_node_DASH_status], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23638) : re_frame.core.subscribe.call(null,G__23638));
})());
var options_map = cljs.core.deref((function (){var G__23639 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_node_DASH_options], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23639) : re_frame.core.subscribe.call(null,G__23639));
})());
var loading_QMARK_ = cljs.core.deref((function (){var G__23640 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_node_DASH_status_DASH_loading_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23640) : re_frame.core.subscribe.call(null,G__23640));
})());
if(((!((loading_QMARK_ == null))) && (cljs.core.not(loading_QMARK_)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$node_DASH_info__container,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$node_DASH_info,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h2$node_DASH_info__title,"Node Status"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.status_map__GT_html_elements,status_map], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$node_DASH_info,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h2$node_DASH_info__title,"Node Options"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.status_map__GT_html_elements,options_map], null)], null)], null);
} else {
return null;
}
});
crux.ui.views.root_page = (function crux$ui$views$root_page(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$root_DASH_page,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$root_DASH_background], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$root_DASH_contents,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h1$root_DASH_title,"Welcome to the Crux Console!"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h2$root_DASH_video__title,"Take a short video tour:"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$iframe$root_DASH_video,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,"https://www.youtube.com/embed/StXLmWvb5Xs",cljs.core.cst$kw$allow,"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$root_DASH_get_DASH_started,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,crux.ui.common.route__GT_url.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$query)], null),"Start exploring your Crux node"], null)], null)], null);
});
crux.ui.views.view = (function crux$ui$views$view(){
var map__23641 = cljs.core.deref((function (){var G__23643 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$crux$ui$subscriptions_SLASH_current_DASH_route], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__23643) : re_frame.core.subscribe.call(null,G__23643));
})());
var map__23641__$1 = ((((!((map__23641 == null)))?(((((map__23641.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23641.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23641):map__23641);
var map__23642 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23641__$1,cljs.core.cst$kw$data);
var map__23642__$1 = ((((!((map__23642 == null)))?(((((map__23642.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23642.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23642):map__23642);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23642__$1,cljs.core.cst$kw$name);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$container$page_DASH_pane,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$kw$homepage))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.root_page], null):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$kw$status))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.status_page], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crux.ui.views.console_pane], null)
))], null);
});
