(ns crux.jon
  (:require [crux.io :as cio])
  (:import java.nio.file.attribute.FileAttribute
           java.nio.file.Files
           [org.apache.lucene.search BooleanClause$Occur BooleanQuery$Builder IndexSearcher Query ScoreDoc BooleanQuery TermQuery]
           [org.apache.lucene.index DirectoryReader IndexWriter IndexWriterConfig Term]
           org.apache.lucene.analysis.standard.StandardAnalyzer
           [org.apache.lucene.document Document Field StringField TextField Field$Store]
           [org.apache.lucene.index DirectoryReader IndexWriter IndexWriterConfig]
           org.apache.lucene.queryparser.classic.QueryParser
           [org.apache.lucene.search BooleanClause$Occur BooleanQuery$Builder IndexSearcher ScoreDoc]
           org.apache.lucene.store.FSDirectory))



;; Get the delete working, but the trouble is TextField is tokenized
;; We need this hashing story

(let [tmp-dir (Files/createTempDirectory "lucene-temp" (make-array FileAttribute 0))]
  (try
    (with-open [directory (FSDirectory/open tmp-dir)]
      (let [analyzer (StandardAnalyzer.)]
        (let [index-writer (IndexWriter. directory, (IndexWriterConfig. analyzer))]
          (.addDocuments index-writer
                         #_[(doto (Document.) (.add (Field. "name", "Jane", TextField/TYPE_STORED)))
                            (doto (Document.) (.add (Field. "name", "Foo Jane", TextField/TYPE_STORED)))]

                         [(doto (Document.)
                            (.add (TextField. "name", "Jane", Field$Store/YES))
                            (.add (StringField. "name2", "Jane", Field$Store/YES)))
                          (doto (Document.) (.add (TextField. "name", "Foo Jane", Field$Store/YES)))])
          (.close index-writer))

        (with-open [directory-reader (DirectoryReader/open directory)]
          (let [attr "name"
                q "Jane"
                index-searcher (IndexSearcher. directory-reader)

                _ (.setSimilarity index-searcher (org.apache.lucene.search.similarities.ClassicSimilarity.))

                qp (QueryParser. attr analyzer)
                q (.build
                   (doto (BooleanQuery$Builder.)
                     (.add (.parse qp q) BooleanClause$Occur/MUST)))
                score-docs (.-scoreDocs (.search index-searcher q 10))]
            (println (.explain index-searcher q 0))

            (into [] (map (fn [^ScoreDoc d]
                            (vector (let [doc (.doc index-searcher (.-doc d))]
                                      (.get ^Document doc attr))
                                    (.-score d)))
                          score-docs))))

        ;; Prove that find for delete works:
        (with-open [directory-reader (DirectoryReader/open directory)]
          (let [q (TermQuery. (Term. "name" "Jane"))
                q (.build (doto (BooleanQuery$Builder.)
                            (.add (TermQuery. (Term. "name2" "Jane")) BooleanClause$Occur/MUST)))
                index-searcher (IndexSearcher. directory-reader)
                score-docs (.-scoreDocs (.search index-searcher q 10))]
            (println (.explain index-searcher q 0))
            (into [] (map (fn [^ScoreDoc d]
                            (vector (let [doc (.doc index-searcher (.-doc d))]
                                      (.get ^Document doc "name"))
                                    (.-score d)))
                          score-docs))))

        ;; Delete doesn't work?
        (let [index-writer (IndexWriter. directory, (IndexWriterConfig. analyzer))]
          (.deleteDocuments index-writer ^"[Lorg.apache.lucene.index.Term;" (into-array Term [(Term. "name2" "Jane")]))
          ;; (.commit index-writer)
          ;; (.forceMergeDeletes index-writer true)
          (.close index-writer)
          )

        ;; .13 for Foo
        (with-open [directory-reader (DirectoryReader/open directory)]
          (let [attr "name"
                q "Jane"
                index-searcher (IndexSearcher. directory-reader)
                qp (QueryParser. attr analyzer)
                q (.build
                   (doto (BooleanQuery$Builder.)
                     (.add (.parse qp q) BooleanClause$Occur/MUST)))
                score-docs (.-scoreDocs (.search index-searcher q 10))]
            (println (.explain index-searcher q 0))

            (into [] (map (fn [^ScoreDoc d]
                            (vector (let [doc (.doc index-searcher (.-doc d))]
                                      (.get ^Document doc attr))
                                    (.-score d)))
                          score-docs))))))
    (finally
      (cio/delete-dir tmp-dir))))
