(ns bc.test
  (:require [clojure.test.check.generators :as gen]
            [com.gfredericks.test.chuck.generators :as chuck]
            [instacheck.generators :as igen]
            [instacheck.util :as util]))

(defn- gen-bc-part-0 [gmap weights]
  (let [g gmap
        w weights

        gen-nz-digit
        (igen/freq [
          [(get w [:nz-digit :alt 0] 3)    ;; ** adjusted by config ***
            (gen/return "1")]
          [(get w [:nz-digit :alt 1] 4)    ;; ** adjusted by config ***
            (gen/return "2")]
          [(get w [:nz-digit :alt 2] 0)    ;; ** adjusted by config ***
            (gen/return "3")]
          [(get w [:nz-digit :alt 3] 0)    ;; ** adjusted by config ***
            (gen/return "4")]
          [(get w [:nz-digit :alt 4] 0)    ;; ** adjusted by config ***
            (gen/return "5")]
          [(get w [:nz-digit :alt 5] 0)    ;; ** adjusted by config ***
            (gen/return "6")]
          [(get w [:nz-digit :alt 6] 0)    ;; ** adjusted by config ***
            (gen/return "7")]
          [(get w [:nz-digit :alt 7] 0)    ;; ** adjusted by config ***
            (gen/return "8")]
          [(get w [:nz-digit :alt 8] 0)    ;; ** adjusted by config ***
            (gen/return "9")]])
        g (assoc g :nz-digit gen-nz-digit)

        gen-any-digit
        (igen/freq [
          [(get w [:any-digit :alt 0] 0)    ;; ** adjusted by config ***
            (gen/return "0")]
          [(get w [:any-digit :alt 1] 0)    ;; ** adjusted by config ***
            (:nz-digit g)]])
        g (assoc g :any-digit gen-any-digit)

        gen-nz-number
        (gen/tuple
          (:nz-digit g)
          (igen/freq [
            [(get w [:nz-number :cat 1 :star nil] 7)    ;; ** adjusted by config ***
              (gen/return "")]
            [(get w [:nz-number :cat 1 :star 0] 0)    ;; ** adjusted by config ***
              (gen/such-that not-empty (gen/vector
                (:any-digit g)))]]))
        g (assoc g :nz-number gen-nz-number)

        gen-any-number
        (igen/freq [
          [(get w [:any-number :alt 0] 0)    ;; ** adjusted by config ***
            (gen/return "0")]
          [(get w [:any-number :alt 1] 7)    ;; ** adjusted by config ***
            (:nz-number g)]])
        g (assoc g :any-number gen-any-number)

        gen-expression
        (gen/recursive-gen
          (fn [inner]
            (igen/freq [
              [(get w [:expression :alt 0] 5)    ;; ** adjusted by config ***
                (gen/tuple
                  (gen/return "(")
                  inner
                  (gen/return ")"))]
              [(get w [:expression :alt 1] 3)    ;; ** adjusted by config ***
                (gen/tuple
                  inner
                  (gen/return "+")
                  inner)]
              [(get w [:expression :alt 2] 0)    ;; ** adjusted by config ***
                (gen/tuple
                  inner
                  (gen/return "-")
                  inner)]
              [(get w [:expression :alt 3] 2)    ;; ** adjusted by config ***
                (gen/tuple
                  inner
                  (gen/return "*")
                  inner)]
              [(get w [:expression :alt 4] 0)    ;; ** adjusted by config ***
                (gen/tuple
                  inner
                  (gen/return "/")
                  (:nz-number g))]
              [(get w [:expression :alt 5] 1)    ;; ** adjusted by config ***
                (gen/tuple
                  inner
                  (gen/return "/")
                  inner)]
              [(get w [:expression :alt 6] 7)    ;; ** adjusted by config ***
                (:any-number g)]]))
          (:any-number g))
        g (assoc g :expression gen-expression)

        gen-file
        (gen/tuple
          (:expression g)
          (gen/return "\nquit\n"))
        g (assoc g :file gen-file)]
    g))

(defn gen-bc [& [gmap weights]]
  (let [g (or gmap {})
        w weights

        g (gen-bc-part-0 g weights)]
    g))
